/*************************************************************************
 *
 *  $RCSfile: adminproviderimpl.cxx,v $
 *
 *  $Revision: 1.27 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/09 11:23:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>
#include "adminproviderimpl.hxx"

#ifndef CONFIGMGR_API_FACTORYIMPL_HXX_
#include "apifactoryimpl.hxx"
#endif
#ifndef CONFIGMGR_API_TREEIMPLOBJECTS_HXX_
#include "apitreeimplobj.hxx"
#endif
#ifndef CONFIGMGR_API_TREEACCESS_HXX_
#include "apitreeaccess.hxx"
#endif
#ifndef CONFIGMGR_ROOTTREE_HXX_
#include "roottree.hxx"
#endif
#ifndef CONFIGMGR_CONFIGNODE_HXX_
#include "noderef.hxx"
#endif
#ifndef CONFIGMGR_API_OBJECTREGISTRY_HXX_
#include "objectregistry.hxx"
#endif
#ifndef CONFIGMGR_CONFIGEXCEPT_HXX_
#include "configexcept.hxx"
#endif
#ifndef CONFIGMGR_BOOTSTRAP_HXX_
#include "bootstrap.hxx"
#endif

#ifndef CONFIGMGR_API_USERIMPL_HXX_
#include "userimpl.hxx"
#endif
#ifndef CONFIGMGR_API_GROUPIMPL_HXX_
#include "groupimpl.hxx"
#endif
#ifndef CONFIGMGR_API_ADMINPROVIDER_HXX_
#include "adminprovider.hxx"
#endif
#ifndef _CONFIGMGR_TREECACHE_HXX_
#include "treecache.hxx"
#endif
#ifndef _CONFIGMGR_TRACER_HXX_
#include "tracer.hxx"
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_CONNECTION_CONNECTIONSETUPEXCEPTION_HPP_
#include <com/sun/star/connection/ConnectionSetupException.hpp>
#endif

namespace configmgr
{
	namespace css	= ::com::sun::star;
	namespace uno	= css::uno;
	namespace beans	= css::beans;

	using ::rtl::OUString;

	using configapi::NodeElement;
	using configuration::RootTree;	
	using configapi::Factory;	

	//=============================================================================
	//= OAdminProviderImpl
	//=============================================================================
	//-----------------------------------------------------------------------------------
	OAdminProviderImpl::OAdminProviderImpl(OAdminProvider* _pProvider, const uno::Reference< lang::XMultiServiceFactory >& _xServiceFactory)
					   :OProviderImpl(_pProvider, _xServiceFactory)					   
	{
	}
	//-----------------------------------------------------------------------------------

	void OAdminProviderImpl::initFromSettings(const ConnectionSettings& _rSettings, bool& rNeedProfile)		
	{	
		if (_rSettings.hasUser())
			m_sDefaultUser = _rSettings.getUser();

	}
	//-----------------------------------------------------------------------------------
	void OAdminProviderImpl::initFromProfile(ISubtree const* pProfile)		
	{	
	}

	//-----------------------------------------------------------------------------------
	OAdminProviderImpl::~OAdminProviderImpl()
	{
	}

	//-----------------------------------------------------------------------------------
	uno::Reference<uno::XInterface>  OAdminProviderImpl::createReadAccess( uno::Sequence<uno::Any> const& aArgs) 
        CFG_UNO_THROW_ALL(  )
	{
		CFG_TRACE_INFO("config provider: going to create a read access instance");

		// extract the args
		OUString sPath;
		sal_Int32 nLevels;
		vos::ORef<OOptions> xOptions = new OOptions(getDefaultOptions());

		OProviderImpl::FactoryArguments::extractArgs(aArgs, sPath, nLevels, xOptions);

		CFG_TRACE_INFO_NI("config provider: node accessor extracted from the args is %s", OUSTRING2ASCII(sPath));
		CFG_TRACE_INFO_NI("config provider: level depth extracted from the args is %i", nLevels);

		if (!xOptions->canUseCache()) CFG_TRACE_INFO_NI("config provider: Ignoring cache for request");

        OUString sUser = xOptions->getUser();
		// no user given, so use the one provided at session creation time
		if (!sUser.getLength())
		{
			CFG_TRACE_WARNING("admin provider: no user specified for tree, using session user instead");
			
            xOptions->setUser( sUser = m_sDefaultUser );
		}

		// no user found (not even defaulted), so unable to create the Access
		if (!sUser.getLength())
		{
			CFG_TRACE_ERROR("admin provider: no user specified for tree, unable to retrieve tree");

			::rtl::OUString sMessage = ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("The read access for node "));
			sMessage += sPath;
			sMessage += ::rtl::OUString::createFromAscii(" could not be created. No user name given!");

            throw css::connection::ConnectionSetupException(sMessage, getProviderInstance());
		}
        OSL_ASSERT( sUser == xOptions->getUser() );

        // loading data as writable always
        OSL_ASSERT( xOptions->isForcingWritable() );

		// create the access object
		uno::Reference< uno::XInterface > xReturn;

        NodeElement* pElement = buildReadAccess(sPath, xOptions, nLevels);
		if (pElement != 0)
		{
			xReturn = pElement->getUnoInstance();
			if (xReturn.is())
				// acquired once by buildReadAccess
				xReturn->release();
		}

        return xReturn;
	}

	//-----------------------------------------------------------------------------------
	uno::Reference<uno::XInterface> OAdminProviderImpl::createUpdateAccess( uno::Sequence<uno::Any> const& aArgs ) 
		CFG_UNO_THROW_ALL(  )
	{
		CFG_TRACE_INFO("config provider: going to create an update access instance");

		// extract the args
		OUString sPath;
		sal_Int32 nLevels;
		vos::ORef<OOptions> xOptions = new OOptions(getDefaultOptions());

		OProviderImpl::FactoryArguments::extractArgs(aArgs, sPath, nLevels, xOptions);

		CFG_TRACE_INFO_NI("config provider: node accessor extracted from the args is %s", OUSTRING2ASCII(sPath));		
		CFG_TRACE_INFO_NI("config provider: level depth extracted from the args is %i", nLevels);						

		if (!xOptions->canUseCache()) 
        {
            CFG_TRACE_INFO_NI("config provider: Ignoring cache for request");
            OSL_ENSURE( !xOptions->getLazyWrite(), "WARNING: Async writing is enabled for non-cached node. Results may be unexpected.");
            if (xOptions->getLazyWrite()) 
                CFG_TRACE_WARNING_NI("config provider: Async writing is enabled for non-cached node. Results may be unexpected.");
        }

        OUString sUser = xOptions->getUser();
		// no user given, so use the one provided at session creation time
		if (!sUser.getLength())
		{
			CFG_TRACE_WARNING("admin provider: no user specified for tree, using session user instead");
			
            xOptions->setUser( sUser = m_sDefaultUser );
		}

		// no user found (not even defaulted), so unable to create the Access
		if (!sUser.getLength())
		{
			CFG_TRACE_ERROR("admin provider: no user specified for tree, unable to retrieve tree");

			::rtl::OUString sMessage = ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("The update access for node "));
			sMessage += sPath;
			sMessage += ::rtl::OUString::createFromAscii(" could not be created. No user name given!");

            throw css::connection::ConnectionSetupException(sMessage, getProviderInstance());
		}
        OSL_ASSERT( sUser == xOptions->getUser() );

        // loading data as writable always
        OSL_ASSERT( xOptions->isForcingWritable() );

		// create the access object
		uno::Reference< uno::XInterface > xReturn;

		NodeElement* pElement = buildUpdateAccess(sPath, xOptions, nLevels);
		if (pElement != 0)
		{
			xReturn = pElement->getUnoInstance();
			if (xReturn.is())
				// acquired once by buildReadAccess
				xReturn->release();
		}

		return xReturn;
	}			

	//-----------------------------------------------------------------------------------
	uno::Reference<uno::XInterface> OAdminProviderImpl::createUserAccess( uno::Sequence<uno::Any> const& aArgs ) 
		CFG_UNO_THROW_ALL(  )
	{
		CFG_TRACE_INFO("admin provider: going to create an user access instance");
		
		// create the access object
		uno::Reference< uno::XInterface > xReturn = static_cast< container::XNameAccess* >(new OUserAccess(this));		
		return xReturn;
	}		

	//-----------------------------------------------------------------------------------
	uno::Reference<uno::XInterface> OAdminProviderImpl::createGroupAccess( uno::Sequence<uno::Any> const& aArgs ) 
		CFG_UNO_THROW_ALL(  )
	{
		CFG_TRACE_INFO("admin provider: going to create an user access instance");
		
		// create the access object
		uno::Reference< uno::XInterface > xReturn = static_cast< container::XNameAccess* >(new OGroupAccess(this));		
		return xReturn;
	}		
} // namespace configmgr
