/*************************************************************************
 *
 *  $RCSfile: confapifactory.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: jb $ $Date: 2001/04/03 16:33:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "confapifactory.hxx"
#include "bootstrap.hxx"
#include "confsvccomponent.hxx"

namespace configmgr
{
	namespace css  = ::com::sun::star;
	namespace uno  = css::uno;
	namespace lang = css::lang;

//-------- Implementation registration information ----------------------------------

	namespace 
	{
		AsciiServiceName const aUserAdminProviderServices[] = 
		{
			"com.sun.star.configuration.UserAdministrationProvider",
			0
		};
		AsciiServiceName const aAdminProviderServices[] = 
		{
			"com.sun.star.configuration.AdministrationProvider",
			0
		};
		ServiceInfo const aUserAdminProviderInfo = 
		{
			"com.sun.star.comp.configuration.UserAdministrationProvider",
			aUserAdminProviderServices
		};
		ServiceInfo const aAdminProviderInfo = 
		{
			"com.sun.star.comp.configuration.AdministrationProvider",
			aAdminProviderServices
		};
	}
//-----------------------------------------------------------------------
//-----------------------------------------------------------------------

	// service info export
	// const ServiceInfo* getConfigurationProviderServices()	- implemented by the provider class
	// const ServiceInfo* getLocalAdminProviderServices()		- implemented by the provider class
	// const ServiceInfo* getRemoteAdminProviderServices()		- implemented by the provider class

	const ServiceInfo* getAdminProviderServices()
	{
		return &aAdminProviderInfo;
	}
	const ServiceInfo* getUserAdminProviderServices()
	{
		return &aUserAdminProviderInfo;
	}

	const ServiceInfo* getConfigurationProviderServiceInfo(ConnectionSettings const& )
	{
		return getConfigurationProviderServices();
	}

	const ServiceInfo* getAdminProviderServiceInfo(ConnectionSettings const& _rConnectionSettings)
	{
		return _rConnectionSettings.isLocalSession() ? 
					getLocalAdminProviderServices() : 
					getRemoteAdminProviderServices();
	}

	//-----------------------------------------------------------------------------
	uno::Reference< uno::XInterface > SAL_CALL instantiateAdminProvider
		(
			uno::Reference< lang::XMultiServiceFactory > const& rServiceManager, 
			ConnectionSettings const& _rConnectionSettings
		);

	uno::Reference< uno::XInterface > SAL_CALL instantiateUserAdminProvider
		(
			uno::Reference< lang::XMultiServiceFactory > const& rServiceManager, 
			ConnectionSettings const& _rConnectionSettings
		);

	// provider instantiation
	uno::Reference< uno::XInterface > SAL_CALL instantiateAdminProvider( uno::Reference< lang::XMultiServiceFactory > const& rServiceManager, ConnectionSettings const& _aSettings )
	{
		if (_aSettings.isLocalSession())
		{
			return instantiateLocalAdminProvider(rServiceManager,_aSettings);
		}
		else
		{
			return instantiateRemoteAdminProvider(rServiceManager,_aSettings);
		}
	}

	//-----------------------------------------------------------------------------
	// provider instantiation
	uno::Reference< uno::XInterface > SAL_CALL instantiateUserAdminProvider( uno::Reference< lang::XMultiServiceFactory > const& rServiceManager, ConnectionSettings const& _aSettings )
	{
		if (_aSettings.isLocalSession())
		{
			OSL_ENSURE(false, "User administration not supported with Local sessions");

			lang::IllegalArgumentException e;
			e.Message = e.Message.createFromAscii("No User Administration possible for local Configurations");
			e.ArgumentPosition = -1;
			throw e;
		}

		return instantiateRemoteAdminProvider(rServiceManager,_aSettings) ;		
	}

} // namespace configmgr


