/*************************************************************************
 *
 *  $RCSfile: notifycallback.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: jb $ $Date: 2001/07/05 17:05:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CONFIGMGR_NOTIFYCALLBACK_HXX
#define CONFIGMGR_NOTIFYCALLBACK_HXX

#ifndef CONFIGMGR_XMLTREEBUILDER_HXX
#include "xmltreebuilder.hxx"
#endif
#ifndef _CONFIGMGR_SESSION_CONFIGSESSION_HXX_
#include "configsession.hxx"
#endif
#ifndef CONFIGMGR_TREEPROVIDER_HXX
#include "treeprovider.hxx"
#endif

#ifndef _OSL_CONDITN_HXX_
#include<osl/conditn.hxx>
#endif

#ifndef INCLUDED_MEMORY
#include <memory>
#define INCLUDED_MEMORY
#endif

namespace configmgr
{
	namespace uno		= ::com::sun::star::uno;
	namespace sax		= ::com::sun::star::xml::sax;

	using ::rtl::OUString;


	//==========================================================================
	//= ONotifyHandler
	//==========================================================================
	/** is a class which implements the hooks for async notifications.		
	*/
	class ONotifyHandler :
		public XMLTreeChangeListBuilder,
		public INotifyCallback,
		public INotifyBroadcaster		
	{
		StatusInfo						m_aStatus;
		::osl::Condition				m_aCondition;		
		std::auto_ptr<TreeChangeList>	m_pChanges;			// list for changes
		::vos::ORef< INotifyListener >	m_xNotifyListener;  // listener who receives a tree change list				
		::vos::ORef<OOptions>			m_xOptions;			// options to be used for the change list		
		AbsolutePath					m_aPath;			// root path for the notifications		
		AbsolutePath					m_aOrgPath;			// org path which is used for registering for notifications

	public:	
		ONotifyHandler(const vos::ORef<OOptions>& _aOptions, const AbsolutePath& _rPath, const AbsolutePath& _rOrgPath);

		virtual ~ONotifyHandler();

		// XDocumentHandler
		virtual void SAL_CALL startDocument(void) throw (sax::SAXException, uno::RuntimeException);
		virtual void SAL_CALL endDocument(void) throw(sax::SAXException, uno::RuntimeException);		
		
		// IInterface
		virtual void SAL_CALL acquire() throw();
		virtual void SAL_CALL release() throw();

		// IRequestCallback		
		virtual void failed(sal_Int32 _nErrorCode);
		virtual void done(const StatusInfo& _rStatus);		

		// IDataRequestCallback
		virtual	uno::Reference< sax::XDocumentHandler > getDataReader();

		// INotifyCallback
		virtual void notifyOccured(const AbsolutePath& _rPath);				

		// INotifyBroadcaster
		virtual	void setNotifyListener(const ::vos::ORef< INotifyListener >& _pListener);				

		StatusInfo waitToResponse(TimeValue* _pTimeout = NULL);
	};


} // namespace configmgr
#endif /* Header double load protection */
	
	
