/*************************************************************************
 *
 *  $RCSfile: treeaccess.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:13:41 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONFIGMGR_TREEACCESS_HXX_
#define _CONFIGMGR_TREEACCESS_HXX_

#ifndef _CONFIGMGR_SYNCHRONIZE_HXX_
#include "synchronize.hxx"
#endif

#ifndef _OSL_INTERLOCK_H_ 
#include <osl/interlck.h>
#endif
#ifndef _OSL_CONDITN_HXX_
#include <osl/conditn.hxx>
#endif

//..........................................................................
namespace configmgr
{
//..........................................................................

//==========================================================================
//= OTreeAccessor
//==========================================================================

/** a class (almost) implementing an ISynchronizedData interface [ can be used to do so].
	It's not really an "tree accessor", but as it controls tree access in this project, it's called so ...<BR>
	The accesses can not be bested in a sense that acquiring the write access when a read access is
	already acquired (in the same thread) will lead to a deadlock.
*/
class OTreeAccessor// : public ISynchronizedData
{
	::osl::Mutex			m_aMemberMutex;
	oslInterlockedCount		m_nReadAccess;
	::osl::Condition		m_aConditionZero;
	::osl::Mutex			m_aWriteAccessMutex;

	void incNumerator() 	{
		osl::MutexGuard aGuard(m_aMemberMutex);
		osl_incrementInterlockedCount(&m_nReadAccess);
		m_aConditionZero.reset();				 // will block
	}
	void decNumerator() 	{
		osl::MutexGuard aGuard(m_aMemberMutex);
		if (!osl_decrementInterlockedCount(&m_nReadAccess))
			m_aConditionZero.set();			 // will not block
	}

public:
	OTreeAccessor()
		:m_nReadAccess(0)
	{
		m_aConditionZero.set();
	}

public:
	void acquireReadAccess()
	{
		osl::MutexGuard aGuard(m_aWriteAccessMutex);
		incNumerator();
	}

	void releaseReadAccess() 
	{
		decNumerator();
	}

	void acquireWriteAccess() 
	{
		m_aWriteAccessMutex.acquire();
		m_aConditionZero.wait();
	}
	
	void releaseWriteAccess()
	{
		m_aWriteAccessMutex.release();
	}
};

//..........................................................................
}	// namespace configmgr
//..........................................................................

#endif // _CONFIGMGR_TREEACCESS_HXX_


