/*************************************************************************
 *
 *  $RCSfile: treebuildercallback.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: jb $ $Date: 2001/07/05 17:05:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

/* PLEASE DON'T DELETE ANY COMMENT LINES, ALSO IT'S UNNECESSARY. */

#ifndef CONFIGMGR_TREEBUILDERCALLBACK_HXX
#define CONFIGMGR_TREEBUILDERCALLBACK_HXX

#ifndef _CONFIGMGR_SESSION_CONFIGSESSION_HXX_
#include "configsession.hxx"
#endif

#ifndef _OSL_CONDITN_HXX_
#include<osl/conditn.hxx>
#endif

#ifndef _OSL_MUTEX_HXX_
#include<osl/mutex.hxx>
#endif

#include <memory>

namespace configmgr
{
	using ::rtl::OUString;

	namespace uno		= ::com::sun::star::uno;
	namespace sax		= ::com::sun::star::xml::sax;
// -----------------------------------------------------------------------------
	class XMLTreeBuilder;
	class XMLTreeChangeListBuilder;
	class INode;
	class ISubtree;
    namespace configuration { class Name; }
// -----------------------------------------------------------------------------

	class TreeBuilderCallback : 
		public IOpenObjectCallback
	{
	private:
		vos::ORefCount			m_nRefs;
		osl::Condition			m_aCondition;
		StatusInfo				m_aStatus;

		rtl::OUString			m_aNodeId;				
		vos::ORef<XMLTreeBuilder> m_xTreeBuilder;

	public:
		struct NoModule {};
		TreeBuilderCallback(NoModule, const vos::ORef<OOptions> &_aOptions);
        TreeBuilderCallback(configuration::Name const& _sModuleName, const vos::ORef<OOptions> &_aOptions);
		virtual ~TreeBuilderCallback();

		std::auto_ptr<ISubtree>	waitToResponse(TimeValue* _pTimeout = NULL);
		std::auto_ptr<INode>	waitToResponseForINode(TimeValue* _pTimeout = NULL);		

		StatusInfo getCallResult() const { return m_aStatus; }

		// IInterface
		virtual void SAL_CALL acquire(  ) throw();
		virtual void SAL_CALL release(  ) throw();

		// IRequestCallback
		virtual void done(const StatusInfo& _rStatus);
		virtual void failed(sal_Int32 _nErrorCode);

		// IDataRequestCallback
		virtual	uno::Reference< sax::XDocumentHandler > getDataReader(); 
		//{ return uno::Reference< sax::XDocumentHandler >(m_xTreeBuilder); }

		// IOpenObjectCallback
		virtual	void gotObjectId(const OUString& _rId);
	};


} // namespace configmgr
#endif /* Header double load protection */
	
	
