/*************************************************************************
 *
 *  $RCSfile: sessionstream.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: dg $ $Date: 2001/01/25 11:23:35 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _CONFIGMGR_SESSION_SESSIONSTREAM_HXX_
#define _CONFIGMGR_SESSION_SESSIONSTREAM_HXX_

#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif


//..........................................................................
namespace configmgr
{
//..........................................................................

//==========================================================================
//= OMutexWrapper
//==========================================================================
/** the current SUNPRO5 compiler has a bug with stack unwinding which includes
    inline dtors calling inline methods, if these calls are conditional.
    <BR>
    That's why we introduce an own mutex wrapping an osl::Mutex, which's acquire
    and - more important - release are not inline.
*/
class OMutexWrapper
{
	::osl::Mutex		m_aMaster;

public:
	void		acquire();
	void		release();
};

//==========================================================================
//= OSessionInputStream
//==========================================================================
typedef ::cppu::WeakImplHelper1< ::com::sun::star::io::XInputStream >	OSessionInputStream_Base;
/** abstract base class for input streams to be used with sessions
*/
class OSessionInputStream : public OSessionInputStream_Base
{
protected:
	void*							m_pReader;			/** the object to read from, shared with other objects, one of these
															(which we don't know) has the final responsibility (for destruction etc.)
															(which implies that we have to be carefull with the various lifetimes)
														*/
	sal_Int32						m_nBytesToSkip;		/// bytes to skip while the next read, see <method>skipBytes</method>
	sal_Bool						m_bClosed;			/** set to sal_True by <method>closeInput</method> before acquiring
															m_aMutex, never reset (it's nearly the same as with m_pReader,
															with the only difference that m_bClosed is set before m_pReader
															is really reset)
														*/
	OMutexWrapper					m_aMutex;			/// access safety
	typedef ::osl::Guard< OMutexWrapper >		Guard;

	::osl::Mutex					m_aCloseMutex;		/// safety within closeInput

	::com::sun::star::uno::Sequence< sal_Int8 >	
									m_aPrependSeq;		/// bytes to be prepended before reading from the socket

public:
	/** creates a new input stream, based on a object implementing the real read.<BR>
		@param		_pReader		the object to use. Must not be NULL. Instead of using a mutex common for different
									threads accessing the same socket, there are some conventions :<BR>
									The reader object MUST not be closed until <method>closeInput</method> on this stream
									object has been called.<BR>
									This implies that the object must not be deleted before calling
									<method>closeInput</method>.
	*/
	OSessionInputStream(void* _pReader);

	// XInputStream

	/// inherited by <type scope="com::sun::star::io">XInputStream</type>, see there
	virtual sal_Int32 SAL_CALL readBytes( ::com::sun::star::uno::Sequence< sal_Int8 >& aData, sal_Int32 nBytesToRead ) throw(::com::sun::star::io::NotConnectedException, ::com::sun::star::io::BufferSizeExceededException, ::com::sun::star::io::IOException, ::com::sun::star::uno::RuntimeException);

	/// inherited by <type scope="com::sun::star::io">XInputStream</type>, see there
	virtual sal_Int32 SAL_CALL readSomeBytes( ::com::sun::star::uno::Sequence< sal_Int8 >& aData, sal_Int32 nMaxBytesToRead ) throw(::com::sun::star::io::NotConnectedException, ::com::sun::star::io::BufferSizeExceededException, ::com::sun::star::io::IOException, ::com::sun::star::uno::RuntimeException);

	/** inherited by <type scope="com::sun::star::io">XInputStream</type>
		<BR>
		the implementation here does not block, instead it remembers the number of bytes and skips them in the next
		read call (which then may block).
	*/
	virtual void SAL_CALL skipBytes( sal_Int32 nBytesToSkip ) throw(::com::sun::star::io::NotConnectedException, ::com::sun::star::io::BufferSizeExceededException, ::com::sun::star::io::IOException, ::com::sun::star::uno::RuntimeException);

	/** inherited by <type scope="com::sun::star::io">XInputStream</type>
		<BR>
		not implemented here, as we are not able to determine how much bytes the socket can supply
	*/
	virtual sal_Int32 SAL_CALL available(  ) throw(::com::sun::star::io::NotConnectedException, ::com::sun::star::io::IOException, ::com::sun::star::uno::RuntimeException);

	/** inherited by <type scope="com::sun::star::io">XInputStream</type>
		<BR>
		closes the input, which in this special case means that m_pReader is not used any further. Instead all following
		calls to the <type scope="com::sun::star::io">XInputStream</type> methods will throw an
		<type scope="com::sun::star::io">NotConnectedException</type>.
		<BR>
		If some of the read methods is blocking while you call this method (from another thread), the read method
		will  be finished (we have no chance to cancel it), but throw an <type scope="com::sun::star::io">NotConnectedException</type>
		afterwards, as if it was called completely after closeInput, which will return after the read method.
	*/
	virtual void SAL_CALL closeInput(  ) throw(::com::sun::star::io::NotConnectedException, ::com::sun::star::io::IOException, ::com::sun::star::uno::RuntimeException);

protected:
	/** read some bytes into a buffer
		@precondition	m_aMutex has to be locked when calling this method
		@param		_pBuffer		the buffer to read the bytes into. Must not be NULL.
		@param		_nBytes			the maximum number of bytes to read, and - after a successfull return -
									the number of bytes really read.
									<BR>
									If you specifiy <var>_bWantAll</var> to be sal_True, but this number was decreased
									within this method, the end-of-file was reached.
		@param		_bWantAll		determines if the method may return if it has read at least one, but not all
									<var>_nBytes</var> bytes (sal_False) or if it should block 'til all the
									bytes are read.
		@return						sal_True, if the read operation (whether <var>_nBytes</var> or less bytes) was
									successfull, else sal_False (which counts for the eof-case, too)
		@throws						<type scope="com::sun::star::io">NotConnectedException</type>, if the stream
									is disconnecting using <method>closeInput</method> while a blocking call (though
									the read may have been served completely).
		@throws						<type scope="com::sun::star::io">IOException</type>, if an error occured
	*/
	virtual sal_Bool	implRead(::com::sun::star::uno::Sequence< sal_Int8 >& _aData, sal_Int32& _nBytes, sal_Bool _bWantAll)
		throw (::com::sun::star::io::NotConnectedException, ::com::sun::star::io::IOException) = 0;

	/** called from within closeInput. Do anything which is required to close your special reader here
	*/
	virtual void		implClose() = 0;

	/** skips bytes in the socket stream, as determined by m_nBytesToSkip
		<BR>
		should not be called when m_nBytesToSkip is zero, as no checks for this condition occur (which means you
		have to do them outside, which means you may spare a unnecessary call this method).
		@return		sal_True if all bytes (as determined by m_nBytesToSkip) where skipped, sal_False else.
					<BR>
					if sal_False is returned though the socket indicates that no error occured and the stream
					is not at eof, the method was unable to allocate the memory needed for the temporary buffer.
		@throws		<type scope="com::sun::star::io">NotConnectedException</type>, if the stream is disconnecting
					using <method>closeInput</method> while a blocking call (though the read may have been served
					completely).
	*/
	sal_Bool	implSkip()
		throw (::com::sun::star::io::NotConnectedException, ::com::sun::star::io::IOException);

	/** check if the strean object is connected to a socket stream, else throw an <type scope="com::sun::star::io">NotConnectedException</type>.
	*/
	virtual sal_Bool isConnected();

	inline void checkConnected()
	{
		if (!isConnected())
			throw ::com::sun::star::io::NotConnectedException(::rtl::OUString(), *this);
	}

	/** append some bytes to the sequence of bytes which is returned next round in doImplRead
		@seealso m_aPrependSeq
	*/
	void pushBackPrependBytes(const sal_Int8* _pBuffer, sal_Int32 _nCount);

	/** virtually the same as implRead, in addition the methods checks if the read request can be fullfilled
		with the data already present in m_aPrependSeq
	*/
	virtual sal_Bool	doImplRead(::com::sun::star::uno::Sequence< sal_Int8 >& _aData, sal_Int32& _nBytes, sal_Bool _bWantAll)
		throw (::com::sun::star::io::NotConnectedException, ::com::sun::star::io::IOException);
};

//==========================================================================
//= OSessionOutputStream
//==========================================================================
typedef ::cppu::WeakImplHelper1< ::com::sun::star::io::XOutputStream >	OSessionOutputStream_Base;
/** wraps an socket stream to an UNO <type scope="com::sun::star::io">XInputStream</type>
*/
class OSessionOutputStream : public OSessionOutputStream_Base
{
protected:
	void*						m_pWriter;			/** the object to write to, shared with other objects, one of these
														(which we don't know) has the final responsibility (for destruction etc.)
														(which implies that we have to be carefull with the various lifetimes)
													*/
	OMutexWrapper				m_aMutex;			/// access safety
	typedef ::osl::Guard< OMutexWrapper >	Guard;
	::osl::Mutex				m_aCloseMutex;		/// safety within closeInput

public:
	/** creates a new output stream, based on a object implementing the real read.<BR>
		If somebody calls closeInput on the <type scope="com::sun::star::io">XInputStream</type> interface,
		the socket will be closed.
		@param		_pWriter		the object to use. Must not be NULL. Instead of using a mutex common for different
									threads accessing the same object, there are some conventions :<BR>
									The object MUST not be closed until <method>closeOutput</method> on this stream
									object has been called.<BR>
									This implies that the object must not be deleted before calling
									<method>closeOutput</method>.
	*/
	OSessionOutputStream(void* _pWriter);

	/// inherited by <type scope="com::sun::star::io">XOutputStream</type>, see there
	virtual void SAL_CALL writeBytes( const ::com::sun::star::uno::Sequence< sal_Int8 >& aData ) throw(::com::sun::star::io::NotConnectedException, ::com::sun::star::io::BufferSizeExceededException, ::com::sun::star::io::IOException, ::com::sun::star::uno::RuntimeException);

	/** inherited by <type scope="com::sun::star::io">XOutputStream</type>
		empty implementation here, as we do no buffering
	*/
	virtual void SAL_CALL flush(  ) throw(::com::sun::star::io::NotConnectedException, ::com::sun::star::io::BufferSizeExceededException, ::com::sun::star::io::IOException, ::com::sun::star::uno::RuntimeException) { }

	/** inherited by <type scope="com::sun::star::io">XOutputStream</type>
		<BR>
		closes the output, which in this special case means that m_pWriter is not used any further. Instead all following
		calls to <method>writeBytes</method> will throw an <type scope="com::sun::star::io">NotConnectedException</type>.
	*/
	virtual void SAL_CALL closeOutput(	) throw(::com::sun::star::io::NotConnectedException, ::com::sun::star::io::BufferSizeExceededException, ::com::sun::star::io::IOException, ::com::sun::star::uno::RuntimeException);

protected:
	/** do the real write
	*/
	virtual sal_Int32	implWrite(const ::com::sun::star::uno::Sequence< sal_Int8 >& _rData) = 0;

	/** called from within closeInput. Do anything which is required to close your special writer here
	*/
	virtual void		implClose() = 0;

	/** check if the strean object is connected to a valid reader object,
		throw an <type scope="com::sun::star::io">NotConnectedException</type> if not.
	*/
	virtual sal_Bool isConnected();

	inline void checkConnected()
	{
		if (!isConnected())
			throw ::com::sun::star::io::NotConnectedException(::rtl::OUString(), *this);
	}
};

//..........................................................................
}	// namespace configmgr
//..........................................................................


#endif // _CONFIGMGR_SESSION_SESSIONSTREAM_HXX_


