/*************************************************************************
 *
 *  $RCSfile: loader.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/09 12:07:04 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdio.h>

#include "loader.hxx"

#ifndef CONFIGMGR_TREEPROVIDER_HXX
#include "treeprovider.hxx"
#endif
#ifndef CONFIGMGR_TREEBUILDERCALLBACK_HXX
#include "treebuildercallback.hxx"
#endif

#ifndef _CONFIGMGR_TRACER_HXX_
#include "tracer.hxx"
#endif

#ifndef _COM_SUN_STAR_CONTAINER_NOSUCHELEMENTEXCEPTION_HPP_
#include <com/sun/star/container/NoSuchElementException.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif

#ifndef _RTL_STRING_HXX_
#include <rtl/string.hxx>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

namespace configmgr
{
    using namespace rtl;
    using namespace com::sun::star::uno;
	namespace container = com::sun::star::container;

	
// -----------------------------------------------------------------------------
// class OTreeLoader
// -----------------------------------------------------------------------------
	OTreeLoader::OTreeLoader(IConfigSession* _pSession, 
							 AbsolutePath const& _aLoadedName, 
							 vos::ORef< OOptions > const& _xOptions, 
							 sal_Int16 _nMinLevels)
				:m_aLoadedName(_aLoadedName)
				,m_nLevels(_nMinLevels)			
				,m_pSession(_pSession)
				,m_xOptions(_xOptions)
				,m_bStarted(false)
	{
	}

// -----------------------------------------------------------------------------
	void OTreeLoader::start(INotifyListener* _pListener)
	{
		osl::MutexGuard aGuard( m_aMutex );
		if (!m_bStarted)
		{
			m_bStarted = true;
			if (!m_pSession->asITreeProvider() && m_pSession->asIUpdateProvider())
			{
				// Ohnly the remote session provides a async interface			
				m_xReader = new TreeBuilderCallback( getComponentName(),m_xOptions);
				sal_Int16 nLevels(m_nLevels);
				if (nLevels == ITreeProvider::ALL_LEVELS)
					// translate the level parameter if it says "all levels", cause this is represented by different
					// numbers inside and outside the session
					nLevels = IConfigSession::COMPLETE_SUBTREE;
				
				m_pSession->asIUpdateProvider()->openNode(getLoadedPath(), m_xOptions, nLevels, m_xReader.getBodyPtr(), _pListener);
			}
		}
	}

// -----------------------------------------------------------------------------
	std::auto_ptr<ISubtree> OTreeLoader::waitToResponse() CFG_UNO_THROW_ALL()
	{
		osl::MutexGuard aGuard( m_aMutex );
		OSL_ENSURE( m_bStarted, "Illegal usage of TreeLoader");
		std::auto_ptr<ISubtree> pReturn;

		if (ITreeProvider* pTreeProvider = m_pSession->asITreeProvider())
			pReturn = pTreeProvider->loadSubtree(getLoadedPath(), m_xOptions, m_nLevels);
		else
		{
			pReturn = m_xReader->waitToResponse(m_pSession->getMasterTimeout());
			if (!pReturn.get())
			{
				OUString sMessage = m_xReader->getCallResult().sMessage;
				throw container::NoSuchElementException(sMessage, NULL);
			}
		}
		return pReturn;
	}	
};
			
