/*************************************************************************
 *
 *  $RCSfile: setnodeimplbase.hxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: jb $ $Date: 2001/09/28 12:44:40 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CONFIGMGR_SETNODEBEHAVIOR_HXX_
#define CONFIGMGR_SETNODEBEHAVIOR_HXX_

#ifndef CONFIGMGR_CONFIGNODEBEHAVIOR_HXX_
#include "nodeimpl.hxx"
#endif

#ifndef CONFIGMGR_CONFIGTEMPLATE_HXX_
#include "template.hxx"
#endif

#ifndef INCLUDED_MEMORY
#include <memory>
#define INCLUDED_MEMORY
#endif

namespace configmgr
{
	class SubtreeChange;

	namespace configuration
	{
//-----------------------------------------------------------------------------
		typedef unsigned int NodeOffset;
		typedef unsigned int TreeDepth;

		class ElementTreeImpl;
        typedef vos::ORef<ElementTreeImpl> ElementTreeHolder; // also in configset.hxx
        typedef std::vector< ElementTreeHolder > ElementList; // also in treeimpl.hxx
        
//-----------------------------------------------------------------------------
	
		struct SetEntry
		{ 
			explicit SetEntry(ElementTreeImpl* pTree_);

			bool isValid()	const { return m_pTree != 0; }

			ElementTreeImpl* tree() const { return m_pTree; }; 
		private:
			ElementTreeImpl* m_pTree; 
		};
	//-------------------------------------------------------------------------

		struct SetNodeVisitor
		{
			enum Result { DONE, CONTINUE };
			virtual Result visit(SetEntry const& anEntry) = 0;
		};

//----------------------------------------------------------------------------
// Specific type of node
//-----------------------------------------------------------------------------

		class SetNodeImpl : public NodeImpl
		{
			ISubtree&		m_rOriginal;
			TemplateHolder	m_aTemplate;
			TemplateProvider m_aTemplateProvider;
			TreeImpl*		m_pParentTree;
			NodeOffset		m_nContextPos;

			typedef NodeOffset InitHelper;
			InitHelper		m_aInit;
		public:
			/// construct a set node referring to rOriginal as data node with the given element-template
			explicit SetNodeImpl(ISubtree& rOriginal, Template* pTemplate);
			/// 'Moving constructor': Constructs a set that takes the data from rOriginal, leaves rOriginal empty
			explicit SetNodeImpl(SetNodeImpl& rOriginal); // only for makeIndirect

			/// retrieve the name of the underlying node
			OUString getOriginalNodeName() const;

		// the following willmostly  be implemented by derived classes (using the virtual equivalents)
			/// does this set contain any elements (loads elements if needed)
			bool		isEmpty();
			/// does this set contain an element named <var>aName</var> (loads elements if needed)
			SetEntry	findElement(Name const& aName);
			/// does this set contain an element named <var>aName</var> (and is that element loaded ?)
			SetEntry	findAvailableElement(Name const& aName);

			/// insert a new entry into this set
			void		insertElement(Name const& aName, SetEntry const& aNewEntry);
			/// remove an existing entry into this set
			void		removeElement(Name const& aName);

			/// Initialize the set data: Set context information, and build the view (actually loading the elements may be deferred)
			void		initElements(TemplateProvider const& aTemplateProvider, TreeImpl& rParentTree, NodeOffset nPos, TreeDepth nDepth);

            /** Create a Subtree change as 'diff' which allows transforming the set to its default state
                (given that <var>_rDefaultTree</var> points to a default instance of this set)
                <p>Ownership of added trees should be transferred to the SubtreeChange.</p>
            */
            std::auto_ptr<SubtreeChange> differenceToDefaultState(ISubtree& _rDefaultTree);

			/// Mark this node as assuming its default state
			void markAsDefault();

			/// Call <code>aVisitor.visit(aElement)</code> for each element in this set until SetNodeVisitor::DONE is returned. 
			SetNodeVisitor::Result dispatchToElements(SetNodeVisitor& aVisitor);

			/// Get the template that describes elements of this set
			TemplateHolder getElementTemplate() const { return m_aTemplate; }

			/// Get a template provider that can create new elements for this set
			TemplateProvider getTemplateProvider() const { return m_aTemplateProvider; }

			/// Prepare committing the changes in this set and its descendants, if any - builds a SubtreeChange describing pending changes.
			std::auto_ptr<SubtreeChange> preCommitChanges(ElementList& _rRemovedElements);
			/// Finalize committing the changes - patch the original state wrapper, reset the pending changes
			void finishCommit(SubtreeChange& rChanges);
			/// Back out precommited changes - restore original state wrapper, rebuild the pending changes
			void revertCommit(SubtreeChange& rChanges);
			/// Fix up precommited changes after failure - try to detect failures, patch the original state wrapper, reset the pending changes
			void failedCommit(SubtreeChange& rChanges);

		// does not load elements:
			/// Adjust the internal representation after external changes to the original data - build NodeChangeInformation objects for notification
			void adjustToChanges(NodeChangesInformation& rLocalChanges, SubtreeChange const& rExternalChanges, TreeDepth nDepth);

		// legacy commit - default is 'Not supported'
		protected:
			~SetNodeImpl();
			virtual std::auto_ptr<SubtreeChange>doPreCommitChanges(ElementList& _rRemovedElements);
			virtual void doFinishCommit(SubtreeChange& rChanges);
			virtual void doRevertCommit(SubtreeChange& rChanges);
			virtual void doFailedCommit(SubtreeChange& rChanges);
		protected:
			TreeImpl*	getParentTree() const;
			NodeOffset	getContextOffset() const;

			ISubtree&	getOriginalSetNode() { return m_rOriginal; };

		// New Overrideables
		private:
			virtual bool		doIsEmpty() const = 0;
			virtual SetEntry	doFindElement(Name const& aName) = 0;
			virtual void		doInsertElement(Name const& aName, SetEntry const& aNewEntry) = 0;
			virtual void		doRemoveElement(Name const& aName) = 0;

            virtual void        doDifferenceToDefaultState(SubtreeChange& _rChangeToDefault, ISubtree& _rDefaultTree);
			virtual void        doMarkAsDefault() = 0;

			virtual void		doInitElements(ISubtree& rTree, TreeDepth nDepth) = 0;
			virtual void		doClearElements() = 0;

			virtual void		doAdjustToChanges(NodeChangesInformation& rLocalChanges, SubtreeChange const& rExternalChanges, TreeDepth nDepth) = 0;

			virtual SetNodeVisitor::Result doDispatchToElements(SetNodeVisitor& aVisitor) = 0;

			virtual void		doCollectChanges(NodeChanges& rChanges) const = 0;

		// NodeImpl implementation - direct clients don't need it
		protected:
			virtual Attributes		doGetAttributes() const;
			virtual NodeType::Enum	doGetType() const;

		private:
			virtual void			doCollectChangesWithTarget(NodeChanges& rChanges, TreeImpl* pParent, NodeOffset nNode) const;
			virtual void			doDispatch(INodeHandler& rHandler);

		protected:
			bool implHasLoadedElements() const;
            void implMarkAsDefault(bool bDefault);
            void implDifferenceToDefaultState(SubtreeChange& _rChangeToDefault, ISubtree& _rDefaultTree) const;
		private:
			bool implLoadElements();
			void implEnsureElementsLoaded();
			bool implInitElements(InitHelper const& aInit);
			void implCollectChanges(NodeChangesInformation& rLocalChanges, SubtreeChange const& rExternalChange, TreeDepth nDepth);
        };

//-----------------------------------------------------------------------------
		// domain-specific 'dynamic_cast' replacement
		SetNodeImpl&	AsSetNode  (NodeImpl& rNode);

//-----------------------------------------------------------------------------
	}
}

#endif // CONFIGMGR_SETNODEBEHAVIOR_HXX_
