/*************************************************************************
 *
 *  $RCSfile: attributeparser.cxx,v $
 *
 *  $Revision: 1.12 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/14 16:53:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdio.h> // include for solaris 8

#include "attributeparser.hxx"

#include "valueinfo.hxx" 
#include "strdecl.hxx" 
// -----------------------------------------------------------------------------

namespace configmgr
{
	namespace uno		= ::com::sun::star::uno;
	namespace sax		= ::com::sun::star::xml::sax;
// -----------------------------------------------------------------------------

static 
inline 
sal_Int16 impl_getIndexByName(uno::Reference< sax::XAttributeList > const& xAttribs, OUString const& aAttributeName)
{
	OSL_ENSURE( xAttribs.is(), "ERROR: NULL Attribute list");

	sal_Int16 nIndex = xAttribs->getLength();

	while (--nIndex >= 0)
	{
		if (xAttribs->getNameByIndex(nIndex).equals(aAttributeName))
			break;
	}
	// nIndex == -1 if not found

	return nIndex;
}
// -----------------------------------------------------------------------------
static 
inline 
bool impl_maybeGetAttribute(uno::Reference< sax::XAttributeList > const& xAttribs, OUString const& aAttributeName, /* OUT */ OUString& rAttributeValue)
{
	OSL_ENSURE( xAttribs.is(), "ERROR: NULL Attribute list");

	sal_Int16 const nEnd = xAttribs->getLength();

	for(sal_Int16 nIndex = 0; nIndex < nEnd; ++nIndex)
	{
		if (xAttribs->getNameByIndex(nIndex).equals(aAttributeName))
		{
			rAttributeValue = xAttribs->getValueByIndex(nIndex);
			break;
		}
	}
	// nIndex >= nEnd if not found

	return nIndex < nEnd; // broke out of loop when found
}
// -----------------------------------------------------------------------------
static 
inline 
bool impl_isValueType(OUString const& sType)
{
	return ! (sType.getLength()==0 || sType.equals(TYPE_SET)|| sType.equals(TYPE_GROUP));
}
// -----------------------------------------------------------------------------
/// takes the node name from either an attribute or the element name
OUString OAttributeParser::getNodeName(OUString const& _sElementName, uno::Reference< sax::XAttributeList > const& _xAttribs)
{
	OUString aRet( _sElementName );

	if (this->maybeGetAttribute(_xAttribs, ATTR_NAME, aRet))
	{
		// never prepend a package to a cfg:name value
	}
	else if (maybeGetAttribute(_xAttribs,ATTR_PACKAGE,aRet))
	{
		static sal_Unicode chPackageSep = '.';

		// this change is necesary for the server
		// because this name may contain a package name
		if (_sElementName.indexOf(aRet) == -1)
			aRet += OUString(&chPackageSep,1) += _sElementName;
		else
			aRet = _sElementName;

		if (m_sCurrentModule.getLength() == 0)
		{
			m_sCurrentModule = aRet;
		}
		else
			OSL_ENSURE(m_sCurrentModule == aRet, "Autodetected module name differs from externally specified module name");
	}
	return aRet;
}
// -----------------------------------------------------------------------------

/// retrieve the locale stored in the attribute list
OUString OAttributeParser::getLocale(uno::Reference< sax::XAttributeList > const& xAttribs)
{
	return xAttribs.is() ? xAttribs->getValueByName(ATTR_LANG) : OUString();
}
// -----------------------------------------------------------------------------

/// retrieve the locale stored in the attribute list or use the context locale
OUString OAttributeParser::getLocale(uno::Reference< sax::XAttributeList > const& xAttribs, OUString const& sContextLocale)
{
	OUString aRet( sContextLocale );

	this->maybeGetAttribute(xAttribs, ATTR_LANG, aRet);

	return aRet;
}
// -----------------------------------------------------------------------------

/// query whether the node is marked deleted
bool OAttributeParser::isDeleted(uno::Reference< sax::XAttributeList > const& xAttribs)
{
	bool bRet = false;

	OUString sState;
	if (this->maybeGetAttribute(xAttribs, ATTR_STATE, sState)) 
		bRet = !! sState.equals(STATE_DELETED);

	return bRet;
}
// -----------------------------------------------------------------------------

/// query whether the node is localized
bool OAttributeParser::isLocalized(uno::Reference< sax::XAttributeList > const& xAttribs)
{
	bool bRet = false;
	this->maybeGetAttribute(xAttribs, ATTR_LOCALIZE, bRet);
	return bRet;
}
// -----------------------------------------------------------------------------

/// retrieve the node's type name
OUString OAttributeParser::getType(uno::Reference< sax::XAttributeList > const& xAttribs)
{
	return xAttribs.is() ? xAttribs->getValueByName(ATTR_TYPE) : OUString();
}
// -----------------------------------------------------------------------------

/// query whether the node is a value
bool OAttributeParser::isValue(uno::Reference< sax::XAttributeList > const& xAttribs)
{
	return impl_isValueType( getType(xAttribs) );
}
// -----------------------------------------------------------------------------

/// query whether the node is a set
bool OAttributeParser::isSet(uno::Reference< sax::XAttributeList > const& xAttribs)
{
	if ( !xAttribs.is() ) return false;

	sal_Int16 nIndex = impl_getIndexByName(xAttribs, ATTR_INSTANCE);

#ifdef _DEBUG
	OUString sType = getType(xAttribs);
	if (nIndex >= 0) // has an instance type 
	{
		OSL_ENSURE( nIndex < xAttribs->getLength(), "ERROR: getIndexByName return index out of bounds");

		OSL_ENSURE( xAttribs->getValueByIndex(nIndex).getLength(), 
					"OAttributeParser: INVALID XML: Found a node with an empty element-type");

		OSL_ENSURE(sType.getLength() == 0 || sType.equalsIgnoreAsciiCase(TYPE_SET), 
					"OAttributeParser: INVALID XML: Found a non-'set'-node having an element-type");
	}
	else
	{
		OSL_ENSURE(!sType.equalsIgnoreAsciiCase(TYPE_SET), 
					"OAttributeParser: INVALID XML: Found a 'set'-node without an element-type");
	}
#endif

	return (nIndex >= 0);
}
// -----------------------------------------------------------------------------

/// retrieve element type (without module name) of a set, 
bool OAttributeParser::getSetElementType(uno::Reference< sax::XAttributeList > const& xAttribs, OUString& aElementType)
{
	return this->maybeGetAttribute(xAttribs, ATTR_INSTANCE, aElementType);
}
// -----------------------------------------------------------------------------

/// retrieve element type and associated module name of a set, 
bool OAttributeParser::getSetElementType(uno::Reference< sax::XAttributeList > const& xAttribs, OUString& aElementType, OUString& aElementTypeModule)
{
	if (!this->maybeGetAttribute(xAttribs, ATTR_INSTANCE, aElementType))
		return false;

	if (!impl_maybeGetAttribute(xAttribs, ATTR_MODULE, aElementTypeModule))
	{
		// no explicit module attribute found - check for legacy format 'module/instance'
		sal_Int32 nPos = aElementType.lastIndexOf('/');
		static OUString aPrefix = TEMPLATE_MODULE_NATIVE_PREFIX;	

		if (0 <= nPos)
		{
			aElementTypeModule	= aElementType.copy(0,nPos);
			aElementType		= aElementType.copy(nPos+1);
		}
		else if (aElementType.compareTo(aPrefix,aPrefix.getLength()) == 0)
			aElementTypeModule = TEMPLATE_MODULE_NATIVE_VALUE;

		else
			aElementTypeModule = this->getCurrentModule();
	}

	OSL_ENSURE(aElementType.getLength(),		"OAttributeParser: INVALID XML: Empty template instance name found.");
	OSL_ENSURE(aElementTypeModule.getLength(), "OAttributeParser: WARNING: Template module name not set.");

	return true;
}
// -----------------------------------------------------------------------------

/// reads attributes for nodes from the attribute list
void OAttributeParser::getNodeAttributes(uno::Reference< sax::XAttributeList > const& xAttribs, NodeAttributes& rAttributes)
{
	if (xAttribs.is())
	{
		bool bValue;

		if (maybeGetAttribute(xAttribs, ATTR_WRITABLE, bValue)) 
        {
			rAttributes.bWritable   = bValue;
			rAttributes.bFinalized  = false;
        }

	    if (maybeGetAttribute(xAttribs, ATTR_FINALIZE, bValue)) 
        {
            OSL_ENSURE(rAttributes.bWritable || !bValue, "Unexpected attribute mix: read-only node is marked as final");
		    rAttributes.bFinalized = bValue && rAttributes.bWritable;
        }

		if (maybeGetAttribute(xAttribs,ATTR_NULLABLE , bValue)) 
			rAttributes.bNullable = bValue;

		if (maybeGetAttribute(xAttribs, ATTR_LOCALIZE, bValue)) 
			rAttributes.bLocalized = bValue;

		// rAttributes.bNotified	- no matching attribute defined
		// rAttributes.bConstrained - no matching attribute defined

		// internal use
		OUString sState;
		if (impl_maybeGetAttribute(xAttribs, ATTR_STATE, sState)) 
        {
            if (sState.equals(STATE_REPLACED))
                rAttributes.setState( node::isReplaced );

		    else if ( sState.equals(STATE_DEFAULT) )
                rAttributes.setState( node::isDefault );

            else if  ( sState.equals(STATE_MODIFIED) )
                rAttributes.setState( node::isMerged );
        }
	}
}
// -----------------------------------------------------------------------------

/// reads attributes for value nodes from the attribute list
bool OAttributeParser::getValueInfo(uno::Reference< sax::XAttributeList > const& xAttribs, ValueInfo& aInfo)
{
	if (!xAttribs.is()) return false;

	impl_maybeGetAttribute(xAttribs, ATTR_TYPE, aInfo.sType);

	getNodeAttributes(xAttribs, aInfo.aAttributes);			

	if (!impl_isValueType(aInfo.sType))
	{
		return false;
	}

	bool bNull;
	if (maybeGetAttribute(xAttribs, ATTR_NULL, bNull)) 
	{
		aInfo.isNull = bNull;
	}

	OUString sModifier;
	if (impl_maybeGetAttribute(xAttribs, ATTR_TYPE_MODIFIER, sModifier)) 
	{
		aInfo.isList = !! sModifier.equals(TYPE_MODIFIER_LIST);
	}

	if (impl_maybeGetAttribute(xAttribs, ATTR_SEPARATOR, aInfo.sSeparator)) 
	{
		OSL_ENSURE( aInfo.isList && 
					(aInfo.sSeparator.trim().getLength() == 0 || aInfo.sType.equalsIgnoreAsciiCase(TYPE_STRING)),
					"OAttributeParser: Found separator unexpectedly");
	}

	if (impl_maybeGetAttribute(xAttribs, ATTR_ENCODING, aInfo.sEncoding)) 
	{
		OSL_ENSURE( aInfo.sType.equalsIgnoreAsciiCase(TYPE_BINARY),
					"OAttributeParser: Found encoding unexpectedly");
	}

	return true;
}
// -----------------------------------------------------------------------------

// low-level internal methods
/// checks for presence of a boolean attribute and assigns its value if it exists (and is a bool)
bool OAttributeParser::maybeGetAttribute(uno::Reference< sax::XAttributeList > const& xAttribs, OUString const& aAttributeName, bool& rAttributeValue)
{
	OUString sAttribute;
	
	if ( !this->maybeGetAttribute(xAttribs, aAttributeName, sAttribute) )
	{
		return false;
	}

	else if (sAttribute.equals(ATTR_VALUE_TRUE))
		rAttributeValue = true; // will return true

	else if (sAttribute.equals(ATTR_VALUE_FALSE))
		rAttributeValue = false;  // will return true

	else 
	{
		OSL_ENSURE(sAttribute.getLength() == 0, "Invalid text found in boolean attribute");
		return false;
	}

	return true;
}
// -----------------------------------------------------------------------------

/// checks for presence of an attribute and assigns its value if it exists 
bool OAttributeParser::maybeGetAttribute(uno::Reference< sax::XAttributeList > const& xAttribs, OUString const& aAttributeName, OUString& rAttributeValue)
{
	return xAttribs.is() && impl_maybeGetAttribute(xAttribs, aAttributeName, rAttributeValue);
}
// -----------------------------------------------------------------------------

/// assigns an attribute value or an empty string if it doesn't exist
void OAttributeParser::alwaysGetAttribute(uno::Reference< sax::XAttributeList > const& xAttribs, OUString const& aAttributeName, OUString& rAttributeValue)
{
	if (xAttribs.is())
		rAttributeValue	= xAttribs->getValueByName(aAttributeName);
	else
		rAttributeValue	= OUString();
}
// -----------------------------------------------------------------------------

} // namespace

