/*************************************************************************
 *
 *  $RCSfile: binarydecide.cxx,v $
 *
 *  $Revision: 1.6 $
 *
 *  last change: $Author: dg $ $Date: 2001/09/18 19:17:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "binarydecide.hxx"
#include "filehelper.hxx"

namespace configmgr
{
	using namespace osl;

// -----------------------------------------------------------------------------
// This Memberfunctions helps to decide which file is to load, the xml or the binary file.
// -----------------------------------------------------------------------------
	bool OFileTimeStampDecision::isBTimeGreaterATime(TimeValue const& A, TimeValue const& B) const
	{
		if (B.Seconds > A.Seconds) return true;
		if (B.Seconds < A.Seconds) return false;
		
		// Seconds are equal, check Nanoseconds
		if (B.Nanosec > A.Nanosec) return true;
		
		// lower or equal
		return false;
	}
// -----------------------------------------------------------------------------	
	DecideContext OFileTimeStampDecision::getNewerFile(DecideContext const& _aContextA, DecideContext const& _aContextB) const
	{
		// PRE: _sFileA and _sFileB must exist.
		
		TimeValue aFileStampA(FileHelper::getModifyTime(_aContextA.sFileURL));
		TimeValue aFileStampB(FileHelper::getModifyTime(_aContextB.sFileURL));
		
		return (isBTimeGreaterATime(aFileStampA, aFileStampB)) ? _aContextB : _aContextA;
	}
// -----------------------------------------------------------------------------
	DecideContext OFileTimeStampDecision::checkFileStamp(OLookupContext const& _rLookup)
	{		
		// determines if both files exist, if this is not the case choose always the XML file		
		rtl::OUString sXMLFileURL = _rLookup.composeFileURL(Lookup::DEFAULT);
		rtl::OUString sBinaryFileURL = _rLookup.composeFileURL(Lookup::CACHE);

		DecideContext aRes(sXMLFileURL, Lookup::DEFAULT);
		if (FileHelper::fileExists(sXMLFileURL) && FileHelper::fileExists(sBinaryFileURL))
			// youngest of 2 Files		
			aRes = getNewerFile(aRes, DecideContext(sBinaryFileURL, Lookup::CACHE));			
		return aRes;
	}	
} // namespace
