/*************************************************************************
 *
 *  $RCSfile: binarytype.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/09 12:18:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CONFIGMGR_BINARYTYPE_HXX
#define CONFIGMGR_BINARYTYPE_HXX

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

namespace configmgr
{
	// -----------------------------------------------------------------------------

	namespace ValueType
	{
		enum Enum
		{
			val_any = 0,
            val_string,
			val_boolean,
			val_int8,
			val_int16,
			val_int32,
			val_int64,
			val_double,
			val_binary,
			
			val_is_null = 0x10,

			sequence    = 0x20,
			seq_any     = sequence,
			seq_string,
			seq_boolean,
			seq_int8,
			seq_int16,
			seq_int32,
			seq_int64,
			seq_double,
			seq_binary,

			mask = 0x3F,
			seq_mask = 0x1f
		};
/*
		inline
		Enum operator & (Enum lhs, Enum rhs)
		{ 
			return Enum((lhs|0u) & rhs);
		}
		inline 
		Enum operator|(Enum lhs, Enum rhs)
		{
			return Enum(lhs | 0u | rhs);
		}
*/
	}
	
    namespace NodeType
	{	
		enum Enum
		{
			stop      = 0,
			subtree   = 0x40,
			value     = 0x80,
			
			group     = subtree,
			ntyp_set  = subtree | 0x01,
			
			valuechange   = value,
			addnode       = value | 0x01,
			removenode    = value | 0x02,

			vtyp_mask = ValueType::mask
		};
	}

	namespace StringType
	{
		enum Enum
		{
			UTF8 = 0x0,
			Unicode
		};
	}
	
	
	const sal_Int32 CFG_BINARY_SUBTREE_MAGIC = 1000000001;
	const sal_Int32 CFG_BINARY_VERSION = 2;

	const sal_Int32 CFG_BINARY_SUBTREECHANGE_MAGIC = 1100000001;

}
#endif
