/*************************************************************************
 *
 *  $RCSfile: localsession.cxx,v $
 *
 *  $Revision: 1.76 $
 *
 *  last change: $Author: jb $ $Date: 2001/12/07 18:19:33 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>

#include "localsession.hxx"

#ifndef _CONFIGMGR_OSLSTREAM_HXX_
#include "oslstream.hxx"
#endif
#ifndef INCLUDED_CONFIGMGR_MERGECHANGE_HXX
#include "mergechange.hxx"
#endif
#ifndef _CONFIGMGR_XMLTREEBUILDER_HXX
#include "xmltreebuilder.hxx"
#endif
#ifndef _CONFIGMGR_SAXTOOLS_HXX_
#include "saxtools.hxx"
#endif
#ifndef _CONFIGMGR_FILEHELPER_HXX_
#include "filehelper.hxx"
#endif
#ifndef CONFIGMGR_CONFIGEXCEPT_HXX_
#include "configexcept.hxx"
#endif
#ifndef CONFIGMGR_MISC_OPTIONS_HXX_
#include "options.hxx"
#endif
#ifndef _CONFIGMGR_TREEACTIONS_HXX_
#include "treeactions.hxx"
#endif
#ifndef CONFIGMGR_LOCALIZEDTREEACTIONS_HXX
#include "localizedtreeactions.hxx"
#endif
#ifndef CONFIGMGR_NODECONVERTER_HXX
#include "nodeconverter.hxx"
#endif
#ifndef CONFIGMGR_XMLFORMATER_HXX
#include "xmlformater.hxx"
#endif
#ifndef CONFIGMGR_NAMEHELPER_HXX
#include "namehelper.hxx"
#endif
#ifndef CONFIGMGR_ATTRIBUTEPARSER_HXX
#include "attributeparser.hxx"
#endif
#ifndef CONFIGMGR_BINARYHANDLER_HXX
#include "writesubtreeasbinaryhandler.hxx"
#endif
#ifndef CONFIGMGR_BINARYREADER_HXX
#include "binaryreader.hxx"
#endif
#ifndef CONFIGMGR_BINARYDECIDE_HXX_
#include "binarydecide.hxx"
#endif
#ifndef CONFIGMGR_PARSERCONTEXT_HXX
#include "parsercontext.hxx"
#endif
#ifndef CONFIGMGR_GENERATECACHE_HXX
#include "generatecache.hxx"
#endif
#ifndef CONFIGMGR_XML_UPDATEHANDLER_HXX_
#include "updatehandler.hxx"
#endif
#ifndef _CONFIGMGR_TRACER_HXX_
#include "tracer.hxx"
#endif
#ifndef _COM_SUN_STAR_XML_SAX_XDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XDocumentHandler.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_INPUTSOURCE_HPP_
#include <com/sun/star/xml/sax/InputSource.hpp>
#endif
#ifndef _COM_SUN_STAR_XML_SAX_SAXPARSEEXCEPTION_HPP_
#include<com/sun/star/xml/sax/SAXParseException.hpp>
#endif
#ifndef _COM_SUN_STAR_CONFIGURATION_CANNOTLOADCONFIGURATIONEXCEPTION_HPP_
#include <com/sun/star/configuration/CannotLoadConfigurationException.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_WRAPPEDTARGETEXCEPTION_HPP_
#include<com/sun/star/lang/WrappedTargetException.hpp>
#endif

#ifndef CONFIGMGR_LOOKUPCONTEXT_HXX_
#include <lookupcontext.hxx>
#endif

#ifndef _RTL_LOGFILE_HXX_
#include <rtl/logfile.hxx>
#endif

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::xml;
using namespace ::com::sun::star::xml::sax;
using namespace ::com::sun::star::io;
using namespace ::vos;
using namespace ::std;
using namespace ::osl;
using namespace ::rtl;
using ::com::sun::star::configuration::CannotLoadConfigurationException;

#define ASCII(x) rtl::OUString::createFromAscii(x)

#define RTL_LOGFILE_OU2A(rtlOUString)	(::rtl::OString((rtlOUString).getStr(), (rtlOUString).getLength(), RTL_TEXTENCODING_ASCII_US).getStr())

namespace configmgr 
{
    using namespace configuration;

	// -----------------------------------------------------------------------------
#ifdef DEBUG
	class TraceTree : public ChangeTreeAction
	{
	public:
		// ChangeTreeAction
		virtual void handle(SubtreeChange const& aSubtree)
			{
				aSubtree.forEachChange(*this);
			}
		
		virtual void handle(ValueChange const& aValueNode)
			{
				volatile int dummy = 0;
			}
		
		virtual void handle(AddNode const& aAddNode)
			{
				volatile int dummy = 0;
			}
		
		virtual void handle(RemoveNode const& aRemoveNode)
			{
				volatile int dummy = 0;
			}		
	};
#endif

	// -----------------------------------------------------------------------------
	namespace 
	{
		struct DocumentBuilder
		{
			typedef Reference< sax::XParser > ParserRef;
			typedef Reference< sax::XDocumentHandler > HandlerRef;

			ParserRef xParser;
	
			DocumentBuilder(ParserRef const& xParser_, HandlerRef const& xHandler_)
			: xParser(xParser_)
			{
				xParser->setDocumentHandler(xHandler_);
			}
			~DocumentBuilder()
			{
				xParser->setDocumentHandler(NULL);
			}

			void parseStream( sax::InputSource const& aInputSource )
				throw (sax::SAXException, RuntimeException)
			{
				xParser->parseStream(aInputSource);
			}
		};
	}

	// -----------------------------------------------------------------------------	
	/*  separates the path of a requested subtree into all it's components
		This is used during XML parsing to determine, when to start evaluating the tree.
	*/
	class ONodePath
	{
		std::vector<rtl::OUString> aElements;
	
	public:
		ONodePath(const AbsolutePath &_rPath)
		{
			aElements.push_back(_rPath.getModuleName().toString());
			AbsolutePath::Iterator it = _rPath.begin();
 			if (it != _rPath.end())
 			{
 				for( ++it; it != _rPath.end() ; ++it)
 				{
 					aElements.push_back(it->getName().toString());
 				}
 			}
		}

		std::vector<rtl::OUString> getElements() const {return aElements;}
	};	

	// -----------------------------------------------------------------------------	
	LocalSession::LocalSession(const Reference< XMultiServiceFactory >& _rxServiceProvider)
				 :m_eError(E_None)
				 ,m_xServiceProvider(_rxServiceProvider)				 
				 ,m_nAccessFlags(Lookup::USER_MODE)			  
	{
		// create empty Objects
		m_xParser = Reference< sax::XParser >(_rxServiceProvider->createInstance(
			::rtl::OUString::createFromAscii("com.sun.star.xml.sax.Parser")),
											  UNO_QUERY);
		if (!m_xParser.is())
		{
			OSL_ENSURE(sal_False, "LocalSession::LocalSession : no or invalid SAX XML Parser !");
			m_eError = E_Invalid;
			return;
		}
	}	

	// -----------------------------------------------------------------------------
	LocalSession::~LocalSession()
	{
	}

	
// -----------------------------------------------------------------------------
	static inline OUString makeString(sal_Unicode const ch)
	{
		return OUString(&ch, 1);
	}
// -----------------------------------------------------------------------------
    static inline node::Attributes getDefaultStartAttributes()
    {
        node::Attributes aResult;
        aResult.setState( node::isDefault );
        return aResult;
    }
// -----------------------------------------------------------------------------
    static inline node::Attributes getTemplateStartAttributes()
    {
        node::Attributes aResult;
        aResult.setState( node::isReplaced );
        return aResult;
    }
// -----------------------------------------------------------------------------

	void LocalSession::setSetupMode(bool _bRecreateBinary)
	{
		// if (_bRecreateBinary) is set, all cache files are build during closing of the session
		// this is typically used during setup
		m_nAccessFlags = _bRecreateBinary ? Lookup::SETUP_MODE : Lookup::ADMIN_MODE;		
	}

	// -----------------------------------------------------------------------------
	void LocalSession::open(const ::rtl::OUString& _rShareURLPath, const ::rtl::OUString& _rUserURLPath) CFG_UNO_THROW_ALL(  )
	{
		if (isOpen())
			return;

		OSL_ENSURE(m_nAccessFlags & Lookup::DEFAULT,
                    "Invalid Access mask in LocalSession::open: not using DEFAULT layer");

		if (!FileHelper::dirExists(_rShareURLPath))
		{
			rtl::OUString sMsg(RTL_CONSTASCII_USTRINGPARAM("Unable to access the configuration path '"));
			sMsg += _rShareURLPath;
			sMsg += ASCII("'.");
			throw CannotLoadConfigurationException(sMsg,0);
		}		

		if (m_nAccessFlags & Lookup::USER)
		{
		    if (_rUserURLPath.equals(_rShareURLPath))
		    {
			    rtl::OUString sMsg(RTL_CONSTASCII_USTRINGPARAM("Invalid path specification, default path equals update path."));			
			    throw CannotLoadConfigurationException(sMsg,0);
		    }

			// guarantee that the path exists
			FileHelper::mkdirs(_rUserURLPath);
			if (!FileHelper::dirExists(_rUserURLPath))
			{
				rtl::OUString sMsg(RTL_CONSTASCII_USTRINGPARAM("Unable to access the configuration path '"));
				sMsg += _rUserURLPath;
				sMsg += ASCII("'.");
				throw CannotLoadConfigurationException(sMsg,0);
			}
        }

		m_aSharedURL = _rShareURLPath;
		m_aUserURL	 = _rUserURLPath;				
	}
	
// -----------------------------------------------------------------------------
	void LocalSession::close()
	{
		::osl::MutexGuard aGuard(m_aMutex);
		// after having completed the setup with updates into the default layer,
		// we now want to create all cache files the first time. therefor we upgrade the mode to ADMIN
		if (m_nAccessFlags == Lookup::SETUP_MODE)
		{
			m_nAccessFlags = Lookup::ADMIN_MODE;
			OGenerateCache aGenerate(m_aSharedURL + FileHelper::delimiterAsString() + OLookupContext::instanceCategory(), 
									 m_aSharedURL + FileHelper::delimiterAsString() + OLookupContext::cacheCategory() + FileHelper::delimiterAsString() + OLookupContext::instanceCategory(),
                                     this, getDefaultStartAttributes());
		}
		// a empty shared URL indicates that the session is closed
		m_aSharedURL = OUString();
	}
	
// -----------------------------------------------------------------------------
	sal_Bool LocalSession::isOpen()
	{
		::osl::MutexGuard aGuard(m_aMutex);
		return m_aSharedURL.getLength() != 0;
	}

	//--------------------------------------------------------------------------
	ITreeProvider* LocalSession::asITreeProvider()              {return this;}
	ITreeProvider const* LocalSession::asITreeProvider() const  {return this;}
	IDefaultProvider* LocalSession::asIDefaultProvider()        {return this;}
	ITemplateProvider* LocalSession::asITemplateProvider()      {return this;}

	// -----------------------------------------------------------------------------
    sal_Bool LocalSession::isAutoLoadingDefaults() const
    {
        return true /*m_bSetupMode */;
    }

	// ITemplateProvider
	// -----------------------------------------------------------------------------

	std::auto_ptr<INode> LocalSession::requestTemplateInstance(
                                            Name const& _aName, Name const& _rModule, 
                                            const vos::ORef < OOptions >& _xOptions
                                        ) 
                                        CFG_UNO_THROW_ALL(  )
	{
		::osl::MutexGuard aGuard(m_aMutex);
		
		// Templates can be found only in the share directory 
		OLookupContext aLookup(m_aSharedURL, 
							   m_aUserURL, 
							   AbsolutePath::makeModulePath(_rModule, AbsolutePath::NoValidate()),
							   Lookup::TEMPLATE_MODE); 				

		// Templates are not found in binary optimized form
		std::auto_ptr<ISubtree> pIRootSubtree = composeSubtree(aLookup, _xOptions);
		std::auto_ptr<INode> pResult;

        if (pIRootSubtree.get())
		{
			if (_aName.isEmpty())
			{
				pResult.reset( pIRootSubtree.release() );
			}
			else
			{
				pResult = pIRootSubtree->removeChild( _aName.toString() );
			}
		}
		return pResult;
	}

// -----------------------------------------------------------------------------

	std::auto_ptr<ISubtree> LocalSession::loadSubtree(
                                                configuration::AbsolutePath const& _aSubtreePath, 
                                                const vos::ORef < OOptions >& _xOptions,
                                                sal_Int16 _nMinLevels
                                            ) 
                                            CFG_UNO_THROW_ALL(  )
	{
		::osl::MutexGuard aGuard(m_aMutex);		 // #87880# wait if other thread works

		RTL_LOGFILE_CONTEXT_AUTHOR(aLog, "configmgr::LocalSession", "jb99855", "loadSubtree()");
		RTL_LOGFILE_CONTEXT_TRACE1(aLog, "%s", RTL_LOGFILE_OU2A(_aSubtreePath.getModuleName().toString()) );

		OLookupContext aLookup(m_aSharedURL, 
							   m_aUserURL, 
							   _aSubtreePath,
							   m_nAccessFlags); 						

		CFG_TRACE_INFO("local session::requestSubtree() start %s", OUSTRING2ASCII(_aSubtreePath.toString()));
		::std::auto_ptr<ISubtree> pSubtree = composeSubtree(aLookup, _xOptions);
		CFG_TRACE_INFO_NI("local session::requestSubtree() stop");
		
		return pSubtree;
	}
	
// -----------------------------------------------------------------------------
    std::auto_ptr<ISubtree> LocalSession::requestDefaultData(
                                                configuration::AbsolutePath const& _aSubtreePath, 
                                                const vos::ORef < OOptions >& _xOptions,
                                                sal_Int16 _nMinLevels
                                            ) 
                                            CFG_UNO_THROW_ALL(  )
    {
		::osl::MutexGuard aGuard(m_aMutex);		 // #87880# wait if other thread works

		RTL_LOGFILE_CONTEXT_AUTHOR(aLog, "configmgr::LocalSession", "jb99855", "loadSubtree()");
		RTL_LOGFILE_CONTEXT_TRACE1(aLog, "%s", RTL_LOGFILE_OU2A(_aSubtreePath.getModuleName().toString()) );

		OLookupContext aLookup(m_aSharedURL, 
							   m_aUserURL, 
							   _aSubtreePath,
                               m_nAccessFlags & Lookup::DEFAULT_MASK); 						

		CFG_TRACE_INFO("local session::requestDefaultData() start %s", OUSTRING2ASCII(_aSubtreePath.toString()));
		::std::auto_ptr<ISubtree> pSubtree = composeSubtree(aLookup, _xOptions);
		CFG_TRACE_INFO_NI("local session::requestDefaultData() stop");
		
		return pSubtree;
    }

// -----------------------------------------------------------------------------
	std::auto_ptr<ISubtree> LocalSession::composeSubtree( 
                                                OLookupContext const& _rLookup, 
										        const vos::ORef<OOptions>& _rOptions
                                            ) 
                                            CFG_UNO_THROW_ALL(  )
	{
		// PRE: the requested Value is not in the cache
		// POST: open the share file as TreeChangeList
		//       if exist, open the user file,
		//       Merge both TreeChangeLists together
		// Handle correct Modulename	
		
		// -------------------------------------
		RTL_LOGFILE_CONTEXT_AUTHOR(aLog, "configmgr::LocalSession", "dg", "composeSubtree()");
		RTL_LOGFILE_CONTEXT_TRACE1(aLog, "modulename: %s ", RTL_LOGFILE_OU2A(_rLookup.getNodePath().toString()));

		std::auto_ptr<ISubtree> pSubtree = loadSubtree(_rLookup, _rOptions);		
		
		// only if the user layer should be accessed, we need to merge
		if (_rLookup.getAccessFlags() & Lookup::USER)
		{			
			// Create a TreeChangeList with the right name, parentname and ConfigurationProperties
			TreeChangeList aChangeList(_rOptions, _rLookup.getNodePath());

						
			if ( loadTreeChangeFromXML(_rLookup, aChangeList) )
			{
				// if we didn't found anything in share, but in the user file (set template)
				// we need a dummy tree							
				if (pSubtree.get() == NULL)
				{
                    OSL_ENSURE(false, "Composing changes with no share Tree");

                    pSubtree = OTreeNodeConverter().createCorrespondingNode( aChangeList.root);
				}
				
				// apply the changes on the tree loaded from the default layer
				::configmgr::mergeLayer(aChangeList, *pSubtree);						
			}
		}

		if (pSubtree.get())
		{
			static const OUString aDummyId(RTL_CONSTASCII_USTRINGPARAM("Generated by local session"));
			OIdPropagator::propagateIdToTree(aDummyId, *pSubtree);
		}
		return pSubtree;
	}
	
// -----------------------------------------------------------------------------

	std::auto_ptr<ISubtree> LocalSession::loadSubtree(
                                                OLookupContext const& _rLookup, 
										        const vos::ORef<OOptions>& _rOptions
                                            ) 
                                            CFG_UNO_THROW_ALL(  )
	{
		CFG_TRACE_INFO("loadSubtree %s", OUSTRING2ASCII(_rLookup.getNodePath().getModuleName().toString()));

		std::auto_ptr<ISubtree> pResult;

		bool bLoaded = false;

		if (_rLookup.getAccessFlags() & Lookup::CACHE)
		{
			OFileTimeStampDecision aDecide(_rLookup);
			if (aDecide.getAccessFlag() == Lookup::CACHE)
			{	
			    // load stuff in binary form
			    CFG_TRACE_INFO_NI("Loading binary file ...");			
			    try
			    {
				    pResult = read(_rLookup.getNodePath(), aDecide.getFileURL(), m_xServiceProvider);
			    
                    bLoaded = true;
                }
			    catch (io::IOException &e)
			    {
				    CFG_TRACE_ERROR_NI("LoadShareAsSubtree: problem with binary file read(): %s", OUSTRING2ASCII(e.Message));
				    OSL_ENSURE(false, "LoadShareAsSubtree: problem with binary file read(), try fallback, read XML");
                    OSL_ASSERT(!bLoaded);
                }
			}			
        }

		if (!bLoaded) 
		{
			// load stuff in xml form
			CFG_TRACE_INFO_NI("Loading xml file");
			pResult = loadSubtreeFromXML(_rLookup, _rOptions);
		}

		return pResult;
	}
	
// -----------------------------------------------------------------------------	
	std::auto_ptr<ISubtree> LocalSession::loadSubtreeFromXML(OLookupContext const& _rLookup, 
												             const vos::ORef<OOptions>& _rOptions) CFG_UNO_THROW_ALL(  )
	{		
		OUString sModuleName = _rLookup.getNodePath().getModuleName().toString();
		CFG_TRACE_INFO("loadSubtreeFromXML %s", OUSTRING2ASCII(sModuleName));		

        sal_uInt32 const nRequestFlags = _rLookup.getAccessFlags();
        
        bool isTemplate = !!(nRequestFlags & Lookup::TEMPLATE);

        // set the base attributes to use
        node::Attributes const aBaseAttributes = 
                            isTemplate ? getTemplateStartAttributes() : getDefaultStartAttributes();

		// create a file URL; could be for templates or instance files
        rtl::OUString const sFileURL = 
                            _rLookup.composeFileURL(isTemplate ? Lookup::TEMPLATE : Lookup::DEFAULT);
		
		// if binary files should be created, the cache file URL is also set
		rtl::OUString sCacheFileURL;
		if (nRequestFlags & Lookup::UPDATE_CACHE)
			sCacheFileURL = _rLookup.composeFileURL(Lookup::CACHE);

		XMLTreeBuilder *pBuilder = new XMLTreeBuilder(sModuleName, _rOptions, aBaseAttributes);
		Reference< sax::XDocumentHandler > xBuilder = pBuilder;
		
		readSubtreeFromXML(sFileURL, sCacheFileURL, xBuilder, pBuilder->getParserContext(), ONodePath(_rLookup.getNodePath()).getElements());

		return pBuilder->getResultTree();
	}

	// -----------------------------------------------------------------------------

    void LocalSession::readSubtreeFromXML(rtl::OUString const& _sFileURL, 
										  rtl::OUString const& _sCacheFileURL,
										  uno::Reference< sax::XDocumentHandler > const& _xWriter,
										  ParserContext & _rParserContext, 
										  vector<OUString> const& _rFilter) CFG_UNO_THROW_ALL(  )
	{
		File aFile(_sFileURL);
		FileBase::RC eError = aFile.open(OpenFlag_Read);		

        if (eError != osl_File_E_None)
		{			
			// not existing files are not handle as IOException,
			// they are considered not to be present and are return as NULL nodes.
			// This allows upper implementations to distinguish between NO Element and IO Exception			
			CFG_TRACE_WARNING_NI("local session: could not open file: (%s)", OUSTRING2ASCII(_sFileURL));			
			return;
		}		

		try
		{				
			// connect stream to input stream to the parser
			InputSource aInputSource;		
			aInputSource.aInputStream =  new configmgr::OSLInputStreamWrapper(aFile);
			
			// create the writer and the parser we want to use		
			Reference<XDocumentHandler> xFilter(new OSelectHandler(_xWriter, _rFilter, _rParserContext ));
			
			if (_sCacheFileURL.getLength())
			{
				// create the binary writer
				// if write to share is wished (default: true)
				// create a binaryWriteHandler, if it fails, never create a binary handler again.				
				try
				{
					// create missing directories					
					FileHelper::mkdirs(FileHelper::getParentDir(_sCacheFileURL));
					
					// create binary file
					Reference<XDocumentHandler> xBinaryWriter(
						new OWriteSubtreeAsBinaryHandler(xFilter, _sCacheFileURL, m_xServiceProvider, _rParserContext));
					
					xFilter = xBinaryWriter;
				}
				catch (io::IOException & e)
				{
                    CFG_TRACE_WARNING("Cannot write binary files at share directory: %s", OUSTRING2ASCII(e.Message));
					// avoid updating again
					m_nAccessFlags &= ~Lookup::UPDATE_CACHE;					
				}
			}
			
			// connect parser and filter
			DocumentBuilder aSaxBuilder( m_xParser, xFilter );			
			aSaxBuilder.parseStream( aInputSource );			
		}
		catch( SAXParseException &e )
		{
			OUString sLine = OUString::valueOf(e.LineNumber);
			OUString aStr = ASCII("SAXParseException occured in ");
			aStr += ASCII(" Line: (") + sLine + ASCII(") in file url: ");
			aStr += _sFileURL;
			OSL_ENSURE(0, rtl::OUStringToOString(aStr,RTL_TEXTENCODING_ASCII_US).getStr());
			CFG_TRACE_WARNING_NI("SAXParseException occured in Line (%s) in file url: %s", OUSTRING2ASCII(sLine), OUSTRING2ASCII(_sFileURL));
			throw;
		}
		catch( SAXException &e )
		{			
			OSL_ENSURE(0, rtl::OUStringToOString(e.Message,RTL_TEXTENCODING_ASCII_US).getStr());
			throw;
		}
		catch( IOException &e )
		{			
			OSL_ENSURE(0, rtl::OUStringToOString(e.Message,RTL_TEXTENCODING_ASCII_US).getStr());
			throw;
		}
	}
	

// -----------------------------------------------------------------------------

    bool LocalSession::loadTreeChangeFromXML(OLookupContext const& _rLookup,
											 TreeChangeList &_aChangeList) CFG_UNO_THROW_ALL(  )
	{
		// PRE: an initialised TreeChangeList, a ModuleName
		// BACK: true, if ChangeList was loaded.
		CFG_TRACE_INFO("loadTreeChangeFromXML: Load XML as SubtreeChange");
		
		rtl::OUString sFileURL(_rLookup.composeFileURL(Lookup::USER));	
        
		File aFile(sFileURL);
		FileBase::RC eError = aFile.open(OpenFlag_Read);

		if (eError != osl_File_E_None)
		{
			// having no file containing updates is not an error and just handled as 'no changes'			
			CFG_TRACE_INFO_NI("local session: there is no user override file (%s)", OUSTRING2ASCII(sFileURL));
			return false;
		}
		
		try
		{
			// ------------- sax read --------------
			// create the writer and the parser we want to use
			XMLTreeChangeListBuilder *pChangeBuilder = new XMLTreeChangeListBuilder(_aChangeList);
			Reference< sax::XDocumentHandler > xChangeWriter = pChangeBuilder;
			
			// connect stream to input stream to the parser
			InputSource aInputSource;		
			aInputSource.aInputStream =  new configmgr::OSLInputStreamWrapper(aFile);			
			
			// get filter			
			Reference<XDocumentHandler> xFilter(new OSelectHandler(xChangeWriter, ONodePath(_rLookup.getNodePath()).getElements(),
																   pChangeBuilder->getParserContext()));	
			
			// connect parser and filter
			DocumentBuilder aSaxBuilder( m_xParser, xFilter );
			
			aSaxBuilder.parseStream( aInputSource );
		}
		catch( SAXParseException &e )
		{
			OUString sLine = OUString::valueOf(e.LineNumber);
			OUString aStr = ASCII("SAXParseException occured in ");
			aStr += ASCII(" Line: (") + sLine + ASCII(") in file url: ");
			aStr += sFileURL;
			OSL_ENSURE(0, rtl::OUStringToOString(aStr,RTL_TEXTENCODING_ASCII_US).getStr());
			CFG_TRACE_WARNING_NI("SAXParseException occured in Line (%s) in file url: %s", OUSTRING2ASCII(sLine), OUSTRING2ASCII(sFileURL));			
			throw;			
		}
		catch( SAXException &e )
		{			
			OSL_ENSURE(0, rtl::OUStringToOString(e.Message,RTL_TEXTENCODING_ASCII_US).getStr());		
			throw;			
		}
		catch( IOException &e )
		{			
			OSL_ENSURE(0, rtl::OUStringToOString(e.Message,RTL_TEXTENCODING_ASCII_US).getStr());			
			throw;			
		}
		return true; // file loaded
	}	

	// -----------------------------------------------------------------------------

	void LocalSession::updateTree(TreeChangeList& _aChanges) CFG_UNO_THROW_ALL(  )
	{
		::osl::MutexGuard aGuard(m_aMutex);		 

		RTL_LOGFILE_CONTEXT_AUTHOR(aLog, "configmgr::LocalSession", "ll93751", "updateTree()");

		OLookupContext aLookup(m_aSharedURL, 
							   m_aUserURL, 
							   _aChanges.getRootNodePath(),
							   m_nAccessFlags); 												

		RTL_LOGFILE_CONTEXT_TRACE1(aLog, " path %s", RTL_LOGFILE_OU2A(_aChanges.getRootNodePath().toString()));		
		
		rtl::OUString aTargetURL;	
		
		if (aLookup.getAccessFlags() & Lookup::USER)
		{
			// The New Methode loads the userFileURL as a TreeChangeList
			// merges the present TreeChangeList in the FileVersion
			// and store this to the UserFile.
			aTargetURL = aLookup.composeFileURL(Lookup::USER);			
			
			// guarantee that directories are created
			FileHelper::mkdirs(FileHelper::getParentDir(aTargetURL));
			writeTreeChangeToXML(aTargetURL, _aChanges);
		}		
		else 
		{
			// writing into the share directory
			aTargetURL = aLookup.composeFileURL(Lookup::DEFAULT);			
			writeSubtreeToXML(aTargetURL, _aChanges);		
		}		
	}	

	// -----------------------------------------------------------------------------
	void LocalSession::writeSubtreeToXML(const rtl::OUString& _sTargetURL,
										 TreeChangeList& _rChanges) CFG_UNO_THROW_ALL(  )
	{	
		// Target file must exist, otherwise updates fails
		File aFile(_sTargetURL);		
		FileBase::RC eError = aFile.open(OpenFlag_Read | OpenFlag_Write);

		if (osl_File_E_None != eError)
		{
			rtl::OUString sError = ASCII("writeSubtreeToXML: ") + FileHelper::createOSLErrorString(eError) + ASCII("\n with URL: ") + _sTargetURL;			
			CFG_TRACE_ERROR("writeSubtreeToXML: can't open file '%s' for update", OUSTRING2ASCII(_sTargetURL));			
			throw io::IOException(sError, NULL);
		}
		
		// URL for temp file, will be moved to the target after success during writing
		rtl::OUString sTempURL = _sTargetURL + ASCII(".tmp");				
		
		// remove a previously created temp file
		try
		{			
			FileHelper::removeFile(sTempURL);
		}
		catch (io::IOException&)
		{
			CFG_TRACE_ERROR("writeSubtreeToXML: can't remove temp file '%s'", OUSTRING2ASCII(sTempURL));			
			throw;
		}				
		
		// create a tmp file for writing
		File aWriteFile(sTempURL);				
		eError = aWriteFile.open(OpenFlag_Write | OpenFlag_Create);		
		if (eError != osl_File_E_None)
		{
			rtl::OUString sError = FileHelper::createOSLErrorString(eError);
			CFG_TRACE_ERROR("writeSubtreeToXML: can't create temp file '%s'", OUSTRING2ASCII(sTempURL));						
			throw io::IOException(sError, NULL);
		}
		
		// write the data to the tempfile
		try
		{			
			uno::Reference<io::XInputStream> xInputStream = new configmgr::OSLInputStreamWrapper(aFile);
		
			// connect stream to input stream to the parser
			sax::InputSource aInputSource;
			uno::Reference<io::XInputStream> xPipeInput( xInputStream, uno::UNO_QUERY );
			aInputSource.aInputStream = xPipeInput;
		
			// ------------- sax write -------------		
			uno::Reference<io::XOutputStream> xOutputStream = new configmgr::OSLOutputStreamWrapper(aWriteFile);		
			uno::Reference< sax::XDocumentHandler > xWriter(m_xServiceProvider->createInstance( ::rtl::OUString::createFromAscii("com.sun.star.xml.sax.Writer")), uno::UNO_QUERY);		
			
			uno::Reference< io::XActiveDataSource> xDataSource( xWriter, uno::UNO_QUERY );
			xDataSource->setOutputStream(xOutputStream);

			OXMLAttributeHandler aAttributeHandler;
			aAttributeHandler.setCurrentModule( _rChanges.getModuleName().toString() );

			XMLFormater aFormater(_rChanges.getOptions(),aAttributeHandler);
			aFormater.setHandler(xWriter);

			uno::Reference<sax::XDocumentHandler> xMergeHandler = new updatetree::TreeMerger(_rChanges, aFormater);
			m_xParser->setDocumentHandler( xMergeHandler );
			m_xParser->parseStream( aInputSource );

		}
		catch (uno::Exception&)
		{
			CFG_TRACE_ERROR("updateTree: can't write changes to file.");
			aWriteFile.close();
			try { FileHelper::removeFile(sTempURL); } catch (io::IOException&) {}
			throw;
		}

		aWriteFile.close();				
		aFile.close();
		FileHelper::replaceFile(_sTargetURL, sTempURL);		
	}

	// -----------------------------------------------------------------------------
	void LocalSession::writeTreeChangeToXML(const rtl::OUString& _sTargetURL,										    
										    TreeChangeList& _aChanges) CFG_UNO_THROW_ALL(  )
	{		
#ifdef DEBUG
		TraceTree aTracer;
		aTracer.handle(_aChanges.root);
#endif			
		
		// we need to load localized values as sets, to preserve multi-locale entries
		vos::ORef< OOptions > xLoadOptions = new OOptions( *_aChanges.getOptions() );
		xLoadOptions->setMultiLocaleMode();

        TreeChangeList *pChangeList = new TreeChangeList(xLoadOptions, AbsolutePath::makeModulePath(_aChanges.getRootNodePath().getModuleName()));
		std::auto_ptr<TreeChangeList> apDeleteChangeList(pChangeList);

		// URL for temp file, will be moved to the target after success during writing
		rtl::OUString sTempURL = _sTargetURL + ASCII(".tmp");		

		// try to read an existing update file
		File aFile(_sTargetURL);
		FileBase::RC eError = aFile.open(OpenFlag_Read);
		if (eError == osl_File_E_None)
		{
			// there is already a changes file, so we have to read it and merge the new changes 
			// into the domtree
			try
			{
				// ------------- sax read --------------
				// connect stream to input stream to the parser
				InputSource aInputSource;			
				aInputSource.aInputStream =  new configmgr::OSLInputStreamWrapper(aFile);			
				
				// create the writer and the parser we want to use					
				XMLTreeChangeListBuilder *pChangeBuilder = new XMLTreeChangeListBuilder(*pChangeList);
				Reference< sax::XDocumentHandler > xChangeWriter = pChangeBuilder;
				
				// get filter
				Reference<XDocumentHandler> xFilter( new OSelectHandler(xChangeWriter, ONodePath(AbsolutePath::makeModulePath(_aChanges.getRootNodePath().getModuleName())).getElements(),
																		pChangeBuilder->getParserContext()) );			
				
				// connect parser and filter
				DocumentBuilder( m_xParser, xFilter ).parseStream( aInputSource );
			}
			catch( SAXParseException &e )
			{
#ifdef DEBUG
				OUString sLine = OUString::valueOf(e.LineNumber);
				OUString aStr = ASCII("SAXParseException occured in ");
				aStr += ASCII(" Line: (") + sLine + ASCII(")");
				OSL_ENSURE(0, rtl::OUStringToOString(aStr,RTL_TEXTENCODING_ASCII_US).getStr());
#endif
				throw;
			}			
			catch( uno::Exception &e )
			{				
				OSL_ENSURE(0, rtl::OUStringToOString(e.Message,RTL_TEXTENCODING_ASCII_US).getStr());
				throw;
			}			
		    aFile.close();

			try
			{
			    // merge changes into existing domtree - must use expanded form of changes
                expandForLocale( _aChanges.root, _aChanges.getOptions()->getLocale() );
                applyLayerUpdate   (_aChanges,*pChangeList);
            }
			catch( configuration::Exception &e )
			{				
                OUString sMessage(RTL_CONSTASCII_USTRINGPARAM("Cannot merge changes in current user file. Internal error:"));
				OSL_ENSURE(0, e.what());
                throw lang::WrappedTargetException(sMessage + e.message(),0,uno::Any());
			}			

            if (OStripDefaults::strip(pChangeList->root))
                pChangeList = NULL;
		}
		else if (eError == osl_File_E_NOENT)
		{
			// no file, use only the new change list			
			CFG_TRACE_INFO("updateTree: There is no update file, we create one.");
			apDeleteChangeList.reset();
			pChangeList = &_aChanges;
		}
		else
		{
			rtl::OUString sError = FileHelper::createOSLErrorString(eError);
			CFG_TRACE_ERROR("LocalSession::doUpdateTree(): %s \n with URL: %s", OUSTRING2ASCII(sError), OUSTRING2ASCII(sTempURL));			
			OSL_ENSURE(0, rtl::OUStringToOString(sError,RTL_TEXTENCODING_ASCII_US).getStr());
			throw io::IOException(sError, NULL);
		}		
		
		// test if there is a temporary file previously created
		try
		{			
			FileHelper::removeFile(sTempURL);
		}
		catch (io::IOException &)
		{
			CFG_TRACE_ERROR("updateTree: the update file can't removed, check your file permissions.");
			OSL_ENSURE(false, "updateTree: the update file can't removed, check your file permissions.");
			throw;
		}
		
        if (pChangeList)
        {
		    // create the temp file
		    File aWriteFile(sTempURL);
		    eError = aWriteFile.open(OpenFlag_Write | OpenFlag_Create);		
		    if (eError != osl_File_E_None)
		    {
			    rtl::OUString sError = FileHelper::createOSLErrorString(eError);
			    CFG_TRACE_ERROR("LocalSession::doUpdateTree(): %s \n with URL: %s", OUSTRING2ASCII(sError), OUSTRING2ASCII(sTempURL));			
			    OSL_ENSURE(0, rtl::OUStringToOString(sError,RTL_TEXTENCODING_ASCII_US).getStr());
			    throw io::IOException(sError, NULL);
		    }
		    
		    // write the changes to the tempfile
		    try
		    {			
			    Reference<XOutputStream> xOutputStream = new configmgr::OSLOutputStreamWrapper(aWriteFile);
			    
			    Reference< sax::XDocumentHandler > xWriter( m_xServiceProvider->createInstance( ::rtl::OUString::createFromAscii("com.sun.star.xml.sax.Writer")), UNO_QUERY);						
			    Reference< XActiveDataSource> xDataSource( xWriter , UNO_QUERY );
			    xDataSource->setOutputStream(xOutputStream);
		    
			    std::auto_ptr<OXMLAttributeHandler> pAttributeHandler( new OXMLChangeAttributeHandler );
			    pAttributeHandler->setCurrentModule( pChangeList->getModuleName().toString() );

			    XMLFormater aFormatter(&pChangeList->root, _aChanges.getOptions(), *pAttributeHandler);
		    
			    aFormatter.setHandler(xWriter);
			    aFormatter.writeAsFlat(pChangeList->getRootNodePath(), true);
		    }
		    catch (uno::Exception&)
		    {
			    CFG_TRACE_ERROR("updateTree: can't write changes to file.");
			    aWriteFile.close();			
			    try { FileHelper::removeFile(sTempURL); } catch (io::IOException&) {}
			    throw;
		    }

		    aWriteFile.close();		
		    FileHelper::replaceFile(_sTargetURL, sTempURL);		
        }
        else
        {
			FileHelper::removeFile(_sTargetURL);
        }
	}
	
// --------------------------------- OSelectHandler::Selector ---------------------------------
	OSelectHandler::Selector::Selector(const std::vector< rtl::OUString > &aFilterVector)
	: m_aTarget(aFilterVector)
	{
		reset();
	}

// -----------------------------------------------------------------------------
	OSelectHandler::Selector::Action OSelectHandler::Selector::start(OUString const& aName)
	{
		switch (m_eState)
		{
		case SEARCHING_DATA:
			OSL_ASSERT(m_nHandleDepth == 0);
			OSL_ASSERT(m_nSearchDepth < m_aTarget.size());
			if (aName != m_aTarget[m_nSearchDepth])
			{
				// mismatch - must ignore now
				m_eState		= IGNORING_DATA;
				++m_nHandleDepth;
				return IGNORE;
			}
			else if (++m_nSearchDepth == m_aTarget.size())
			{
				// found it
				m_eState		= HANDLING_DATA;
				++m_nHandleDepth;
				OSL_DEBUG_ONLY(--m_nSearchDepth);
				return START_HANDLING;
			}
			else 
			{
				// keep searching 
				return START_CONTEXT;
			}
			
		case HANDLING_DATA:
			++m_nHandleDepth;
			return KEEP_HANDLING;

		case IGNORING_DATA:
			++m_nHandleDepth;
			return IGNORE;

		default: OSL_ASSERT(false);
		case DONE:
			OSL_DEBUG_ONLY(++m_nHandleDepth);
			return IGNORE;
		}
	}

// -----------------------------------------------------------------------------
	OSelectHandler::Selector::Action OSelectHandler::Selector::end()
	{
		switch (m_eState)
		{
		case SEARCHING_DATA: // this case means: Selected data not found
			OSL_ASSERT(m_nHandleDepth == 0);
			OSL_ASSERT(m_nSearchDepth > 0);
			--m_nSearchDepth;
			return IGNORE;

		case HANDLING_DATA:
			OSL_ASSERT(m_nHandleDepth > 0);
			if (--m_nHandleDepth == 0)
			{
				m_eState = DONE;
				return END_HANDLING;
			}
			return KEEP_HANDLING;

		case IGNORING_DATA:
			OSL_ASSERT(m_nHandleDepth > 0);
			if (--m_nHandleDepth == 0)
			{
				m_eState = SEARCHING_DATA;
			}
			return IGNORE;

		default: OSL_ASSERT(false);
		case DONE:
			OSL_ASSERT(0 < (m_nHandleDepth ? m_nHandleDepth : m_nSearchDepth)); 
			OSL_DEBUG_ONLY( --(m_nHandleDepth ? m_nHandleDepth : m_nSearchDepth)); 
			return IGNORE;
		}
	}

// -----------------------------------------------------------------------------
	void OSelectHandler::Selector::reset()
	{
		if ( m_aTarget.empty() )
		{
			m_eState = HANDLING_DATA;
		}
		else
		{
			m_eState = SEARCHING_DATA;
		}
		m_nHandleDepth = 0;
		m_nSearchDepth = 0;
	}
// -----------------------------------------------------------------------------
// ------------------------------- OSelectHandler -------------------------------
// -----------------------------------------------------------------------------

	OSelectHandler::OSelectHandler( const uno::Reference< sax::XDocumentHandler > &xWriter,
									  const std::vector<rtl::OUString> &aFilterVector,
									  ParserContext& rParserContext)
	: m_aSelector(aFilterVector)
	, m_rParserContext(rParserContext)
	, m_xHandler(xWriter)
	{
	}

// -----------------------------------------------------------------------------
	rtl::OUString OSelectHandler::getSelectName(const rtl::OUString& aName,
									const uno::Reference< sax::XAttributeList > &xAttribs)
	{
		return m_rParserContext.aAttributeParser.getNodeName(aName,xAttribs);
	}
// -----------------------------------------------------------------------------
    void OSelectHandler::updateContext(const uno::Reference< sax::XAttributeList > &xAttribs)
    {
        m_rParserContext.aAttributeParser.getNodeAttributes(xAttribs,m_rParserContext.aBaseAttributes);
    }

// -----------------------------------------------------------------------------

	void OSelectHandler::startDocument(void)
		throw (sax::SAXException, uno::RuntimeException)
	{
		m_aSelector.reset();
		if (m_aSelector.isHandling())
			m_xHandler->startDocument();
	}

// -----------------------------------------------------------------------------
	
	void OSelectHandler::endDocument(void)
		throw(sax::SAXException, uno::RuntimeException)
	{
		OSL_ENSURE(!m_aSelector.isHandling(),"Empty document for empty target path ?");
		if (m_aSelector.isHandling())
		{
			m_xHandler->endDocument();
			m_aSelector.reset();
		}
	}
	
// -----------------------------------------------------------------------------

	void OSelectHandler::startElement(const OUString& aName,
										const uno::Reference< sax::XAttributeList > &xAttrList)
		throw(sax::SAXException, uno::RuntimeException)
	{
		switch( m_aSelector.start( getSelectName(aName,xAttrList) ) )
		{
		case Selector::START_CONTEXT:
            this->updateContext(xAttrList);
			break;

		case Selector::START_HANDLING:
			m_xHandler->startDocument();
			m_xHandler->startElement(aName, xAttrList);
			break;

		case Selector::KEEP_HANDLING:
			m_xHandler->startElement(aName, xAttrList);
			break;

		default: OSL_ASSERT(false);

		case Selector::IGNORE:
			break;
		}
	}
// -----------------------------------------------------------------------------
	
	void OSelectHandler::endElement(const OUString& aName)
		throw(sax::SAXException, uno::RuntimeException)
	{
		switch( m_aSelector.end() )
		{
		case Selector::END_HANDLING:
			m_xHandler->endElement(aName);
			m_xHandler->endDocument();
			break;

		case Selector::KEEP_HANDLING:
			m_xHandler->endElement(aName);
			break;

		default: OSL_ASSERT(false);

		case Selector::IGNORE:
			break;
		}
	}
// -----------------------------------------------------------------------------
	
	void OSelectHandler::characters(const OUString& aChars)
		throw(sax::SAXException, uno::RuntimeException)
	{
		if (m_aSelector.isHandling())
			m_xHandler->characters(aChars);
	}
// -----------------------------------------------------------------------------
	
	
	void OSelectHandler::ignorableWhitespace(const OUString& aWhitespaces)
		throw(sax::SAXException, uno::RuntimeException)
	{
		if (m_aSelector.isHandling())
			m_xHandler->ignorableWhitespace(aWhitespaces);
	}
// -----------------------------------------------------------------------------

	void OSelectHandler::processingInstruction(const OUString& aTarget,
												  const OUString& aData)
		throw(sax::SAXException, uno::RuntimeException)
	{
		if (m_aSelector.isHandling())
			m_xHandler->processingInstruction(aTarget, aData);
	}
// -----------------------------------------------------------------------------
	
	void OSelectHandler::setDocumentLocator(const uno::Reference< sax::XLocator > &xLocator)
		throw(sax::SAXException, uno::RuntimeException)
	{
		// if (m_aSelector.isActive())
		m_xHandler->setDocumentLocator(xLocator);
	}
// -----------------------------------------------------------------------------
} // namespace configmgr


