/*************************************************************************
 *
 *  $RCSfile: treebuildercallback.cxx,v $
 *
 *  $Revision: 1.8 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/14 17:06:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h>

#include "treebuildercallback.hxx"

#ifndef _CONFIGMGR_XMLTREEBUILDER_HXX
#include "xmltreebuilder.hxx"
#endif

#ifndef _CONFIGMGR_STRDECL_HXX_
#include "strdecl.hxx"
#endif
#ifndef _CONFIGMGR_TREEACTIONS_HXX_
#include "treeactions.hxx"
#endif

using namespace com::sun::star::uno;
using namespace com::sun::star::xml::sax;
using namespace rtl;

namespace configmgr
{

// -----------------------------------------------------------------------------
// #define ASCII(x) OUString::createFromAscii(x)
#ifndef ASCII
	static inline OUString ASCII(const char* aStr)
	{
		return OUString::createFromAscii(aStr);
	}
#endif

// ---------------------- IRequestCallback implementations ----------------------
	void TreeBuilderCallback::failed(sal_Int32 nErrorCode)
	{
		m_aCondition.set();				 // will not block
	}

	void TreeBuilderCallback::done(const StatusInfo& rStatus)
	{
		m_aStatus = rStatus;
		m_aCondition.set();				 // will not block
	}

	void TreeBuilderCallback::gotObjectId(const ::rtl::OUString& _rId)
	{
		m_aNodeId = _rId;

	}


// ---------------------------------- C/D Tors ----------------------------------
	TreeBuilderCallback::TreeBuilderCallback(NoModule , const vos::ORef<OOptions> &_aOptions) 
	: m_nRefs()
	, m_aCondition()
	, m_aStatus()
	, m_aNodeId()			
    , m_xTreeBuilder(new XMLTreeBuilder( OUString(), _aOptions, node::Attributes()))
	{
		m_aCondition.reset();				 // will block
	}
// -----------------------------------------------------------------------------
    TreeBuilderCallback::TreeBuilderCallback(configuration::Name const& _sModuleName, const vos::ORef<OOptions> &_aOptions) 
	: m_nRefs()
	, m_aCondition()
	, m_aStatus()
	, m_aNodeId()			
    , m_xTreeBuilder(new XMLTreeBuilder(_sModuleName.toString(), _aOptions, node::Attributes()))
	{
		m_aCondition.reset();				 // will block
	}
// -----------------------------------------------------------------------------
	TreeBuilderCallback::~TreeBuilderCallback()
	{
		m_aCondition.set();				 // release waiting clients
	}

// -----------------------------------------------------------------------------
	Reference< sax::XDocumentHandler > TreeBuilderCallback::getDataReader()
	{
		return m_xTreeBuilder.getBodyPtr();
	}

// -----------------------------------------------------------------------------

	auto_ptr<ISubtree> TreeBuilderCallback::waitToResponse(TimeValue* _pTimeout)
	{
		OSL_ENSURE(m_xTreeBuilder.isValid(),"TreeBuilderCallback - cannot wait: no handler");

		m_aCondition.wait(_pTimeout);

		if (!m_aCondition.check())
		{
			// The condition timed out - has building the tree started at all?

			if (!m_xTreeBuilder->hasResult())
				// after the given timeout there was no response from the server
				return auto_ptr<ISubtree>(0);

			// building the tree started, we're here just because the the condition timed out before it was ready
			// from now on, we wait without a timeout. The given timeout specifies the period to wait
			// for _any_ server response, not the period to wait for the complete tree to be completely
			// transfered.
			m_aCondition.wait();
		}

		auto_ptr<ISubtree> aResult = m_xTreeBuilder->getResultTree();

		OSL_ENSURE(aResult.get() || !m_xTreeBuilder->hasResult(),"Return value isn't a Subtree, return NULL");
		if (aResult.get() && !aResult->hasId())
		{
			OIdPropagator::propagateIdToTree(m_aNodeId,*aResult);
		}

		return aResult;
	}
// -----------------------------------------------------------------------------
	auto_ptr<INode> TreeBuilderCallback::waitToResponseForINode(TimeValue* _pTimeout)
	{
		OSL_ENSURE(m_xTreeBuilder.isValid(),"TreeBuilderCallback - cannot wait: no handler");

		m_aCondition.wait(_pTimeout);

		if (!m_aCondition.check())
		{
			// The condition timed out - has building the tree started at all?

			if (!m_xTreeBuilder->hasResult())
				// after the given timeout there was no response from the server
				return auto_ptr<INode>(0);

			// building the tree started, we're here just because the the condition timed out before it was ready
			// from now on, we wait without a timeout. The given timeout specifies the period to wait
			// for _any_ server response, not the period to wait for the complete tree to be completely
			// transfered.
			m_aCondition.wait();
		}

		auto_ptr<INode> aResult = m_xTreeBuilder->getResultNode();

		return aResult;
	}


// -----------------------------------------------------------------------------
	void SAL_CALL TreeBuilderCallback::acquire() throw ()
	{
		++m_nRefs;
	}

// -----------------------------------------------------------------------------
	void SAL_CALL TreeBuilderCallback::release() throw ()
	{
		if (--m_nRefs == 0) delete this;
	}
// -----------------------------------------------------------------------------

} // namespace configmgr

