/*************************************************************************
 *
 *  $RCSfile: updatehandler.cxx,v $
 *
 *  $Revision: 1.19 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/14 17:04:56 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <stdio.h> // include for solaris 8

#include <vector>
#include <stack>

#ifndef _COM_SUN_STAR_XML_SAX_XPARSER_HPP_
#include <com/sun/star/xml/sax/XParser.hpp>
#endif

#ifndef _COM_SUN_STAR_XML_SAX_XEXTENDEDDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XExtendedDocumentHandler.hpp>
#endif

#ifndef _COM_SUN_STAR_IO_XACTIVEDATASOURCE_HPP_
#include <com/sun/star/io/XActiveDataSource.hpp>
#endif

#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif

#ifndef _COM_SUN_STAR_XML_SAX_SAXPARSEEXCEPTION_HDL_
#include <com/sun/star/xml/sax/SAXParseException.hdl>
#endif

// header for define OSL_ASSERT
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

#ifndef _CONFIGMGR_OSLSTREAM_HXX_
#include "oslstream.hxx"
#endif

#ifndef _CONFIGMGR_LOCAL_LOCAL_HXX_
#include "localsession.hxx"
#endif

#ifndef _CONFIGMGR_FILEHELPER_HXX_
#include "filehelper.hxx"
#endif

#ifndef _OSL_FILE_HXX_
#include <osl/file.hxx>
#endif

#ifndef _CONFIGMGR_STRDECL_HXX_
#include "strdecl.hxx"
#endif
#ifndef _CONFIGMGR_XML_UPDATEHANDLER_HXX_
#include "updatehandler.hxx"
#endif

#define ASCII(x) rtl::OUString::createFromAscii(x)

namespace configmgr
{
	namespace updatetree
	{

		namespace css = com::sun::star;
		namespace uno = css::uno;
		namespace sax = css::xml::sax;
		namespace io = css::io;

		using namespace osl;

        using configuration::AbsolutePath;

		// -----------------------------------------------------------------------------
		class HandlerStateFactory : private ChangeTreeAction
		{
			HandlerState* m_pProduct;
			OUString m_sElementType;
		public:
			HandlerStateFactory(OUString const& _sElementType) 
                : m_pProduct(NULL)
                , m_sElementType(_sElementType) 
            { }

			HandlerState* createHandler(Change const * pNode)
				{
					if (pNode)
						applyToChange(*pNode);
					else
						handleNullNode();

					return m_pProduct;
				}
		private:
			void handleNullNode()
				{
					m_pProduct = new WriteThruState(m_sElementType);
				}

			virtual void handle(ValueChange const& aValueNode)
				{
					m_pProduct = new ValueChangeState(aValueNode,m_sElementType);
				}

			virtual void handle(AddNode const& aAddNode)
				{
					m_pProduct = new AddNodeState(aAddNode,m_sElementType);
				}

			virtual void handle(RemoveNode const& aRemoveNode)
				{
					m_pProduct = new RemoveNodeState(aRemoveNode,m_sElementType);
				}

			virtual void handle(SubtreeChange const& aSubtree)
				{
					m_pProduct = new SubtreeChangeState(aSubtree,m_sElementType);
				}
		};

		// =============================================================================
		/** dumps AddNode change not which are not already handle by a SubtreeChangeState
		*/
		class DumpRemainingChanges : public ChangeTreeAction
		{
			::std::set< ::rtl::OUString >	m_aAlreadyDone;	// list of names to ignore
            OUString                        m_sElementType;
			HandlerContext&					m_rContext;		// the context we're working in

		public:
			DumpRemainingChanges(HandlerContext& _rContext, const ::std::set< ::rtl::OUString >& _rDone);

			void dumpChildren(const SubtreeChange& _rSubtree)
			{
                m_sElementType = _rSubtree.getElementTemplateName();
				applyToChildren(_rSubtree);
			}

		protected:
			virtual void handle(ValueChange const& aValueNode);
			virtual void handle(AddNode const& aAddNode);
			virtual void handle(RemoveNode const& aRemoveNode);
			virtual void handle(SubtreeChange const& aSubtree);

		protected:
			sal_Bool shouldHandle(const Change& _rChange)
			{
				return m_aAlreadyDone.end() == m_aAlreadyDone.find(_rChange.getNodeName());
			}
		};

		// -----------------------------------------------------------------------------
		DumpRemainingChanges::DumpRemainingChanges(HandlerContext& _rContext, const ::std::set< ::rtl::OUString >& _rDone)
			:m_aAlreadyDone(_rDone)
            ,m_sElementType()
			,m_rContext(_rContext)
		{
		}

		// -----------------------------------------------------------------------------
		void DumpRemainingChanges::handle(ValueChange const& aValueNode)
		{
			OSL_ENSURE(!shouldHandle(aValueNode), "DumpRemainingChanges::handle: can't handle value nodes!");
		}

		// -----------------------------------------------------------------------------
		void DumpRemainingChanges::handle(AddNode const& _rAddNode)
		{
			if (shouldHandle(_rAddNode))
			{
                m_rContext.m_rFormater.writeChange(_rAddNode, m_sElementType, node::isDefault);
			}
		}

		// -----------------------------------------------------------------------------
		void DumpRemainingChanges::handle(RemoveNode const& aRemoveNode)
		{
			OSL_ENSURE(!shouldHandle(aRemoveNode), "DumpRemainingChanges::handle: can't handle removals!!");
		}

		// -----------------------------------------------------------------------------
		void DumpRemainingChanges::handle(SubtreeChange const& aSubtree)
		{
			OSL_ENSURE(!shouldHandle(aSubtree), "DumpRemainingChanges::handle: can't handle SubtreeChanges!");
		}

		// -----------------------------------------------------------------------------
		// -----------------------------------------------------------------------------
		bool const bIgnoreCaseOnAttributes = true;

		// -----------------------------------------------------------------------------

		// helper
		// -----------------------------------------------------------------------------
		sal_Int16 getAttributeIndexByName(const uno::Reference< sax::XAttributeList > &_xAttr,
										  const rtl::OUString &_aName)
		{
			// POST return the index, if the name exists, -1 otherwise
			rtl::OUString sType;
			if (_xAttr.is())
			{
				sal_Int16 nCount = _xAttr->getLength();
				for( sal_Int16 i=0; i < nCount; i++ )
				{
					rtl::OUString aParamName(  _xAttr->getNameByIndex( i ) );
					if (bIgnoreCaseOnAttributes)
					{
						if (aParamName.equalsIgnoreAsciiCase(_aName))
						{
							return i;
						}
					}
					else
					{
						if (aParamName.equals(_aName))
						{
							return i;
						}
					}
				}
			}
			return -1;
		}

		/*
		  // temporary debug only code
		  void attributlist(const uno::Reference< sax::XAttributeList > &_xAttrList)
		  {
		  rtl::OUString aStr;
		  sal_Int16 nAttrCount = _xAttrList.is() ? _xAttrList->getLength() : 0;
		  for( sal_Int16 i=0; i < nAttrCount; i++ )
		  {
		  rtl::OUString aParamName( _xAttrList->getNameByIndex( i ) );
		  rtl::OUString aParamValue( _xAttrList->getValueByIndex( i ) );
		  aStr += aParamName;
		  aStr += rtl::OUString::createFromAscii("=");
		  aStr += aParamValue;
		  aStr += rtl::OUString::createFromAscii(" ");
		  }
		  volatile int dummy = 0;
		  }
		*/

		// -----------------------------------------------------------------------------

		/*
		  I try to descripe what this class do.
		  these classes are for update the main tree with a tree which contains only the nodes
		  we want to replace.
		  class InnerNodeState contains only the nodes we want to replace during the hole tree
		  is only on the filesystem which sax is running through. [durchlaufen]

		  Original tree (on filesystem)           update tree
		  a                                   a
		  |                                   |
		  -----                               -----
          |     |                             |
		  b     c                             b
          |                                   |
		  -----                               ----- --
		  |     |                                   |  |
		  d     e                                   e  f

		  Both, the update tree and the original tree (on filesystem) whould be run through parallel.
		  For every node InnerNodeState::startChild() is called, which control if there exist a child
		  with the corresponding name. Could be null if not!
		  If null, NullLeafNoteState() or WriteThruState() will created.
		  If exist InnerNodeState() or LeadNodeState() will created.

		  For every xml element will called.

		  startSelf("a" ...) writes <A ...>
		  startChild("b" ...)
		  endChild("b")
		  startChild("c" ...)
		  endChild("b")
		  ...
		  endSelf("a") writes </A>

		  real write to filesystem is done in InnerNodeState::startSelf()

		  to be cleared and continued...
		  lla: don't try to debug this code, you won't understand it.
		*/


		/////////////////////////////////////////////////////////////////////////////////////////////

///////////////////////////////////////////////////////////////////
		HandlerState::HandlerState(OUString const& _sElementType)
				: m_sElementType(_sElementType)
                , m_nStarted(0)
		{}

		// -----------------------------------------------------------------------------
		HandlerState::~HandlerState()
		{
			OSL_ASSERT(!started());
		}
		// -----------------------------------------------------------------------------
		bool HandlerState::started() const
		{
			return m_nStarted > 0;
		}

		// -----------------------------------------------------------------------------
		void HandlerState::characters(HandlerContext& ctx, const rtl::OUString &text)
		{
			ctx.xOut->characters(text);
		}

		// -----------------------------------------------------------------------------
		void HandlerState::startSelf(HandlerContext& ctx, const rtl::OUString &name,
									 const uno::Reference< sax::XAttributeList > &xAttr)
		{
            if (m_sElementType.getLength()) OSL_ENSURE(name == m_sElementType, "Name does not match expected element type");

			ctx.xOut->startElement(name, xAttr); // standard behaviour call startElement at the XDocumentHandler
		}
		// -----------------------------------------------------------------------------
		void HandlerState::startChild(HandlerContext& ctx, const rtl::OUString &name,
									  const uno::Reference< sax::XAttributeList > &xAttr)
		{
		}


		// -----------------------------------------------------------------------------
		void HandlerState::endChild(HandlerContext& ctx, const rtl::OUString &name)
		{
		}
		// -----------------------------------------------------------------------------
		void HandlerState::endSelf(HandlerContext& ctx, const rtl::OUString &name)
		{
			ctx.xOut->endElement(name); // standard behaviour call endElement at the XDocumentHandler
		}


		///////////////////////////////////////////////////////////////////
		// -----------------------------------------------------------------------------
		void HandlerState::startElement(HandlerContext& ctx, const rtl::OUString &name,
										const uno::Reference< sax::XAttributeList > &xAttr)
		{
			if (start(ctx))
				startSelf(ctx, name, xAttr);  // Attention: if we are a SubtreeChange call Subtreechange::startSelf()
			else
				startChild(ctx, name, xAttr);
		}
		// -----------------------------------------------------------------------------
		void HandlerState::endElement(HandlerContext& ctx, const rtl::OUString &name)
		{
			if (stop(ctx))
			{
				endSelf(ctx, name);
				if (!ctx.states.empty())
				{
					OSL_ASSERT(ctx.states.top()->m_nStarted > 1);
					ctx.states.top()->endElement(ctx, name);
				}
				delete this;
			}
			else
				endChild(ctx, name);
		}
		// -----------------------------------------------------------------------------
		bool HandlerState::start(HandlerContext& ctx)
		{
			OSL_ASSERT(m_nStarted >= 0);
			if (m_nStarted++ != 0)
				return false;

			ctx.states.push(this);
			return true;
		}
		// -----------------------------------------------------------------------------
		bool HandlerState::stop(HandlerContext& ctx)
		{
			OSL_ASSERT(m_nStarted > 0);
			if (--m_nStarted != 0)
				return false;

			OSL_ASSERT(this == ctx.states.top());
			ctx.states.pop();
			return true;
		}
		// -----------------------------------------------------------------------------
        OUString HandlerState::getTypeAsElement() const
        {
            OSL_ENSURE(m_nStarted <= 1, "This element type does not apply to nested nodes");
            return m_sElementType;
        }

		///////////////////////////////////////////////////////////////////
		HandlerContext::HandlerContext(XMLFormater &_aFormater, Name const& aModuleName)
				: xOut(_aFormater.getSaxHandler()), m_rFormater(_aFormater), m_aParser(aModuleName.toString())
		{
			OSL_ENSURE(xOut.is(),"Cannot create XML: No Sax Handler");
		}

		// -----------------------------------------------------------------------------
		void HandlerContext::pushHandler(HandlerState& rHandler, const rtl::OUString &aName,
										 const uno::Reference< sax::XAttributeList > &xAttributes)
		{
			OSL_ASSERT(!rHandler.started());
			rHandler.startElement(*this,aName,xAttributes);
		}

		// -----------------------------------------------------------------------------
		Handler::Handler(XMLFormater &_rFormater, Name const& aModuleName)
				: m_aContext(_rFormater, aModuleName)
		{
		}

		// -----------------------------------------------------------------------------
		void SAL_CALL Handler::startDocument() throw (sax::SAXException, uno::RuntimeException)
		{
			startDocument( *createDocumentState());
		}
		// -----------------------------------------------------------------------------
		void Handler::startDocument(HandlerState& rInitialState, const rtl::OUString &name)
		{
			OSL_ASSERT(m_aContext.states.empty());
			m_aContext.pushHandler( rInitialState,name, 0 );
		}
		// -----------------------------------------------------------------------------
		void SAL_CALL Handler::startElement(const rtl::OUString &name,
											const uno::Reference< sax::XAttributeList > &xAttr)
			throw(sax::SAXException, uno::RuntimeException)
		{
			state().startElement(m_aContext,name,xAttr);
		}
		// -----------------------------------------------------------------------------
		void SAL_CALL Handler::endElement(const rtl::OUString &name)
			throw(sax::SAXException, uno::RuntimeException)
		{
			state().endElement(m_aContext,name);
		}
		// -----------------------------------------------------------------------------
		void SAL_CALL Handler::characters(const rtl::OUString &text)
			throw(sax::SAXException, uno::RuntimeException)
		{
			state().characters(m_aContext,text);
		}

		// -----------------------------------------------------------------------------
		void SAL_CALL Handler::endDocument()
			throw(sax::SAXException, uno::RuntimeException)
		{
			m_aContext.states.top()->endElement( m_aContext, rtl::OUString() );
			OSL_ASSERT(m_aContext.states.empty());
		}

		// -----------------------------------------------------------------------------
		void SAL_CALL Handler::ignorableWhitespace(const class rtl::OUString & aWS)
            throw (::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException)
		{
			m_aContext.xOut->ignorableWhitespace(aWS);
		}
		// -----------------------------------------------------------------------------
		void SAL_CALL Handler::processingInstruction(const class rtl::OUString & sTarget,
													 const class rtl::OUString &sData)
             throw (::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException)
		{
			m_aContext.xOut->processingInstruction(sTarget,sData);
		}
		// -----------------------------------------------------------------------------
		void SAL_CALL Handler::setDocumentLocator(const uno::Reference< sax::XLocator> &xLoc)
            throw (::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException)
		{
			m_aContext.xOut->setDocumentLocator(xLoc);
		}

		// -----------------------------------------------------------------------------
		HandlerState& Handler::state()
		{
			OSL_ASSERT(!m_aContext.states.empty()); return *m_aContext.states.top();
		}
		// -----------------------------------------------------------------------------
		// Write with start/endDocument()
		// -----------------------------------------------------------------------------
        DocumentStateBase::DocumentStateBase() : HandlerState(OUString()) {}
		// -----------------------------------------------------------------------------

		void DocumentStateBase::startSelf(HandlerContext& ctx, const rtl::OUString &name,
										  const uno::Reference< sax::XAttributeList > &xAttr)
		{
			OSL_ASSERT( name.getLength() == 0 );
			OSL_ASSERT( ! xAttr.is() );
			ctx.xOut->startDocument();
		}
		// -----------------------------------------------------------------------------
		void DocumentStateBase::startChild(HandlerContext& ctx, const rtl::OUString &name,
										   const uno::Reference< sax::XAttributeList > &xAttr)
		{
			if (HandlerState* pDocElementHandler = createChildHandler(ctx,name,xAttr))
			{
				ctx.pushHandler(*pDocElementHandler, name, xAttr);
			}
		}
		// -----------------------------------------------------------------------------
		void DocumentStateBase::endChild(HandlerContext& ctx, const rtl::OUString &name)
		{
			HandlerState::endChild(ctx,name);
		}
		// -----------------------------------------------------------------------------
		void DocumentStateBase::endSelf(HandlerContext& ctx, const rtl::OUString &name)
		{
			OSL_ASSERT( name.getLength() == 0 );
			ctx.xOut->endDocument();
		}
		// -----------------------------------------------------------------------------
		// write without start/endDocument()
		// -----------------------------------------------------------------------------
        SilentStateBase::SilentStateBase() : HandlerState(OUString()) {}
		// -----------------------------------------------------------------------------

		void SilentStateBase::startSelf(HandlerContext& ctx, const rtl::OUString &name,
										const uno::Reference< sax::XAttributeList > &xAttr)
		{
			OSL_ASSERT( name.getLength() == 0 );
			OSL_ASSERT( ! xAttr.is() );
		}
		// -----------------------------------------------------------------------------
		void SilentStateBase::startChild(HandlerContext& ctx, const rtl::OUString &name,
										 const uno::Reference< sax::XAttributeList > &xAttr)
		{
			if (HandlerState* pDocElementHandler = createChildHandler(ctx,name,xAttr))
			{
				ctx.pushHandler(*pDocElementHandler, name, xAttr);
			}
		}
		// -----------------------------------------------------------------------------
		void SilentStateBase::endChild(HandlerContext& ctx, const rtl::OUString &name)
		{
			HandlerState::endChild(ctx,name);
		}
		// -----------------------------------------------------------------------------
		void SilentStateBase::endSelf(HandlerContext& ctx, const rtl::OUString &name)
		{
			OSL_ASSERT( name.getLength() == 0 );
		}
		//-----------------------------------------------------------------------------
		// TreeMerger Handler
		//-----------------------------------------------------------------------------
		TreeMerger::TreeMerger(TreeChangeList& _rChanges, XMLFormater& _rFormater)
				: Handler(_rFormater, _rChanges.getModuleName()), m_rChanges(_rChanges)
		{
		}

		TreeMerger::~TreeMerger() {}

		// -----------------------------------------------------------------------------
		void TreeMerger::startWithoutDocument()
		{
			startDocument(*createSilentState() );
		}
		// -----------------------------------------------------------------------------
		void TreeMerger::endWithoutDocument()
		{
			endDocument();
		}
		// -----------------------------------------------------------------------------
		HandlerState* TreeMerger::createDocumentState()
		{
			return new TreeMergerStartState<DocumentStateBase>(m_rChanges);
		}

		// -----------------------------------------------------------------------------
		HandlerState* TreeMerger::createSilentState()
		{
			return new TreeMergerStartState<SilentStateBase>(m_rChanges);
		}


		////////////////////////////////////////////////////////////////////////////
		// WriteThruState HandlerState
		////////////////////////////////////////////////////////////////////////////

		//---------------------------------------------------------------------
		void WriteThruState::startChild(HandlerContext& ctx, const rtl::OUString &name,
										const uno::Reference< sax::XAttributeList > &xAttr)
		{
			ctx.xOut->startElement(name, xAttr);
		}
		//---------------------------------------------------------------------
		void WriteThruState::endChild(HandlerContext& ctx, const rtl::OUString &name)
		{
			ctx.xOut->endElement(name);
		}
		//---------------------------------------------------------------------
		void WriteThruState::startSelf(HandlerContext& ctx, const rtl::OUString &name,
									   const uno::Reference< sax::XAttributeList > &xAttr)
		{
			HandlerState::startSelf(ctx,name,xAttr);
		}
		//---------------------------------------------------------------------
		void WriteThruState::endSelf(HandlerContext& ctx, const rtl::OUString &name)
		{
			HandlerState::endSelf(ctx,name);
		}

		//---------------------------------------------------------------------

		// -----------------------------------------------------------------------------
		// this class is contains only the differences which should merge into the main tree
		// -----------------------------------------------------------------------------
		/* OLD: InnerNodeState */
		SubtreeChangeState::SubtreeChangeState(const SubtreeChange& pNode, OUString const& _sElementType)
				: HandlerState(_sElementType), m_rNode(pNode)
		{}

		// -----------------------------------------------------------------------------
		void SubtreeChangeState::startChild(HandlerContext& ctx, const rtl::OUString &name,
											const uno::Reference< sax::XAttributeList > &xAttr)
		{
			OUString aChildName = ctx.m_aParser.getNodeName(name,xAttr);
			const Change* pChildNode = m_rNode.getChange(aChildName);
			HandlerState* pNextState = createElementHandler(pChildNode, m_rNode.getElementTemplateName(), name, xAttr);
			ctx.pushHandler(*pNextState, name, xAttr);

			if (pChildNode)
				// mark the child as handled
				m_aChildrenHandled.insert(aChildName);
		}
		//---------------------------------------------------------------------

		void SubtreeChangeState::endChild(HandlerContext& ctx, const rtl::OUString &name)
		{
			HandlerState::endChild(ctx,name);
		}
		//---------------------------------------------------------------------
		void SubtreeChangeState::startSelf(HandlerContext& ctx, const rtl::OUString &name,
										   const uno::Reference< sax::XAttributeList > &xAttr)
		{
			OSL_ASSERT(ctx.m_aParser.getNodeName(name,xAttr) == m_rNode.getNodeName());
			// merge attributes if need
			// attributlist(m_rNode.m_attributes);
			// attributlist(xAttr);

			OSL_ENSURE(!ctx.m_aParser.isValue(xAttr),
				"SubtreeChangeState::startSelf : unexpected node type: expected tree - found value!");

			HandlerState::startSelf(ctx,name,xAttr); // write to XDocumentHandler
		}
		//---------------------------------------------------------------------
		void SubtreeChangeState::endSelf(HandlerContext& ctx, const rtl::OUString &name)
		{
			// write down all not handled 'til here
			DumpRemainingChanges aDump(ctx, m_aChildrenHandled);
			aDump.dumpChildren(m_rNode);

			HandlerState::endSelf(ctx,name);
		}

		// -----------------------------------------------------------------------------



		// -----------------------------------------------------------------------------
		// this class is contains only the differences which should merge into the main tree
		// -----------------------------------------------------------------------------

		ValueChangeState::ValueChangeState(const ValueChange& pNode, OUString const& _sElementType)
				: HandlerState(_sElementType), m_rNode(pNode)
		{}

		// -----------------------------------------------------------------------------
		void ValueChangeState::startSelf(HandlerContext& ctx, const rtl::OUString &name,
									   const uno::Reference< sax::XAttributeList > &xAttr)
		{
			OSL_ASSERT(ctx.m_aParser.getNodeName(name,xAttr) == m_rNode.getNodeName());

			OSL_ENSURE(ctx.m_aParser.isValue(xAttr),
				"ValueChangeState::startSelf : unexpected node type: expected value - found tree!");

			ctx.m_rFormater.writeChange(m_rNode, this->getTypeAsElement(), node::isDefault);

		}
		// -----------------------------------------------------------------------------
		void ValueChangeState::startChild(HandlerContext& ctx, const rtl::OUString &name,
										const uno::Reference< sax::XAttributeList > &xAttr)
		{
			OSL_ENSURE(name.equals(TAG_VALUE), "ERROR: Localized subelement started in value tag (Missing localization support ?)");
			// ignore - we have something better to offer
		}
		// -----------------------------------------------------------------------------
		void ValueChangeState::characters(HandlerContext& ctx, const rtl::OUString &text)
		{
			// ignore - we have something better to offer
		}

		// -----------------------------------------------------------------------------
		void ValueChangeState::endChild(HandlerContext& ctx, const rtl::OUString &name)
		{
			OSL_ENSURE(name.equals(TAG_VALUE), "ERROR: Localized subelement ended in value tag (Missing localization support ?)");
			// ignore - we have something better to offer
		}
		// -----------------------------------------------------------------------------
		void ValueChangeState::endSelf(HandlerContext& ctx, const rtl::OUString &name)
		{
			//? OSL_ASSERT(m_rNode.marked());
			// would be done in startself
			// HandlerState::endSelf(ctx,name);
		}

		//---------------------------------------------------------------------
		uno::Reference< sax::XAttributeList > ValueChangeState::mergeAttributes(
			const uno::Reference< sax::XAttributeList > &xAttr)
		{
			// merge attributes if need
			// attributlist(m_rNode.m_attributes);
			// attributlist(xAttr);
			uno::Reference< sax::XAttributeList > xRet( xAttr );

			//? OSL_ENSURE(m_rNode.m_attributes.is(),"Cannot have a value node without attributes");
			//? if (m_rNode.m_attributes.is())
			//? {
			//? 	OUString const aTypeName = ATTR_TYPE;
			//?
			//? 	sal_Int16 nNewIndex = getAttributeIndexByName(m_rNode.m_attributes, aTypeName );
			//? 	OSL_ENSURE(nNewIndex >= 0,"Cannot have a value node without type attribute");
			//?
			//? 	sal_Int16 nOldIndex = getAttributeIndexByName(xAttr, aTypeName );
			//? 	OSL_ENSURE(nOldIndex >= 0,"Cannot have a value node without type attribute");
			//?
			//? 	OUString sNewType = m_rNode.m_attributes->getValueByIndex(nOldIndex);
			//? 	OUString sOrigType = xAttr->getValueByIndex(nNewIndex);
			//?
			//? 	if (sOrigType != sNewType)
			//? 	{
			//? 		// Original type isn't new type, so check if original type is any
			//? 		if (! sOrigType.equalsIgnoreAsciiCase(TYPE_ANY))
			//? 		{
			//? 			OSL_ENSURE(false, "Originaltype can't change if it is not an any type!");
			//?
			//? 			// Merge attributes together - substitute the original type for the new type
			//? 			AttributeListImpl *pList = new AttributeListImpl;
			//? 			uno::Reference< sax::XAttributeList > rList(
			//? 				static_cast<sax::XAttributeList *>( pList ), uno::UNO_QUERY );
			//?
			//? 			// get all attributes from new change value
			//? 			for( sal_Int16 i=0; i < m_rNode.m_attributes->getLength(); i++ )
			//? 			{
			//? 				rtl::OUString aParamName(  m_rNode.m_attributes->getNameByIndex( i ) );
			//? 				rtl::OUString aParamType(  m_rNode.m_attributes->getTypeByIndex( i ) );
			//? 				rtl::OUString aParamValue( m_rNode.m_attributes->getValueByIndex( i ) );
			//?
			//? 				if (i == nNewIndex) aParamValue = sOrigType;
			//?
			//? 				pList->addAttribute( aParamName, aParamType, aParamValue);
			//? 			}
			//? 			xRet = rList;
			//? 		}
			//? 	}
			//?
			//? }
			return xRet;
		}
		// =============================================================================
		// -----------------------------------------------------------------------------
		// this class is contains only the differences which should merge into the main tree
		// -----------------------------------------------------------------------------

		AddNodeState::AddNodeState(const AddNode& pNode, OUString const& _sElementType)
				: HandlerState(_sElementType), m_rNode(pNode)
		{}

		// -----------------------------------------------------------------------------
 		void AddNodeState::startSelf(HandlerContext& ctx, const rtl::OUString &name,
									   const uno::Reference< sax::XAttributeList > &xAttr)
		{
			OSL_ASSERT(ctx.m_aParser.getNodeName(name,xAttr) == m_rNode.getNodeName());
			
			ctx.m_rFormater.writeChange(m_rNode, this->getTypeAsElement(), node::isDefault);
		}

		// -----------------------------------------------------------------------------
		void AddNodeState::startChild(HandlerContext& ctx, const rtl::OUString &name,
										const uno::Reference< sax::XAttributeList > &xAttr)
		{
			OSL_ENSURE(false, "ERROR: Subelement started in value tag (Missing localization support ?)");
		}
		// -----------------------------------------------------------------------------
		void AddNodeState::characters(HandlerContext& ctx, const rtl::OUString &text)
		{
			// ignore - we have something better to offer
		}

		// -----------------------------------------------------------------------------
		void AddNodeState::endChild(HandlerContext& ctx, const rtl::OUString &name)
		{
			OSL_ENSURE(false, "ERROR: Subelement ended in value tag (Missing localization support ?)");
		}
		// -----------------------------------------------------------------------------
		void AddNodeState::endSelf(HandlerContext& ctx, const rtl::OUString &name)
		{
			//? OSL_ASSERT(m_rNode.marked());
			// would be done in startself
			// HandlerState::endSelf(ctx,name);
		}
		// -----------------------------------------------------------------------------
		// this class is contains only the differences which should merge into the main tree
		// -----------------------------------------------------------------------------

		RemoveNodeState::RemoveNodeState(const RemoveNode& pNode, OUString const& _sElementType)
				: HandlerState(_sElementType), m_rNode(pNode)
		{}

		// -----------------------------------------------------------------------------
		void RemoveNodeState::startSelf(HandlerContext& ctx, const rtl::OUString &name,
									   const uno::Reference< sax::XAttributeList > &xAttr)
		{
			OSL_ASSERT(ctx.m_aParser.getNodeName(name,xAttr) == m_rNode.getNodeName());

			ctx.m_rFormater.writeChange(m_rNode, this->getTypeAsElement(), node::isDefault);

		}
		// -----------------------------------------------------------------------------
		void RemoveNodeState::startChild(HandlerContext& ctx, const rtl::OUString &name,
										const uno::Reference< sax::XAttributeList > &xAttr)
		{
			// nothing to do. The Node is deleted, so allof it's children are not visible
			// in the new file anymore.
		}
		// -----------------------------------------------------------------------------
		void RemoveNodeState::characters(HandlerContext& ctx, const rtl::OUString &text)
		{
		}

		// -----------------------------------------------------------------------------
		void RemoveNodeState::endChild(HandlerContext& ctx, const rtl::OUString &name)
		{
		}
		// -----------------------------------------------------------------------------
		void RemoveNodeState::endSelf(HandlerContext& ctx, const rtl::OUString &name)
		{
		}
		// ============================================================================
		//-----------------------------------------------------------------------------
		//
		// This State is only for the first searching for the right positioning and syncronizing
		//
		//-----------------------------------------------------------------------------
		void SearchNodeState::startChild(HandlerContext& ctx, const rtl::OUString &_rStartedElementName,
										 const uno::Reference< sax::XAttributeList > &xAttr)
		{
			HandlerState* pNextHandler = 0;

            OUString sName = ctx.m_aParser.getNodeName(_rStartedElementName,xAttr);

            // is it a set element ?
            OUString sElementType;
            if (_rStartedElementName != sName)
            {
                // this can occur because there is a package attribue, which should not be the case here
                // thus sName should not end in '.' + _rStartedElementName
                OSL_ENSURE(sName.copy(1+sName.lastIndexOf(sal_Unicode('.')+_rStartedElementName))
                            != _rStartedElementName, "Found a node having package+name as child !?");

                // ... or because this is a set element (which we assume here)
                sElementType = _rStartedElementName;
            }

            OUString const& sSearch = m_search;
			if (sName == sSearch)
			{	// we found the element we're looking for at this level

				if (  m_remain.isEmpty() )
				{	// we found the path we were looking for (and which m_pChange 'points to')
					OSL_ENSURE(m_pChange->getNodeName() == sSearch, "SearchNodeState::startChild: invalid initial search path or invalid SubtreeChange!");
					pNextHandler = createElementHandler(m_pChange, sElementType, sSearch, xAttr);
				}
				else
				{
					// still elements to look -> step down
					pNextHandler = new SearchNodeState(sSearch, sElementType, m_remain, m_pChange);
				}
			}
			else
				// here an element which is parallel to m_search starts -> ignore everything
				pNextHandler = new WriteThruState(sElementType);
			OSL_ASSERT(pNextHandler != 0);
			ctx.pushHandler(*pNextHandler, _rStartedElementName, xAttr);
		}
		//---------------------------------------------------------------------

		void SearchNodeState::endChild(HandlerContext& ctx, const rtl::OUString &name)
		{
			HandlerState::endChild(ctx,name);
		}
		//---------------------------------------------------------------------
		void SearchNodeState::startSelf(HandlerContext& ctx, const rtl::OUString &name,
										const uno::Reference< sax::XAttributeList > &xAttr)
		{
			OSL_ASSERT(ctx.m_aParser.getNodeName(name,xAttr) == m_name);

			HandlerState::startSelf(ctx,name,xAttr);
			//? if (m_root)
			//? 	m_root->clearMarks();
		}
		//---------------------------------------------------------------------
		void SearchNodeState::endSelf(HandlerContext& ctx, const rtl::OUString &name)
		{
//			if (m_remain.getLength() == 0 /*&& m_pRoot != 0  && !m_root->marked() */ )
//			{
//				OSL_ENSURE(false,"Update concerns only non-existing node: Dumping it");
//				//? m_root->dump(ctx.xOut,true);
//			}
				// obsolete. We don't mark nodes anymore

			HandlerState::endSelf(ctx,name);
		}

        //-----------------------------------------------------------------------------
			
        static inline OUString splitFirst(Path::Rep& _rPath)
        {
            OUString sResult = _rPath.getFirstName().getName().toString();  
            _rPath.dropFirstName();
            return sResult;
        }

        //-----------------------------------------------------------------------------
        // order of members is important !
		SearchNodeState::SearchNodeState(const TreeChangeList* _pRoot, const rtl::OUString& _aInitialName)
        : HandlerState( OUString() ) // no type name for module name component
        , m_remain( _pRoot->getRootNodePath().rep() )
        , m_name( splitFirst(m_remain) )
        , m_search( splitFirst(m_remain) )
		, m_pChange( &_pRoot->root )
		{
			OSL_PRECOND(_pRoot != 0, "SearchNodeState: No tree to find");

            OSL_ENSURE( m_name == _aInitialName, "Unexpected start of path");
		}
		//-----------------------------------------------------------------------------

        SearchNodeState::SearchNodeState(OUString const& _sName, OUString const& _sElementType, Path::Rep const& _aPath/*, const TreeChangeList* _pRoot*/, const SubtreeChange* _pChange)
        : HandlerState( _sElementType ) 
        , m_remain( _aPath )
		, m_name( _sName )
		, m_search( splitFirst(m_remain) )
		,m_pChange(_pChange)
		{
			OSL_PRECOND(m_pChange != NULL, "SearchNodeState: No SubtreeChange!");
			OSL_PRECOND(!_aPath.isEmpty(), "SearchNodeState: Creating search node with nothing to search");
		}

		//-----------------------------------------------------------------------------
		//
		// This function creates the HandlerState for
		//  WriteThruState - write all
		//  SubtreeChange [InnerNode]
		//  ValueChange [TypedValueNode]
		//  RemoveChange
		//  AddChange
		//
		//-----------------------------------------------------------------------------

		HandlerState* createElementHandler(const Change* _pNode, const rtl::OUString &_sElementType,
                                           const rtl::OUString &_sName,
										   const uno::Reference<sax::XAttributeList>& _xAttributes)
		{
			HandlerStateFactory aFactory(_sElementType);
			return aFactory.createHandler(_pNode);
		}

	} // namespace updatetree
} // namespace configmgr


