/*************************************************************************
 *
 *  $RCSfile: updatehandler.hxx,v $
 *
 *  $Revision: 1.17 $
 *
 *  last change: $Author: hr $ $Date: 2001/09/12 10:20:05 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef CONFIGMGR_XML_UPDATEHANDLER_HXX_
#define CONFIGMGR_XML_UPDATEHANDLER_HXX_

#ifndef CONFIGMGR_CHANGE_HXX
#include "change.hxx"
#endif
#ifndef CONFIGMGR_XMLFORMATER_HXX
#include "xmlformater.hxx"
#endif
#ifndef CONFIGMGR_TREECHANGELIST_HXX
#include "treechangelist.hxx"
#endif
#ifndef CONFIGMGR_ATTRIBUTEPARSER_HXX
#include "attributeparser.hxx"
#endif
#ifndef CONFIGMGR_CONFIGPATH_HXX_
#include "configpath.hxx"
#endif

#ifndef _COM_SUN_STAR_XML_SAX_XEXTENDEDDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XExtendedDocumentHandler.hpp>
#endif

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef INCLUDED_STACK
#include <stack>
#define INCLUDED_STACK
#endif

namespace configmgr 
{
	namespace updatetree
	{
		namespace css = com::sun::star;
		namespace sax = css::xml::sax;
		namespace uno = css::uno;

        using rtl::OUString;

        using configuration::AbsolutePath;
        using configuration::RelativePath;
        using configuration::Name;
        namespace Path = configuration::Path;
        typedef Path::Component FullName;
		// -----------------------------------------------------------------------------

		class HandlerState;
		struct HandlerContext
		{
			std::stack<HandlerState*> states;
			uno::Reference<sax::XDocumentHandler> const xOut;
			XMLFormater&		m_rFormater;
			OAttributeParser	m_aParser;

			HandlerContext(XMLFormater& _rFormater, Name const& aModuleName);
			void pushHandler(HandlerState& rHandler, const OUString &aName,
							 const uno::Reference< sax::XAttributeList > &xAttributes);
		};

		// -----------------------------------------------------------------------------
		class HandlerState
		{
		protected:
			HandlerState(OUString const& _sElementType);
			virtual ~HandlerState();

		public:
			bool started() const;

			void startElement(HandlerContext& ctx, const OUString &name,
							  const uno::Reference< sax::XAttributeList > &xAttr);
			void endElement(HandlerContext& ctx, const rtl::OUString &name);

			virtual void characters(HandlerContext& ctx, const OUString &text);

            OUString getTypeAsElement() const;
		protected:
			virtual void startSelf(HandlerContext& ctx, const OUString &name,
								   const uno::Reference< sax::XAttributeList > &xAttr) = 0;
			virtual void startChild(HandlerContext& ctx, const OUString &name,
									const uno::Reference< sax::XAttributeList > &xAttr) = 0;

			virtual void endChild(HandlerContext& ctx, const OUString &name) = 0;
			virtual void endSelf(HandlerContext& ctx, const OUString &name) = 0;

		private:
			bool start(HandlerContext& ctx);
			bool stop(HandlerContext& ctx);
            
            OUString m_sElementType;
			int m_nStarted;
		};

		// -----------------------------------------------------------------------------

		struct Handler : cppu::WeakImplHelper1<sax::XDocumentHandler>
		{
			HandlerContext m_aContext;

			Handler(XMLFormater &_aFormater, Name const& aModuleName);

			virtual HandlerState* createDocumentState() = 0;

			virtual void SAL_CALL startDocument() throw (sax::SAXException, uno::RuntimeException);
			void startDocument(HandlerState& rInitialState, const OUString &name = OUString());
			virtual void SAL_CALL startElement(const OUString &name,
											   const uno::Reference< sax::XAttributeList > &xAttr)
				throw(sax::SAXException, uno::RuntimeException);
			virtual void SAL_CALL endElement(const OUString &name)
				throw(sax::SAXException, uno::RuntimeException);
			virtual void SAL_CALL characters(const OUString &text)
				throw(sax::SAXException, uno::RuntimeException);
			virtual void SAL_CALL endDocument() 
				throw(sax::SAXException, uno::RuntimeException);
			virtual void SAL_CALL ignorableWhitespace(const class OUString & aWS) throw (::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException); 
			virtual void SAL_CALL processingInstruction(const class OUString & sTarget,
														const class OUString &sData) throw (::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException);
			virtual void SAL_CALL setDocumentLocator(const uno::Reference< sax::XLocator> &xLoc) throw (::com::sun::star::xml::sax::SAXException, ::com::sun::star::uno::RuntimeException);

		private:
			HandlerState& state();

		};


		////////////////////////////////////////////////////////////////////////////
		HandlerState* createElementHandler(const Change* _pNode, const rtl::OUString &_sElementType,
                                           const OUString &_sName,
										   const uno::Reference< sax::XAttributeList > &_xAttributes);

		// -----------------------------------------------------------------------------
		// SearchNodeState
		// -----------------------------------------------------------------------------
		/** a state class for searching children represented by SubtreeChanges
		*/
		struct SearchNodeState : HandlerState
		{
            Path::Rep   m_remain; // must be first !!
			OUString    m_name;   // must be second !!
            OUString    m_search; // must be last !!

            const SubtreeChange*	m_pChange;
					// this is the change which represents m_name/m_search/m_remain
			
			SearchNodeState(const TreeChangeList * _pRoot, const OUString& aInitialName);

			// ----------- from HandlerState -----------
			void startChild(HandlerContext& ctx, const OUString &name,
							const uno::Reference< sax::XAttributeList > &xAttr);
			void endChild(HandlerContext& ctx, const OUString &name);
			void startSelf(HandlerContext& ctx, const OUString &name,
						   const uno::Reference< sax::XAttributeList > &xAttr);
			void endSelf(HandlerContext& ctx, const OUString &name);
		private:
			SearchNodeState(OUString const& sName, OUString const& _sElementType, Path::Rep const& sPath, const SubtreeChange* _pChange);
		};

		//-----------------------------------------------------------------------------
		// TreeMergerStartState
		//-----------------------------------------------------------------------------
		
		template <class Base>
		struct TreeMergerStartState : Base
		{
			TreeChangeList& m_rChanges;

			TreeMergerStartState(TreeChangeList& rChanges) : m_rChanges(rChanges)
				{
				}
			virtual HandlerState* createChildHandler(HandlerContext& ctx, const rtl::OUString &name,
													 const uno::Reference< sax::XAttributeList > &xAttr)
				{
					OSL_ASSERT( m_rChanges.getRootNodePath().getModuleName().toString() ==  ctx.m_aParser.getNodeName(name,xAttr) );
					if (m_rChanges.isModuleRootChange())
					{
						SubtreeChange* pNode = &m_rChanges.root;

                        // empty type name for module root
                        OSL_ASSERT(m_rChanges.getRootNodePath().getLocalName().getTypeName().isEmpty());

						OSL_ASSERT(!pNode || ctx.m_aParser.getNodeName(name,xAttr) == pNode->getNodeName());
						return createElementHandler(pNode, OUString(), name, xAttr);
					}
					else
					{
						return new SearchNodeState(&m_rChanges, name);
					}
				}
		};

		// -----------------------------------------------------------------------------
		// Write with start/endDocument()
		// -----------------------------------------------------------------------------

		struct DocumentStateBase : HandlerState
		{
            DocumentStateBase();

			void startSelf(HandlerContext& ctx, const rtl::OUString &name,
						   const uno::Reference< sax::XAttributeList > &xAttr);
			void startChild(HandlerContext& ctx, const rtl::OUString &name,
							const uno::Reference< sax::XAttributeList > &xAttr);
			void endChild(HandlerContext& ctx, const rtl::OUString &name);
			void endSelf(HandlerContext& ctx, const rtl::OUString &name);
		protected:
			virtual HandlerState* createChildHandler(HandlerContext& ctx, const rtl::OUString &name,
													 const uno::Reference< sax::XAttributeList > &xAttr) = 0;
		};
		// -----------------------------------------------------------------------------
		// write without start/endDocument()
		// -----------------------------------------------------------------------------

		struct SilentStateBase : HandlerState
		{
            SilentStateBase();

			void startSelf(HandlerContext& ctx, const rtl::OUString &name,
						   const uno::Reference< sax::XAttributeList > &xAttr);
			void startChild(HandlerContext& ctx, const rtl::OUString &name,
							const uno::Reference< sax::XAttributeList > &xAttr);
			void endChild(HandlerContext& ctx, const rtl::OUString &name);
			void endSelf(HandlerContext& ctx, const rtl::OUString &name);
		protected:
			virtual HandlerState* createChildHandler(HandlerContext& ctx, const rtl::OUString &name,
													 const uno::Reference< sax::XAttributeList > &xAttr) = 0;
		};
		//-----------------------------------------------------------------------------
		// TreeMerger Handler
		//-----------------------------------------------------------------------------
		struct TreeMerger : Handler
		{
			TreeChangeList& m_rChanges;
			TreeMerger(TreeChangeList& _rChanges, XMLFormater& _aFormater);

			~TreeMerger();

			void startWithoutDocument();
			void endWithoutDocument();
		private:
			virtual HandlerState* createDocumentState(); 
			virtual HandlerState* createSilentState(); 
		};

		
		// -----------------------------------------------------------------------------
		// WriteThruState HandlerState
		// -----------------------------------------------------------------------------
		struct WriteThruState : HandlerState
		{
            explicit
            WriteThruState(OUString const& _sElementType) : HandlerState(_sElementType) {}

			// ----------- from HandlerState -----------
			void startChild(HandlerContext& ctx, const rtl::OUString &name,
							const uno::Reference< sax::XAttributeList > &xAttr);
			void endChild(HandlerContext& ctx, const rtl::OUString &name);
			void startSelf(HandlerContext& ctx, const rtl::OUString &name,
						   const uno::Reference< sax::XAttributeList > &xAttr);
			void endSelf(HandlerContext& ctx, const rtl::OUString &name);
		};

		// -----------------------------------------------------------------------------
		// this class is contains only the differences which should merge into the main tree
		// -----------------------------------------------------------------------------
		/* OLD: InnerNodeState */
		struct SubtreeChangeState : HandlerState
		{
			const SubtreeChange& m_rNode;
			
			SubtreeChangeState(const SubtreeChange& pNode, OUString const& _sElementType);
			
			// ----------- from HandlerState -----------
			void startChild(HandlerContext& ctx, const rtl::OUString &name,
							const uno::Reference< sax::XAttributeList > &xAttr);
			void endChild(HandlerContext& ctx, const rtl::OUString &name);
			void startSelf(HandlerContext& ctx, const rtl::OUString &name,
						   const uno::Reference< sax::XAttributeList > &xAttr);
			void endSelf(HandlerContext& ctx, const rtl::OUString &name);

		protected:
			::std::set< ::rtl::OUString > m_aChildrenHandled;
		};

		// -----------------------------------------------------------------------------
		// this class is contains only the differences which should merge into the main tree
		// -----------------------------------------------------------------------------

		struct ValueChangeState : HandlerState
		{
			const ValueChange& m_rNode;

			ValueChangeState(const ValueChange& pNode, OUString const& _sElementType);

			// ----------- from HandlerState -----------
			void startSelf(HandlerContext& ctx, const rtl::OUString &name,
						   const uno::Reference< sax::XAttributeList > &xAttr);
			void startChild(HandlerContext& ctx, const rtl::OUString &name,
							const uno::Reference< sax::XAttributeList > &xAttr);
			void characters(HandlerContext& ctx, const rtl::OUString &text);
			void endChild(HandlerContext& ctx, const rtl::OUString &name);
			void endSelf(HandlerContext& ctx, const rtl::OUString &name);
			uno::Reference< sax::XAttributeList > mergeAttributes( const uno::Reference< sax::XAttributeList > &xAttr);
		};

		// -----------------------------------------------------------------------------
		struct AddNodeState : HandlerState
		{
			const AddNode& m_rNode;

			AddNodeState(const AddNode& pNode, OUString const& _sElementType);

			// ----------- from HandlerState -----------
			void startSelf(HandlerContext& ctx, const rtl::OUString &name,
						   const uno::Reference< sax::XAttributeList > &xAttr);
			void startChild(HandlerContext& ctx, const rtl::OUString &name,
							const uno::Reference< sax::XAttributeList > &xAttr);
			void characters(HandlerContext& ctx, const rtl::OUString &text);
			void endChild(HandlerContext& ctx, const rtl::OUString &name);
			void endSelf(HandlerContext& ctx, const rtl::OUString &name);
			// uno::Reference< sax::XAttributeList > mergeAttributes( const uno::Reference< sax::XAttributeList > &xAttr);
		};
		// -----------------------------------------------------------------------------
		struct RemoveNodeState : HandlerState
		{
			const RemoveNode& m_rNode;

			RemoveNodeState(const RemoveNode& pNode, OUString const& _sElementType);

			// ----------- from HandlerState -----------
			void startSelf(HandlerContext& ctx, const rtl::OUString &name,
						   const uno::Reference< sax::XAttributeList > &xAttr);
			void startChild(HandlerContext& ctx, const rtl::OUString &name,
							const uno::Reference< sax::XAttributeList > &xAttr);
			void characters(HandlerContext& ctx, const rtl::OUString &text);
			void endChild(HandlerContext& ctx, const rtl::OUString &name);
			void endSelf(HandlerContext& ctx, const rtl::OUString &name);
			// uno::Reference< sax::XAttributeList > mergeAttributes( const uno::Reference< sax::XAttributeList > &xAttr);
		};


	} // namespace updatetree
} // namespace configmgr


#endif
