/*************************************************************************
 *
 *  $RCSfile: valuehandler.cxx,v $
 *
 *  $Revision: 1.18 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/05 10:30:34 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdio.h> // include for solaris 8
#include "valuehandler.hxx"

#ifndef CONFIGMGR_LOCALIZEDNODEBUILDER_HXX
#include "localizednodebuilder.hxx"
#endif
#ifndef CONFIGMGR_ATTRIBUTEPARSER_HXX
#include "attributeparser.hxx"
#endif
#ifndef CONFIGMGR_PARSERCONTEXT_HXX
#include "parsercontext.hxx"
#endif

namespace configmgr 
{
	using rtl::OUString;
// -----------------------------------------------------------------------------

OValueHandler::OValueHandler(
	ParserContext& rContext
)
	: m_rContext( rContext )
	, m_pActiveNodeBuilder(0)
{
	m_xSimpleNodeBuilder.bind( new SimpleValueNodeBuilder(m_rContext) );
	m_xLocalizedNodeBuilder = createLocalizedNodeBuilder(m_xSimpleNodeBuilder);
}
// -----------------------------------------------------------------------------

OValueHandler::~OValueHandler()
{
}
// -----------------------------------------------------------------------------

OAttributeParser& OValueHandler::getAttributeHandler() const 
{
	return m_rContext.aAttributeParser;
}
// -----------------------------------------------------------------------------

OTreeNodeFactory& OValueHandler::getNodeFactory() const
{
	return m_rContext.aNodeFactory;
}
// -----------------------------------------------------------------------------

// get the active handler
uno::Reference< sax::XDocumentHandler > OValueHandler::handler() const
{
	OSL_ENSURE(isActive(), "ERROR: trying to get a handler from a non-prepared OValueHandler");
	return m_pActiveNodeBuilder->getSaxHandler();
}
// -----------------------------------------------------------------------------

// prepare the value handler for the next run
void OValueHandler::prepare(const uno::Reference< sax::XAttributeList > &xAttribs, node::Attributes const& _aBaseAttributes)
{
	OSL_ENSURE(m_rContext.xTypeConverter.is(), "OValueHandler::prepare - ERROR: no type converter available");

    AbstractValueNodeBuilder* pActiveValueNodeBuilder;
	if (getAttributeHandler().isLocalized(xAttribs))
		pActiveValueNodeBuilder = m_xLocalizedNodeBuilder.getBodyPtr();

	else
		pActiveValueNodeBuilder = m_xSimpleNodeBuilder.getBodyPtr();

	OSL_ENSURE(pActiveValueNodeBuilder != 0, "OValueHandler::prepare: ERROR: could not get a node builder");
    m_pActiveNodeBuilder = pActiveValueNodeBuilder;

	pActiveValueNodeBuilder->setBaseAttributes(_aBaseAttributes);
	m_pActiveNodeBuilder->prepareNode();
}
// -----------------------------------------------------------------------------

// Access methods
std::auto_ptr<INode> OValueHandler::createNode()
{
	OSL_ENSURE(isActive(), "WARNING: trying to get a node from a non-prepared OValueHandler - returning NULL");

	std::auto_ptr<INode> aResult;
	if (m_pActiveNodeBuilder)
	{
		aResult = m_pActiveNodeBuilder->buildNode();
		m_pActiveNodeBuilder = 0;
	}
	return aResult;
}
// -----------------------------------------------------------------------------

} // namespace

