/*************************************************************************
 *
 *  $RCSfile: xmlformater.cxx,v $
 *
 *  $Revision: 1.48 $
 *
 *  last change: $Author: jb $ $Date: 2001/11/14 16:45:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <stdio.h> // needed for solaris 8!!!!

#include "xmlformater.hxx"

#ifndef CONFIGMGR_MISC_ATTRIBUTELIST_HXX
#include "attributelist.hxx"
#endif
#ifndef CONFIGMGR_TYPECONVERTER_HXX
#include "typeconverter.hxx"
#endif
#ifndef _CONFIGMGR_SERVER_VERSION_HXX_
#include "server_version.hxx"
#endif
#ifndef CONFIGMGR_SIMPLETYPEHELPER_HXX
#include "simpletypehelper.hxx"
#endif
#ifndef CONFIGMGR_NAMEHELPER_HXX
#include "namehelper.hxx"
#endif

#ifndef _COM_SUN_STAR_UNO_ANY_HXX_
#include <com/sun/star/uno/Any.hxx>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif

#ifndef _COM_SUN_STAR_XML_SAX_XEXTENDEDDOCUMENTHANDLER_HPP_
#include <com/sun/star/xml/sax/XExtendedDocumentHandler.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XACTIVEDATASOURCE_HPP_
#include <com/sun/star/io/XActiveDataSource.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_SCRIPT_CANNOTCONVERTEXCEPTION_HPP_
#include <com/sun/star/script/CannotConvertException.hpp>
#endif

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

#ifndef _CPPUHELPER_SERVICEFACTORY_HXX_
#include <cppuhelper/servicefactory.hxx>
#endif

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

#ifndef _CONFIGMGR_TRACER_HXX_
#include "tracer.hxx"
#endif
#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

#ifndef INCLUDED_VECTOR
#include <vector>
#define INCLUDED_VECTOR
#endif
#ifndef INCLUDED_ALGORITHM
#include <algorithm>
#define INCLUDED_ALGORITHM
#endif

#define ASCII(x) rtl::OUString::createFromAscii(x)

#define LOCALIZED_SUBVALUES_NEED_STATE 0

inline sal_Bool rtl_ascii_isWhitespace( sal_Unicode ch )
{
    return ch <= 0x20 && ch;
}

using namespace vos;
using namespace com::sun::star::io;
using namespace com::sun::star::lang;
using namespace com::sun::star::uno;
using namespace com::sun::star::xml::sax;
using namespace rtl;
// using namespace std;

#define XMLNS_STR     "http://openoffice.org/2000/registry/components/"
#define XMLNS_CFG_STR "http://openoffice.org/2000/registry/instance"
#define XMLNS_XSI_STR "http://www.w3.org/1999/XMLSchema-instance"

/*========================================================================
 *
 * XML Export
 *
 *=======================================================================*/

#define ERR_SWG_WRITE_ERROR 1

namespace configmgr
{
	namespace uno = com::sun::star::uno;
	using ::rtl::OUString;	


//==========================================================================
//= Helper
//==========================================================================

static 
inline
void addBoolAttribute(AttributeListImpl& _rList, const rtl::OUString &_sAttrNameName, bool _bValue)
{
	_rList.addAttribute(_sAttrNameName, XML_CDATA,
						_bValue ? ATTR_VALUE_TRUE : ATTR_VALUE_FALSE);
}

// -----------------------------------------------------------------------------
static 
inline
void addBoolAttribute(AttributeListImpl& _rList, const rtl::OUString &_sAttrNameName, bool _bValue, bool _bDefault)
{
	if (_bValue != _bDefault)
		addBoolAttribute( _rList, _sAttrNameName, _bValue );
}

// -----------------------------------------------------------------------------

static 
inline
OUString makeElementTemplatePath(OUString const& _sTemplateName, OUString const& _sTemplateModule)		
{ 
	sal_Unicode const chSep = '/';

	OUString sTemplateName = _sTemplateName;

	if (_sTemplateModule.getLength() > 0)
	{
		OSL_ENSURE(_sTemplateName.getLength()>0,"set has template module, but no type name");

		sTemplateName = _sTemplateModule.concat( OUString(&chSep,1) ).concat( _sTemplateName);
	}
	
	return sTemplateName;
}		

// -----------------------------------------------------------------------------
template <class T>
OUString getElementTemplatePath(T const& rNode)		
{ 
	return makeElementTemplatePath( rNode.getElementTemplateName(), rNode.getElementTemplateModule());
}		

// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------
static
inline
bool canUseWhitespace(rtl::OUString const &aStr)
{
	sal_Unicode const * const pBegin = aStr.getStr();
	sal_Unicode const * const pEnd   = pBegin + aStr.getLength();

	// BACK: true, if no whitespace in string and string not empty
	if (pBegin == pEnd)
		return false;

	sal_Unicode const * const pSpace = std::find_if(pBegin,pEnd,rtl_ascii_isWhitespace);

	return pSpace == pEnd;
}
// -----------------------------------------------------------------------------

static
bool canUseWhitespace(const Sequence< rtl::OUString > &aSeq)
{
	// BACK: true, if whitespace Separator is ok, (no whitespace in Strings, no empty strings)
	
	for(int i=0; i < aSeq.getLength(); ++i)
	{
		if ( !canUseWhitespace(aSeq[i]) )
		{
			return false;
		}
	}
	return true;
}

// -----------------------------------------------------------------------------
template <class Element>
bool canUseWhitespace(const Sequence< Sequence<Element> > &aSeq)
{
	// BACK: true, if whitespace Separator is ok (no empty elements)
	
	for(int i=0; i<aSeq.getLength(); i++)
	{
		if (aSeq[i].getLength() == 0)
		{
			return false;
		}
	}
	return true;
}

// -----------------------------------------------------------------------------
class AnyToXML;

class Separator
{
	OUString m_sValue;
public:
    // -----------------------------------------------------------------------------
	Separator() : m_sValue(DEFAULT_SEPARATOR) {}
    // -----------------------------------------------------------------------------
	Separator(OUString const& sSep) : m_sValue(sSep) {}
    // -----------------------------------------------------------------------------
	sal_Bool isDefault() const { return m_sValue.equals(DEFAULT_SEPARATOR); }
    // -----------------------------------------------------------------------------
	OUString value() const { return m_sValue; }
    // -----------------------------------------------------------------------------
	static bool check(rtl::OUString const& sSep, const Sequence<rtl::OUString> &aSeq)
	{
		// BACK: true, if Separator is ok, not in Strings
		
		for(int i=0;i<aSeq.getLength();i++)
		{
			if (aSeq[i].indexOf(sSep) >= 0)
			{
				return false;
			}
		}
		return true;
	}

    // -----------------------------------------------------------------------------
	bool check(const Sequence<rtl::OUString> &aSeq) const
	{
		return check(m_sValue, aSeq);
	}

    // -----------------------------------------------------------------------------
	bool trySeparator(rtl::OUString const& sSep, const Sequence<rtl::OUString> &aSeq)
	{
		OSL_ENSURE(canUseWhitespace(sSep), "There should be no spaces in non-default separators");
		// BACK: true, if Separator is ok, not in Strings
		if (!check(sSep, aSeq))
			return false;
		m_sValue = sSep;
		return true;
	}
    // -----------------------------------------------------------------------------
	inline void write(AnyToXML& rWriter) const;	
    // -----------------------------------------------------------------------------
};
// -----------------------------------------------------------------------------
class AnyToXML
{
	XMLOutputContext& m_rContext;
public:
	AnyToXML(XMLOutputContext& _rContext):m_rContext(_rContext){}		
	
	static void setDefaultValueAttributes(const uno::Any& _rElement, const uno::Type& _rType, AttributeListImpl& _rList);
	
	// Value to XML (String) conversations

	// <Name></Name> attribute list will be owned by
	sal_Bool write(const rtl::OUString& _rNodeName, 
				   const uno::Any& _rValue, 
				   AttributeListImpl& _rList)
        CFG_UNO_THROW1( xml::sax::SAXException );

	// <Name><value>...</value></Name>
	sal_Bool writeLocalized(const rtl::OUString& _rNodeName,
							const rtl::OUString& _rLocale,
							const uno::Any& _rValue, 
							AttributeListImpl& _rList)
        CFG_UNO_THROW1( xml::sax::SAXException );
    

	sal_Bool writeContent(const uno::Any& _rElement, AttributeListImpl& _rList)	
        CFG_UNO_THROW1( xml::sax::SAXException );
    
	sal_Bool writeSimpleValue(const uno::Any& _rValue, const uno::Type& _rType)
        CFG_UNO_THROW2( script::CannotConvertException, xml::sax::SAXException );

	sal_Bool writeSequenceValue(const uno::Any& _aValue, uno::Type const& aElementType, OUString const& sSeparator )
        CFG_UNO_THROW2( script::CannotConvertException, xml::sax::SAXException );

	OUString convertSimpleValue(const uno::Any& _rValue, const uno::Type& _rType)
        CFG_UNO_THROW1( script::CannotConvertException );	

	sal_Bool addRepresentationAttributes(const uno::Any& _rValue, AttributeListImpl& _rList);

private:
	// deprecated
	void startElement(const rtl::OUString &aName, const uno::Any& aElement);
	void endElement(const rtl::OUString &aName);

	friend class Separator;

};
// -----------------------------------------------------------------------------

static
Separator createSeparator(const uno::Any& aAny)
{
	Separator aResult;

	// create a Separator which isn't in any value
	if (aAny.getValueTypeClass() == TypeClass_SEQUENCE)
	{
		Type aType = configmgr::getSequenceElementType(aAny.getValueType());
		if (aType.getTypeClass() == TypeClass_STRING)
		{
			// only in strings we need to search a separator
			Sequence<OUString> aSeq;
			if (aAny >>= aSeq)
			{
				bool bValidSeparator =
					canUseWhitespace(aSeq) || 
					aResult.trySeparator(ASCII(","), aSeq) || 
					aResult.trySeparator(ASCII(";"), aSeq) || 
					aResult.trySeparator(ASCII(":"), aSeq) || 
					aResult.trySeparator(ASCII("|"), aSeq) || 
					aResult.trySeparator(ASCII("#"), aSeq) || 
					aResult.trySeparator(ASCII("-#*=+#-"), aSeq);

				if (!bValidSeparator) 
				{
					OSL_ENSURE(false, "Could not create Separator for string list");
				}
				else
				{
					// maybe the whitespace test was invalid ?
					OSL_ENSURE(aResult.check(aSeq), "Found Separator does not pass check ?!");
				}
			}
		}
		else if (aType == SimpleTypeHelper::getBinaryType())
		{
			// only in strings we need to search a separator
			Sequence< Sequence<sal_uInt8> > aSeq;
			if (aAny >>= aSeq)
			{
				if (!canUseWhitespace(aSeq)) 
				{
					aResult = ASCII(":");
				}					
				// else - keep default separator;
			}
		}
	}
	
	// DefaultSeparator
	return aResult;
}

// -----------------------------------------------------------------------------
static
inline
sal_Unicode hexNibble(sal_uInt8 _nNibble)
{
	OSL_ASSERT(_nNibble <= 0x0F);

	const sal_uInt8 cDecOffset = sal_uInt8('0');
	const sal_uInt8 cHexOffset = sal_uInt8('a') - 10;

	return _nNibble + (_nNibble<10 ? cDecOffset : cHexOffset);
}

// -----------------------------------------------------------------------------
static
inline
void appendHex(rtl::OUStringBuffer& rBuff, sal_uInt8 _nByte)
{
	rBuff.append( hexNibble(_nByte >> 4) );
	rBuff.append( hexNibble(_nByte & 0x0f) );
}

// -----------------------------------------------------------------------------
static
OUString binaryToHex(const uno::Sequence<sal_Int8>& _aBinarySeq)
{
	sal_Int32 const nLength = _aBinarySeq.getLength();

	OUStringBuffer sHex(2*nLength);

	for (sal_Int32 nPos = 0;nPos < nLength; ++nPos) 
	{
		appendHex( sHex, _aBinarySeq[nPos] );
	}

	OSL_ASSERT(sHex.getLength() == 2*nLength);
	return sHex.makeStringAndClear();;
}
	
// -----------------------------------------------------------------------------
void AnyToXML::startElement(const rtl::OUString &aName, const uno::Any& aElement)
{
	AttributeListImpl *pList = new AttributeListImpl;
	Reference< XAttributeList > rList( (XAttributeList *) pList , UNO_QUERY );

	//setDefaultValueAttributes(aElement, aElement.getValueType(), *pList);
	m_rContext.m_xHandler->startElement(aName, rList);	
}
// -----------------------------------------------------------------------------
void AnyToXML::endElement(const rtl::OUString &aName)
{
	m_rContext.m_xHandler->endElement(aName);
	m_rContext.m_xHandler->ignorableWhitespace(OUString());
}
// -----------------------------------------------------------------------------
#if 0
void AnyToXML::startElement(const rtl::OUString &aName, const uno::Any& , 
							AttributeListImpl& _rList)
{
	m_rContext.m_xHandler->startElement(aName, rList);	
}
#endif

// -----------------------------------------------------------------------------
OUString AnyToXML::convertSimpleValue(const uno::Any& _rValue, const uno::Type& _rType)
        CFG_UNO_THROW1( script::CannotConvertException )
{
	OUString sResult;

	if (_rValue.hasValue())
	{
		OSL_ENSURE(_rType == _rValue.getValueType(), "Unexpected mismatch of value and type");

		if (_rType == SimpleTypeHelper::getBinaryType())
		{
			Sequence<sal_Int8> aBinarySeq;

			OSL_VERIFY(_rValue >>= aBinarySeq);
				
            sResult = binaryToHex(aBinarySeq);
		}
		else
		{
			// cannot have nested any
			OSL_ASSERT(_rValue.getValueTypeClass() != TypeClass_ANY);

			sResult = toString(m_rContext.m_xTypeConverter, _rValue);
		}
	}		
	return sResult;
}

// -----------------------------------------------------------------------------
sal_Bool AnyToXML::writeSimpleValue(const uno::Any& _rValue, const uno::Type& _rType)
    CFG_UNO_THROW2( script::CannotConvertException, xml::sax::SAXException )
{
	// PRE: a ValueNode pointer
	// POST: write the content of the valuenode as string
	bool bCharsWritten = false;

    OUString sStringRepresentation = convertSimpleValue(_rValue,_rType);
	if (sStringRepresentation.getLength())
	{
		m_rContext.m_xHandler->characters(sStringRepresentation);
		bCharsWritten = true;
	}

    return bCharsWritten;
}

// -----------------------------------------------------------------------------
inline void Separator::write(AnyToXML& rWriter) const
{
	rWriter.m_rContext.m_xHandler->characters(m_sValue);
}

// -----------------------------------------------------------------------------
template <class Element>
bool writeSequence(AnyToXML& rWriter, Sequence< Element > const& aSequence, Separator const& aSeparator)
    CFG_UNO_THROW2( script::CannotConvertException, xml::sax::SAXException )
{
	bool bWritten = false;

	sal_Int32 const nLength = aSequence.getLength();

	for(sal_Int32 i=0; i<nLength; ++i) 
	{
		if (bWritten) aSeparator.write(rWriter);

		if (!rWriter.writeSimpleValue(makeAny(aSequence[i]), ::getCppuType(static_cast< Element const*>(0))))
		{
			OSL_ENSURE(aSeparator.value().trim() == aSeparator.value(),
						"WARNING: List separator cannot be used for empty elements");
		}

		bWritten = true;
	} 

	return bWritten;
}

// -----------------------------------------------------------------------------

#define CASE_WRITE_SEQUENCE(TYPE_CLASS, DATA_TYPE)	\
	case TYPE_CLASS:								\
	{												\
		Sequence< DATA_TYPE > aData;				\
		OSL_ASSERT( ::getCppuType(static_cast< DATA_TYPE const*>(0)).getTypeClass() == (TYPE_CLASS) );	\
		OSL_VERIFY( _aValue >>= aData );										\
		bResult = writeSequence(*this,aData,sSeparator);						\
	}	break																	\

sal_Bool AnyToXML::writeSequenceValue(Any const& _aValue, uno::Type const& aElementType, OUString const& sSeparator )
    CFG_UNO_THROW2( script::CannotConvertException, xml::sax::SAXException )
{
	sal_Bool bResult = false;

	switch(aElementType.getTypeClass())
	{
	CASE_WRITE_SEQUENCE( TypeClass_BOOLEAN, sal_Bool );

	CASE_WRITE_SEQUENCE( TypeClass_SHORT, sal_Int16 );

	CASE_WRITE_SEQUENCE( TypeClass_LONG, sal_Int32 );

	CASE_WRITE_SEQUENCE( TypeClass_HYPER, sal_Int64 );

	CASE_WRITE_SEQUENCE( TypeClass_DOUBLE, double );

	CASE_WRITE_SEQUENCE( TypeClass_STRING, OUString );

	CASE_WRITE_SEQUENCE( TypeClass_SEQUENCE, Sequence<sal_Int8> );

	default: 
		OSL_ENSURE(false, "Unexpected typeclass for sequence elements");
		break;
	}

	return bResult;
}

#undef CASE_WRITE_SEQUENCE

// -----------------------------------------------------------------------------
sal_Bool AnyToXML::writeContent(const uno::Any& _rValue, AttributeListImpl& _rList)
    CFG_UNO_THROW1( xml::sax::SAXException )
{
	// PRE: a ValueNode pointer
	// POST: write the content of the valuenode as string
	if (!_rValue.hasValue())
		return false;

	bool bSeq;
	Type aTargetType = getBasicType(_rValue.getValueType(), bSeq);


	sal_Bool bRet;
    try
    {
	    if (!bSeq)
	    {		
		    bRet = this->writeSimpleValue(_rValue, aTargetType);		
	    }
	    else
	    {
		    rtl::OUString sSeparator = _rList.getValueByName(ATTR_SEPARATOR);
		    if (sSeparator.getLength() == 0)
			    sSeparator = DEFAULT_SEPARATOR;

		    bRet = this->writeSequenceValue(_rValue, aTargetType, sSeparator);		
	    }
    }
    catch (script::CannotConvertException& cce)
    {
        OUString const sMessage(RTL_CONSTASCII_USTRINGPARAM("Configuration: Could not convert value to XML representation: "));
        throw sax::SAXException(sMessage + cce.Message, cce.Context, uno::makeAny(cce));
    }
		
	return bRet;
}

// -----------------------------------------------------------------------------
sal_Bool AnyToXML::writeLocalized(const rtl::OUString& _rNodeName,
								  const rtl::OUString& _rLocale, 
								  const uno::Any& _rValue,
								  AttributeListImpl& _rList)
    CFG_UNO_THROW1( xml::sax::SAXException )   
{
	sal_Bool bRet = false;

	m_rContext.m_xHandler->startElement(_rNodeName, &_rList);
	m_rContext.m_xHandler->ignorableWhitespace(OUString());	

	{
		AttributeListImpl *pValueAttrList = new AttributeListImpl;
		Reference< XAttributeList > xAttrList(pValueAttrList);

		pValueAttrList->addAttribute(ATTR_LANG, XML_CDATA, _rLocale);	

		// Do we have a state attribute?
		// Then duplicate it for the server
#if LOCALIZED_SUBVALUES_NEED_STATE
		OUString aState = _rList.getValueByName(ATTR_STATE);
		if (aState.getLength())
			pValueAttrList->addAttribute(ATTR_STATE, XML_CDATA, aState);	
#endif // LOCALIZED_SUBVALUES_NEED_STATE

		// write the value tag with locale informations	
		bRet = write(TAG_VALUE, _rValue, *pValueAttrList);
	}

	m_rContext.m_xHandler->endElement(_rNodeName);
	m_rContext.m_xHandler->ignorableWhitespace(OUString());

	return bRet;
}

// -----------------------------------------------------------------------------
sal_Bool AnyToXML::write(const rtl::OUString& _rNodeName, 
						 const uno::Any& _rValue, 
						 AttributeListImpl& _rList)
    CFG_UNO_THROW1( xml::sax::SAXException )   
{
	addRepresentationAttributes(_rValue, _rList);

	m_rContext.m_xHandler->startElement(_rNodeName, &_rList);		
	writeContent(_rValue, _rList);		
	m_rContext.m_xHandler->endElement(_rNodeName);	
	m_rContext.m_xHandler->ignorableWhitespace(OUString());

	return true;
}

// -----------------------------------------------------------------------------
sal_Bool AnyToXML::addRepresentationAttributes(const uno::Any& _rValue, 
												AttributeListImpl& _rList)
{
	// do we have a NULL value	
	if (!_rValue.hasValue())
	{
		addBoolAttribute(_rList, ATTR_NULL,true);
		return false;
	}
	
	if (_rValue.getValueTypeClass() == uno::TypeClass_SEQUENCE) // binary or list
	{
		bool bSeq;
		Type aTargetType = getBasicType(_rValue.getValueType(), bSeq);

		// set binary encoding
		if (aTargetType == SimpleTypeHelper::getBinaryType())
		{
			_rList.addAttribute( ATTR_ENCODING,
								 XML_CDATA,
								 ENCODING_HEX);
		}

		// create a sequence separator
		if (bSeq)
		{
			Separator aSeparator = createSeparator(_rValue);
			// write separator if not the default
			if (!aSeparator.isDefault())
			{
				_rList.addAttribute(ATTR_SEPARATOR,
					 				 XML_CDATA,
									 aSeparator.value());
			}
		}
	}

	return true;
}

// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------
	class AXMLFormatHandler
		:public ChangeTreeAction
		,public NodeAction
	{
		XMLFormatContext&   m_rContext;
        NodeState           m_eState;
	public:
        AXMLFormatHandler(XMLFormatContext& _rContext, NodeState _eState)
				:m_rContext(_rContext)
                ,m_eState(_eState)
			{}
		virtual ~AXMLFormatHandler() {}
		
		IXMLAttributeHandler& getContextAttributeHandler() const
		{ 
			OSL_ASSERT(m_rContext.m_pAttributeHandler);
			return *m_rContext.m_pAttributeHandler; 
		}
		virtual IXMLAttributeHandler& getAttributeHandler() const;

		// NodeAction
		virtual void handle(ValueNode const&);
		virtual void handle(ISubtree const&);

		// ChangeTreeAction
		virtual void handle(SubtreeChange const& aSubtree);
		virtual void handle(ValueChange const& aValueNode);
		virtual void handle(AddNode const& aAddNode);
		virtual void handle(RemoveNode const& aRemoveNode);	
        
        // checks for a change to default - returns true if handled as default
        bool handleChangeToDefault(Change const& _aChange);
	private:
		OUString implGetElementName(OUString const& sNodeName, AttributeListImpl& rAttributes);
        void implSetElementState(NodeState _eState, AttributeListImpl& _rAttributes);

		virtual OUString doGetElementName(OUString const& sNodeName, AttributeListImpl& _rList) = 0;
        
	};
// -----------------------------------------------------------------------------
	class OXMLComponentRootHandler : public AXMLFormatHandler
	{
		bool m_bUseNewFileStructure;
	public:
		OXMLComponentRootHandler(XMLFormatContext& _rContext, bool _bUseNew)
            :AXMLFormatHandler(_rContext,node::isAdded),
				 m_bUseNewFileStructure(_bUseNew)
			{}

	private:
		virtual OUString doGetElementName(OUString const& sNodeName, AttributeListImpl& _rList);

	};
// -----------------------------------------------------------------------------
	class OXMLGroupFormatHandler : public AXMLFormatHandler
	{
	public:
        OXMLGroupFormatHandler(XMLFormatContext& _rContext, NodeState _eState)
				:AXMLFormatHandler(_rContext,_eState)
			{}

	private:
		virtual OUString doGetElementName(OUString const& sNodeName, AttributeListImpl& _rList);

	};
// -----------------------------------------------------------------------------
	class OXMLSetFormatHandler : public AXMLFormatHandler
	{
		OUString m_sElementName;
	public:
		OXMLSetFormatHandler(OUString const& _sElementName, XMLFormatContext& _rContext, NodeState _eState)
				:AXMLFormatHandler(_rContext,_eState), m_sElementName(_sElementName)
			{}

	private:
		virtual OUString doGetElementName(OUString const& sNodeName, AttributeListImpl& _rList);

	};
// -----------------------------------------------------------------------------
	class OXMLLocalizedValueSetFormatHandler : public AXMLFormatHandler
	{
	public:
		OXMLLocalizedValueSetFormatHandler(XMLFormatContext& _rContext, NodeState _eState)
				:AXMLFormatHandler(_rContext,_eState)
			{}

	private:
		struct AttributeHandler;
		virtual IXMLAttributeHandler& getAttributeHandler() const;

		virtual OUString doGetElementName(OUString const& sNodeName, AttributeListImpl& _rList);

	};

// -----------------------------------------------------------------------------
// Real implementation of XML Export for CM

// -----------------------------------------------------------------------------
void XMLFormater::initContext(const vos::ORef<OOptions>& rOptions,IXMLAttributeHandler& rAttrHandler)
{
	if (rOptions.isValid())
	{
		m_aContext.m_aOutput.m_xTypeConverter = rOptions->getTypeConverter();
		m_aContext.m_sLocale = rOptions->getLocale();
	}
	
	m_aContext.m_pAttrList = new AttributeListImpl();
	m_aContext.m_pAttrList->acquire();

	m_aContext.m_pAttributeHandler = &rAttrHandler;
}
// -----------------------------------------------------------------------------
XMLFormater::XMLFormater(const SubtreeChange* _pChanges,
							 const vos::ORef<OOptions>& rOptions, IXMLAttributeHandler& rAttrHandler)
		:m_pChanges(_pChanges)
{
	OSL_ENSURE(m_pChanges, "CmXMLFormater::CmXMLFormater : invalid changes tree !");	
	initContext(rOptions,rAttrHandler);
}

// -----------------------------------------------------------------------------
XMLFormater::XMLFormater(const vos::ORef<OOptions>& rOptions, IXMLAttributeHandler& rAttrHandler)
		:m_pChanges(NULL)
{	
	initContext(rOptions,rAttrHandler);
}

// -----------------------------------------------------------------------------
XMLFormater::~XMLFormater()
{
	m_aContext.m_pAttrList->release();
}

// -----------------------------------------------------------------------------
// Helper Class for writing xml conform header.
// work like a sax::XDocumentHandler, which extend the startelement and if it is the first
// element, write also a xml conform header, else
// through put the startelement to the given XDocumentHandler

typedef ::cppu::WeakImplHelper1< sax::XDocumentHandler > ODocumentHandler_Base;
class OWriteXMLHeader : public ODocumentHandler_Base
{
protected:
	uno::Reference < sax::XDocumentHandler > m_xHandler;
	bool m_bFirstElement;

	OWriteXMLHeader() : m_bFirstElement(true) {}
public:
	
	OWriteXMLHeader(const uno::Reference < sax::XDocumentHandler > &_xHandler )
			:m_xHandler(_xHandler),
			 m_bFirstElement(true)
		{}
	
	// XDocumentHandler
	virtual void SAL_CALL startDocument(  ) throw(sax::SAXException, RuntimeException) {m_xHandler->startDocument();}
	virtual void SAL_CALL endDocument(  ) throw(sax::SAXException, RuntimeException) {m_xHandler->endDocument();}
	
	virtual void SAL_CALL startElement( const ::rtl::OUString& _aNodeName,
										const Reference< sax::XAttributeList >& _xAttrList )
		throw(sax::SAXException, RuntimeException)
		{
			if (m_bFirstElement)
			{
				AttributeListImpl *pList = new AttributeListImpl;
				Reference< sax::XAttributeList > rList( (XAttributeList *) pList , UNO_QUERY );
				
				// Copy all Attributes in the new list
				if (_xAttrList.is())
				{
					sal_Int16 nAttrCount = _xAttrList.is() ? _xAttrList->getLength() : 0;
					
					for( sal_Int16 i=0; i < nAttrCount; i++ )
					{
						OUString aParamName( _xAttrList->getNameByIndex( i ) );
						OUString aParamType( _xAttrList->getTypeByIndex( i ) );
						OUString aParamValue( _xAttrList->getValueByIndex( i ) );
						pList->addAttribute(aParamName, aParamType, aParamValue);
					}
				}
				// xmlns="http://openoffice.org/2000/registry/components/org.openoffice.Office.Common"
				// xmlns:cfg="http://openoffice.org/2000/registry/instance"
				// xmlns:xsi="http://www.w3.org/1999/XMLSchema-instance"
				// xml:lang="en-US"
				OUString aStr = ASCII(XMLNS_STR);
				aStr += _aNodeName;
				pList->addAttribute( ASCII("xmlns"),
									 ASCII("CDATA"),
									 aStr);
				
				pList->addAttribute( ASCII("xmlns:cfg"),
									 ASCII("CDATA"),
									 ASCII(XMLNS_CFG_STR));
				
				pList->addAttribute( ASCII("xmlns:xsi"),
									 ASCII("CDATA"),
									 ASCII(XMLNS_XSI_STR));
				
				//? is this necessary?
				// pList->addAttribute( ASCII("xml:lang"),
				// 						ASCII("CDATA"),
				// 						ASCII("en-US"));
				
				m_xHandler->startElement(_aNodeName, rList);
				m_bFirstElement = false;
			}
			else
			{
				m_xHandler->startElement(_aNodeName, _xAttrList);
			}
		}
	
	virtual void SAL_CALL endElement( const ::rtl::OUString& aName ) throw(sax::SAXException, RuntimeException)
		{m_xHandler->endElement(aName);}
	
	virtual void SAL_CALL characters( const ::rtl::OUString& aChars ) throw(sax::SAXException, RuntimeException)
		{m_xHandler->characters(aChars);}
	
	virtual void SAL_CALL ignorableWhitespace( const ::rtl::OUString& aWhitespaces ) throw(sax::SAXException, RuntimeException)
		{m_xHandler->ignorableWhitespace (aWhitespaces);}
	
	virtual void SAL_CALL processingInstruction( const ::rtl::OUString& aTarget, const ::rtl::OUString& aData ) throw(sax::SAXException, RuntimeException)
		{m_xHandler->processingInstruction (aTarget, aData);}
	
	virtual void SAL_CALL setDocumentLocator( const Reference< sax::XLocator >& xLocator ) throw(sax::SAXException, RuntimeException)
		{m_xHandler->setDocumentLocator(xLocator);}	
};
// -----------------------------------------------------------------------------
void XMLFormater::setHandler(const Reference< XDocumentHandler > &rHandler)
{
	Reference<sax::XDocumentHandler> xWriteHeader(new OWriteXMLHeader(rHandler));
	m_aContext.m_aOutput.m_xHandler = xWriteHeader;
	OSL_ENSURE(m_aContext.m_aOutput.m_xHandler.is(), "CmXMLFormater::SetHandler : invalid handler, won't write anything !");
}
	
// -----------------------------------------------------------------------------
sal_Bool XMLFormater::writeAsFlat(const AbsolutePath &_aRootNodePath, bool _bUseNew) CFG_UNO_THROW1(xml::sax::SAXException)
{
	// POST: This function WRITES ALLWAYS start/endDocument(!)
	// used from localSession::updateTree()

	Reference<sax::XDocumentHandler> xHandler = m_aContext.m_aOutput.m_xHandler;

	OSL_ENSURE(xHandler.is(),"ERROR: XMLFormater::writeAsFlat called without a handler");
	OSL_ENSURE(!_aRootNodePath.isRoot(),"ERROR: XMLFormater::writeAsFlat called without an empty (root) location");
	
	sal_Bool bBack = sal_False;
	xHandler->startDocument();

	OSL_ENSURE(m_pChanges, "writeAsFlat: No Data");
	// write all Subtrees in PathToRoot
	if (_aRootNodePath.getDepth() > 1)
	{
		OSL_ENSURE(false, "Write as flat with a  path to root does not work correctly");
		OSL_ASSERT(m_aContext.m_pAttributeHandler);
	// should be set by caller
	//	m_aContext.m_pAttributeHandler->setCurrentModule(aName.moduleName());

		// create a state Attribute

		AttributeListImpl *pList = new AttributeListImpl;
		Reference< XAttributeList > rList( (XAttributeList *) pList , UNO_QUERY );
		pList->addAttribute( ATTR_STATE,
							 ASCII("CDATA"),
							 STATE_MODIFIED); // write value to stream

		std::stack< rtl::OUString, std::vector<rtl::OUString> > aStringStack;
        
        AbsolutePath::Iterator const first = _aRootNodePath.begin();
 		AbsolutePath::Iterator const last  = _aRootNodePath.end()-1; // exclude the root change's name

		for (AbsolutePath::Iterator  it = first; it != last; ++it)
		{
            rtl::OUString aName = it->getName().toString();
            rtl::OUString aElementName = it->isSimpleName() ? aName : it->getTypeName().toString();
		    pList->addAttribute( ATTR_NAME,
							     ASCII("CDATA"),
							     aName);

			xHandler->startElement(aElementName, rList);
			xHandler->ignorableWhitespace(OUString());
			aStringStack.push(aElementName);
		}
        if (m_pChanges) 
        {
            // here we need an element type name                                    
            rtl::OUString aElementType = last->getTypeName().toString();
		    bBack = writeChange(*m_pChanges, aElementType, node::isModification);
        }

		// run stack down, write backward
		xHandler->ignorableWhitespace(OUString());
		while(!aStringStack.empty())
		{
			OUString aElementName = aStringStack.top();
			xHandler->endElement(aElementName);
			xHandler->ignorableWhitespace(OUString());
			aStringStack.pop();
		}
	}
	else if (m_pChanges != NULL)
	{
		// write the changes
		bBack = writeRootElementChange(*m_pChanges, _bUseNew);
	}

	// finish
	xHandler->endDocument();
	return bBack;
}

// -----------------------------------------------------------------------------

sal_Bool XMLFormater::writeGroupElementChange(Change const& _rChange, NodeState _eState) 
            CFG_UNO_THROW1(xml::sax::SAXException)
{
	sal_Bool bBack = sal_True;

	OXMLGroupFormatHandler aHandler(m_aContext,_eState);
	aHandler.applyToChange(_rChange);

	return bBack;
}

// -----------------------------------------------------------------------------

sal_Bool XMLFormater::writeSetElementChange(Change const& _rChange, OUString const& sElementName, NodeState _eState) 
            CFG_UNO_THROW1(xml::sax::SAXException)
{
	sal_Bool bBack = sal_True;

	OXMLSetFormatHandler aHandler(sElementName,m_aContext,_eState);
	aHandler.applyToChange(_rChange);

	return bBack;
}
// -----------------------------------------------------------------------------

sal_Bool XMLFormater::writeRootElementChange(Change const& _rChange, bool _bUseNew) 
            CFG_UNO_THROW1(xml::sax::SAXException)
{
	if (m_pChanges != NULL) 
	{
		OXMLComponentRootHandler aHandler(m_aContext, _bUseNew);
		aHandler.applyToChange(_rChange);

		return true;
	}
	else
		return false;
}

// -----------------------------------------------------------------------------

sal_Bool XMLFormater::writeChange(Change const& _rChange, OUString const& _sElementName, NodeState _eState) 
            CFG_UNO_THROW1(xml::sax::SAXException)
{
	if (_sElementName.getLength()) 
		return writeSetElementChange(_rChange, _sElementName, _eState);

	else 
		return writeGroupElementChange(_rChange, _eState);
}
// -----------------------------------------------------------------------------

void XMLFormater::writeNodeData(const uno::Reference< sax::XDocumentHandler >& _rHandler)
{
    // here we need an element type name and a context state ?!                                  
    // rtl::OUString aElementName = it->isSimpleName() ? aName : it->getTypeName().toString();

	setHandler(_rHandler);
    OSL_VERIFY( m_pChanges != NULL && writeChange(*m_pChanges, OUString(), node::isAdded) );
}

// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------
OXMLAttributeHandler::~OXMLAttributeHandler()
{
}
// -----------------------------------------------------------------------------
void OXMLAttributeHandler::setCurrentModule(OUString const& _sCurrentModule)
{
	this->m_sCurrentModule = _sCurrentModule;
}

// -----------------------------------------------------------------------------
void OXMLAttributeHandler::implTypeAttributes(const OUString& _sTypeName, bool _bList, AttributeListImpl& _rList)
{		
	_rList.addAttribute( ATTR_TYPE,
						 XML_CDATA,
						 _sTypeName);

	if (_bList)
	{
		_rList.addAttribute( ATTR_TYPE_MODIFIER,
							 XML_CDATA,
							 TYPE_MODIFIER_LIST);
	}
}
// -----------------------------------------------------------------------------
void OXMLAttributeHandler::implValueAttributes(const uno::Type& _rType, AttributeListImpl& _rList)
{		
	bool bSeq;
	Type aTargetType = getBasicType(_rType, bSeq);

	implTypeAttributes( toTypeName(aTargetType.getTypeClass()), bSeq, _rList);
}

// -----------------------------------------------------------------------------
void OXMLAttributeHandler::implLocalizedValueSetAttributes(const OUString& _rSpecialTemplateName, AttributeListImpl& _rList)
{		
//	toTemplateName(aInfo.sType, aInfo.isList), 
	bool bSeq;
	OUString aBasicTypeName; // maybe should use TypeClass as that adds more validation ?

	if ( !parseTemplateName(_rSpecialTemplateName, aBasicTypeName, bSeq) )
	{
		OSL_ENSURE(false, "Invalid pseudo-templatename found in set representation of localized value");

		aBasicTypeName = _rSpecialTemplateName; // ? - better fallback ? - recovery code ?
		bSeq = false;
	}

	implTypeAttributes( aBasicTypeName, bSeq, _rList);
}

// -----------------------------------------------------------------------------		
void OXMLAttributeHandler::implSetAttributes(OUString const& _sElementTypeName, OUString const& _sElementTypeModule, AttributeListImpl&  _rList)
{
	// new formatting: (no type='set') element-type = 'instance' element-component = 'module'
	OSL_ASSERT(_sElementTypeName.getLength() > 0);

	_rList.addAttribute( ATTR_INSTANCE,
						 XML_CDATA,
						 _sElementTypeName);

	if (_sElementTypeModule != this->getCurrentModule())
	{
		OSL_ENSURE(_sElementTypeModule.getLength() > 0, "ERROR: Empty element type module in set");
		_rList.addAttribute( ATTR_MODULE,
							 XML_CDATA,
							 _sElementTypeModule);
	}
}

// -----------------------------------------------------------------------------		
NodeState OXMLAttributeHandler::implCommonAttributes(NodeAttributes const& _aAttributes, AttributeListImpl& _rList)
{
	static const NodeAttributes aDefaultAttributes;

    OSL_ENSURE(!aDefaultAttributes.bFinalized,"Migration logic doesn't work, if finalized is default !?!");
    OSL_ENSURE(aDefaultAttributes.bWritable,"Migration logic doesn't work, if writable is not default !?!");

    if (_aAttributes.bFinalized)
    {
        if (_aAttributes.bWritable) // OK: Proper finalized support
	        addBoolAttribute(_rList, ATTR_FINALIZE, _aAttributes.bFinalized, aDefaultAttributes.bFinalized);

        else // The 'final' state was obtained by mapping from read-only
	        addBoolAttribute(_rList, ATTR_WRITABLE, !_aAttributes.bFinalized, aDefaultAttributes.bWritable);
    }
    else // standard behavior for writable
	    addBoolAttribute(_rList, ATTR_WRITABLE, _aAttributes.bWritable,  aDefaultAttributes.bWritable);

	addBoolAttribute(_rList, ATTR_NULLABLE, _aAttributes.bNullable, aDefaultAttributes.bNullable);

	addBoolAttribute(_rList, ATTR_LOCALIZE, _aAttributes.bLocalized, aDefaultAttributes.bLocalized);

    return _aAttributes.state();
}
// -----------------------------------------------------------------------------
void OXMLAttributeHandler::implStateAttributes(NodeState _eState, AttributeListImpl& _rList)
{
    OUString sState;
    switch (_eState)
    {
    case node::isModification:  sState = STATE_MODIFIED; break;

    case node::isAddition:
    case node::isReplacement:   sState = STATE_REPLACED; break;

    case node::isToDefault:     OSL_ENSURE(false, "Unexpected state 'default' whilegenerating attributes");
                                sState = STATE_DEFAULT;  break;

    default: OSL_ASSERT(false); return;
    }

    _rList.addAttribute( ATTR_STATE, XML_CDATA, sState);
}

// -----------------------------------------------------------------------------
void OXMLAttributeHandler::handleState(NodeState , AttributeListImpl& , bool )
{
    // no state written by default
}

// -----------------------------------------------------------------------------
NodeState OXMLAttributeHandler::handleAttributes(ValueNode const& _rNode, AttributeListImpl& _rList)
{
	implValueAttributes(_rNode.getValueType(), _rList);	

	return implCommonAttributes(_rNode.getAttributes(), _rList);
}

// -----------------------------------------------------------------------------
NodeState OXMLAttributeHandler::handleAttributes(ValueChange const& _rChange, AttributeListImpl& _rList)
{
	uno::Any aValue = _rChange.getNewValue();
	uno::Type aType = _rChange.getValueType();
	OSL_ENSURE( aType.getTypeClass() != TypeClass_VOID, "ERROR: Cannot get value type of change");

	implValueAttributes(aType, _rList);	

	return implCommonAttributes(_rChange.getAttributes(), _rList);
}

// -----------------------------------------------------------------------------
NodeState OXMLAttributeHandler::handleAttributes(ISubtree const& _rTree, AttributeListImpl& _rList)
{
	if ( isLocalizedValueSet(_rTree) )
	{
		OUString aValueTypeName	= _rTree.getElementTemplateName();

		implLocalizedValueSetAttributes(aValueTypeName, _rList);
	}

	else if (_rTree.isSetNode())
	{
		// new formatting: (no type='set') element-type = 'instance' element-component = 'module'
		OUString aElementTypeName	= _rTree.getElementTemplateName();
		OUString aElementTypeModule	= _rTree.getElementTemplateModule();

		implSetAttributes( aElementTypeName, aElementTypeModule, _rList );
	}	
	
	return implCommonAttributes(_rTree.getAttributes(), _rList);
}

// -----------------------------------------------------------------------------
NodeState OXMLAttributeHandler::handleAttributes(SubtreeChange const& _rTree, AttributeListImpl& _rList)
{
	if ( isLocalizedValueSet(_rTree) )
	{
		OUString aValueTypeName	= _rTree.getElementTemplateName();

		implLocalizedValueSetAttributes(aValueTypeName, _rList);
	}

	else if (_rTree.isSetNodeChange())
	{
		// new formatting: (no type='set') element-type = 'instance' element-component = 'module'
		OUString aElementTypeName	= _rTree.getElementTemplateName();
		OUString aElementTypeModule	= _rTree.getElementTemplateModule();

		implSetAttributes( aElementTypeName, aElementTypeModule, _rList );
	}	
	
	return implCommonAttributes(_rTree.getAttributes(), _rList);
}

// -----------------------------------------------------------------------------
bool OXMLAttributeHandler::handleRemoval(RemoveNode const& _rNode, AttributeListImpl& _rList)
{
	// adding the deleted state - is not done here
	return false;
}

// -----------------------------------------------------------------------------
bool OXMLAttributeHandler::markDefaulted(Change const& _rNode, AttributeListImpl&)
{
    OSL_ASSERT(_rNode.isToDefault());

	// adding the defaulted state - is not done here
	return false;
}

// -----------------------------------------------------------------------------
OUString OXMLAttributeHandler::translateElementName( OUString const& _sNodeName, OUString const& _sTypeName, 
								AttributeListImpl& _rList)
{
	OUString sElementName = _sTypeName;
	if (sElementName.getLength() == 0)
	{
		OSL_ENSURE(false, "Empty element-type - cannot use as element tag");
		OSL_ENSURE(_sNodeName.getLength() > 0, "Neither element-type nor node-name- cannot create element tag");

		sElementName = _sNodeName;
	}

	if (_sNodeName != sElementName)
	{
		_rList.addAttribute( ATTR_NAME,XML_CDATA,_sNodeName);
	}

	return sElementName;
}

// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------
void OXMLChangeAttributeHandler::handleState(node::State _eState, AttributeListImpl& _rList, bool _bChanged)
{
    // write state only if changed
    if (_bChanged)
        implStateAttributes(_eState,_rList);
}

// -----------------------------------------------------------------------------
bool OXMLChangeAttributeHandler::handleRemoval(RemoveNode const& _rNode, AttributeListImpl& _rList)
{
	// adding the deleted state
	_rList.addAttribute( ATTR_STATE,
						 XML_CDATA,
						 STATE_DELETED);
	return true;
}

// -----------------------------------------------------------------------------
bool OXMLChangeAttributeHandler::markDefaulted(Change const& _rNode, AttributeListImpl& _rList)
{
    OSL_ASSERT(_rNode.isToDefault());

	// adding the default state
	_rList.addAttribute( ATTR_STATE,
						 XML_CDATA,
						 STATE_DEFAULT);
	return true;
}

// -----------------------------------------------------------------------------
void AXMLFormatHandler::handle(ValueNode const& _rNode)
{
	AttributeListImpl& rAttrList = *m_rContext.m_pAttrList;
	// clear the attributes
	rAttrList.clear();	

	// set the default attributes for a value
	NodeState eThisState = getAttributeHandler().handleAttributes(_rNode, rAttrList);	
    this->implSetElementState(eThisState,rAttrList);
	
	AnyToXML aValueWriter(m_rContext.m_aOutput);
	OUString sNodeName = implGetElementName(_rNode.getName(),rAttrList);

	// if we use localized data
	bool bLocalized = _rNode.isLocalized();
	if (bLocalized)
		aValueWriter.writeLocalized(sNodeName, m_rContext.m_sLocale, _rNode.getValue(), rAttrList);
	else
		aValueWriter.write(sNodeName, _rNode.getValue(), rAttrList);
}

// -----------------------------------------------------------------------------
void AXMLFormatHandler::handle(ISubtree const& _rTree)
{
	Reference<sax::XDocumentHandler> xHandler = m_rContext.m_aOutput.m_xHandler;

	OSL_ENSURE(xHandler.is(),"ERROR: XMLFormatHandler used without a SAX handler");
	
	AttributeListImpl& rAttrList = *m_rContext.m_pAttrList;
	// clear the attributes
	rAttrList.clear();

	NodeState eThisState = getAttributeHandler().handleAttributes(_rTree, rAttrList);	
    this->implSetElementState(eThisState,rAttrList);
	
	OUString sNodeName = implGetElementName(_rTree.getName(),rAttrList);

	xHandler->startElement(sNodeName,&rAttrList);
	xHandler->ignorableWhitespace(OUString());

	if (isLocalizedValueSet(_rTree))
	{
		OXMLLocalizedValueSetFormatHandler aFormater(m_rContext,eThisState);
		_rTree.forEachChild(aFormater);
	}
	else if (_rTree.isSetNode())
	{
		OXMLSetFormatHandler aFormater(_rTree.getElementTemplateName(),m_rContext,eThisState);
		_rTree.forEachChild(aFormater);
	}
	else
	{
		OXMLGroupFormatHandler aFormater(m_rContext,eThisState);
		_rTree.forEachChild(aFormater);
	}
	

	xHandler->endElement(sNodeName);
	xHandler->ignorableWhitespace(OUString());
}

// ---------------------------------- Changes ----------------------------------
void AXMLFormatHandler::handle(ValueChange const& aValueNode)
{
    if (!handleChangeToDefault(aValueNode))
    {
	    AttributeListImpl& rAttrList = *m_rContext.m_pAttrList;
	    // clear the attributes
	    rAttrList.clear();	

	    // set the required attributes
	    NodeState eThisState = getAttributeHandler().handleAttributes(aValueNode, rAttrList);	
        this->implSetElementState(eThisState,rAttrList);
	    
	    AnyToXML aValueWriter(m_rContext.m_aOutput);
	    OUString sNodeName = implGetElementName(aValueNode.getNodeName(),rAttrList);

	    bool bLocalized = aValueNode.isLocalizedValue();
	    if (bLocalized)
		    aValueWriter.writeLocalized(sNodeName, m_rContext.m_sLocale, aValueNode.getNewValue(), rAttrList);
	    else
		    aValueWriter.write(sNodeName, aValueNode.getNewValue(), rAttrList);	
    }
}

// -----------------------------------------------------------------------------
void AXMLFormatHandler::handle(AddNode const& aAddNode)
{
    if (!handleChangeToDefault(aAddNode))
    {
	    // write the INode
	    INode* pNewNode = aAddNode.getAddedNode();
	    if (!pNewNode)
	    {
		    pNewNode = aAddNode.getAddedNode_unsafe();
		    OSL_ENSURE(pNewNode, "CmXMLFormater::handle : added an empty node ?");
		    CFG_TRACE_WARNING("xml formatter: Formatting 'AddNode' change that doesn't own its node");
	    }

	    if (pNewNode)
		    pNewNode->dispatch(*this);
    }
}

// -----------------------------------------------------------------------------
void AXMLFormatHandler::handle(RemoveNode const& _rNode)
{
    if (!handleChangeToDefault(_rNode))
    {
        Reference<sax::XDocumentHandler> xHandler = m_rContext.m_aOutput.m_xHandler;

	    OSL_ENSURE(xHandler.is(),"ERROR: XMLFormatHandler used without a SAX handler");
	    
	    AttributeListImpl& rAttrList = *m_rContext.m_pAttrList;
	    // clear the attributes
	    rAttrList.clear();	

	    // set the required attributes and query whether to write this removed node
	    if (getAttributeHandler().handleRemoval(_rNode, rAttrList))
	    {
		    OUString sNodeName = implGetElementName(_rNode.getNodeName(),rAttrList);

		    xHandler->startElement(sNodeName, &rAttrList);
		    xHandler->endElement(sNodeName);
		    xHandler->ignorableWhitespace(OUString());
	    }
    }
}

// -----------------------------------------------------------------------------
void AXMLFormatHandler::handle(SubtreeChange const& _rSubtree)
{
    if (!handleChangeToDefault(_rSubtree))
    {
        Reference<sax::XDocumentHandler> xHandler = m_rContext.m_aOutput.m_xHandler;

	    OSL_ENSURE(xHandler.is(),"ERROR: XMLFormatHandler used without a SAX handler");
	    
	    AttributeListImpl& rAttrList = *m_rContext.m_pAttrList;
	    // clear the attributes
	    rAttrList.clear();	

	    // set the required attributes
	    NodeState eThisState = getAttributeHandler().handleAttributes(_rSubtree, rAttrList);	
        this->implSetElementState(eThisState,rAttrList);
	    
	    OUString sNodeName = implGetElementName(_rSubtree.getNodeName(),rAttrList);

	    xHandler->startElement(sNodeName, &rAttrList);
	    xHandler->ignorableWhitespace(OUString());

	    if (isLocalizedValueSet(_rSubtree))
	    {
		    OXMLLocalizedValueSetFormatHandler aFormater(m_rContext,eThisState);
		    _rSubtree.forEachChange(aFormater);
	    }
	    else if (_rSubtree.isSetNodeChange())
	    {
		    OXMLSetFormatHandler aFormater(_rSubtree.getElementTemplateName(),m_rContext,eThisState);
		    _rSubtree.forEachChange(aFormater);
	    }
	    else
	    {
		    OXMLGroupFormatHandler aFormater(m_rContext,eThisState);
		    _rSubtree.forEachChange(aFormater);
	    }

	    xHandler->endElement(sNodeName);
	    xHandler->ignorableWhitespace(OUString());
    }
}
// -----------------------------------------------------------------------------
bool AXMLFormatHandler::handleChangeToDefault(Change const& _aChange)
{
    bool bHandled = false;
    if (_aChange.isToDefault())
    {
	    Reference<sax::XDocumentHandler> xHandler = m_rContext.m_aOutput.m_xHandler;

	    OSL_ENSURE(xHandler.is(),"ERROR: XMLFormatHandler used without a SAX handler");
	    
	    AttributeListImpl& rAttrList = *m_rContext.m_pAttrList;
	    // clear the attributes
	    rAttrList.clear();	

	    // set the required attributes and query whether to write this defaulted node
	    if (getAttributeHandler().markDefaulted(_aChange, rAttrList))
	    {
		    OUString sNodeName = implGetElementName(_aChange.getNodeName(),rAttrList);

		    xHandler->startElement(sNodeName, &rAttrList);
		    xHandler->endElement(sNodeName);
		    xHandler->ignorableWhitespace(OUString());

            bHandled = true;
	    }
    }
    return bHandled;
}


// -----------------------------------------------------------------------------
OUString AXMLFormatHandler::implGetElementName(OUString const& _sNodeName, AttributeListImpl& _rList)
{
	OUString sElementName = this->doGetElementName(_sNodeName, _rList);

	return sElementName;
}

// -----------------------------------------------------------------------------
void AXMLFormatHandler::implSetElementState(NodeState _eState, AttributeListImpl& _rAttributes)
{
    getAttributeHandler().handleState(_eState,_rAttributes, _eState != m_eState);
}

// -----------------------------------------------------------------------------
IXMLAttributeHandler& AXMLFormatHandler::getAttributeHandler() const
{
	return this->getContextAttributeHandler();
}

// -----------------------------------------------------------------------------
OUString OXMLGroupFormatHandler::doGetElementName(OUString const& _sNodeName, AttributeListImpl& _rList )
{
	return _sNodeName;
}
// -----------------------------------------------------------------------------
OUString OXMLSetFormatHandler::doGetElementName(OUString const& _sNodeName, AttributeListImpl& _rList )
{
	OUString sElementName = getAttributeHandler().translateElementName(_sNodeName, m_sElementName, _rList);

	return sElementName;
}
// -----------------------------------------------------------------------------
OUString OXMLComponentRootHandler::doGetElementName(OUString const& _sNodeName, AttributeListImpl& _rList )
{
	if (m_bUseNewFileStructure)
	{
		_rList.addAttribute(ATTR_PACKAGE, XML_CDATA, NameHelper::getPackageName(_sNodeName));
		return NameHelper::getModuleNameWithoutPackageName(_sNodeName);
	}
	else
	{
		return _sNodeName;
	}
}

// -----------------------------------------------------------------------------
struct OXMLLocalizedValueSetFormatHandler::AttributeHandler : IXMLAttributeHandler
{
	// Handle the attributes, writing the attributes belonging to each type of node
	virtual NodeState handleAttributes(ValueNode const&, AttributeListImpl&);
	virtual NodeState handleAttributes(ISubtree const&, AttributeListImpl&);
	virtual NodeState handleAttributes(SubtreeChange const& , AttributeListImpl&);
	virtual NodeState handleAttributes(ValueChange const& , AttributeListImpl&);
    
	virtual bool      handleRemoval(RemoveNode const& , AttributeListImpl&);
	
    virtual void handleState(NodeState , AttributeListImpl& , bool );

    virtual bool markDefaulted(Change const& , AttributeListImpl&);

	// special handling of element name in sets
	virtual OUString translateElementName( OUString const& sNodeName, OUString const& sLanguageName, 
											AttributeListImpl& );

	virtual void setCurrentModule(OUString const& _sCurrentModule);
};
// -----------------------------------------------------------------------------
#if LOCALIZED_SUBVALUES_NEED_STATE
	#error "Localized value set formatting does not propagate state yet"
	// note the return value of the RemoveNode Handler as well	
#endif // LOCALIZED_SUBVALUES_NEED_STATE

    // unused here
void OXMLLocalizedValueSetFormatHandler::AttributeHandler::
	setCurrentModule(OUString const& )
	{}
// attributes are all suppreseed on the sub value tag
// -----------------------------------------------------------------------------
NodeState OXMLLocalizedValueSetFormatHandler::AttributeHandler::
	handleAttributes(ValueNode const& , AttributeListImpl&) 
    { return node::isReplaced; }
NodeState OXMLLocalizedValueSetFormatHandler::AttributeHandler::
	handleAttributes(ValueChange const& , AttributeListImpl&)		
	{ return node::isReplaced; }		
NodeState OXMLLocalizedValueSetFormatHandler::AttributeHandler::
	handleAttributes(ISubtree const&, AttributeListImpl&)	
	{ OSL_ASSERT(false); return node::isReplaced; }
NodeState OXMLLocalizedValueSetFormatHandler::AttributeHandler::
	handleAttributes(SubtreeChange const& , AttributeListImpl&)	
	{ OSL_ASSERT(false); return node::isReplaced; }
bool OXMLLocalizedValueSetFormatHandler::AttributeHandler::
	handleRemoval(RemoveNode const& , AttributeListImpl& _rList) 
	{ 	_rList.addAttribute( ATTR_STATE,XML_CDATA, STATE_DELETED);
        return true; }
bool OXMLLocalizedValueSetFormatHandler::AttributeHandler::
	markDefaulted(Change const& , AttributeListImpl& _rList) 
	{ 	_rList.addAttribute( ATTR_STATE,XML_CDATA, STATE_DEFAULT);
        return true; }
void OXMLLocalizedValueSetFormatHandler::AttributeHandler::
    handleState(node::State , AttributeListImpl& , bool )
	{
    #if LOCALIZED_SUBVALUES_NEED_STATE
        _rList.addAttribute( ATTR_STATE,XML_CDATA, STATE_REPLACED);
    #endif // LOCALIZED_SUBVALUES_NEED_STATE
    }

// -----------------------------------------------------------------------------
OUString OXMLLocalizedValueSetFormatHandler::AttributeHandler::
	translateElementName( 
		OUString const& _sLanguageName, 
		OUString const& _sTagName, 
		AttributeListImpl& _rList)
{
	// the node name is the locale
	_rList.addAttribute( ATTR_LANG, XML_CDATA, _sLanguageName);

	return _sTagName;
}

// -----------------------------------------------------------------------------
OUString OXMLLocalizedValueSetFormatHandler::doGetElementName(OUString const& _sNodeName, AttributeListImpl& _rList)
{
	// the node name her is the locale name !
	OUString sElementName = getAttributeHandler().translateElementName(_sNodeName, TAG_VALUE, _rList);

	return sElementName;
}
// -----------------------------------------------------------------------------
// -----------------------------------------------------------------------------
IXMLAttributeHandler& OXMLLocalizedValueSetFormatHandler::getAttributeHandler() const
{
	static AttributeHandler s_aAttributeHandler; // currently stateless !
	return s_aAttributeHandler;
}

//==========================================================================
//= ORemoteXMLAttributeHandler
//==========================================================================

// -----------------------------------------------------------------------------
template <class Tree>
void implOldSetAttributes(Tree const& _aTree, AttributeListImpl&  _rList)
{
	// old formatting: type='set' element-type = 'module/instance'
	_rList.addAttribute( ATTR_TYPE,
						 XML_CDATA,
						 TYPE_SET);

	OUString aSetName = getElementTemplatePath(_aTree);
	OSL_ENSURE(aSetName.getLength() > 0, "set has no element type");

	_rList.addAttribute( ATTR_INSTANCE,
						 XML_CDATA,
						 aSetName);
}

// -----------------------------------------------------------------------------
void ORemoteUpdateXMLAttributeHandler::handleState(NodeState _eState, AttributeListImpl& _rList, bool )
{
    // always write state
    implStateAttributes(_eState,_rList);
}

// -----------------------------------------------------------------------------
NodeState ORemoteUpdateXMLAttributeHandler::handleAttributes(ISubtree const& _rTree, AttributeListImpl& _rList)
{
	if (_rTree.isSetNode() && !isLocalizedValueSet(_rTree) )
	{
		implOldSetAttributes(_rTree,_rList);

		return implCommonAttributes(_rTree.getAttributes(), _rList);
	}
	else // for groups and localized values (as set) use the common version
		return OXMLChangeAttributeHandler::handleAttributes(_rTree, _rList);	
	
}

// -----------------------------------------------------------------------------
NodeState ORemoteUpdateXMLAttributeHandler::handleAttributes(SubtreeChange const& _rChange, AttributeListImpl& _rList)
{
	if (_rChange.isSetNodeChange() && !isLocalizedValueSet(_rChange) )
	{
		implOldSetAttributes(_rChange,_rList);

		return implCommonAttributes(_rChange.getAttributes(), _rList);
	}
	else // for groups and localized values (as set) use the common version
		return OXMLChangeAttributeHandler::handleAttributes(_rChange, _rList);	
}

// -----------------------------------------------------------------------------
OUString ORemoteUpdateXMLAttributeHandler::translateElementName( OUString const& _sNodeName, OUString const& , 
															AttributeListImpl& )
{
	OSL_ENSURE(_sNodeName.getLength() > 0, "No node-name- cannot create element tag");

	return _sNodeName;
}

// -----------------------------------------------------------------------------
} // namespace configmgr


