/*************************************************************************
 *
 *  $RCSfile: MABConnection.cxx,v $
 *
 *  $Revision: 1.24 $
 *
 *  last change: $Author: oj $ $Date: 2001/10/05 06:43:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Darren Kenny, Willem van Dorp
 *
 *
 ************************************************************************/
#ifndef _CONNECTIVITY_MAB_CONNECTION_HXX_
#include "mozaddressbook/MABConnection.hxx"
#endif
#ifndef _CONNECTIVITY_MAB_DATABASEMETADATA_HXX_
#include "mozaddressbook/MABDatabaseMetaData.hxx"
#endif
#ifndef _CONNECTIVITY_MAB_CATALOG_HXX_
#include "mozaddressbook/MABCatalog.hxx"
#endif
#ifndef _CONNECTIVITY_MAB_ODRIVER_HXX_
#include "mozaddressbook/MABDriver.hxx"
#endif
#ifndef _COM_SUN_STAR_LANG_DISPOSEDEXCEPTION_HPP_
#include <com/sun/star/lang/DisposedException.hpp>
#endif
#ifndef _CONNECTIVITY_MAB_PREPAREDSTATEMENT_HXX_
#include "mozaddressbook/MABPreparedStatement.hxx"
#endif
#ifndef _CONNECTIVITY_MAB_STATEMENT_HXX_
#include "mozaddressbook/MABStatement.hxx"
#endif
#ifndef _DBHELPER_DBEXCEPTION_HXX_
#include <connectivity/dbexception.hxx>
#endif

#include <MABDebug.hxx>

using namespace connectivity::mozaddressbook;
using namespace connectivity::file;

//------------------------------------------------------------------------------

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::lang;

// --------------------------------------------------------------------------------

namespace connectivity {
    namespace mozaddressbook {
		// For the moment, we will connect the Mozilla address book to the Mozilla 
		// top-level address book which will display whatever is in the preferences 
		// file of Mozilla.
        static sal_Char*    MOZ_SCHEME_MOZILLA          = "moz-abdirectory://";
		static sal_Bool     USES_FACTORY_MOZILLA        = sal_False ;
		// This one is a base uri which will be completed with the connection data.
        static sal_Char*    MOZ_SCHEME_LDAP             = "moz-abldapdirectory://";
		static sal_Bool     USES_FACTORY_LDAP           = sal_False ;
		// These two uris will be used to obtain directory factories to access all
		// address books of the given type.
        static sal_Char*    MOZ_SCHEME_OUTLOOK_MAPI     = "moz-aboutlookdirectory://op/";
		static sal_Bool     USES_FACTORY_OUTLOOK_MAPI   = sal_True ;
        static sal_Char*    MOZ_SCHEME_OUTLOOK_EXPRESS  = "moz-aboutlookdirectory://oe/";
		static sal_Bool     USES_FACTORY_OUTLOOK_EXPRESS= sal_True ;
    }
}
// -----------------------------------------------------------------------------
const sal_Char* OMozabConnection::getSDBC_SCHEME_MOZILLA()
{
	static sal_Char*    SDBC_SCHEME_MOZILLA			= "mozilla";
	return SDBC_SCHEME_MOZILLA;
}
// -----------------------------------------------------------------------------
const sal_Char* OMozabConnection::getSDBC_SCHEME_LDAP()
{
	static sal_Char*    SDBC_SCHEME_LDAP            = "ldap";
	return SDBC_SCHEME_LDAP;
}
// -----------------------------------------------------------------------------       
const sal_Char* OMozabConnection::getSDBC_SCHEME_OUTLOOK_MAPI()
{
	static sal_Char*    SDBC_SCHEME_OUTLOOK_MAPI    = "outlook";
	return SDBC_SCHEME_OUTLOOK_MAPI;
}
// -----------------------------------------------------------------------------
const sal_Char* OMozabConnection::getSDBC_SCHEME_OUTLOOK_EXPRESS()
{
	static sal_Char*    SDBC_SCHEME_OUTLOOK_EXPRESS = "outlookexp";
	return SDBC_SCHEME_OUTLOOK_EXPRESS;
}
// -----------------------------------------------------------------------------

OMozabConnection::OMozabConnection(OMozabDriver* _pDriver)
	:OConnection(_pDriver)
	,m_nAnonABCount( 0 )
	,m_nMaxResultRecords( -1 )
	,m_UsesFactory(sal_False)
	,m_IsLDAP(sal_False)
	,m_bOutlookExpress(sal_False)
{
	OSL_TRACE("IN/OUT OMozabConnection::OMozabConnection()\n" );
	// m_aFilenameExtension is not used
	
	// Initialise m_aColumnAlias.
	m_aColumnAlias.setAlias(_pDriver->getMSFactory());
}

OMozabConnection::~OMozabConnection()
{
	OSL_TRACE("IN/OUT OMozabConnection::~OMozabConnection()\n" );
}

void OMozabConnection::construct(const ::rtl::OUString& url,const Sequence< PropertyValue >& info)
	throw(SQLException)
{
	OSL_TRACE("IN OMozabConnection::construct()\n" );
	//	open file

	m_sURL = url;
    // 
    // Skip 'sdbc:mozab: part of URL
    //
	sal_Int32 nLen = url.indexOf(':');
	nLen = url.indexOf(':',nLen+1);
	::rtl::OUString aAddrbookURI(url.copy(nLen+1));
    // Get Scheme
	nLen = aAddrbookURI.indexOf(':');
    ::rtl::OUString aAddrbookScheme;
    if ( nLen == -1 )
	{
        // There isn't any subschema: - but could be just subschema
        if ( aAddrbookURI.getLength() > 0 ) {
            aAddrbookScheme= aAddrbookURI;
        }
        else {
            OSL_TRACE( "No subschema given!!!\n");
            ::dbtools::throwGenericSQLException(
                        ::rtl::OUString::createFromAscii("No subschema provided"),NULL);
        }
    }
    else {
        aAddrbookScheme = aAddrbookURI.copy(0, nLen);
    }

	OSL_TRACE("URI = %s\n", ((OUtoCStr(aAddrbookURI)) ? (OUtoCStr(aAddrbookURI)):("NULL")) );
	OSL_TRACE("Scheme = %s\n", ((OUtoCStr(aAddrbookScheme)) ? 
                                 (OUtoCStr(aAddrbookScheme)):("NULL")) );

    //
    // Now we have a URI convert it to a MozillaURI
    //
    // The Mapping being used is:
    //
    // * for Mozilla 
    //      "sdbc:address:mozilla:"        -> abdirectory://
    // * for LDAP                          
    //      "sdbc:address:ldap:"           -> abldapdirectory://
    // * for Outlook (using MAPI API)       
    //      "sdbc:address:outlook:"        -> aboutlookdirectory://op/
    // * for windows system address book    
    //      "sdbc:address:outlookexp:"     -> aboutlookdirectory://oe/
    //
	m_IsLDAP = sal_False ;
    if ( aAddrbookScheme.compareToAscii( getSDBC_SCHEME_MOZILLA() ) == 0 ) {
        m_sMozillaURI = rtl::OUString::createFromAscii( MOZ_SCHEME_MOZILLA );
		m_UsesFactory = USES_FACTORY_MOZILLA ;
    }
    else if ( aAddrbookScheme.compareToAscii( getSDBC_SCHEME_LDAP() ) == 0 ) {
        rtl::OUString sHostName;
        rtl::OUString sBaseDN;
        sal_Int32     nPortNumber = -1;

        m_sMozillaURI = rtl::OUString::createFromAscii( MOZ_SCHEME_LDAP );
		m_UsesFactory = USES_FACTORY_LDAP ;
		m_IsLDAP = sal_True ;

		const PropertyValue* pInfo = info.getConstArray();
		const PropertyValue* pInfoEnd = pInfo + info.getLength();

        for (; pInfo != pInfoEnd; ++pInfo)
		{
			OSL_TRACE( "info[%d].Name = %s\n", pInfo - info.getConstArray(), OUtoCStr( pInfo->Name ) );

            if ( 0 == pInfo->Name.compareToAscii("HostName") )
			{
                pInfo->Value >>= sHostName;
            } 
            else if ( 0 == pInfo->Name.compareToAscii("BaseDN") )
			{
                pInfo->Value >>= sBaseDN;
            } 
            else if ( 0 == pInfo->Name.compareToAscii("PortNumber") )
			{
                pInfo->Value >>= nPortNumber;
            } 
            else if ( 0 == pInfo->Name.compareToAscii("MaxRowCount") )
			{
                pInfo->Value >>= m_nMaxResultRecords;
            } 
        }
        if ( sHostName.getLength() != 0 ) {
            m_sMozillaURI += sHostName;
        } 
        else {
            ::dbtools::throwGenericSQLException(
                        ::rtl::OUString::createFromAscii("No HostName provided"),NULL);
        }

        if ( nPortNumber > 0 ) {
            m_sMozillaURI += rtl::OUString::createFromAscii( ":" );
            m_sMozillaURI += rtl::OUString::valueOf( nPortNumber );
        }

        if ( sBaseDN.getLength() != 0 ) {
            m_sMozillaURI += rtl::OUString::createFromAscii( "/" );
            m_sMozillaURI += sBaseDN;
        } 
        else {
            ::dbtools::throwGenericSQLException(
                        ::rtl::OUString::createFromAscii("No BaseDN provided"),NULL);
        }
	// Addition of a fake query to enable the Mozilla LDAP directory to work correctly.
	m_sMozillaURI += ::rtl::OUString::createFromAscii("?(or(DisplayName,=,DontDoThisAtHome))");

    }
    else if ( aAddrbookScheme.compareToAscii( getSDBC_SCHEME_OUTLOOK_MAPI() ) == 0 ) {
        m_sMozillaURI		= ::rtl::OUString::createFromAscii( MOZ_SCHEME_OUTLOOK_MAPI );
		m_UsesFactory		= USES_FACTORY_OUTLOOK_MAPI ;
    }
    else if ( aAddrbookScheme.compareToAscii( getSDBC_SCHEME_OUTLOOK_EXPRESS() ) == 0 ) {
        m_sMozillaURI		= rtl::OUString::createFromAscii( MOZ_SCHEME_OUTLOOK_EXPRESS );
		m_UsesFactory		= USES_FACTORY_OUTLOOK_EXPRESS ;
		m_bOutlookExpress	= sal_True;
    }
    else
	{
		OSL_TRACE("Invalid subschema given!!!\n");
        ::dbtools::throwGenericSQLException(
                    ::rtl::OUString::createFromAscii("Invalid subschema provided"),NULL);
    }

	OSL_TRACE("Moz URI = %s, %s\n", ((OUtoCStr(m_sMozillaURI)) ? 
                                  (OUtoCStr(m_sMozillaURI)):("NULL")),
								  m_UsesFactory ? "uses factory" : "no factory");
	OSL_TRACE( "\tOUT OMozabConnection::construct()\n" );
}

void OMozabConnection::disposing()
{
	OSL_TRACE( "IN OMozabConnection::disposing()\n" );
	::osl::MutexGuard aGuard(m_aMutex);

	OConnection::disposing();
	OSL_TRACE( "\tOUT OMozabConnection::disposing()\n" );
}

// XServiceInfo
// --------------------------------------------------------------------------------

IMPLEMENT_SERVICE_INFO(OMozabConnection, "com.sun.star.sdbc.drivers.mozaddressbook.Connection", "com.sun.star.sdbc.Connection")

// --------------------------------------------------------------------------------

Reference< XDatabaseMetaData > SAL_CALL OMozabConnection::getMetaData(  ) throw(SQLException, RuntimeException)
{
	OSL_TRACE("IN OMozabConnection::getMetaData()\n" );
	::osl::MutexGuard aGuard( m_aMutex );
	if (OConnection::rBHelper.bDisposed)
		throw DisposedException();

	Reference< XDatabaseMetaData > xMetaData = m_xMetaData;
	if(!xMetaData.is())
	{
		xMetaData = new OMozabDatabaseMetaData(this);
		m_xMetaData = xMetaData;
	}
	OSL_TRACE( "\tOUT OMozabConnection::getMetaData()\n" );

	return xMetaData;
}

//------------------------------------------------------------------------------

::com::sun::star::uno::Reference< XTablesSupplier > OMozabConnection::createCatalog()
{
	OSL_TRACE("IN OMozabConnection::createCatalog()\n" );
	::osl::MutexGuard aGuard( m_aMutex );
	Reference< XTablesSupplier > xTab = m_xCatalog;
	if(!xTab.is())
	{
		OMozabCatalog *pCat = new OMozabCatalog(this);
		xTab = pCat;
		m_xCatalog = xTab;
	}
	OSL_TRACE( "\tOUT OMozabConnection::createCatalog()\n" );
	return xTab;
}

// --------------------------------------------------------------------------------

Reference< XStatement > SAL_CALL OMozabConnection::createStatement(  ) throw(SQLException, RuntimeException)
{
	OSL_TRACE( "IN OMozabConnection::createStatement()\n" );
	::osl::MutexGuard aGuard( m_aMutex );
	if (OConnection::rBHelper.bDisposed)
        throw DisposedException();

	Reference< XStatement > xReturn = new OMozabStatement(this);
    m_aStatements.push_back(WeakReferenceHelper(xReturn));
	OSL_TRACE( "\tOUT OMozabConnection::createStatement()\n" );
	return xReturn;
}

// --------------------------------------------------------------------------------

Reference< XPreparedStatement > SAL_CALL OMozabConnection::prepareStatement( const ::rtl::OUString& sql )
	throw(SQLException, RuntimeException)
{
	OSL_TRACE( "IN OMozabConnection::prepareStatement()\n" );
	::osl::MutexGuard aGuard( m_aMutex );
	if (OConnection::rBHelper.bDisposed)
        throw DisposedException();

	OMozabPreparedStatement* pStmt = new OMozabPreparedStatement(this );
	Reference< XPreparedStatement > xHoldAlive = pStmt;
	pStmt->construct(sql);
    m_aStatements.push_back(WeakReferenceHelper(*pStmt));
	OSL_TRACE( "\tOUT OMozabConnection::prepareStatement()\n" );
	return pStmt;
}

// --------------------------------------------------------------------------------

Reference< XPreparedStatement > SAL_CALL OMozabConnection::prepareCall( const ::rtl::OUString& sql )
	throw(SQLException, RuntimeException)
{
	OSL_TRACE( "IN OMozabConnection::prepareCall()\n" );
	::osl::MutexGuard aGuard( m_aMutex );
	if (OConnection::rBHelper.bDisposed)
        throw DisposedException();
	OSL_TRACE( "\tOUT OMozabConnection::prepareCall()\n" );
	return NULL;
}


