/*************************************************************************
 *
 *  $RCSfile: MABTable.cxx,v $
 *
 *  $Revision: 1.29 $
 *
 *  last change: $Author: oj $ $Date: 2001/10/26 07:47:13 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Darren Kenny, Willem van Dorp
 *
 *
 ************************************************************************/

#ifndef _CONNECTIVITY_MAB_TABLE_HXX_
#include "mozaddressbook/MABTable.hxx"
#endif
#ifndef _COM_SUN_STAR_SDBC_COLUMNVALUE_HPP_
#include <com/sun/star/sdbc/ColumnValue.hpp>
#endif
#ifndef _COM_SUN_STAR_SDBC_XROW_HPP_
#include <com/sun/star/sdbc/XRow.hpp>
#endif
#ifndef _COM_SUN_STAR_TEXT_XTEXT_HPP_
#include <com/sun/star/text/XText.hpp>
#endif
#ifndef _CONNECTIVITY_MAB_CONNECTION_HXX_
#include "mozaddressbook/MABConnection.hxx"
#endif
#ifndef _CONNECTIVITY_MAB_COLUMNS_HXX_
#include "mozaddressbook/MABColumns.hxx"
#endif
#ifndef _CONNECTIVITY_SDBCX_COLUMN_HXX_
#include "connectivity/sdbcx/VColumn.hxx"
#endif
#ifndef _UCBHELPER_CONTENT_HXX
#include <ucbhelper/content.hxx>
#endif
#ifndef _DBHELPER_DBEXCEPTION_HXX_
#include <connectivity/dbexception.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif

#include <MABDebug.hxx>

using namespace connectivity;
using namespace connectivity::mozaddressbook;
using namespace connectivity::file;
using namespace ::rtl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::container;

// -------------------------------------------------------------------------
void OMozabTable::fillColumns()
{

    OSL_TRACE( "IN OMozabTable::fillColumns()\n" );


    String              aStrFieldName;
    ::rtl::OUString     aTypeName;
    

    aStrFieldName.AssignAscii("Column");

    m_aAttributeStrings.clear();
	m_aAttributeStrings.reserve(m_nNR_OF_FIELDS+1);
    m_aAttributeStrings.push_back( ::rtl::OUString::createFromAscii("card:URI") );

    Reference< XDatabaseMetaData > xMtd = m_pConnection->getMetaData();
    ::comphelper::UStringMixEqual aCase(xMtd->storesMixedCaseQuotedIdentifiers());

    Reference< XResultSet > xRes = xMtd->getColumns( Any(), 
                                                       ::rtl::OUString(), 
                                                       m_Name, 
                                                       ::rtl::OUString::createFromAscii("%")); 
    Reference<XRow> xRow(xRes,UNO_QUERY);

	// clear the whole vector stuff
	if(!m_aColumns.isValid())
		m_aColumns = new OSQLColumns();
	else
		m_aColumns->clear();

	m_aTypes.clear();
	m_aPrecisions.clear();
	m_aScales.clear();
	// reserve some space to speed up this think
	m_aColumns->reserve(m_nNR_OF_FIELDS);
	m_aTypes.reserve(m_nNR_OF_FIELDS);
	m_aPrecisions.reserve(m_nNR_OF_FIELDS);
	m_aScales.reserve(m_nNR_OF_FIELDS);

    for (sal_Int32 i = 1; i <= m_nNR_OF_FIELDS; i++)
    {
        ::rtl::OUString aColumnName;
        sal_Int32 eType         = DataType::OTHER;
        sal_Bool bCurrency      = sal_False;
        sal_Int32 nPrecision    = 0;   //! ...
        sal_Int32 nDecimals     = 0;    //! ...
        sal_Int32 nNullable     = ColumnValue::NULLABLE;

        if(xRes.is() && xRes->next())
        {
            aColumnName = xRow->getString(4);
            eType       = xRow->getShort(5);
            aTypeName   = xRow->getString(6);
            nPrecision  = xRow->getInt(7);
            nDecimals   = xRow->getInt(9);
            nNullable   = xRow->getInt(11);
        }
        else
        {
            OSL_TRACE(0,"OMozabTable::fillColumns: getColumns doesn't return a resultset!");
        }
        //  getColumnInfo( i, aColumnName, eType );

        OSL_TRACE( "inserting string %s\n", OUtoCStr( aColumnName ) );
        m_aAttributeStrings.push_back( aColumnName );

        // check if the column name already exists
        ::rtl::OUString aAlias = aColumnName;
        OSQLColumns::const_iterator aFind = connectivity::find(m_aColumns->begin(),m_aColumns->end(),aAlias,aCase);
        sal_Int32 nExprCnt = 0;
        while(aFind != m_aColumns->end())
        {
            (aAlias = aColumnName) += ::rtl::OUString::valueOf((sal_Int32)++nExprCnt);
            aFind = connectivity::find(m_aColumns->begin(),m_aColumns->end(),aAlias,aCase);
        }

        sdbcx::OColumn* pColumn = new sdbcx::OColumn( aAlias, aTypeName, ::rtl::OUString(),
                                                nNullable, nPrecision, nDecimals,
                                                eType, sal_False, sal_False, bCurrency,
                                                aCase.isCaseSensitive() );
        Reference< XPropertySet> xCol = pColumn;
        m_aColumns->push_back(xCol);
        m_aTypes.push_back(eType);
        m_aPrecisions.push_back(nPrecision);
        m_aScales.push_back(nDecimals);
    }


    OSL_TRACE( "\tOUT OMozabTable::fillColumns()\n" );

}

// -------------------------------------------------------------------------
#if defined DEBUG || defined DBG_UTIL
extern void printParseTree( const OSQLParseNode*  parseTree, OString tab );
#endif
// -------------------------------------------------------------------------
void OMozabTable::parseParameter( const OSQLParseNode* pNode, rtl::OUString& rMatchString )
{
    OSL_ENSURE(pNode->count() > 0,"Error parsing parameter in Parse Tree");
    OSQLParseNode *pMark = pNode->getChild(0);

    // Initialize to empty string
    rMatchString = ::rtl::OUString::createFromAscii("");

    OUString aParameterName;
    if (SQL_ISPUNCTUATION(pMark,"?")) {
        aParameterName = ::rtl::OUString::createFromAscii("?");
    }
    else if (SQL_ISPUNCTUATION(pMark,":")) {
        aParameterName = pNode->getChild(1)->getTokenValue();
    }
    // XXX - Now we know name, what's value????
    sParamIndex ++;
    OSL_TRACE("Parameter name [%d]: %s\n", sParamIndex, 
              OUtoCStr(aParameterName) );

    if ( m_aParameterRow.isValid() ) {
        OSL_ENSURE( sParamIndex < m_aParameterRow->size() + 1, "More parameters than values found" );
        rMatchString = (*m_aParameterRow)[(UINT16)sParamIndex];
        OSL_TRACE("Prop Value       : %s\n", OUtoCStr( rMatchString ) );
    }
    else {
        OSL_TRACE("Prop Value       : Invalid ParameterRow!\n" );
    }
}

void OMozabTable::analyseWhereClause( const OSQLParseNode*    parseTree, 
                ::std::vector< ::rtl::OUString >       &matchItems,
                ::std::vector< OMozabQuery::eSqlOppr > &matchOper,
                ::std::vector< ::rtl::OUString >       &matchValues,
                connectivity::OSQLParseTreeIterator& aSQLIterator)
{
    ::rtl::OUString         columnName;
    OMozabQuery::eSqlOppr   op;
    ::rtl::OUString         matchString;

    if ( parseTree == NULL )
        return;

    if ( aSQLIterator.getParseTree() != NULL ) {
        OSL_TRACE("FULL QUERY IS : \n" );
#if defined DEBUG || defined DBG_UTIL
        printParseTree( aSQLIterator.getParseTree(), "XX " );
#endif
        OSL_TRACE("FULL QUERY IS : \n" );

        ::vos::ORef<OSQLColumns> xColumns = aSQLIterator.getParameters();
        if(xColumns.isValid())
        {
            ::rtl::OUString aTabName,aColName,aParameterName,aParameterValue;
            OSQLColumns::iterator aIter = xColumns->begin();
            sal_Int32 i = 1;
            for(;aIter != xColumns->end();++aIter)
            {
                (*aIter)->getPropertyValue(OMetaConnection::getPropMap().getNameByIndex(PROPERTY_ID_NAME)) >>= aColName;
                OSL_TRACE("Prop Column Name : %s\n", OUtoCStr( aColName ) );
                if ( m_aParameterRow.isValid() ) {
                    aParameterValue = (*m_aParameterRow)[(UINT16)i];
                    OSL_TRACE("Prop Value       : %s\n", OUtoCStr( aParameterValue ) );
                }
                else {
                    OSL_TRACE("Prop Value       : Invalid ParameterRow!\n" );
                }
                i++;
            }
        }

    }
#if defined DEBUG || defined DBG_UTIL
    printParseTree( parseTree, "XX " );
#endif

    if ( SQL_ISRULE(parseTree,where_clause) )
    {
        OSL_TRACE("analyseSQL : Got WHERE clause\n");
        // Reset Parameter Counter
        resetParameters();
        analyseWhereClause( parseTree->getChild( 1 ), matchItems, matchOper, matchValues, aSQLIterator);
    }
    else if ( SQL_ISRULE(parseTree,where_clause) )
    {
        OSL_TRACE("analyseSQL : Got WHERE clause\n");
        analyseWhereClause( parseTree->getChild( 1 ), matchItems, matchOper, matchValues, aSQLIterator);
    }
    else if ( parseTree->count() == 3 &&                         // Handle ()'s 
        SQL_ISPUNCTUATION(parseTree->getChild(0),"(") &&
        SQL_ISPUNCTUATION(parseTree->getChild(2),")")) 
    {

        OSL_TRACE("analyseSQL : Got Punctuation ()\n");
        analyseWhereClause( parseTree->getChild( 1 ), matchItems, matchOper, matchValues,aSQLIterator );
    }
    else if ((SQL_ISRULE(parseTree,search_condition) || (SQL_ISRULE(parseTree,boolean_term)))
             && parseTree->count() == 3)                   // Handle AND/OR
    {

        OSL_TRACE("analyseSQL : Got AND/OR clause\n");

        // TODO - Need to take care or AND, for now match is always OR
        analyseWhereClause( parseTree->getChild( 0 ), matchItems, matchOper, matchValues, aSQLIterator );
        analyseWhereClause( parseTree->getChild( 2 ), matchItems, matchOper, matchValues, aSQLIterator );
    }
    else if (SQL_ISRULE(parseTree,comparison_predicate))
    {
        DBG_ASSERT(parseTree->count() == 3, "Error parsing COMPARE predicate");
        if (!(SQL_ISRULE(parseTree->getChild(0),column_ref) ||
          parseTree->getChild(2)->getNodeType() == SQL_NODE_STRING ||
          parseTree->getChild(2)->getNodeType() == SQL_NODE_INTNUM ||
          parseTree->getChild(2)->getNodeType() == SQL_NODE_APPROXNUM ||
          SQL_ISTOKEN(parseTree->getChild(2),TRUE) ||
          SQL_ISTOKEN(parseTree->getChild(2),FALSE) ||
          SQL_ISRULE(parseTree->getChild(2),parameter) ||
          // odbc date
          (SQL_ISRULE(parseTree->getChild(2),set_fct_spec) && SQL_ISPUNCTUATION(parseTree->getChild(2)->getChild(0),"{"))))
        {
            ::dbtools::throwGenericSQLException(
                        ::rtl::OUString::createFromAscii("Statement too complex"),NULL);
        }

        OSQLParseNode *pPrec = parseTree->getChild(1);
        if (pPrec->getNodeType() == SQL_NODE_EQUAL)
            op = OMozabQuery::matchIs;
        else if (pPrec->getNodeType() == SQL_NODE_NOTEQUAL)
            op = OMozabQuery::matchIsNot;

        ::rtl::OUString sTableRange;
        if(SQL_ISRULE(parseTree->getChild(0),column_ref))
            aSQLIterator.getColumnRange(parseTree->getChild(0),columnName,sTableRange);
        else if(parseTree->getChild(0)->isToken())
            columnName = parseTree->getChild(0)->getTokenValue();
        
        if ( SQL_ISRULE(parseTree->getChild(2),parameter) ) {
            parseParameter( parseTree->getChild(2), matchString );
        }
        else {
            matchString = parseTree->getChild(2)->getTokenValue();
        }

        matchItems.push_back( columnName );
        matchOper.push_back( op );
        matchValues.push_back( matchString );
    }
    else if (SQL_ISRULE(parseTree,like_predicate))
    {
        DBG_ASSERT(parseTree->count() >= 4, "Error parsing LIKE predicate");

        OSL_TRACE("analyseSQL : Got LIKE rule\n");

        if ( !(SQL_ISRULE(parseTree->getChild(0), column_ref)) )
        {
            ::dbtools::throwGenericSQLException(
                    ::rtl::OUString::createFromAscii("Invalid Statement - Not a Column"),NULL);
        }


        OSQLParseNode *pColumn;
        OSQLParseNode *pAtom;
        OSQLParseNode *pOptEscape;
        pColumn     = parseTree->getChild(0);                        // Match Item
        pAtom       = parseTree->getChild(parseTree->count()-2);     // Match String
        pOptEscape  = parseTree->getChild(parseTree->count()-1);     // Opt Escape Rule

        if (!(pAtom->getNodeType() == SQL_NODE_STRING ||
              pAtom->getNodeType() == SQL_NODE_NAME ||
              SQL_ISRULE(pAtom,parameter) ||
              ( pAtom->getChild(0) && pAtom->getChild(0)->getNodeType() == SQL_NODE_NAME ) ||
              ( pAtom->getChild(0) && pAtom->getChild(0)->getNodeType() == SQL_NODE_STRING )
              ) )
        {
#if defined DEBUG || defined DBG_UTIL
            printParseTree( pAtom, "AnalyseSQL " );
#endif
            OSL_TRACE("analyseSQL : pAtom->count() = %d\n", pAtom->count() );
#ifdef DBG_UTIL
                for ( sal_uInt32 i = 0; i < pAtom->count(); ++i )
                    OSL_TRACE("analyseSQL : pAtom (%d) : %d, %d  = %s\n", i, 
                            (sal_Int32)pAtom->getRuleID(),
                            pAtom->getChild(i)->getNodeType(),
                            OUtoCStr(pAtom->getChild(i)->getTokenValue()));
#endif


            ::dbtools::throwGenericSQLException(
                    ::rtl::OUString::createFromAscii("Invalid Statement - Not a String"),NULL);
        }

        ::rtl::OUString sTableRange;
        if(SQL_ISRULE(pColumn,column_ref))
            aSQLIterator.getColumnRange(pColumn,columnName,sTableRange);
        
        OSL_TRACE("ColumnName = %s\n", OUtoCStr( columnName ) );

        if ( SQL_ISRULE(pAtom,parameter) ) {
            parseParameter( pAtom, matchString );
        }
        else
        {
            matchString = pAtom->getTokenValue();
        }

        // Determine where '%' character is...
        const sal_Unicode WILDCARD = '%';
        const sal_Unicode MATCHCHAR = '_';
        
        if ( matchString.indexOf ( WILDCARD ) == -1 &&
             matchString.indexOf ( MATCHCHAR ) == -1 )
        {
            // Simple string , eg. "to match"
            if ( parseTree->count() == 5 )
                op = OMozabQuery::matchDoesNotContain;
            else
                op = OMozabQuery::matchContains;
        }
        else if (  matchString.indexOf ( WILDCARD ) == 0 &&
                   matchString.lastIndexOf ( WILDCARD ) == matchString.getLength() -1 &&
                   matchString.indexOf ( WILDCARD, 1 ) == matchString.lastIndexOf ( WILDCARD )
                   && matchString.indexOf( MATCHCHAR ) == -1 
                 )
        {
            // Relatively simple "%string%" - ie, contains...
            // Cut '%'  from front and rear
            matchString = matchString.replaceAt( 0, 1, rtl::OUString() ); 
            matchString = matchString.replaceAt( matchString.getLength() -1 , 1, rtl::OUString() );

            if ( parseTree->count() == 5 )
                op = OMozabQuery::matchDoesNotContain;
            else
                op = OMozabQuery::matchContains;
        }
        else if ( parseTree->count() == 5 )
        {
            // We currently can't handle a 'NOT LIKE' when there are '%' or '_'
            // dispersed throughout
            ::dbtools::throwGenericSQLException(
                        ::rtl::OUString::createFromAscii("Statement too complex"),NULL);
        }
        else
        {
            if ( (matchString.indexOf ( WILDCARD ) == matchString.lastIndexOf ( WILDCARD ))
                  && matchString.indexOf( MATCHCHAR ) == -1 
                )
            {
                // One occurance of '%' - no '_' matches...
                if ( matchString.indexOf ( WILDCARD ) == 0 ) 
                {
                    op = OMozabQuery::matchEndsWith;
                    matchString = matchString.replaceAt( 0, 1, rtl::OUString() );
                }
                else if ( matchString.indexOf ( WILDCARD ) == matchString.getLength() -1 ) 
                {
                    op = OMozabQuery::matchBeginsWith;
                    matchString = matchString.replaceAt( matchString.getLength() -1 , 1, rtl::OUString() );
                } 
                else 
                {
                    sal_Int32 pos = matchString.indexOf ( WILDCARD );
                    matchString = matchString.replaceAt( pos, 1,::rtl::OUString::createFromAscii(".*") );
                    op = OMozabQuery::matchRegExp;
                }

            }
            else
            {
                // Most Complex, need to use an RE
                sal_Int32 pos = matchString.indexOf ( WILDCARD );
                while ( (pos = matchString.indexOf ( WILDCARD )) != -1 )
                {
                    matchString = matchString.replaceAt( pos, 1, ::rtl::OUString::createFromAscii(".*") );
                }

                pos = matchString.indexOf ( MATCHCHAR );
                while ( (pos = matchString.indexOf( MATCHCHAR )) != -1 ) 
                {
                    matchString = matchString.replaceAt( pos, 1, ::rtl::OUString::createFromAscii(".") );
                }

                op = OMozabQuery::matchRegExp;
            }
        }

        matchItems.push_back( columnName );
        matchOper.push_back( op );
        matchValues.push_back( matchString );
    }
    else if (SQL_ISRULE(parseTree,test_for_null))
    {
        DBG_ASSERT(parseTree->count() >= 3,"Error in ParseTree");
        DBG_ASSERT(SQL_ISTOKEN(parseTree->getChild(1),IS),"Error in ParseTree");

        if (!SQL_ISRULE(parseTree->getChild(0),column_ref))
        {
            ::dbtools::throwGenericSQLException(::rtl::OUString::createFromAscii("Invalid Statement - Not a Column"),NULL);
        }

        if (SQL_ISTOKEN(parseTree->getChild(2),NOT))
        {
            ::dbtools::throwGenericSQLException(
                        ::rtl::OUString::createFromAscii("Statement too complex"),NULL);
        }
        else
                op = OMozabQuery::matchExists;

        ::rtl::OUString sTableRange;
        aSQLIterator.getColumnRange(parseTree->getChild(0),columnName,sTableRange);

        matchItems.push_back( columnName );
        matchOper.push_back( op );
        matchValues.push_back( rtl::OUString() );
    }
    else
    {
        OSL_TRACE( "Unexpected statement!!!" );

        ::dbtools::throwGenericSQLException(::rtl::OUString::createFromAscii("Invalid Statement - Unexpected"),NULL);
    }
}

// -------------------------------------------------------------------------

void 
OMozabTable::fillRowData( connectivity::OSQLParseTreeIterator& aSQLIterator )
{
    OSL_TRACE( "IN OMozabTable::fillRowData()\n" );

    
    ::std::vector< ::rtl::OUString >        matchItems;
    ::std::vector< OMozabQuery::eSqlOppr >  matchOper;
    ::std::vector< ::rtl::OUString >        matchValues;

    // Generate Match Conditions for Query
    const OSQLParseNode*  pParseTree = aSQLIterator.getWhereTree();

    // const OSQLParseNode*  pParseTree = NULL;
    if ( pParseTree != NULL ) 
    {
        // Extract required info

        OSL_TRACE("\tHave a Where Clause\n");

        analyseWhereClause( pParseTree, matchItems, matchOper, matchValues ,aSQLIterator);
    }
    else
    {
        OSL_TRACE("\tDon't have a Where Clause\n");

        // LDAP does not allow a query without restriction, so we add a dummy for FirstName
        // For other types we stick to the old behaviour of using card:nsIAbCard.
        if (static_cast<OMozabConnection*>(getConnection())->isLDAP())
            matchItems.push_back( ::rtl::OUString::createFromAscii("FirstName") );
        else
            matchItems.push_back( ::rtl::OUString::createFromAscii("card:nsIAbCard") );

        matchOper.push_back( OMozabQuery::matchExists );
        matchValues.push_back( ::rtl::OUString()  );

//      matchItems.push_back( ::rtl::OUString::createFromAscii("DisplayName") );
//      matchOper.push_back( OMozabQuery::matchBeginsWith );
//      matchValues.push_back( ::rtl::OUString::createFromAscii("Darren")  );
//      matchItems.push_back( ::rtl::OUString::createFromAscii("PrimaryEmail") );
//      matchOper.push_back( OMozabQuery::matchBeginsWith );
//      matchValues.push_back( ::rtl::OUString::createFromAscii("Darren")  );
    }

    m_xQuery->setMatchItems( matchItems );
    m_xQuery->setSqlOppr( matchOper );
    m_xQuery->setMatchValues( matchValues );

    // We need a unique id for caching mechanism so should fetch card:URI
    m_xQuery->setAttributes( m_aAttributeStrings );

    rtl::OUString aStr(getName());
    m_xQuery->setAddressbook( aStr );

    sal_Int32 rv = m_xQuery->executeQuery(static_cast<OMozabConnection*>(m_pConnection)->isOutlookExpress());

    OSL_TRACE( "executeQuery returned %d\n", rv );

    OSL_TRACE( "\tOUT OMozabTable::fillRowData()\n" );
}


// -------------------------------------------------------------------------

OMozabTable::OMozabTable(const OMozabTable* _pTable)
        :OMozabTable_BASE(  _pTable->m_pTables,_pTable->getConnection(),
                            _pTable->m_Name,
                            _pTable->m_Type,
                            _pTable->m_Description,
                            _pTable->m_SchemaName,
                            _pTable->m_CatalogName),
         m_aColumnAlias(_pTable->getColumnAlias())
{
    OSL_TRACE( "IN/OUT OMozabTable::OMozabTable()\n" );

    m_xQuery = new OMozabQuery(m_aColumnAlias.getAliasMap());
    m_xQuery->setMaxNrOfReturns(static_cast<OMozabConnection*>(_pTable->getConnection())->getMaxResultRecords());

    fillColumns();

}
// -------------------------------------------------------------------------
OMozabTable::OMozabTable(sdbcx::OCollection* _pTables,OMozabConnection* _pConnection,
                    const ::rtl::OUString& _Name,
                    const ::rtl::OUString& _Type,
                    const ::rtl::OUString& _Description ,
                    const ::rtl::OUString& _SchemaName,
                    const ::rtl::OUString& _CatalogName
                ) : OMozabTable_BASE(_pTables,_pConnection,_Name,
                                  _Type,
                                  _Description,
                                  _SchemaName,
                                  _CatalogName),
                    m_aColumnAlias(_pConnection->getColumnAlias())
{
    OSL_TRACE( "IN OMozabTable::OMozabTable()\n" );

    m_xQuery = new OMozabQuery(m_aColumnAlias.getAliasMap());
    m_xQuery->setMaxNrOfReturns(_pConnection->getMaxResultRecords());

    fillColumns();
    OSL_TRACE( "\tOUT OMozabTable::OMozabTable()\n" );
}

// -----------------------------------------------------------------------------
OMozabTable::OMozabTable(sdbcx::OCollection* _pTables,OMozabConnection* _pConnection)
        :OMozabTable_BASE(_pTables,_pConnection), m_aColumnAlias(_pConnection->getColumnAlias())
{
    OSL_TRACE( "IN/OUT OMozabTable::OMozabTable()\n" );

    m_xQuery = new OMozabQuery(m_aColumnAlias.getAliasMap());
    m_xQuery->setMaxNrOfReturns(_pConnection->getMaxResultRecords());
}

// -------------------------------------------------------------------------
OMozabTable::~OMozabTable( )
{
    // Clean up
    //
    delete m_xQuery;
}

// -------------------------------------------------------------------------
void OMozabTable::refreshColumns()
{

    OSL_TRACE( "IN OMozabTable::refreshColumns()\n" );

    ::osl::MutexGuard aGuard( m_aMutex );

    ::std::vector< ::rtl::OUString> aVector;
	aVector.reserve(m_aColumns->size());

    for(OSQLColumns::const_iterator aIter = m_aColumns->begin();aIter != m_aColumns->end();++aIter)
        aVector.push_back(Reference< XNamed>(*aIter,UNO_QUERY)->getName());

    if(m_pColumns)
        m_pColumns->reFill(aVector);
    else
        m_pColumns  = new OMozabColumns(this,m_aMutex,aVector);

    OSL_TRACE( "\tOUT OMozabTable::refreshColumns()\n" );

}
// -------------------------------------------------------------------------
void OMozabTable::refreshIndexes()
{

    OSL_TRACE( "IN/OUT OMozabTable::refreshIndexes()\n" );

    //  Calc table has no index
}

// -------------------------------------------------------------------------
void SAL_CALL OMozabTable::disposing(void)
{

    OSL_TRACE( "IN OMozabTable::disposing()\n" );

    OFileTable::disposing();
    ::osl::MutexGuard aGuard(m_aMutex);
    
    m_aColumns = NULL;


    OSL_TRACE( "\tOUT OMozabTable::disposing()\n" );

}
// -------------------------------------------------------------------------
Sequence< Type > SAL_CALL OMozabTable::getTypes(  ) throw(RuntimeException)
{

    OSL_TRACE( "IN OMozabTable::getTypes()\n" );

    Sequence< Type > aTypes = OTable_TYPEDEF::getTypes();
    ::std::vector<Type> aOwnTypes;
	aOwnTypes.reserve(aTypes.getLength());	
    const Type* pBegin = aTypes.getConstArray();
    const Type* pEnd = pBegin + aTypes.getLength();
    for(;pBegin != pEnd;++pBegin)
    {
        if(!(*pBegin == ::getCppuType((const Reference<XKeysSupplier>*)0) ||
            *pBegin == ::getCppuType((const Reference<XIndexesSupplier>*)0) ||
            *pBegin == ::getCppuType((const Reference<XRename>*)0) ||
            *pBegin == ::getCppuType((const Reference<XAlterTable>*)0) ||
            *pBegin == ::getCppuType((const Reference<XDataDescriptorFactory>*)0)))
        {
            aOwnTypes.push_back(*pBegin);
        }
    }
    aOwnTypes.push_back(::getCppuType( (const Reference< ::com::sun::star::lang::XUnoTunnel > *)0 ));

	return Sequence< Type >(aOwnTypes.begin(),aOwnTypes.size());
}

// -------------------------------------------------------------------------
Any SAL_CALL OMozabTable::queryInterface( const Type & rType ) throw(RuntimeException)
{

    OSL_TRACE( "IN OMozabTable::queryInterface()\n" );

    if( rType == ::getCppuType((const Reference<XKeysSupplier>*)0) ||
        rType == ::getCppuType((const Reference<XIndexesSupplier>*)0) ||
        rType == ::getCppuType((const Reference<XRename>*)0) ||
        rType == ::getCppuType((const Reference<XAlterTable>*)0) ||
        rType == ::getCppuType((const Reference<XDataDescriptorFactory>*)0))
        return Any();

    Any aRet = ::cppu::queryInterface(rType,static_cast< ::com::sun::star::lang::XUnoTunnel*> (this));
    return aRet.hasValue() ? aRet : OTable_TYPEDEF::queryInterface(rType);
}

//--------------------------------------------------------------------------
Sequence< sal_Int8 > OMozabTable::getUnoTunnelImplementationId()
{

    OSL_TRACE( "IN OMozabTable::getUnoTunnelImplementation()\n" );

    static ::cppu::OImplementationId * pId = 0;
    if (! pId)
    {
        ::osl::MutexGuard aGuard( ::osl::Mutex::getGlobalMutex() );
        if (! pId)
        {
            static ::cppu::OImplementationId aId;
            pId = &aId;
        }
    }

    OSL_TRACE( "\tOUT OMozabTable::getUnoTunnelImplementation()\n" );

    return pId->getImplementationId();
}

// com::sun::star::lang::XUnoTunnel
//------------------------------------------------------------------
sal_Int64 OMozabTable::getSomething( const Sequence< sal_Int8 > & rId ) throw (RuntimeException)
{
	return (rId.getLength() == 16 && 0 == rtl_compareMemory(getUnoTunnelImplementationId().getConstArray(),  rId.getConstArray(), 16 ) ) 
				?
			(sal_Int64)this
				: 
			OMozabTable_BASE::getSomething(rId);
}
//------------------------------------------------------------------
sal_Int32 OMozabTable::getCurrentLastPos() const
{

    OSL_TRACE( "IN/OUT OMozabTable::getCurrentLastPos()\n" );

    return (m_xQuery)?(m_xQuery->getRowCount()):(-1);
}
//------------------------------------------------------------------
sal_Bool OMozabTable::seekRow(IResultSetHelper::Movement eCursorPosition, sal_Int32 nOffset, sal_Int32& nCurPos)
{

    OSL_TRACE( "IN OMozabTable::seekRow()\n" );

    // ----------------------------------------------------------
    // Positionierung vorbereiten:

    sal_uInt32 nNumberOfRecords = m_xQuery->getRealRowCount();
    sal_uInt32 nTempPos = m_nFilePos;
    m_nFilePos = nCurPos;

    switch(eCursorPosition)
    {
        case IResultSetHelper::NEXT:

            OSL_TRACE("\tIResultSetHelper::NEXT\n");

            m_nFilePos++;
            break;
        case IResultSetHelper::PRIOR:

            OSL_TRACE("\tIResultSetHelper::PRIOR\n");

            if (m_nFilePos > 0)
                m_nFilePos--;
            break;
        case IResultSetHelper::FIRST:

            OSL_TRACE("\tIResultSetHelper::FIRST\n");

            m_nFilePos = 1;
            break;
        case IResultSetHelper::LAST:

            OSL_TRACE("\tIResultSetHelper::LAST\n");

            m_nFilePos = nNumberOfRecords;
            break;
        case IResultSetHelper::RELATIVE:

            OSL_TRACE("\tIResultSetHelper::RELATIVE (offset %d)\n", nOffset);

            m_nFilePos = (((sal_Int32)m_nFilePos) + nOffset < 0) ? 0L
                            : (sal_uInt32)(((sal_Int32)m_nFilePos) + nOffset);
            break;
        case IResultSetHelper::ABSOLUTE:
        case IResultSetHelper::BOOKMARK:

            OSL_TRACE("\tIResultSetHelper::ABSOLUTE or BOOKMARK (offset %d)\n", nOffset);

            m_nFilePos = (sal_uInt32)nOffset;
            break;
    }

    if (m_nFilePos > (sal_Int32)nNumberOfRecords)
        m_nFilePos = (sal_Int32)nNumberOfRecords + 1;

    while ( !m_xQuery->queryComplete() && m_nFilePos >= (sal_Int32)nNumberOfRecords + 1) 
    {
        m_xQuery->checkRowAvailable( m_nFilePos );
        nNumberOfRecords = m_xQuery->getRealRowCount();
    }

    if (m_nFilePos == 0 || m_nFilePos == (sal_Int32)nNumberOfRecords + 1)
        goto Error;
    else
    {
        //! read buffer / setup row object etc?
    }
    goto End;

Error:
    switch(eCursorPosition)
    {
        case IResultSetHelper::PRIOR:
        case IResultSetHelper::FIRST:
            m_nFilePos = 0;
            break;
        case IResultSetHelper::LAST:
        case IResultSetHelper::NEXT:
        case IResultSetHelper::ABSOLUTE:
        case IResultSetHelper::RELATIVE:
            if (nOffset > 0)
                m_nFilePos = nNumberOfRecords + 1;
            else if (nOffset < 0)
                m_nFilePos = 0;
            break;
        case IResultSetHelper::BOOKMARK:
            m_nFilePos = nTempPos;   // vorherige Position
    }
    //  aStatus.Set(SDB_STAT_NO_DATA_FOUND);

    OSL_TRACE( "\tOUT OMozabTable::seekRow() --> Error:\n" );

    return sal_False;

End:

    OSL_TRACE( "\tOUT OMozabTable::seekRow() --> End:\n" );

    nCurPos = m_nFilePos;
    return sal_True;
}
//------------------------------------------------------------------
sal_Bool OMozabTable::fetchRow( OValueRow _rRow, const OSQLColumns & _rCols,
                                sal_Bool _bUseTableDefs, sal_Bool bRetrieveData )
{

    OSL_TRACE( "IN OMozabTable::fetchRow()\n" );

    // read the bookmark

//    BOOL bIsCurRecordDeleted = sal_False;
//    _rRow->setDeleted(bIsCurRecordDeleted);
    (*_rRow)[0] = m_nFilePos;

    if (!bRetrieveData) {

        OSL_TRACE( "\tOUT OMozabTable::fetchRow() --> TRUE\n" );

        return TRUE;
    }

    // fields
    OSQLColumns::const_iterator aIter = _rCols.begin();
	const ::rtl::OUString sProprtyName = OMetaConnection::getPropMap().getNameByIndex(PROPERTY_ID_NAME);
	::rtl::OUString sName;
    for (sal_Int32 i = 1; aIter != _rCols.end();++aIter, i++)
    {
		if ((*_rRow)[i].isBound())
		{
			sal_Int32 nType;
			if(_bUseTableDefs)
				nType = m_aTypes[i-1];
			else
				(*aIter)->getPropertyValue(OMetaConnection::getPropMap().getNameByIndex(PROPERTY_ID_TYPE)) >>= nType;

			(*aIter)->getPropertyValue(sProprtyName) >>= sName;
			m_xQuery->getRowValue( (*_rRow)[i], m_nFilePos, sName, nType );
		}
    }

    OSL_TRACE( "\tOUT OMozabTable::fetchRow() --> sal_True\n" );

    return sal_True;
}
// -------------------------------------------------------------------------
void OMozabTable::FileClose()
{

    OSL_TRACE( "IN OMozabTable::FileClose()\n" );

    ::osl::MutexGuard aGuard(m_aMutex);

    OMozabTable_BASE::FileClose();

    OSL_TRACE( "\tOUT OMozabTable::FileClose()\n" );

}
// -------------------------------------------------------------------------
BOOL OMozabTable::CreateImpl()
{

    OSL_TRACE( "IN/OUT OMozabTable::CreateImpl()\n" );

    return sal_False;       // read-only for now
}

//------------------------------------------------------------------
BOOL OMozabTable::DropImpl()
{

    OSL_TRACE( "IN/OUT OMozabTable::DropImpl()\n" );

    return sal_False;       // read-only for now
}
//------------------------------------------------------------------
BOOL OMozabTable::InsertRow(OValueVector& rRow, BOOL bFlush,const Reference<XIndexAccess>& _xCols)
{

    OSL_TRACE( "IN/OUT OMozabTable::InsertRow()\n" );

    return sal_False;       // read-only for now
}

//------------------------------------------------------------------
BOOL OMozabTable::UpdateRow(OValueVector& rRow, OValueRow pOrgRow,const Reference<XIndexAccess>& _xCols)
{

    OSL_TRACE( "IN/OUT OMozabTable::UpdateRow()\n" );

    return sal_False;       // read-only for now
}

//------------------------------------------------------------------
BOOL OMozabTable::DeleteRow(const OSQLColumns& _rCols)
{

    OSL_TRACE( "IN/OUT OMozabTable::DeleteRow()\n" );

    return sal_False;       // read-only for now
}

// -------------------------------------------------------------------------
Reference<XPropertySet> OMozabTable::isUniqueByColumnName(const ::rtl::OUString& _rColName)
{

    OSL_TRACE( "IN/OUT OMozabTable::isUniqueByColumnName()\n" );

    return Reference<XPropertySet>();
}
//------------------------------------------------------------------
BOOL OMozabTable::UpdateBuffer(OValueVector& rRow, OValueRow pOrgRow,const Reference<XIndexAccess>& _xCols)
{

    OSL_TRACE( "IN/OUT OMozabTable::UpdateBuffer()\n" );

    return sal_False;       // read-only for now
}
//------------------------------------------------------------------
BOOL OMozabTable::WriteBuffer()
{

    OSL_TRACE( "IN/OUT OMozabTable::WriteBuffer()\n" );

    return sal_False;       // read-only for now
}
// -----------------------------------------------------------------------------
OMozabTable* OMozabTable::clone() const
{
    return new OMozabTable(this);
}
// -----------------------------------------------------------------------------
