/*************************************************************************
 *
 *  $RCSfile: MABQueryHelper.cxx,v $
 *
 *  $Revision: 1.20 $
 *
 *  last change: $Author: mmaher $ $Date: 2001/10/04 13:39:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): Darren Kenny, Willem van Dorp
 *
 *
 ************************************************************************/

#ifndef _CONNECTIVITY_MAB_QUERYHELPER_HXX_
#include <mozaddressbook/MABQueryHelper.hxx>
#endif
#include "mozaddressbook/MABTypeConverter.hxx"
#include "../MABDebug.hxx"

using namespace connectivity::mozaddressbook;

NS_IMPL_THREADSAFE_ISUPPORTS1(connectivity::mozaddressbook::OMozabQueryHelper,nsIAbDirectoryQueryResultListener)

//
// class OMozabQueryHelperResultEntry 
//


OMozabQueryHelperResultEntry::OMozabQueryHelperResultEntry()
{
}

OMozabQueryHelperResultEntry::~OMozabQueryHelperResultEntry()
{
}

void
OMozabQueryHelperResultEntry::insert( rtl::OUString &key, rtl::OUString &value )
{
    m_Fields.insert( fieldMap::value_type( key, value ) );
}

rtl::OUString 
OMozabQueryHelperResultEntry::getValue( const rtl::OUString &key ) const
{
    fieldMap::const_iterator  iter;

    iter = m_Fields.find( key );

    if ( iter == m_Fields.end() ) {
        return rtl::OUString();
    } else {
        return (*iter).second;
    }
}

//
// class OMozabQueryHelper 
//
// MIME-types.
static char PreferMailFormatTypes[2][11] = {"text/plain",
					    "text/html"};
// This is what mozilla returns.
static char mozPreferMailFormatTypes[3][11] = {"unknown",
                                               "plaintext",
                                               "html"};


OMozabQueryHelper::OMozabQueryHelper() :    m_nIndex( 0 ), 
                                            m_bHasMore( sal_True ), 
                                            m_bQueryComplete( sal_False ), 
                                            m_bAtEnd( sal_False )
{
    m_aResults.clear();
}

OMozabQueryHelper::~OMozabQueryHelper()
{
    clear_results();
}

void
OMozabQueryHelper::append(OMozabQueryHelperResultEntry* resEnt )
{
    if ( resEnt != NULL ) {
        m_aResults.push_back( resEnt );
        m_bAtEnd   = sal_False;
    }
}

void
OMozabQueryHelper::clear_results()
{
    resultsArray::iterator iter = m_aResults.begin();
    while ( iter != m_aResults.end() ) {
        delete (*iter);
        ++iter;
    }
    m_aResults.clear();
}

void
OMozabQueryHelper::rewind()
{
    m_nIndex = 0;
}

void
OMozabQueryHelper::reset()
{
    m_nIndex = 0;
    m_bHasMore = sal_True;
    m_bQueryComplete = sal_False;
    m_bAtEnd = sal_False;
    clear_results();
}

void 
OMozabQueryHelper::clearResultOrComplete()
{
    // Don't use a Mutex, it should be called by a method already holding it.
    m_aCondition.reset();
}

void 
OMozabQueryHelper::notifyResultOrComplete()
{
    m_aCondition.set();
}

void
OMozabQueryHelper::waitForResultOrComplete()
{
    // Can't hold mutex or condition would never get set...
    while( m_aCondition.wait() == ::osl::Condition::result_error );
}


OMozabQueryHelperResultEntry*
OMozabQueryHelper::next()
{
    OMozabQueryHelperResultEntry* result;
    sal_Int32                     index;

    m_aMutex.acquire();
    index = m_nIndex;
    m_aMutex.release();

    result = getByIndex( m_nIndex + 1 ) ; // Add 1 as Row is numbered from 1 to N

    if ( result ) {
        m_aMutex.acquire();
        m_nIndex++;
        m_aMutex.release();
    }

    return( result );
}

OMozabQueryHelperResultEntry*
OMozabQueryHelper::getByIndex( sal_Int32 nRow )
{
    // Row numbers are from 1 to N, need to ensure this, and then
    // substract 1
    if ( nRow < 1 ) {
        return( NULL );
    }

    do {
        // Obtain the Mutex - don't use a guard as we want to be able to release
        // and acquire again...
        m_aMutex.acquire();
        if ( nRow > m_aResults.size() ) {
            if ( m_bQueryComplete ) {
                m_bAtEnd = sal_True;
                m_aMutex.release();
                return( NULL );
            } else {
                clearResultOrComplete();
                m_aMutex.release();
                waitForResultOrComplete();
            }
        } else {
            m_aMutex.release();
            return( m_aResults[ nRow -1 ] );
        }
    } while ( sal_True );

    OSL_TRACE("!!!!! Shouldn't have reached this!!!!\n");

    return( NULL );

}

sal_Bool
OMozabQueryHelper::hasMore() const
{
    return m_bHasMore;
}

sal_Bool
OMozabQueryHelper::atEnd() const
{
    return m_bAtEnd;
}

sal_Bool
OMozabQueryHelper::queryComplete() const
{
    return m_bQueryComplete;
}

void
OMozabQueryHelper::waitForRow( sal_Int32 rowNum )
{
    m_aMutex.acquire();
    do
    {
        m_aMutex.release();
        clearResultOrComplete();
        waitForResultOrComplete();
        m_aMutex.acquire();
    }
    while ( !m_bQueryComplete && m_aResults.size() < rowNum );

    m_aMutex.release();
}

// -------------------------------------------------------------------------

sal_Int32
OMozabQueryHelper::getResultCount() const
{
    OSL_TRACE( "IN OMozabQueryHelper::getResultCount()" );
    if ( !m_bQueryComplete ) 
    {
        OSL_TRACE( "\tOUT OMozabQueryHelper::getResultCount() = -1\n");
        return -1;
    }
    else
    {
        OSL_TRACE( "\tOUT OMozabQueryHelper::getResultCount() = %d\n", m_aResults.size() );
        return m_aResults.size();
    }
}

// -------------------------------------------------------------------------

sal_Int32
OMozabQueryHelper::getRealCount() const
{
    OSL_TRACE( "IN/OUT OMozabQueryHelper::getRealCount() = %d\n", m_aResults.size() );
    return m_aResults.size();
}

// -------------------------------------------------------------------------
NS_IMETHODIMP OMozabQueryHelper::OnQueryItem(nsIAbDirectoryQueryResult *result)
{
        OSL_TRACE( "IN OMozabQueryHelper::OnQueryItem()\n" );

	nsresult rv;
	PRInt32 resultType;

    if ( result == NULL ) {
        OSL_TRACE("\tresult ptr is NULL\n");
        return NS_OK;
    }

	// Get return status of executeQuery() call.
	rv = result -> GetType(&resultType);
	NS_ENSURE_SUCCESS(rv, rv); 

	// Check for errors of the executeQuery() call.
    m_bQueryComplete = sal_True;    // Default to True
    switch ( resultType ) {
	case nsIAbDirectoryQueryResult::queryResultError:
        OSL_TRACE("\tresultType == nsIAbDirectoryQueryResult::queryResultError\n");
        notifyResultOrComplete();
        return NS_OK;
        break;
	case nsIAbDirectoryQueryResult::queryResultStopped:
        OSL_TRACE("\tresultType == nsIAbDirectoryQueryResult::queryResultStopped\n");
        notifyResultOrComplete();
        return NS_OK;
        break;
	case nsIAbDirectoryQueryResult::queryResultComplete:
        OSL_TRACE("\tresultType == nsIAbDirectoryQueryResult::queryResultComplete\n");
        notifyResultOrComplete();
        return NS_OK;
        break;
    case nsIAbDirectoryQueryResult::queryResultMatch:
        OSL_TRACE("IN OMozabQueryHelper::OnQueryItem --> queryResultMatch\n");
        // Don't return, continues onto rest of method.
        break;
    default:
        OSL_TRACE("\t******** Unexpected : resultType\n");
        return NS_OK;
        break;
    }

	// Initialise an array that holds the resultset of the query.
    m_bQueryComplete = sal_False;
	nsCOMPtr<nsISupportsArray> properties;
	rv = result -> GetResult(getter_AddRefs (properties));
	NS_ENSURE_SUCCESS(rv, rv); 

	PRUint32 count;
	rv = properties -> Count(&count);
	NS_ENSURE_SUCCESS(rv, rv); 

	// Initialise the resultset (xResultSet).
    OSL_TRACE("\tGot %d properties\n", count );
    if ( count > 0 ) {
        PRUint32 i;

        // Need to determine if it's a MailingList, so first find the
        // nsIAbCard property any check the boolean isMailList
        for ( i = 0; i < count; ++i) {
            nsCOMPtr<nsISupports> item;
            rv = properties -> GetElementAt(i, getter_AddRefs(item));
            NS_ENSURE_SUCCESS(rv, rv); 

            nsCOMPtr<nsIAbDirectoryQueryPropertyValue> property(do_QueryInterface(item,
&rv));

            char *name;
            rv = property -> GetName(&name);
            if ( !strcmp(name,"card:nsIAbCard") ) {
                nsCOMPtr<nsISupports> cardSupports;
                property->GetValueISupports (getter_AddRefs (cardSupports));
                nsCOMPtr<nsIAbCard> card(do_QueryInterface(cardSupports, &rv));

                PRBool bIsMailList = PR_FALSE;
                card->GetIsMailList( &bIsMailList );
                if ( bIsMailList ) {
                    // No just skip, ie. return without inserting.
					nsMemory::Free(name);
                    return(NS_OK);
                }
                else {
                    break;
                }
            }
			nsMemory::Free(name);
        }
        OMozabQueryHelperResultEntry *resEntry = new OMozabQueryHelperResultEntry();
        for (i = 0; i < count; ++i) {
            nsCOMPtr<nsISupports> item;
            rv = properties -> GetElementAt(i, getter_AddRefs(item));
            NS_ENSURE_SUCCESS(rv, rv); 

            nsCOMPtr<nsIAbDirectoryQueryPropertyValue> property(do_QueryInterface(item, &rv));

            // TODO (1line)
            char *name;
            rv = property -> GetName(&name);
            ::rtl::OUString sValue;
            ::rtl::OUString sName = ::rtl::OUString::createFromAscii( name );
            OSL_TRACE("IN OMozabQueryHelper::OnQueryItem --> name = %s\n", name);
            if ( !strcmp(name,"card:nsIAbCard") ) {
                // Do Nothing, property is useless outside here
            }
            else {

            unsigned short *value;
            rv = property -> GetValue(&value);

            // Default value for PerferMailFormat is mime type text/plain.
	    // Mapping for PreferMailFormat values to Mime-types.
            if (strcmp(name, "PreferMailFormat") == 0) {

		nsCAutoString val_c;
		val_c.AssignWithConversion(value);
                if (strcmp((char *) val_c.get(), mozPreferMailFormatTypes[0]) == 0) {
                        // unknown, insert plain/text mime type
                        sValue = ::rtl::OUString::createFromAscii(PreferMailFormatTypes[0]);
                } else if (strcmp((char *) val_c.get(), mozPreferMailFormatTypes[1]) == 0) {
                        // plaintext
                        sValue = ::rtl::OUString::createFromAscii(PreferMailFormatTypes[0]);
                } else if (strcmp((char *) val_c.get(), mozPreferMailFormatTypes[2]) == 0) {
                        // html
                        sValue = ::rtl::OUString::createFromAscii(PreferMailFormatTypes[1]);
                } else {
                        // undefined value passed back from mozilla, insert text/plain
                        sValue = ::rtl::OUString::createFromAscii(PreferMailFormatTypes[0]);
                }
            } else {
		// All other fields but PreferMailFormat.
                nsAutoString v (value);
				OMozabTypeConverter::nsStringToOUString( v, sValue );
            }
			nsMemory::Free(value);
	    }
			nsMemory::Free(name);
            resEntry->insert( sName, sValue );
        }
        append( resEntry );
    }
   
    OSL_TRACE( "\tOUT OMozabQueryHelper::OnQueryItem()\n" );

    notifyResultOrComplete();

	return(NS_OK);
}

void OMozabQueryHelper::notifyQueryError() 
{
	m_bQueryComplete = sal_True ;
	notifyResultOrComplete() ;
}

// -------------------------------------------------------------------------
