/*************************************************************************
 *
 *  $RCSfile: dlgtext.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: oj $ $Date: 2001/01/10 07:11:28 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the License); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an AS IS basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef DBAUI_DLGTEXT_HXX
#include "dlgtext.hxx"
#endif
#ifndef DBAUI_DLGTEXT_HRC
#include "dlgtext.hrc"
#endif
#ifndef _DBU_RESOURCE_HRC_
#include "dbu_resource.hrc"
#endif
#ifndef _DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _DBAUI_MODULE_DBU_HXX_
#include "moduledbu.hxx"
#endif

using namespace dbaui;
DBG_NAME( ODlgText );

//------------------------------------------------------------------------------
ODlgText::ODlgText( Window * pParent )
	: ModalDialog( pParent, ModuleRes(DLG_TEXT) ),
	m_aStrText( this, ResId( STR_TEXT ) ),
	m_aBoxData( this, ResId( BOX_DATA ) ),
	m_aOKButton( this, ResId( BT_OK ) ),
	m_aCancelButton( this, ResId( BT_CANCEL ) )
{
	DBG_CTOR( ODlgText, NULL );

	m_aStrText.SetText( String() );
	m_aStrText.SetReadOnly();
	FreeResource();
}

//------------------------------------------------------------------------------
ODlgText::ODlgText( Window * pParent, const String& rText )
	: ModalDialog( pParent, ModuleRes(DLG_TEXT) ),
	m_aStrText( this, ResId( STR_TEXT ) ),
	m_aBoxData( this, ResId( BOX_DATA ) ),
	m_aOKButton( this, ResId( BT_OK ) ),
	m_aCancelButton( this, ResId( BT_CANCEL ) )
{
	DBG_CTOR( ODlgText, NULL );

	m_aStrText.SetText( rText );
	m_aStrText.SetReadOnly();
	FreeResource();
}

//------------------------------------------------------------------------------
ODlgText::~ODlgText()
{
	DBG_DTOR( ODlgText, NULL );
}


