/*************************************************************************
 *
 *  $RCSfile: missingdocdlg.cxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: fs $ $Date: 2001/04/26 11:41:52 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DBAUI_MISSINGDOCDLG_HXX_
#include "missingdocdlg.hxx"
#endif
#ifndef _DBAUI_MISSINGDOCDLG_HRC_
#include "missingdocdlg.hrc"
#endif
#ifndef _DBU_RESOURCE_HRC_
#include "dbu_resource.hrc"
#endif
#ifndef _DBAUI_MODULE_DBU_HXX_
#include "moduledbu.hxx"
#endif
#ifndef _DBAUI_FILENOTATION_HXX_
#include "filenotation.hxx"
#endif

//......................................................................
namespace dbaui
{
//......................................................................

	//==================================================================
	//= OMissingLinkDialog
	//==================================================================
	//------------------------------------------------------------------
	OMissingLinkDialog::OMissingLinkDialog( Window* _pParent, const String& _rURL )
		:ModalDialog( _pParent, ModuleRes(DLG_DEADDOCUMENTLINK) )
		,m_aURLLabel		(this, ResId(FT_URLLABEL))
		,m_aURL				(this, ResId(FT_URL))
		,m_aQuestion		(this, ResId(FT_QUESTION))
		,m_aEditLink		(this, ResId(RB_EDITLINK))
		,m_aDropLink		(this, ResId(RB_DROPLINK))
		,m_aSeparator		(this, ResId(FL_SEPARATOR))
		,m_aOK				(this, ResId(BTN_OK))
		,m_aCancel			(this, ResId(BTN_CANCEL))
	{
		FreeResource();

		OFileNotation aTransformer(_rURL, OFileNotation::N_URL);
		m_aURL.SetText(aTransformer.get(OFileNotation::N_SYSTEM));

		m_aEditLink.SetStyle( m_aEditLink.GetStyle() | WB_WORDBREAK );
		m_aDropLink.SetStyle( m_aDropLink.GetStyle() | WB_WORDBREAK );

		m_aEditLink.Check();
		m_aDropLink.Check(sal_False);
	}

//......................................................................
}	// namespace dbaui
//......................................................................

/*************************************************************************
 * history:
 *	$Log: missingdocdlg.cxx,v $
 *	Revision 1.1  2001/04/26 11:41:52  fs
 *	initial checkin - dialog invoked when encountering dead datasource document links
 *	
 *
 *	Revision 1.0 25.04.01 08:43:03  fs
 ************************************************************************/

