/*************************************************************************
 *
 *  $RCSfile: ScrollHelper.hxx,v $
 *
 *  $Revision: 1.1.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/05/31 14:43:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the License); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an AS IS basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifndef DBAUI_SCROLLHELPER_HXX
#define DBAUI_SCROLLHELPER_HXX

#ifndef _LINK_HXX 
#include <tools/link.hxx>
#endif
#ifndef _SV_GEN_HXX 
#include <vcl/gen.hxx>
#endif
#ifndef _SV_TIMER_HXX 
#include <vcl/timer.hxx>
#endif

namespace dbaui
{
	class OScrollHelper
	{
		Timer	m_aScrollTimer;
		Link	m_aUpScroll;
		Link	m_aDownScroll;
	public:
		/** default contructor
		*/
		OScrollHelper();

		~OScrollHelper();

		/** set the memthod which should be called when scrolling up
			@param	_rUpScroll
				the method to set
		*/
		inline void setUpScrollMethod( const Link& _rUpScroll )
		{
			m_aUpScroll = _rUpScroll;
		}

		/** set the memthod which should be called when scrolling down
			@param	_rDownScroll
				the method to set
		*/
		inline void setDownScrollMethod( const Link& _rDownScroll )
		{
			m_aDownScroll = _rDownScroll;
		}

		/** check if a scroll method has to be called
			@param	_rPoint	
				the current selection point
			@param	_rOutputSize
				the output size of the window
		*/
		void scroll(const Point& _rPoint, const Size& _rOutputSize);
	};
}
#endif // DBAUI_SCROLLHELPER_HXX

