/*************************************************************************
 *
 *  $RCSfile: curledit.hxx,v $
 *
 *  $Revision: 1.3 $
 *
 *  last change: $Author: fs $ $Date: 2001/05/08 09:55:03 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DBAUI_CURLEDIT_HXX_
#define _DBAUI_CURLEDIT_HXX_

#ifndef _SV_EDIT_HXX
#include <vcl/edit.hxx>
#endif
#ifndef _SV_FIXED_HXX
#include <vcl/fixed.hxx>
#endif
#ifndef _DBAUI_DSNTYPES_HXX_
#include "dsntypes.hxx"
#endif

//.........................................................................
namespace dbaui
{
//.........................................................................

//=========================================================================
//= OConnectionURLEdit
//=========================================================================
/** an edit control which may be used to edit connection URLs like
	"sdbc:odbc:" or "jdbc:". It prevents the user from editing this prefix,
	though it is normally shown.
*/
class OConnectionURLEdit : public Edit
{
	ODsnTypeCollection	m_aTypeCollection;
	FixedText*			m_pForcedPrefix;
	String				m_sSaveValueNoPrefix;

public:
	OConnectionURLEdit(Window* pParent, WinBits nStyle = WB_BORDER);
	OConnectionURLEdit(Window* pParent, const ResId& rResId);
	~OConnectionURLEdit();

public:
	// Edit overridables
	virtual void	SetText(const String& _rStr);
	virtual void	SetText(const String& _rStr, const Selection& _rNewSelection);
	virtual String	GetText() const;

	/// get the currently set text, excluding the prefix indicating the type
	virtual String	GetTextNoPrefix() const;
	/// set a new text, leave the current prefix unchanged
	virtual void	SetTextNoPrefix(const String& _rText);

	void	SaveValueNoPrefix()				{ m_sSaveValueNoPrefix = GetTextNoPrefix(); }
	String	GetSavedValueNoPrefix() const	{ return m_sSaveValueNoPrefix; }
};

//.........................................................................
}	// namespace dbaui
//.........................................................................

#endif // _DBAUI_CURLEDIT_HXX_

/*************************************************************************
 * history:
 *	$Log: curledit.hxx,v $
 *	Revision 1.3  2001/05/08 09:55:03  fs
 *	#86224# added SaveValueNoPrefix / GetSavedValueNoPrefix
 *	
 *	Revision 1.2  2000/10/24 12:07:36  fs
 *	S/GetTextNoPrefix
 *	
 *	Revision 1.1  2000/10/05 10:08:07  fs
 *	initial checkin
 *	
 *
 *	Revision 1.0 28.09.00 13:11:23  fs
 ************************************************************************/

