/*************************************************************************
 *
 *  $RCSfile: documentautolinker.hxx,v $
 *
 *  $Revision: 1.1 $
 *
 *  last change: $Author: fs $ $Date: 2001/04/26 11:53:36 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DBAUI_DOCUMENTAUTOLINKER_HXX_
#define _DBAUI_DOCUMENTAUTOLINKER_HXX_

#ifndef _COM_SUN_STAR_FRAME_XMODEL_HPP_
#include <com/sun/star/frame/XModel.hpp>
#endif
#ifndef _COM_SUN_STAR_DOCUMENT_XEVENTLISTENER_HPP_
#include <com/sun/star/document/XEventListener.hpp>
#endif
#ifndef _COM_SUN_STAR_CONTAINER_XNAMECONTAINER_HPP_
#include <com/sun/star/container/XNameContainer.hpp>
#endif
#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

//......................................................................
namespace dbaui
{
//......................................................................

	//==================================================================
	//= ODocumentAutoLinker
	//==================================================================
	typedef ::cppu::WeakImplHelper1	<	::com::sun::star::document::XEventListener
									>	ODocumentAutoLinker_Base;

	class ODocumentAutoLinker : public ODocumentAutoLinker_Base
	{
	protected:
		::com::sun::star::uno::Reference< ::com::sun::star::frame::XModel >
						m_xModel;
		::com::sun::star::uno::Reference< ::com::sun::star::container::XNameContainer >
						m_xLinkCollection;
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent >
						m_xDataSource;	// redundant, can be obtained from m_xLinkCollection
		::osl::Mutex	m_aMutex;

	public:
		ODocumentAutoLinker(
			const ::com::sun::star::uno::Reference< ::com::sun::star::frame::XModel >& _rxNewDocument,
			const ::com::sun::star::uno::Reference< ::com::sun::star::container::XNameContainer >& _rxLinks );
		~ODocumentAutoLinker();

		// css::document::XEventListener
		virtual void SAL_CALL notifyEvent( const ::com::sun::star::document::EventObject& _rEvent ) throw (::com::sun::star::uno::RuntimeException);

		// css::lang::XEventListener
		virtual void SAL_CALL disposing( const ::com::sun::star::lang::EventObject& _rEvent ) throw (::com::sun::star::uno::RuntimeException);

	protected:
		void implAutoLinkDocument( const ::rtl::OUString& _rURL );

		// if the method leaves, the object may be deleted !!
		void implDetach( ::osl::ClearableMutexGuard& _rClearBeforeDestruction );
	};

//......................................................................
}	// namespace dbaui
//......................................................................

#endif // _DBAUI_DOCUMENTAUTOLINKER_HXX_

/*************************************************************************
 * history:
 *	$Log: documentautolinker.hxx,v $
 *	Revision 1.1  2001/04/26 11:53:36  fs
 *	initial checkin - automatically bookmark data source associated documents
 *	
 *
 *	Revision 1.0 24.04.01 17:22:06  fs
 ************************************************************************/

