/*************************************************************************
 *
 *  $RCSfile: querydesignaccess.hxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: fs $ $Date: 2001/09/07 09:39:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _DBAUI_QUERYDESIGNACCESS_HXX_
#define _DBAUI_QUERYDESIGNACCESS_HXX_

#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif
#ifndef _COM_SUN_STAR_SDBC_XCONNECTION_HPP_
#include <com/sun/star/sdbc/XConnection.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XDISPATCH_HPP_
#include <com/sun/star/frame/XDispatch.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XCOMPONENT_HPP_ 
#include <com/sun/star/lang/XComponent.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif
#ifndef _VOS_REF_HXX_ 
#include <vos/ref.hxx>
#endif

// .........................................................................
namespace dbaui
{
// .........................................................................
	class OComponentClientMonitor;

	class ODesignAccess
	{
	protected:
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >
					m_xORB;

	private:
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent >
					doDispatch( const ::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& _rArgs );

	protected:
		virtual ::rtl::OUString getDispatchURL() const = 0;

		virtual void fill(
			::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& _rDispatchArguments,
			const ::rtl::OUString& _rDatasourceName,
			const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >& _rxConnection,
			const ::rtl::OUString& _rName = ::rtl::OUString()/*,
			sal_Bool _bAsView = sal_True*/
		) = 0;

	public:
		ODesignAccess(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB);
		virtual ~ODesignAccess(){}

		/** opens a design for a new object
			@param _rDatasourceName
				the name of the data source the new query should belong to
			@param _rxConnection
				an existent connection for this data source, if available
			@return
				the controller of the newly created document
		*/
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent >
			create(
				const ::rtl::OUString& _rDatasourceName,
				const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >& _rxConnection
			);

		/** opens a design for a new object
			@param _rDatasourceName
				the name of the data source the new query should belong to
			@param _rClientMonitor
				a reference to a object monitoring clients of the connection. The object itself is asked for
				it's connection (<method>OComponentClientMonitor::getComponent</method>).<br/>
				If opening the design component is successfull, it is registered as client of the connection
				at the client monitor.
			@return
				the controller of the newly created document
		*/
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent >
			create(
				const ::rtl::OUString& _rDatasourceName,
				const ::vos::ORef< OComponentClientMonitor >& _rClientMonitor
			);

		/** opens a design for editing an existent object
			@param _rDatasourceName
				the name of the data source the new query should belong to
			@param _rQueryName
				the name of the query to be edited
			@param _rxConnection
				an existent connection for this data source, if available
			@return
				the controller of the newly created document
		*/
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent >
			edit(
				const ::rtl::OUString& _rDatasourceName,
				const ::rtl::OUString& _rName,
				const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >& _rxConnection
			);

		/** opens a design for editing an existent object
			@param _rDatasourceName
				the name of the data source the new query should belong to
			@param _rQueryName
				the name of the query to be edited
			@param _rClientMonitor
				a reference to a object monitoring clients of the connection. The object itself is asked for
				it's connection (<method>OComponentClientMonitor::getComponent</method>).<br/>
				If opening the design component is successfull, it is registered as client of the connection
				at the client monitor.
			@return
				the controller of the newly created document
		*/
		::com::sun::star::uno::Reference< ::com::sun::star::lang::XComponent >
			edit(
				const ::rtl::OUString& _rDatasourceName,
				const ::rtl::OUString& _rName,
				const ::vos::ORef< OComponentClientMonitor >& _rClientMonitor
			);
	};
	//======================================================================
	//= OQueryDesignAccess
	//======================================================================
	class OQueryDesignAccess : public ODesignAccess
	{
	protected:
		sal_Bool	m_bCreateView;
		sal_Bool	m_bPreferSQLView;

	protected:
		virtual ::rtl::OUString getDispatchURL() const;

		virtual void fill(
			::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& _rDispatchArguments,
			const ::rtl::OUString& _rDatasourceName,
			const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >& _rxConnection,
			const ::rtl::OUString& _rQueryName = ::rtl::OUString()/*,
			sal_Bool _bAsView = sal_True*/
		);

	public:
		OQueryDesignAccess(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB,
			sal_Bool _bCreateView = sal_False,
			sal_Bool _bPreferSQLView = sal_False);
	};
	//======================================================================
	//= OTableDesignAccess
	//======================================================================
	class OTableDesignAccess : public ODesignAccess
	{
	protected:
		virtual ::rtl::OUString getDispatchURL() const;

		virtual void fill(
			::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& _rDispatchArguments,
			const ::rtl::OUString& _rDatasourceName,
			const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >& _rxConnection,
			const ::rtl::OUString& _rQueryName = ::rtl::OUString()/*,
			sal_Bool _bAsView = sal_True*/
		);

	public:
		OTableDesignAccess(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB);
	};
	//======================================================================
	//= ORelationDesignAccess
	//======================================================================
	class ORelationDesignAccess : public ODesignAccess
	{
	protected:
		virtual ::rtl::OUString getDispatchURL() const;

		virtual void fill(
			::com::sun::star::uno::Sequence< ::com::sun::star::beans::PropertyValue >& _rDispatchArguments,
			const ::rtl::OUString& _rDatasourceName,
			const ::com::sun::star::uno::Reference< ::com::sun::star::sdbc::XConnection >& _rxConnection,
			const ::rtl::OUString& _rQueryName = ::rtl::OUString()/*,
			sal_Bool _bAsView = sal_True*/
		);

	public:
		ORelationDesignAccess(const ::com::sun::star::uno::Reference< ::com::sun::star::lang::XMultiServiceFactory >& _rxORB);
	};

// .........................................................................
}	// namespace dbaui
// .........................................................................

#endif // _DBAUI_QUERYDESIGNACCESS_HXX_

/*************************************************************************
 * history:
 *	$Log: querydesignaccess.hxx,v $
 *	Revision 1.10  2001/09/07 09:39:50  fs
 *	added versions of create/edit using a OComponentClientMonitor
 *	
 *	Revision 1.9  2001/08/14 14:10:01  fs
 *	#86945# changes to return the component just loaded
 *	
 *	Revision 1.8  2001/05/10 12:15:25  fs
 *	OQueryDesignAccess: allow to open/create as SQL view
 *	
 *	Revision 1.7  2001/04/26 11:47:48  fs
 *	some consolidations
 *	
 *	Revision 1.6  2001/04/24 14:34:10  oj
 *	impl views and a menu
 *	
 *	Revision 1.5  2001/02/28 10:10:02  oj
 *	changes for the new relation design
 *	
 *	Revision 1.4  2001/02/14 14:39:23  oj
 *	some changes
 *	
 *	Revision 1.3  2001/02/05 12:34:08  oj
 *	default value for parameter
 *	
 *	Revision 1.2  2001/02/05 09:46:41  oj
 *	new parameter for the designview
 *	
 *	Revision 1.1  2001/01/26 14:16:48  fs
 *	initial checkin - small helper for opening a query design
 *	
 *
 *	Revision 1.0 26.01.01 11:12:34  fs
 ************************************************************************/

