/*************************************************************************
 *
 *  $RCSfile: pkgchk_env.cxx,v $
 *
 *  $Revision: 1.7.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/11/01 14:39:24 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "pkgchk_env.h"
#include "pkgchk_unorc.h"
#include <pkgchk.hxx>

#include <cppuhelper/servicefactory.hxx>
#include <unotools/processfactory.hxx>
#include <ucbhelper/contentbroker.hxx>
#include <ucbhelper/configurationkeys.hxx>

#include <com/sun/star/lang/XComponent.hpp>
#include <com/sun/star/beans/XPropertySet.hpp>


using namespace ::rtl;
using namespace ::osl;
using namespace ::com::sun::star::uno;
using namespace ::com::sun::star;
using namespace ::com::sun::star::ucb; // because of conflicting ::com::sun::star::ucb with ::ucb

namespace pkgchk
{

//__________________________________________________________________________________________________
pkgchk_env::pkgchk_env(
    Bootstrap const & unorc,
    OptionsContainer const & options )
    SAL_THROW( (RuntimeException) )
        : m_ucb_inited( false ),
          m_classpath_inited( false ),
          m_log_file( 0 )
{
#ifdef __DIAG
    OSL_VERIFY( osl_getSystemTime( &m_start_time ) );
#endif
    // read out some options
    bool shared_packages = options.get_option( OUSTR("shared"), 's' );
    m_verbose = options.get_option( OUSTR("verbose"), 'v' );
    m_strict_error_handling = options.get_option( OUSTR("strict_error_handling") );
    m_supersede_basic_libs = options.get_option( OUSTR("supersede_basic_libs") );
    Any val;
    if (options.get_argument( &val, OUSTR("log"), 'l' ))
    {
        if (val >>= m_log_file_path)
        {
            m_log_file_path = path_make_absolute( m_log_file_path );
        }
    }
    
    OUString config_path;
    if (shared_packages)
    {
        m_packages_path = path_make_absolute(
            getFromBstrap( OUSTR(UNO_SHARED_PACKAGES), unorc ) );
        m_cache_path = path_make_absolute(
            getFromBstrap( OUSTR(UNO_SHARED_PACKAGES_CACHE), unorc ) );
#if SUPD > 641
        m_reg_cache_path = OUSTR(EXPAND_PROTOCOL ":$" UNO_SHARED_PACKAGES_CACHE); // expand url
#else
        m_reg_cache_path = OUSTR("$" UNO_SHARED_PACKAGES_CACHE); // expand url
#endif
        config_path = OUSTR(RC_SHARED_INSTPATH_MACRO "/share");
    }
    else
    {
        m_packages_path = path_make_absolute(
            getFromBstrap( OUSTR(UNO_USER_PACKAGES), unorc ) );
        m_cache_path = path_make_absolute(
            getFromBstrap( OUSTR(UNO_USER_PACKAGES_CACHE), unorc ) );
#if SUPD > 641
        m_reg_cache_path = OUSTR(EXPAND_PROTOCOL ":$" UNO_USER_PACKAGES_CACHE); // expand url
#else
        m_reg_cache_path = OUSTR("$" UNO_USER_PACKAGES_CACHE); // expand url
#endif
        config_path = OUSTR(RC_USER_INSTPATH_MACRO "/user");
    }
    
    // basic pathes
    unorc.expandMacrosFrom( config_path );
    config_path = path_make_absolute( config_path );
    m_basic_script_libs.m_container_path = path_concat( config_path, CSTR_LEN("basic/script.xlc") );
    m_basic_dialog_libs.m_container_path = path_concat( config_path, CSTR_LEN("basic/dialog.xlc") );
    
    // ensure packages path
    dir_ensure( m_packages_path );
    // ensure cache path
    dir_ensure( m_cache_path );
    
    // log file
    if (! m_log_file_path.getLength())
    {
        // set default log file
        m_log_file_path = path_concat( m_cache_path, CSTR_LEN("log.txt") );
    }
}
//__________________________________________________________________________________________________
pkgchk_env::~pkgchk_env()
    SAL_THROW( () )
{
    try
    {
        // close services.rdb, types.rdb
        if (m_xServices_rdb.is())
        {
            m_xServices_rdb->close();
            m_xServices_rdb.clear();
        }
        if (m_xTypes_rdb.is())
        {
            m_xTypes_rdb->close();
            m_xTypes_rdb.clear();
        }
        // flush classpath
        classpath_flush();
        // flush basic scripts, dialogs
        basic_flush();
        // close log file
        if (m_log_file)
        {
            OSL_VERIFY( osl_File_E_None == osl_closeFile( m_log_file ) );
            m_log_file = 0;
        }
        // cleanup ucbhelper ucb
        if (m_ucb_inited)
        {
            m_ucb_inited = false;
            ::ucb::ContentBroker::deinitialize();
        }
        // cleanup component context
        if (m_xComponentContext.is())
        {
            Reference< lang::XComponent > xComp( m_xComponentContext, UNO_QUERY );
            if (xComp.is())
            {
                m_xComponentContext.clear();
                xComp->dispose();
            }
            ::utl::setProcessServiceFactory( m_xOldProcessServiceFactory );
        }
    }
#ifdef _DEBUG
    catch (Exception & exc) // no exc here
    {
        OSL_ENSURE( 0, "# ~pkgchk_env() UNO exception occured:" );
        OString str( OUStringToOString( exc.Message, RTL_TEXTENCODING_ASCII_US ) );
        OSL_ENSURE( 0, str.getStr() );
    }
#endif 
    catch (...) // no exc here
    {
        OSL_ENSURE( 0, "# ~pkgchk_env() non-UNO exception occured!" );
    }
}

//__________________________________________________________________________________________________
Reference< XComponentContext > const & pkgchk_env::get_component_context() const
    SAL_THROW( (RuntimeException) )
{
    if (! m_xComponentContext.is())
    {
        try
        {
            // bootstrap uno from applicat.rdb directly avoiding any rc entries
            Reference< lang::XMultiServiceFactory > xMgr(
                ::cppu::createRegistryServiceFactory(
                    path_concat( path_get_executable(), CSTR_LEN("applicat.rdb") ),
                    sal_True /* read-only */ ) );
            Reference< beans::XPropertySet > xProps( xMgr, UNO_QUERY );
            OSL_ASSERT( xProps.is() );
            xProps->getPropertyValue( OUSTR("DefaultContext") ) >>= m_xComponentContext;
            OSL_ASSERT( m_xComponentContext.is() );
            // set global process service factory used by unotools config helpers
            m_xOldProcessServiceFactory = ::utl::getProcessServiceFactory();
            ::utl::setProcessServiceFactory( xMgr );
        }
        catch (Exception & exc)
        {
            throw RuntimeException( exc.Message, exc.Context );
        }
    }
    return m_xComponentContext;
}
//__________________________________________________________________________________________________
Reference< registry::XImplementationRegistration > const & pkgchk_env::get_impreg() const
    SAL_THROW( (RuntimeException) )
{
    if (! m_xImpReg.is())
    {
        // raise impreg
        Reference< XComponentContext > const & xContext = get_component_context();
        m_xImpReg.set(
            xContext->getServiceManager()->createInstanceWithContext(
                OUSTR("com.sun.star.registry.ImplementationRegistration"), xContext ), UNO_QUERY );
        if (! m_xImpReg.is())
        {
            throw RuntimeException(
                OUSTR("no implementation registration available!"), Reference< XInterface >() );
        }
    }
    return m_xImpReg;
}
//__________________________________________________________________________________________________
Reference< XCommandProcessor > pkgchk_env::get_ucb_cmdproc() const
    SAL_THROW( (RuntimeException) )
{
    if (! m_ucb_inited)
    {
        // we have to initialize the ucbhelper ucb, because the package implementation uses it
        Reference< lang::XMultiServiceFactory > xFac(
            get_component_context()->getServiceManager(), UNO_QUERY );
        OSL_ASSERT( xFac.is() );
        // init ucb
        Sequence< Any > args( 2 );
        args[ 0 ] <<= OUSTR(UCB_CONFIGURATION_KEY1_LOCAL);
        args[ 1 ] <<= OUSTR(UCB_CONFIGURATION_KEY2_OFFICE);
        if (! ::ucb::ContentBroker::initialize( xFac, args ))
        {
            throw RuntimeException(
                OUSTR("cannot initialize ucb!"), Reference< XInterface >() );
        }
        m_ucb_inited = true;
    }
    return ::ucb::ContentBroker::get()->getCommandProcessorInterface();
}
//__________________________________________________________________________________________________
Reference< XSimpleFileAccess > const & pkgchk_env::get_simple_file_access() const
    SAL_THROW( (RuntimeException) )
{
    if (! m_xSimpleFileAccess.is())
    {
        // raise simple file access
        Reference< XComponentContext > const & xContext = get_component_context();
        m_xSimpleFileAccess.set(
            xContext->getServiceManager()->createInstanceWithContext(
                OUSTR("com.sun.star.ucb.SimpleFileAccess"), xContext ), UNO_QUERY );
        if (! m_xSimpleFileAccess.is())
        {
            throw RuntimeException(
                OUSTR("no simple file access available!"), Reference< XInterface >() );
        }
    }
    return m_xSimpleFileAccess;
}

//__________________________________________________________________________________________________
Reference< registry::XSimpleRegistry > pkgchk_env::rdb_open(
	OUString const & url, bool readOnly, bool create ) const
	SAL_THROW( (RuntimeException) )
{
    Reference< XComponentContext > const & xContext = get_component_context();
	Reference< registry::XSimpleRegistry > xNewReg(
        xContext->getServiceManager()->createInstanceWithContext(
            OUSTR("com.sun.star.registry.SimpleRegistry"), xContext ), UNO_QUERY );
    if (! xNewReg.is())
    {
        throw RuntimeException( OUSTR("no simple registry available!"), Reference< XInterface >() );
    }
    
	try
	{
		xNewReg->open(
            url, readOnly ? sal_True: sal_False, create ? sal_True : sal_False );
		if (! xNewReg->isValid())
        {
            xNewReg->close();
            throw RuntimeException(
                OUSTR("invalid registry ") + url, Reference< XInterface >() );
        }
	}
	catch (Exception & exc)
	{
        throw RuntimeException(
            exc.Message, Reference< XInterface >() );
	}
    
    return xNewReg;
}
//__________________________________________________________________________________________________
Reference< registry::XSimpleRegistry > const & pkgchk_env::get_services_rdb() const
    SAL_THROW( (RuntimeException) )
{
    if (! m_xServices_rdb.is())
    {
        m_xServices_rdb = rdb_open(
            path_concat( m_cache_path, CSTR_LEN("services.rdb") ), false, true );
    }
    return m_xServices_rdb;
}
//__________________________________________________________________________________________________
Reference< registry::XSimpleRegistry > const & pkgchk_env::get_types_rdb() const
    SAL_THROW( (RuntimeException) )
{
    if (! m_xTypes_rdb.is())
    {
        m_xTypes_rdb = rdb_open(
            path_concat( m_cache_path, CSTR_LEN("types.rdb") ), false, true );
    }
    return m_xTypes_rdb;
}

}
