/*************************************************************************
 *
 *  $RCSfile: pkgchk_env.h,v $
 *
 *  $Revision: 1.5.6.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/11/01 14:39:26 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2002 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "pkgchk_misc.h"

#ifdef __DIAG
#include <osl/time.h>
#endif

#include <hash_set>
#include <hash_map>

#include <xmlscript/xmllib_imexp.hxx>

#include <com/sun/star/uno/XComponentContext.hpp>
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#include <com/sun/star/registry/XSimpleRegistry.hpp>
#include <com/sun/star/registry/XImplementationRegistration.hpp>

#include <com/sun/star/ucb/XCommandProcessor.hpp>
#include <com/sun/star/ucb/XSimpleFileAccess.hpp>

#define EXPAND_PROTOCOL "vnd.sun.star.expand"


namespace pkgchk
{

class OptionsContainer;

typedef ::std::hash_set< ::rtl::OUString, ::rtl::OUStringHash > t_string_set;

typedef ::std::hash_map<
    ::rtl::OUString, ::xmlscript::LibDescriptor, ::rtl::OUStringHash > t_libs_map;

//==================================================================================================
class pkgchk_env
{
    mutable ::com::sun::star::uno::Reference<
        ::com::sun::star::lang::XMultiServiceFactory > m_xOldProcessServiceFactory;
    mutable ::com::sun::star::uno::Reference<
        ::com::sun::star::uno::XComponentContext > m_xComponentContext;
    mutable ::com::sun::star::uno::Reference<
        ::com::sun::star::registry::XSimpleRegistry > m_xServices_rdb;
    mutable ::com::sun::star::uno::Reference<
        ::com::sun::star::registry::XSimpleRegistry > m_xTypes_rdb;
    mutable ::com::sun::star::uno::Reference<
        ::com::sun::star::registry::XImplementationRegistration > m_xImpReg;
    mutable ::com::sun::star::uno::Reference<
        ::com::sun::star::ucb::XSimpleFileAccess > m_xSimpleFileAccess;
    mutable bool m_ucb_inited;
    
    ::com::sun::star::uno::Reference<
        ::com::sun::star::registry::XSimpleRegistry > rdb_open(
        ::rtl::OUString const & url, bool readOnly, bool create ) const
        SAL_THROW( (::com::sun::star::uno::RuntimeException) );
    
    // logging, errors
    bool m_strict_error_handling;
    bool m_verbose;
    mutable ::rtl::OUString m_log_file_path;
    mutable oslFileHandle m_log_file;
#ifdef __DIAG
    ::TimeValue m_start_time;
#endif
    void log_write( ::rtl::OString const & text ) const
        SAL_THROW( (::com::sun::star::uno::RuntimeException) );
    
    // java classpath
    t_string_set m_classpathes;
    bool m_classpath_inited;
    mutable bool m_classpath_modified;
    void classpath_verify_init() SAL_THROW( () );
    
    // basic scripts, dialog libs
    struct basic_libs
    {
        ::rtl::OUString m_container_path;
        t_libs_map m_map;
        bool m_inited, m_modified;
        inline basic_libs() SAL_THROW( () )
            : m_inited( false )
            {}
    };
    bool m_supersede_basic_libs;
    mutable basic_libs m_basic_script_libs, m_basic_dialog_libs;
    void basic_verify_init( basic_libs * libs )
        SAL_THROW( () );
    void basic_flush( basic_libs * libs ) const
        SAL_THROW( (::com::sun::star::uno::RuntimeException) );
    // basic library container modifications
    bool basic_insert(
        basic_libs * libs, ::rtl::OUString const & path )
        SAL_THROW( () );
    bool basic_remove(
        basic_libs * libs, ::rtl::OUString const & path, bool exact = true )
        SAL_THROW( () );
    
    // packages to be installed
    t_string_set m_packages_to_be_installed;
    // packages to be revoked
    t_string_set m_packages_to_be_removed;
    
public:
    pkgchk_env( ::rtl::Bootstrap const & unorc, OptionsContainer const & options )
        SAL_THROW( (::com::sun::star::uno::RuntimeException) );
    ~pkgchk_env()
        SAL_THROW( () );
    
    // misc: uno services, rdbs, ucb
    ::com::sun::star::uno::Reference<
        ::com::sun::star::uno::XComponentContext > const & get_component_context() const
        SAL_THROW( (::com::sun::star::uno::RuntimeException) );
    ::com::sun::star::uno::Reference<
        ::com::sun::star::registry::XSimpleRegistry > const & get_services_rdb() const
        SAL_THROW( (::com::sun::star::uno::RuntimeException) );
    ::com::sun::star::uno::Reference<
        ::com::sun::star::registry::XSimpleRegistry > const & get_types_rdb() const
        SAL_THROW( (::com::sun::star::uno::RuntimeException) );
    ::com::sun::star::uno::Reference<
        ::com::sun::star::registry::XImplementationRegistration > const & get_impreg() const
        SAL_THROW( (::com::sun::star::uno::RuntimeException) );
    ::com::sun::star::uno::Reference<
        ::com::sun::star::ucb::XCommandProcessor > get_ucb_cmdproc() const
        SAL_THROW( (::com::sun::star::uno::RuntimeException) );
    ::com::sun::star::uno::Reference<
        ::com::sun::star::ucb::XSimpleFileAccess > const & get_simple_file_access() const
        SAL_THROW( (::com::sun::star::uno::RuntimeException) );
    
    // pathes
    ::rtl::OUString m_packages_path;
    ::rtl::OUString m_cache_path;
    ::rtl::OUString m_reg_cache_path;
    
    // java classpath
    void classpath_flush() const
        SAL_THROW( (::com::sun::star::uno::RuntimeException) );
    void classpath_insert( ::rtl::OUString const & path ) SAL_THROW( () );
    void classpath_remove( ::rtl::OUString const & path ) SAL_THROW( () );
    
    // basic
    inline void basic_flush() const
        SAL_THROW( (::com::sun::star::uno::RuntimeException) );
    inline bool basic_remove_cache_entries() SAL_THROW( () );
    inline bool basic_insert( ::rtl::OUString const & path ) SAL_THROW( () );
    inline bool basic_remove( ::rtl::OUString const & path ) SAL_THROW( () );
    
    // logging, errors
    void log( ::rtl::OUString const & text ) const
        SAL_THROW( (::com::sun::star::uno::RuntimeException) );
    void log_err( ::rtl::OUString const & text ) const
        SAL_THROW( (::com::sun::star::uno::RuntimeException) );
    void err( ::rtl::OUString const & text ) const
        SAL_THROW( (::com::sun::star::uno::RuntimeException) );
    
    // packages management
    void packages_remove_all()
        SAL_THROW( (::com::sun::star::uno::RuntimeException) );
    bool packages_check()
        SAL_THROW( (::com::sun::star::uno::RuntimeException) );
    inline bool packages_to_be_balanced() SAL_THROW( () )
        { return (!m_packages_to_be_installed.empty() || !m_packages_to_be_removed.empty()); }
    void packages_balance()
        SAL_THROW( (::com::sun::star::uno::RuntimeException) );
};
//__________________________________________________________________________________________________
inline void pkgchk_env::basic_flush() const
    SAL_THROW( (::com::sun::star::uno::RuntimeException) )
{
    basic_flush( &m_basic_script_libs );
    basic_flush( &m_basic_dialog_libs );
}
//__________________________________________________________________________________________________
inline bool pkgchk_env::basic_remove_cache_entries() SAL_THROW( () )
{
    bool ret = basic_remove( &m_basic_script_libs, m_cache_path, false );
    ret |= basic_remove( &m_basic_dialog_libs, m_cache_path, false );
    return ret;
}
//__________________________________________________________________________________________________
inline bool pkgchk_env::basic_insert( ::rtl::OUString const & path ) SAL_THROW( () )
{
    return basic_insert( (ends_with_ignore_ascii_case( path, CSTR_LEN("/dialog.xlb") )
                          ? &m_basic_dialog_libs : &m_basic_script_libs), path );
}
//__________________________________________________________________________________________________
inline bool pkgchk_env::basic_remove( ::rtl::OUString const & path ) SAL_THROW( () )
{
    return basic_remove( (ends_with_ignore_ascii_case( path, CSTR_LEN("/dialog.xlb") )
                          ? &m_basic_dialog_libs : &m_basic_script_libs), path );
}

}
