/*************************************************************************
 *
 *  $RCSfile: abspilot.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: fs $ $Date: 2001/08/08 15:41:42 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef EXTENSIONS_ABSPILOT_HXX
#include "abspilot.hxx"
#endif
#ifndef __EXTENSIONS_INC_EXTENSIO_HRC__
#include "extensio.hrc"
#endif
#ifndef EXTENSIONS_ABPRESID_HRC
#include "abpresid.hrc"
#endif
#ifndef _EXTENSIONS_COMPONENT_MODULE_HXX_
#include "componentmodule.hxx"
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef EXTENSIONS_ABP_TYPESELECTIONPAGE_HXX
#include "typeselectionpage.hxx"
#endif
#ifndef EXTENSIONS_ABP_ADMINDIALOG_INVOKATION_PAGE_HXX
#include "admininvokationpage.hxx"
#endif
#ifndef EXTENSIONS_ABP_TABLESELECTIONPAGE_HXX
#include "tableselectionpage.hxx"
#endif
#ifndef _SV_WAITOBJ_HXX 
#include <vcl/waitobj.hxx>
#endif
#ifndef _SV_MSGBOX_HXX 
#include <vcl/msgbox.hxx>
#endif
#ifndef EXTENSIONS_ABP_ABPFINALPAGE_HXX
#include "abpfinalpage.hxx"
#endif
#ifndef EXTENSIONS_ABP_FIELDMAPPINGPAGE_HXX
#include "fieldmappingpage.hxx"
#endif
#ifndef EXTENSIONS_ABP_FIELDMAPPINGIMPL_HXX
#include "fieldmappingimpl.hxx"
#endif

//.........................................................................
namespace abp
{
//.........................................................................

#define STATE_SELECT_ABTYPE			0
#define STATE_INVOKE_ADMIN_DIALOG	1
#define STATE_TABLE_SELECTION		2
#define STATE_MANUAL_FIELD_MAPPING	3
#define STATE_FINAL_CONFIRM			4

	using namespace ::svt;
	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::lang;

	//=====================================================================
	//= OAddessBookSourcePilot
	//=====================================================================
	//---------------------------------------------------------------------
	OAddessBookSourcePilot::OAddessBookSourcePilot(Window* _pParent, const Reference< XMultiServiceFactory >& _rxORB)
		:OAddessBookSourcePilot_Base(_pParent, ModuleRes(RID_DLG_ADDRESSBOOKSOURCEPILOT), WZB_HELP | WZB_FINISH | WZB_CANCEL | WZB_NEXT | WZB_PREVIOUS)
		,m_xORB(_rxORB)
		,m_aNewDataSource(_rxORB)
		,m_eNewDataSourceType( AST_INVALID )
	{
		SetPageSizePixel(LogicToPixel(Size(WINDOW_SIZE_X, WINDOW_SIZE_Y), MAP_APPFONT));

		ShowButtonFixedLine(sal_True);

		enableHeader( Bitmap( ModuleRes( BMP_HEADERIMAGE ) ) );

		m_pPrevPage->SetHelpId(HID_ABSPILOT_PREVIOUS);
		m_pNextPage->SetHelpId(HID_ABSPILOT_NEXT);
		m_pCancel->SetHelpId(HID_ABSPILOT_CANCEL);
		m_pFinish->SetHelpId(HID_ABSPILOT_FINISH);
		m_pHelp->SetUniqueId(UID_ABSPILOT_HELP);

		m_pCancel->SetClickHdl( LINK( this, OAddessBookSourcePilot, OnCancelClicked) );

		// some initial settings
#ifdef UNX
		m_aSettings.eType = AST_MORK;
#else
		m_aSettings.eType = AST_OE;
#endif
		m_aSettings.sDataSourceName = String(ModuleRes(RID_STR_DEFAULT_NAME));

		defaultButton(WZB_NEXT);
		enableButtons(WZB_FINISH, sal_False);
		ActivatePage();
	}

	//---------------------------------------------------------------------
	void OAddessBookSourcePilot::implCommitAll()
	{
		// in real, the data source already exists in the data source context
		// Thus, if the user changed the name, we have to rename the data source
		if ( m_aSettings.sDataSourceName != m_aNewDataSource.getName() )
			m_aNewDataSource.rename( m_aSettings.sDataSourceName );

		// 1. the data source
		// nothing to do anymore, it already exists

		// 2. write the data source / table names into the configuration
		addressconfig::writeTemplateAddressSource( getORB(), m_aSettings.sDataSourceName, m_aSettings.sSelectedTable );

		// write the field mapping
		fieldmapping::writeTemplateAddressFieldMapping( getORB(), m_aSettings.aFieldMapping );
	}

	//---------------------------------------------------------------------
	void OAddessBookSourcePilot::implCleanup()
	{
		if ( m_aNewDataSource.isValid() )
			m_aNewDataSource.remove();
	}

	//---------------------------------------------------------------------
	IMPL_LINK( OAddessBookSourcePilot, OnCancelClicked, void*, NOTINTERESTEDIN )
	{
		// do cleanups
		implCleanup();

		// reset the click hdl
		m_pCancel->SetClickHdl( Link() );
		// simulate the click again - this time, the default handling of the button will strike ....
		m_pCancel->Click();

		return 0L;
	}

	//---------------------------------------------------------------------
	BOOL OAddessBookSourcePilot::Close()
	{
		implCleanup();

		return OAddessBookSourcePilot_Base::Close();
	}

	//---------------------------------------------------------------------
	sal_Bool OAddessBookSourcePilot::onFinish(sal_Int32 _nResult)
	{
		if (!OAddessBookSourcePilot_Base::onFinish(_nResult))
			return sal_False;

		if (RET_OK != _nResult)
			return sal_True;

		implCommitAll();

		addressconfig::markPilotSuccess( getORB() );

		MessBox aSuccessMessage( GetParent(), WB_OK, GetText(), String( ModuleRes( RID_STR_ABP_SUCCESS ) ) );
		aSuccessMessage.Execute();

		return sal_True;
	}

	//---------------------------------------------------------------------
	void OAddessBookSourcePilot::enterState(sal_uInt16 _nState)
	{
		switch ( _nState )
		{
			case STATE_FINAL_CONFIRM:
				if ( !needManualFieldMapping( ) )
					implDoAutoFieldMapping();
				break;

			case STATE_TABLE_SELECTION:
				implDefaultTableName();
				break;
		}

		OAddessBookSourcePilot_Base::enterState(_nState);
	}

	//---------------------------------------------------------------------
	sal_Bool OAddessBookSourcePilot::leaveState(sal_uInt16 _nState)
	{
		if (!OAddessBookSourcePilot_Base::leaveState(_nState))
			return sal_False;

		switch ( _nState )
		{
			case STATE_SELECT_ABTYPE:
				implCreateDataSource();
				// create the data source, if necessary (in some cases, it may already have been created, 'cause it was
				// needed for determining the next state)
				break;
		}

		return sal_True;
	}

	//---------------------------------------------------------------------
	void OAddessBookSourcePilot::implDefaultTableName()
	{
		const StringBag& rTableNames = getDataSource().getTableNames();
		if ( rTableNames.end() != rTableNames.find( getSettings().sSelectedTable ) )
			// already a valid table selected
			return;

		const sal_Char* pGuess = NULL;
		switch ( getSettings().eType )
		{
			case AST_MORK		: pGuess = "Personal Address Book"; break;
			case AST_LDAP		: pGuess = "LDAP Directory"; break;
		}
		const ::rtl::OUString sGuess = ::rtl::OUString::createFromAscii( pGuess );
		if ( rTableNames.end() != rTableNames.find( sGuess ) )
			getSettings().sSelectedTable = sGuess;
	}

	//---------------------------------------------------------------------
	void OAddessBookSourcePilot::implDoAutoFieldMapping()
	{
		DBG_ASSERT( !needManualFieldMapping( ), "OAddessBookSourcePilot::implDoAutoFieldMapping: invalid call!" );

		fieldmapping::defaultMapping( getORB(), m_aSettings.aFieldMapping );
	}

	//---------------------------------------------------------------------
	void OAddessBookSourcePilot::implCreateDataSource()
	{
		if (m_aNewDataSource.isValid())
		{	// we already have a data source object
			if ( m_aSettings.eType == m_eNewDataSourceType )
				// and it already has the correct type
				return;

			// it has a wrong type -> remove it
			m_aNewDataSource.remove();
		}

		ODataSourceContext aContext( getORB() );
		aContext.disambiguate( m_aSettings.sDataSourceName );

		switch (m_aSettings.eType)
		{
			case AST_MORK:
				m_aNewDataSource = aContext.createNewMORK( m_aSettings.sDataSourceName );
				break;

			case AST_LDAP:
				m_aNewDataSource = aContext.createNewLDAP( m_aSettings.sDataSourceName );
				break;

			case AST_OUTLOOK:
				m_aNewDataSource = aContext.createNewOutlook( m_aSettings.sDataSourceName );
				break;

			case AST_OE:
				m_aNewDataSource = aContext.createNewOE( m_aSettings.sDataSourceName );
				break;

			case AST_OTHER:
				m_aNewDataSource = aContext.createNewDBase( m_aSettings.sDataSourceName );
				break;
		}
		m_eNewDataSourceType = m_aSettings.eType;
	}

	//---------------------------------------------------------------------
	sal_Bool OAddessBookSourcePilot::connectToDataSource( sal_Bool _bForceReConnect )
	{
		DBG_ASSERT( m_aNewDataSource.isValid(), "OAddessBookSourcePilot::implConnect: invalid current data source!" );

		WaitObject aWaitCursor( this );
		if ( _bForceReConnect && m_aNewDataSource.isConnected( ) )
			m_aNewDataSource.disconnect( );

		return m_aNewDataSource.connect( this );
	}

	//---------------------------------------------------------------------
	OWizardPage* OAddessBookSourcePilot::createPage(sal_uInt16 _nState)
	{
		switch (_nState)
		{
			case STATE_SELECT_ABTYPE:
				return new TypeSelectionPage( this );

			case STATE_INVOKE_ADMIN_DIALOG:
				return new AdminDialogInvokationPage( this );

			case STATE_TABLE_SELECTION:
				return new TableSelectionPage( this );

			case STATE_MANUAL_FIELD_MAPPING:
				return new FieldMappingPage( this );

			case STATE_FINAL_CONFIRM:
				return new FinalPage( this );

			default:
				DBG_ERROR("OAddessBookSourcePilot::createPage: invalid state!");
				return NULL;
		}
	}

	//---------------------------------------------------------------------
	sal_uInt16 OAddessBookSourcePilot::determineNextState(sal_uInt16 _nCurrentState)
	{
		switch (_nCurrentState)
		{
			case STATE_SELECT_ABTYPE:

				if	( needAdminInvokationPage() )
					return STATE_INVOKE_ADMIN_DIALOG;
				// _NO_ break !!!

			case STATE_INVOKE_ADMIN_DIALOG:
			{
				// determining the next state here is somewhat more complex: it depends on the type selected,
				// and on the number of tables in the data source specified by the user

				// ........................................................
				// create the new data source
				implCreateDataSource( );

				// ........................................................
				// if we're here, we have all settings necessary for connecting to the data source
				if ( !connectToDataSource( sal_False ) )
					// connecting did not succeed -> do not allow traveling (indicated by returning WZS_INVALID_STATE)
					return WZS_INVALID_STATE;

				// ........................................................
				// get the tables of the connection
				const StringBag& aTables = m_aNewDataSource.getTableNames();
				if ( aTables.size() > 1 )
					// in the next step, we need to determine the primary address table
					return STATE_TABLE_SELECTION;

				// ........................................................
				// do we have any tables ?
				if ( 0 == aTables.size() )
				{	// ... no
					QueryBox aQuery( this, ModuleRes( RID_QRY_NOTABLES ) );
					if ( RET_YES == aQuery.Execute() )
					{	// but the user chose to use this data source, anyway
						// -> go to the final page (no field mapping possible at all ...)
						return STATE_FINAL_CONFIRM;
					}

					// not allowed to leave the page
					return WZS_INVALID_STATE;
				}

				// remember the one and only table we have
				m_aSettings.sSelectedTable = *aTables.begin();
			}
				// _NO_ break !!!

			case STATE_TABLE_SELECTION:

				// ........................................................
				// do we need a field mapping provided by the user?
				if ( needManualFieldMapping( ) )
					return STATE_MANUAL_FIELD_MAPPING;

				// ........................................................
				// we're nearly done ...
				return STATE_FINAL_CONFIRM;

			case STATE_MANUAL_FIELD_MAPPING:
				return STATE_FINAL_CONFIRM;

			default:
				DBG_ERROR("OAddessBookSourcePilot::determineNextState: invalid current state!");
		}

		DBG_ERROR("OAddessBookSourcePilot::determineNextState: no next state available!");
		return WZS_INVALID_STATE;
	}

//.........................................................................
}	// namespace abp
//.........................................................................

/*************************************************************************
 * history:
 *	$Log: abspilot.cxx,v $
 *	Revision 1.4  2001/08/08 15:41:42  fs
 *	#90716# UID_ABSPILOT_HELP
 *	
 *	Revision 1.3  2001/08/08 14:55:41  fs
 *	#90716# layout changes
 *	
 *	Revision 1.2  2001/08/02 10:45:28  fs
 *	#88530# layout changes
 *	
 *	Revision 1.1  2001/08/01 11:06:28  fs
 *	initial checkin - address book auto pilot - the dialog itself
 *	
 *
 *	Revision 1.0 26.07.01 08:45:44  fs
 ************************************************************************/

