/*************************************************************************
 *
 *  $RCSfile: dbidialogs.cxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: fs $ $Date: 2001/03/02 16:57:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_DBI_DBIDIALOGS_HXX_
#include "dbidialogs.hxx"
#endif
#ifndef _EXTENSIONS_DBIRESID_HRC_
#include "dbiresid.hrc"
#endif
//#ifndef _EXTENSIONS_DBI_WIZARDSTATEMACHINE_HRC_
//#include "wizardstatemachine.hrc"
//#endif
#ifndef _SV_MSGBOX_HXX 
#include <vcl/msgbox.hxx>
#endif
#ifndef _EXTENSIONS_COMPONENT_MODULE_HXX_
#include "componentmodule.hxx"
#endif
#ifndef _EXTENSIONS_DBI_FILENOTATION_HXX_
#include "filenotation.hxx"
#endif
#ifndef _URLOBJ_HXX 
#include <tools/urlobj.hxx>
#endif

//.........................................................................
namespace dbi
{
//.........................................................................

	using namespace ::com::sun::star::uno;
	using namespace ::com::sun::star::container;

	//=====================================================================
	//= OQueryNameConflictDialog
	//=====================================================================
	//---------------------------------------------------------------------
	OQueryNameConflictDialog::OQueryNameConflictDialog(Window* _pParent,
			const Reference< XNameAccess >& _rxAllNames, const String& _rCurrentName)
		:ModalDialog(_pParent, ModuleRes(RID_DLG_QUERYNAMINGCONFLICT))
		,m_aMessage		(this, ResId(FT_NAMINGCONFLICT))
		,m_aRequest		(this, ResId(FT_PLEASERENAME))
		,m_aNewName		(this, ResId(ET_NEWNAME))
		,m_aOK			(this, ResId(PB_FINISH))
		,m_aCancel		(this, ResId(PB_CANCEL))
		,m_xAllNames(_rxAllNames)
	{
		FreeResource();

		m_aOK.SetClickHdl(LINK(this, OQueryNameConflictDialog, OnOK));
		m_aNewName.SetModifyHdl(LINK(this, OQueryNameConflictDialog, OnNameModified));

		m_sUninitializedMessage = m_aMessage.GetText();
		m_aNewName.SetText(_rCurrentName);
		implUpdateMessage(_rCurrentName);
	}

	//---------------------------------------------------------------------
	void OQueryNameConflictDialog::implUpdateMessage(const String& _rName)
	{
		String sNewMessage(m_sUninitializedMessage);
		sNewMessage.SearchAndReplaceAscii("$name$", _rName);
		m_aMessage.SetText(sNewMessage);
		m_sInvalidName = _rName;
		OnNameModified(&m_aNewName);
	}

	//---------------------------------------------------------------------
	IMPL_LINK( OQueryNameConflictDialog, OnNameModified, void*, EMPTYARG )
	{
		sal_Bool bInvalidName = m_aNewName.GetText() == m_sInvalidName;
		m_aOK.Enable(!bInvalidName);
		return 0L;
	}

	//---------------------------------------------------------------------
	IMPL_LINK( OQueryNameConflictDialog, OnOK, void*, EMPTYARG )
	{
		String sNewName = m_aNewName.GetText();
		if (m_xAllNames->hasByName(sNewName))
		{
			implUpdateMessage(sNewName);
			return 1L;
		}

		EndDialog(RET_OK);
		return 0L;
	}

	//=====================================================================
	//= OFormExistsDialog
	//=====================================================================
	//---------------------------------------------------------------------
	OFormExistsDialog::OFormExistsDialog(Window* _pParent, const String& _rCompleteURL)
		:ModalDialog(_pParent, ModuleRes(RID_DLG_FORMNAMINGCONFLICT))
		,m_aExistsLabel		(this, ResId(FT_FILEEXISTS))
		,m_aURL				(this, ResId(ET_EXISTENTNAME))
		,m_aAlternatives	(this, ResId(FT_ALTERNATIVES))
		,m_aOverwrite		(this, ResId(RB_OVERWRITE))
		,m_aSkipForm		(this, ResId(RB_SKIPFORM))
		,m_aSaveAs			(this, ResId(RB_SAVEAS))
		,m_aNewLocalName	(this, ResId(ET_NEWNAME))
		,m_aOK				(this, ResId(PB_FINISH))
		,m_aCancel			(this, ResId(PB_CANCEL))
	{
		FreeResource();

		m_aOverwrite.SetClickHdl(LINK(this, OFormExistsDialog , OnRadioClicked));
		m_aSkipForm.SetClickHdl(LINK(this, OFormExistsDialog , OnRadioClicked));
		m_aSaveAs.SetClickHdl(LINK(this, OFormExistsDialog , OnRadioClicked));

		m_aURL.SetText(_rCompleteURL);

		OFileNotation aTransformer(_rCompleteURL, OFileNotation::N_SYSTEM);
		INetURLObject aURL(aTransformer.get(OFileNotation::N_URL));
		m_aNewLocalName.SetText(aURL.getName());

		m_aSaveAs.Check();
		implCheckEditState();
		m_aNewLocalName.GrabFocus();
	}

	//---------------------------------------------------------------------
	void OFormExistsDialog::implCheckEditState()
	{
		m_aNewLocalName.Enable(m_aSaveAs.IsChecked());
	}

	//---------------------------------------------------------------------
	IMPL_LINK( OFormExistsDialog, OnRadioClicked, void*, NOTINTERESTEDIN )
	{
		implCheckEditState();
		if (m_aSaveAs.IsChecked())
			m_aNewLocalName.GrabFocus();
		return 0L;
	}

//.........................................................................
}	// namespace dbi
//.........................................................................

/*************************************************************************
 * history:
 *	$Log: dbidialogs.cxx,v $
 *	Revision 1.2  2001/03/02 16:57:14  fs
 *	now using the OWizardMachine from svtools / #84575# / minor layout changes
 *	
 *	Revision 1.1  2001/02/12 07:10:37  fs
 *	initial checkin - importing StarOffice 5.2 database files
 *	
 *
 *	Revision 1.0 08.02.01 15:27:21  fs
 ************************************************************************/

