/*************************************************************************
 *
 *  $RCSfile: urlcontrol.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: fs $ $Date: 2001/08/30 15:49:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc..
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_DBI_URLCONTROL_HXX
#include "urlcontrol.hxx"
#endif
#ifndef _OSL_FILE_H_
#include <osl/file.h>
#endif
#ifndef _EXTENSIONS_DBI_FILENOTATION_HXX_
#include "filenotation.hxx"
#endif

//.........................................................................
namespace dbi
{
//.........................................................................

	//=====================================================================
	//= OFileURLControl
	//=====================================================================
	//---------------------------------------------------------------------
	OFileURLControl::OFileURLControl(Window* _pParent)
		:SvtURLBox(_pParent, INET_PROT_FILE)
	{
		DisableHistory();
	}

	//---------------------------------------------------------------------
	OFileURLControl::OFileURLControl(Window* _pParent, const ResId& _rId)
		:SvtURLBox(_pParent, _rId, INET_PROT_FILE)
	{
		DisableHistory();
	}

	//---------------------------------------------------------------------
	long OFileURLControl::PreNotify( NotifyEvent& _rNEvt )
	{
		if (GetSubEdit() == _rNEvt.GetWindow())
			if (EVENT_KEYINPUT == _rNEvt.GetType())
				if (KEY_RETURN == _rNEvt.GetKeyEvent()->GetKeyCode().GetCode())
					if (IsInDropDown())
						m_sPreservedText = GetURL();

		return SvtURLBox::PreNotify(_rNEvt);
	}

	//---------------------------------------------------------------------
	long OFileURLControl::Notify( NotifyEvent& _rNEvt )
	{
		if (GetSubEdit() == _rNEvt.GetWindow())
			if (EVENT_KEYINPUT == _rNEvt.GetType())
				if (KEY_RETURN == _rNEvt.GetKeyEvent()->GetKeyCode().GetCode())
					if (IsInDropDown())
					{
						long nReturn = SvtURLBox::Notify(_rNEvt);

						// build a system dependent (thus more user readable) file name
						OFileNotation aTransformer(m_sPreservedText, OFileNotation::N_URL);
						SetText(aTransformer.get(OFileNotation::N_SYSTEM));
						Modify();

						// Update the pick list
						UpdatePickList();

						return nReturn;
					}

		return SvtURLBox::Notify(_rNEvt);
	}

//.........................................................................
}	// namespace dbi
//.........................................................................

/*************************************************************************
 * history:
 *	$Log: urlcontrol.cxx,v $
 *	Revision 1.4  2001/08/30 15:49:14  fs
 *	#91440# UpdaetPickList when doing the late SetText
 *	
 *	Revision 1.3  2001/07/09 14:38:18  dv
 *	#89176# SfxURLBOX has been moved to svtools and was renamed to SvtURLBox
 *	
 *	Revision 1.2  2001/04/12 10:17:11  fs
 *	#85872# use DisableHistory
 *	
 *	Revision 1.1  2001/02/12 07:16:32  fs
 *	initial checkin - importing StarOffice 5.2 database files
 *	
 *
 *	Revision 1.0 31.01.01 13:57:49  fs
 ************************************************************************/

