/*************************************************************************
 *
 *  $RCSfile: contenttaskenv.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:46 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef HIERARCHY_CONTENTTASKENVIRONMENT_HXX
#define HIERARCHY_CONTENTTASKENVIRONMENT_HXX

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _COM_SUN_STAR_UCB_XCONTENTTASKENVIRONMENT_HPP_
#include <com/sun/star/ucb/XContentTaskEnvironment.hpp>
#endif

#if defined(TF_TYPE) || (SUPD >= 564)
using namespace cppu;
#endif

using namespace com::sun::star::uno;
using namespace com::sun::star::ucb;
using namespace com::sun::star::task;

class OContentTaskWrapper :
public XContentTaskEnvironment,
public XContentTaskClient,
public XContentTask,
public OWeakObject
{
protected:
	safe_list< Reference< XContentTask > >	m_aTaskList;
	Reference< XEnvironment >				m_xEnvironment;

public:
	OContentTaskWrapper( const Reference< XContentTaskEnvironment > & xEnv );

    //	XInterface
#if defined(TF_TYPE) || (SUPD >= 564)
	virtual Any SAL_CALL queryInterface( const Type& type ) throw( RuntimeException );
#else
	virtual sal_Bool SAL_CALL queryInterface( const Uik& aUik, Any& ifc ) throw(RuntimeException);
#endif

	virtual void SAL_CALL acquire() throw(RuntimeException) { OWeakObject::acquire(); };
    virtual void SAL_CALL release() throw(RuntimeException) { OWeakObject::release(); };


	//	XContentTaskEnvironment
	virtual Reference< XContentTaskClient > SAL_CALL getClient() throw(RuntimeException) { return this };

    // returns the interaction handler to report errors to.
    virtual Reference< XInteractionHandler > SAL_CALL getInteractionHandler() throw(RuntimeException) { return m_xEnvironment->getInterActionHandler() };

    // returns the handler that should receive progress notifications.
    virtual Reference< XProgressHandler > SAL_CALL getProgressHandler() throw(RuntimeException) { return m_xEnvironment->getProgressHandler() };



};


Reference< XCommandTask > OContentHolder::createCommandTask( const Command& TheCommand, const Reference< XContentTaskEnvironment >& Environment )
{
	Reference< XEnvironment >	xEnvironmentWrapper = new OContentTaskWrapper( xEnvironment );

	Reference< XCommandTask >	xTask1 = createCommandTask( TheCommand, xEnvironmentWrapper );
	Reference< XCommandTask >	xTask2 = createCommandTask( TheCommand, xEnvironmentWrapper ); 

	return
}


void OTaskWrapper::start()
{
	for ( safe_list< Reference< XContentTask > >::iterator it = m_aTaskList::begin(); it != m_aTaskList.end(); it++ )
		it->start();
}


void OTaskWrapper::execute()
{
	for ( safe_list< Reference< XContentTask > >::iterator it = m_aTaskList::begin(); it != m_aTaskList.end(); it++ )
		it->execute();
}

void OTaskWrapper::abort()
{
	for ( safe_list< Reference< XContentTask > >::iterator it = m_aTaskList::begin(); it != m_aTaskList.end(); it++ )
		it->abort();
}

OTaskWrapper::contentTaskEvent()
{
	switch( Event )
	{
	case CREATED:
		if( !m_bCreaedPropagated )
			m_xClient->contentTaskEvent( Event );
		m_aTaskList.pushback( rEvent.Source );
		status = created;
		break;
	case RUNNING:
		if ( !m_bRunningPropagated )
			m_xClient->contentTaskEvent( Event );
		break;
	case DONE:

	}
}


class OContentTaskEnvironment: 
public XContentTaskEnvironment,
public XContentTaskClient,
public OWeakObject
{
public:

	OContentTaskEnvironment(Reference< XContentTaskEnvironment > xEnvironment);

    /*
     * XInterface
     */

    // query interface
#if defined(TF_TYPE) || (SUPD >= 564)
	virtual Any SAL_CALL queryInterface( const Type& type ) throw( RuntimeException );
#else
	virtual sal_Bool SAL_CALL queryInterface( const Uik& aUik, Any& ifc ) throw(RuntimeException);
#endif

    // increase refcount
	virtual void SAL_CALL acquire() throw(RuntimeException) { OWeakObject::acquire(); };

    // decrease refcount
    virtual void SAL_CALL release() throw(RuntimeException) { OWeakObject::release(); };

    /*
     * XContentTaskEnvironment
     */

    // returns the client that should receive status notifications.
	virtual Reference< XContentTaskClient > SAL_CALL getClient() throw(RuntimeException);

    // returns the interaction handler to report errors to.
    virtual Reference< XInteractionHandler > SAL_CALL getInteractionHandler() throw(RuntimeException);

    // returns the handler that should receive progress notifications.
    virtual Reference< XProgressHandler > SAL_CALL getProgressHandler() throw(RuntimeException);

protected:
	~OContentTaskEnvironment();

private:

    // original environment
	Reference< XContentTaskEnvironment > m_xEnvironment;
};

#endif /* HIERARCHY_CONTENTTASKENVIRONMENT_HXX */

