/*************************************************************************
 *
 *  $RCSfile: encode.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:47 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include "flatany.hxx"

#include <rtl/string.hxx>
#include <osl/diagnose.h>

using namespace rtl;
using namespace com::sun::star::uno;

inline sal_Char getCharFromNibble( sal_Int8 nibble )
{
	if ( nibble >= 0x0A && nibble <= 0x0F )
		return nibble - 10 + 'A';
	else if ( nibble >= 0 && nibble <= 9 )
		return nibble + '0';
	else
		return '\0';
}

inline sal_Int8 getNibbleFromChar( sal_Char c )
{
	if ( c >= 'a' && c <= 'f' )
		return c - 'a' + 10;
	else if ( c >= 'A' && c <= 'F' )
		return c - 'A' + 10;
	else if ( c >= '0' && c <= '9' )
		return c - '0';
	else
		return -1;
}


OString encodeHierarchyIdentifier( const Sequence< Any > & id, sal_Char OpenDelimiter, sal_Char CloseDelimiter )
{
	OString	aResult;

	int	len = id.getLength();

	for ( int i = 0; i < len; i++ )
	{
		Sequence< sal_Int8 >	aToken = anySerialize( id[i] );
		int	nTokenLen = aToken.getLength();

		aResult += OString( &OpenDelimiter, 1 ) ;

		for ( int j = 0; j < nTokenLen; j++ )
		{
			sal_uInt8	value = (sal_uInt8)aToken[j];
			sal_Char	cEncoded[2];

			cEncoded[0] = getCharFromNibble( value % 16 );
			cEncoded[1] = getCharFromNibble( value / 16 );
			aResult += OString( cEncoded, sizeof(cEncoded) / sizeof(sal_Char) );
		}

		aResult += OString( &CloseDelimiter, 1 );
	}

	return aResult;
}


Sequence< Any > decodeHierarchyIdentifier( const OString & str, sal_Char OpenDelimiter, sal_Char CloseDelimiter )
{
	Sequence< Any >	aResult;
	int	nResultLen = 0;
	int nStrLen = str.getLength();


	int nCloseDelimiterIndex = -1;
	int nOpenDelimiterIndex = str.indexOf( OpenDelimiter );

	while ( nOpenDelimiterIndex >= 0 )
	{
		nCloseDelimiterIndex = str.indexOf( CloseDelimiter, nOpenDelimiterIndex + 1 );
		OSL_ASSERT( nCloseDelimiterIndex > nOpenDelimiterIndex );

		OString	aToken = str.copy( nOpenDelimiterIndex + 1, nCloseDelimiterIndex - nOpenDelimiterIndex - 1 );
		int nTokenLen = aToken.getLength();
		OSL_ASSERT( nTokenLen % 2 == 0 );
		
		Sequence< sal_Int8 > aSeq( (nTokenLen + 1) / 2 );
		int	nSeqLen = aSeq.getLength();

		for ( int i = 0; i < nSeqLen; i++ )
		{
			sal_Int8 loNibble = getNibbleFromChar( aToken.getStr()[2 * i] );
			OSL_ASSERT( loNibble >= 0 && loNibble <= 0x0F );

			sal_Int8 hiNibble = getNibbleFromChar( aToken.getStr()[2 * i + 1] );
			OSL_ASSERT( hiNibble >= 0 && loNibble <= 0x0F );

			sal_Int8	aByte = (sal_Int8)((sal_uInt8)loNibble + 16 * (sal_uInt8)hiNibble);
			aSeq[i] =	aByte;
		}

		aResult.realloc( nResultLen + 1 );
		aResult[ nResultLen++ ] = anyDeserialize( aSeq );

		nOpenDelimiterIndex = str.indexOf( OpenDelimiter, nCloseDelimiterIndex + 1 );
		OSL_ASSERT( nOpenDelimiterIndex == nCloseDelimiterIndex + 1 || nOpenDelimiterIndex < 0 && nCloseDelimiterIndex + 1 == nStrLen );
	}

	return aResult;
}


