/*************************************************************************
 *
 *  $RCSfile: inimanager.hxx,v $
 *
 *  $Revision: 1.2 $
 *
 *  last change: $Author: hr $ $Date: 2001/11/02 11:08:07 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_INIMANAGER_HXX_
#define _EXTENSIONS_INIMANAGER_HXX_

//_______________________________________________________________________________________________________________________
//	includes of other projects
//_______________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_XMODIFYLISTENER_HPP_
#include <com/sun/star/util/XModifyListener.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_XMODIFIABLE_HPP_
#include <com/sun/star/util/XModifiable.hpp>
#endif

#ifndef _COM_SUN_STAR_UTIL_XMODIFYBROADCASTER_HPP_
#include <com/sun/star/util/XModifyBroadcaster.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XSERVICENAME_HPP_
#include <com/sun/star/lang/XServiceName.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XTYPEPROVIDER_HPP_
#include <com/sun/star/lang/XTypeProvider.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XSINGLESERVICEFACTORY_HPP_
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_MERGECONFLICTEXCEPTION_HPP_
#include <com/sun/star/registry/MergeConflictException.hpp>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_XSIMPLEREGISTRY_HPP_
#include <com/sun/star/registry/XSimpleRegistry.hpp>
#endif

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif

//_______________________________________________________________________________________________________________________
//	includes of my own project
//_______________________________________________________________________________________________________________________

#ifndef _EXTENSIONS_ROOTKEY_HXX_
#include "rootkey.hxx"
#endif

#ifndef _EXTENSIONS_PROFILECACHE_HXX_
#include "profilecache.hxx"
#endif

//_______________________________________________________________________________________________________________________
//	defines and namespaces :-)
//_______________________________________________________________________________________________________________________

namespace com{
	namespace sun{
		namespace star{
			namespace comp{
				namespace extensions{
					namespace inimanager{

#define	XREGISTRYKEY				::com::sun::star::registry::XRegistryKey
#define	XTYPEPROVIDER				::com::sun::star::lang::XTypeProvider
#define	XSERVICEINFO				::com::sun::star::lang::XServiceInfo
#define	XSIMPLEREGISTRY				::com::sun::star::registry::XSimpleRegistry
#define	XMULTISERVICEFACTORY		::com::sun::star::lang::XMultiServiceFactory
#define	OUSTRING					::rtl::OUString
#define	OWEAKOBJECT					::cppu::OWeakObject
#define	INVALIDREGISTRYEXCEPTION	::com::sun::star::registry::InvalidRegistryException
#define	RUNTIMEEXCEPTION			::com::sun::star::uno::RuntimeException
#define	MERGECONFLICTEXCEPTION		::com::sun::star::registry::MergeConflictException
#define	ANY							::com::sun::star::uno::Any
#define	MUTEX						::osl::Mutex
#define	REFERENCE					::com::sun::star::uno::Reference
#define	SEQUENCE					::com::sun::star::uno::Sequence
#define	UNOTYPE						::com::sun::star::uno::Type

//_______________________________________________________________________________________________________________________
//	declaration of structs and typedefs
//_______________________________________________________________________________________________________________________

struct IMPL_MutexContainer
{
	MUTEX m_aMutex ;
};	// struct IMPL_MutexContainer

//_______________________________________________________________________________________________________________________
//	class declaration
//_______________________________________________________________________________________________________________________

class INIManager	: public XTYPEPROVIDER
					, public XSERVICEINFO
					, public XSIMPLEREGISTRY
					, public IMPL_MutexContainer
					, public OWEAKOBJECT
{

//_______________________________________________________________________________________________________________________
//	public methods
//_______________________________________________________________________________________________________________________

public:

	//____________________________________________________________________________________________________
	//	constructor / destructor
	//____________________________________________________________________________________________________

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	INIManager( const REFERENCE< XMULTISERVICEFACTORY >& xFactory );

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

	virtual	~INIManager();

	//____________________________________________________________________________________________________
	//	XSimpleRegistry
	//____________________________________________________________________________________________________

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual void SAL_CALL open(	const	OUSTRING&	sURL		,
										sal_Bool	bReadOnly	,
										sal_Bool	bCreate		) throw(	INVALIDREGISTRYEXCEPTION	,
																			RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual void SAL_CALL close() throw(	INVALIDREGISTRYEXCEPTION	,
											RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual void SAL_CALL destroy() throw(	INVALIDREGISTRYEXCEPTION	,
											RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual void SAL_CALL mergeKey(	const	OUSTRING&	sKeyName	,
									const	OUSTRING&	sURL		) throw(	INVALIDREGISTRYEXCEPTION	,
																				MERGECONFLICTEXCEPTION		,
																				RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual OUSTRING SAL_CALL getURL() throw( RUNTIMEEXCEPTION );

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual REFERENCE< XREGISTRYKEY > SAL_CALL getRootKey() throw(	INVALIDREGISTRYEXCEPTION	,
																	RUNTIMEEXCEPTION			);

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual sal_Bool SAL_CALL isValid() throw( RUNTIMEEXCEPTION );

	/**___________________________________________________________________________________________________
		@short		-
		@descr		-

		@seealso	-

		@param		-

		@return		-

		@onerror	-
	*/

    virtual sal_Bool SAL_CALL isReadOnly() throw(	INVALIDREGISTRYEXCEPTION	,
													RUNTIMEEXCEPTION			);

	//____________________________________________________________________________________________________
	//	XInterface
	//____________________________________________________________________________________________________

	/**___________________________________________________________________________________________________
		@short		give answer, if interface is supported
		@descr		The interfaces are searched by type.

		@seealso	XInterface

		@param      "rType" is the type of searched interface.

		@return		Any		information about found interface

		@onerror	A RuntimeException is thrown.
	*/

	virtual ANY SAL_CALL queryInterface( const UNOTYPE& aType ) throw( RUNTIMEEXCEPTION );

	/**___________________________________________________________________________________________________
		@short		increment refcount
		@descr		-

		@seealso	XInterface
		@seealso	release()

		@param		-

		@return		-

		@onerror	A RuntimeException is thrown.
	*/

    virtual void SAL_CALL acquire() throw() ;

	/**___________________________________________________________________________________________________
		@short		decrement refcount
		@descr		-

		@seealso	XInterface
		@seealso	acquire()

		@param		-

		@return		-

		@onerror	A RuntimeException is thrown.
	*/

    virtual void SAL_CALL release() throw() ;

	//____________________________________________________________________________________________________
	//	XTypeProvider
	//____________________________________________________________________________________________________

	/**___________________________________________________________________________________________________
		@short		get information about supported interfaces
		@descr      -

		@seealso	XTypeProvider

		@param      -

		@return		Sequence of types of all supported interfaces

		@onerror	A RuntimeException is thrown.
	*/

	virtual SEQUENCE< UNOTYPE > SAL_CALL getTypes() throw( RUNTIMEEXCEPTION ) ;

	/**___________________________________________________________________________________________________
		@short		get implementation id
		@descr      This ID is neccessary for UNO-caching. If there no ID, cache is disabled.
					Another way, cache is enabled.

		@seealso	XTypeProvider

		@param		-

		@return		ID as Sequence of byte

		@onerror	A RuntimeException is thrown.
	*/

	virtual SEQUENCE< sal_Int8 > SAL_CALL getImplementationId() throw( RUNTIMEEXCEPTION ) ;

	//____________________________________________________________________________________________________
	//	XServiceInfo
	//____________________________________________________________________________________________________

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

    virtual OUSTRING SAL_CALL getImplementationName() throw( RUNTIMEEXCEPTION );

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

    virtual sal_Bool SAL_CALL supportsService( const OUSTRING& sServiceName ) throw( RUNTIMEEXCEPTION );

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

    virtual SEQUENCE< OUSTRING > SAL_CALL getSupportedServiceNames() throw( RUNTIMEEXCEPTION );

	//____________________________________________________________________________________________________
	//	public impl. and static methods to register service
	//____________________________________________________________________________________________________

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

	static SEQUENCE< OUSTRING > impl_getStaticSupportedServiceNames();

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

	static OUSTRING impl_getStaticImplementationName();

//_______________________________________________________________________________________________________________________
//	protected methods
//_______________________________________________________________________________________________________________________

protected:

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

    void impl_addPropertyChangeListener(	const	OUSTRING&								sKeyName	,
											const	REFERENCE< XPROPERTYCHANGELISTENER >&	xListener	) throw( RUNTIMEEXCEPTION );

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

    void impl_removePropertyChangeListener(	const	OUSTRING&								sKeyName	,
											const	REFERENCE< XPROPERTYCHANGELISTENER >&	xListener	) throw( RUNTIMEEXCEPTION );

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

    void impl_addModifyListener( const REFERENCE< XMODIFYLISTENER >& xListener ) throw( RUNTIMEEXCEPTION );

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

    void impl_removeModifyListener( const REFERENCE< XMODIFYLISTENER >& xListener ) throw( RUNTIMEEXCEPTION );

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

	void impl_setConfigManagerReference( XINTERFACE* pConfigManager );

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

	void impl_disposing( const EVENTOBJECT& aEvent ) throw( RUNTIMEEXCEPTION );

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

	REFERENCE< XMULTISERVICEFACTORY >& impl_getFactoryReference();

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

	void impl_flush();

//_______________________________________________________________________________________________________________________
//	private methods
//_______________________________________________________________________________________________________________________

private:

	/**___________________________________________________________________________________________________
		@short
		@descr

		@seealso

		@param

		@return

		@onerror
	*/

	void impl_resetObject();

//_______________________________________________________________________________________________________________________
//	debug and check methods
//_______________________________________________________________________________________________________________________

#ifdef _DEBUG

private:

	sal_Bool impl_checkParameter_open	(	const	OUSTRING&	sURL		,
													sal_Bool	bReadOnly	,
													sal_Bool	bCreate		);

#endif // #ifdef DEBUG

//_______________________________________________________________________________________________________________________
// private variables
//_______________________________________________________________________________________________________________________

protected:

	OUSTRING								m_sURL			;	// Name of INI-file

private:

	REFERENCE< XMULTISERVICEFACTORY > 		m_xFactory		;
 	ProfileCache							m_aINIFile		;	// Pointer to opened INI-file
	sal_Bool								m_bIsReadOnly	;	// State of file
	sal_Bool								m_bIsOpen		;	// State of file

};	// class INIManager

     } // namespace inimanager
    } // namespace extensions
   } // namespace comp
  } // namespace star
 } // namespace sun
} // namespace com

#endif	// #ifndef _EXTENSIONS_INIMANAGER_HXX_
