/*************************************************************************
 *
 *  $RCSfile: inetset.cxx,v $
 *
 *  $Revision: 1.4 $
 *
 *  last change: $Author: th $ $Date: 2001/05/11 10:07:54 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "inetset.hxx"

#ifndef _CPPUHELPER_FACTORY_HXX_
#include <cppuhelper/factory.hxx>
#endif

#ifndef _UNO_MAPPING_HXX_
#include <uno/mapping.hxx>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HPP_
#include <com/sun/star/registry/XRegistryKey.hpp>
#endif

#ifndef _OSL_DIAGNOSE_H_
#include <osl/diagnose.h>
#endif

using namespace ::osl;
using namespace ::cppu;
using namespace com::sun::star::registry;
using namespace ::rtl;


/* --- XInterface --------------------------------------------------------- */
Any SAL_CALL Directory::queryInterface(const Type& aType)
    throw(RuntimeException)
{
    Any aRet = ::cppu::queryInterface(aType, static_cast < XNameAccess *>
      (this), static_cast < XElementAccess *> (this));
    return aRet.hasValue() ? aRet : OWeakObject::queryInterface(aType);
}

/* --- Methoden von XElementAccess ---------------------------------------- */
Type SAL_CALL Directory::getElementType() throw(RuntimeException)
{ // !!!
    return ::getCppuType((Any *) 0);
}

sal_Bool SAL_CALL Directory::hasElements(void) throw(RuntimeException)
{
    return (mnUsed > 0);
}

/* --- Methoden von XNameAccess ------------------------------------------- */
Sequence<OUString> SAL_CALL Directory::getElementNames(void)
  throw(RuntimeException)
{
    OUString *names = new OUString[mnUsed];
    for (int i = mnUsed - 1; i >= 0; i--) names[i] = maEntries[i]->name;
    return Sequence<OUString>(names, mnUsed);
}

Any SAL_CALL Directory::getByName(const OUString& aName)
  throw(NoSuchElementException, WrappedTargetException, RuntimeException)
{
    Entry *e = get(aName);
    if (e) return e->value;
    throw NoSuchElementException();
    return Any();
}

sal_Bool SAL_CALL Directory::hasByName(const OUString& aName)
  throw(RuntimeException)
{
    return (get(aName) != 0);
}

/* --- Methoden von Directory --------------------------------------------- */
#ifdef debug_br
int NewDisposeCounter = 0;
#endif

Directory::Directory(sal_Bool isRoot)
{
#ifdef debug_br
    NewDisposeCounter++;
#endif
    mbIsRoot = isRoot;
    mnSize = 8;
    maEntries = new Entry*[mnSize];
    mnUsed = 0;
    if (isRoot)
    {
        Directory *alle = new Directory(sal_False);
#if defined(SAL_W32) || defined(SAL_UNX)
        readNetscape(this);
  #if defined(SAL_W32)
        readIExplorer(this);
        readOutlook(this);
  #endif
#endif
        readStarOffice(this);
        copySub(this, alle, rtl::OUString::createFromAscii("browser"));
        copySub(this, alle, rtl::OUString::createFromAscii("mail"));
        copySub(this, alle, rtl::OUString::createFromAscii("news"));
        insert(createSub("alle", alle));
        // insert "alle" always (even if it's empty)
    }
}

Directory::~Directory()
{
    for (int i = mnUsed - 1; i >= 0; i--)
    {
        maEntries[i]->value = Any(); // clear references
        delete maEntries[i];
    }
    delete maEntries;
#ifdef debug_br
    NewDisposeCounter--;
    if (mbIsRoot)
    {
        int j = NewDisposeCounter;
        // to set a breakpoint on it; NewDisposeCounter should be 0 here
    }
#endif
}

void Directory::copySub(Directory *src, Directory *dst, const OUString &name)
{
    int i = indexOf(name);
    if (i < 0) return; // nicht vorhanden
    Directory *srcAble = src->maEntries[i]->dir;
    for (int j = 0; j < srcAble->mnUsed; j++)
    {
        OUString srcAppName = srcAble->maEntries[j]->name;
        Directory *srcApp = srcAble->maEntries[j]->dir;

        OUString dstAppName(srcAppName);
#ifdef SAL_W32
        if ((srcAppName == L"Internet Explorer") ||
            (srcAppName == L"OutlookExpress")) // ugly
        {
            dstAppName = L"Internet Explorer & Outlook Express";
        }
#endif
        Directory *dstApp = dst->_createSub(dstAppName);
        Directory *dstAble = dstApp->_createSub(name);
        for (int l = 0; l < srcApp->mnUsed; l++)
            dstAble->insert(copyEntry(srcApp->maEntries[l]));
    }
}

Directory *Directory::_createSub(const OUString& aSubName)
{
    int i = indexOf(aSubName);
    if (i >= 0) return maEntries[i]->dir;
    Directory *sub = new Directory(sal_False);
    insert(createSub(aSubName, sub));
    return sub;
}

Entry *Directory::get(const OUString& aName) const
{
    int i = indexOf(aName);
    if (i < 0) return 0;
    return maEntries[i];
}

int Directory::indexOf(const OUString& aName) const
{
    int l, m, r;
    l = 0;
    r = mnUsed;
    while (l < r)
    {
        m = (l + r) / 2;
        if (maEntries[m]->name < aName) l = m + 1; else r = m;
    }
    if (r < mnUsed) if (maEntries[r]->name == aName) return r;
    return ~r;
}

int Directory::insert(Entry *aEntry, const OUString& aPath)
{
    sal_Int32 slash = aPath.indexOf('/');
    if (slash < 0)
    { // aPath have only one subdir
        Directory *sub = _createSub(aPath);
        if (!sub) return -1;
        int res = sub->insert(aEntry);
        return res;
    }
    else
    { // aPath have at least two subdirs
        OUString subName = aPath.copy(0, slash);
        Directory *sub = _createSub(subName);
        if (!sub) return -1;
        int res = sub->insert(aEntry, aPath.copy(slash + 1));
        return res;
    }
}

int Directory::insert(Entry *aEntry)
{
    int i = indexOf(aEntry->name);
    if (i >= 0) return i;
    if (mnUsed == mnSize)
    { // expand array
        int oldSize = mnSize;
        mnSize = (mnSize * 5) >> 2; // mnSize *= 1.25
        Entry **oldEntry = maEntries;
        maEntries = new Entry*[mnSize];
        memcpy(maEntries, oldEntry, mnUsed * sizeof(maEntries[0]));
        delete oldEntry;
    }
    i = ~i;
    if (i < mnUsed) memmove(maEntries + i + 1, maEntries + i,
                            (mnUsed - i) * sizeof(maEntries[0]));
    maEntries[i] = aEntry;
    mnUsed++;
    return i;
}

sal_Bool Directory::remove(const OUString& aName)
{
    int i = indexOf(aName);
    if (i < 0) return sal_False;
    delete maEntries[i];
    if (i != mnUsed - 1) memmove(maEntries + i, maEntries + i + 1,
                                 (mnUsed - i - 1) * sizeof(maEntries[0]));
    mnUsed--;
    return sal_True;
}

// --- statics ---------------------------------------------------------------
static OUString Inetset_getImplementationName()
{
    return OUString::createFromAscii(INETSET_IMPLEMENTATION_NAME);
}

static Sequence<OUString> Inetset_getSupportedServiceNames()
{
    OUString aName(OUString::createFromAscii(INETSET_SERVICE_NAME));
    Sequence<OUString> aSeq(&aName, 1);
    return aSeq;
}

static Reference<XInterface> SAL_CALL Inetset_createInstance(
    const Reference<XMultiServiceFactory> &rxManager)
{
    Reference<XInterface> xInst(
        SAL_STATIC_CAST(::cppu::OWeakObject *, new Directory(true)));
    return xInst;
}

static Reference<XSingleServiceFactory> Inetset_createServiceFactory (
    const Reference<XMultiServiceFactory> &rxManager)
{
    Reference<XSingleServiceFactory> xFactory (
        cppu::createSingleFactory (
            rxManager,
            Inetset_getImplementationName(),
            Inetset_createInstance,
            Inetset_getSupportedServiceNames()));
    return xFactory;
}

//-----------------------------------------------------------------------
// registration
//-----------------------------------------------------------------------

extern "C"
{
    //-------------------------------------------------------------------
    // component_getImplementationEnvironment
    //-------------------------------------------------------------------

    void SAL_CALL component_getImplementationEnvironment(
        const sal_Char** ppEnvTypeName, uno_Environment** ppEnv )
    {
        *ppEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
    }

    //-------------------------------------------------------------------
    // component_writeInfo
    //-------------------------------------------------------------------

    sal_Bool SAL_CALL component_writeInfo( void* pServiceManager, void* pRegistryKey )
    {
        sal_Bool bRet = sal_False;

        if ( pRegistryKey )
        {
            try
            {
                Reference< XRegistryKey > xNewRegKey(
                    reinterpret_cast< XRegistryKey* >( pRegistryKey )->createKey(
                    OUString::createFromAscii( "/" INETSET_IMPLEMENTATION_NAME "/UNO/SERVICES" ) ) );

                Sequence< OUString >& rSNL = Inetset_getSupportedServiceNames( );
                const OUString* pArray = rSNL.getConstArray( );
                for ( sal_Int32 i = rSNL.getLength( ); i--; /* empty */ )
                    xNewRegKey->createKey( pArray[i] );

                bRet = sal_True;

            }
            catch( InvalidRegistryException& )
            {
                OSL_ENSURE( sal_False, "### InvalidRegistryException!" );
            }
        }

        return bRet;
    }

    //-------------------------------------------------------------------
    // component_getFactory
    //-------------------------------------------------------------------

    void* SAL_CALL component_getFactory(
        const sal_Char* pImplName, void* pServiceManager, void* pRegistryKey )
    {
        void* pRet = 0;

        if ( 0 == rtl_str_compare( pImplName, INETSET_IMPLEMENTATION_NAME ) )
        {
            Reference< XSingleServiceFactory > xFactory( createOneInstanceFactory(
                reinterpret_cast< XMultiServiceFactory* >( pServiceManager ),
                OUString::createFromAscii( pImplName ),
                Inetset_createInstance,
                Inetset_getSupportedServiceNames( ) ) );

            if ( xFactory.is( ) )
            {
                xFactory->acquire( );
                pRet = xFactory.get( );
            }
        }

        return pRet;
    }

} // extern "C"


/* --- CVS-LogText -------------------------------------------------------- */
