/*************************************************************************
 *
 *  $RCSfile: pgpimpl.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_PGP_PGPIMPL_HXX
#define _EXTENSIONS_PGP_PGPIMPL_HXX "$Revision: 1.1.1.1 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_ANY_H_
#include <com/sun/star/uno/Any.h>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif

#ifndef _COM_SUN_STAR_PGP_XPGPENCODER_HPP_
#include <com/sun/star/pgp/XPGPEncoder.hpp>
#endif
#ifndef _COM_SUN_STAR_PGP_XPGPDECODER_HPP_
#include <com/sun/star/pgp/XPGPDecoder.hpp>
#endif
#ifndef _COM_SUN_STAR_PGP_XPGPDECODERLISTENER_HPP_
#include <com/sun/star/pgp/XPGPDecoderListener.hpp>
#endif

#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _EXTENSIONS_PGP_PGPTYPES_HXX
#include "pgptypes.hxx"
#endif

/*========================================================================
 *
 * PGPCodec_Impl internals.
 *
 *======================================================================*/
namespace com
{
namespace sun
{
namespace star
{
namespace pgp
{
					
typedef com::sun::star::io::XInputStream  istream_type;
typedef com::sun::star::io::XOutputStream ostream_type;

/*========================================================================
 *
 * PGPCodec_Impl interface.
 *
 *======================================================================*/
class PGPCodec_Impl : public cppu::OWeakObject
{
public:
	PGPCodec_Impl (void);

	/** XInterface.
	 */
	virtual com::sun::star::uno::Any
	SAL_CALL queryInterface (
		const com::sun::star::uno::Type &rType)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL acquire (void)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL release (void)
		throw (com::sun::star::uno::RuntimeException);

protected:
	/** Destruction.
	 */
	virtual ~PGPCodec_Impl (void);

	/** Operation.
	 */
	sal_Bool transportData (
		const com::sun::star::uno::Reference<istream_type> &rxInput,
		const com::sun::star::uno::Reference<ostream_type> &rxOutput)
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Bool codeData (
		com::sun::star::uno::Sequence<sal_Int8> &rBuffer);

private:
	/** Representation.
	 */
	com::sun::star::uno::Sequence<sal_Int8> m_buffer;
};

/*========================================================================
 *
 * PGPEncoderContext_Impl interface.
 *
 *======================================================================*/
struct PGPEncoderContext_Impl
{
	PGPContextRef    m_context;
	PGPKeySetRef     m_keyring;
	PGPOptionListRef m_options;

	PGPEncoderContext_Impl (void);
	~PGPEncoderContext_Impl (void);

	sal_Bool prepareEncrypt (
		const com::sun::star::uno::Sequence<rtl::OUString> &rRecipients);

	sal_Bool prepareSign    (sal_Bool bDataIsAscii);
	sal_Bool prepareOutput  (sal_Bool bDataIsAscii);

	sal_Bool encode (
		com::sun::star::uno::Sequence<sal_Int8> &rBuffer);
};

/*========================================================================
 *
 * PGPEncoder_Impl interface.
 *
 *======================================================================*/
class PGPEncoder_Impl : public XPGPEncoder, public PGPCodec_Impl
{
public:
	PGPEncoder_Impl (void);

	/** XInterface.
	 */
	virtual com::sun::star::uno::Any
	SAL_CALL queryInterface (
		const com::sun::star::uno::Type &rType)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL acquire (void)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL release (void)
		throw (com::sun::star::uno::RuntimeException);

	/** XPGPEncoder.
	 */
	virtual sal_Bool SAL_CALL encryptAndSign (
		const com::sun::star::uno::Sequence<rtl::OUString> &rRecipients,
		const com::sun::star::uno::Reference<istream_type> &rxPlainText,
		const com::sun::star::uno::Reference<ostream_type> &rxCipherText)
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL encrypt (
		const com::sun::star::uno::Sequence<rtl::OUString> &rRecipients,
		const com::sun::star::uno::Reference<istream_type> &rxPlainText,
		const com::sun::star::uno::Reference<ostream_type> &rxCipherText)
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL sign (
		sal_Bool                                            bDataIsAscii,
		const com::sun::star::uno::Reference<istream_type> &rxPlainText,
		const com::sun::star::uno::Reference<ostream_type> &rxCipherText)
		throw (com::sun::star::uno::RuntimeException);

protected:
	/** Destruction.
	 */
	virtual ~PGPEncoder_Impl (void);

private:
	/** Representation.
	 */
	PGPEncoderContext_Impl m_context;

	/** Operation.
	 */
	virtual sal_Bool codeData (
		com::sun::star::uno::Sequence<sal_Int8> &rBuffer);
};

/*========================================================================
 *
 * PGPDecoderContext_Impl interface.
 *
 *======================================================================*/
struct PGPDecoderContext_Impl
{
	PGPContextRef          m_context;
	PGPKeySetRef           m_keyring;
	PGPKeySetRef           m_recipients;
	const PGPKeyID        *m_keyidlist;
	PGPUInt32              m_keyidcount;
	PGPOptionListRef       m_options;

	com::sun::star::uno::Reference<XPGPDecoderListener> m_listener;

	PGPDecoderContext_Impl (void);
	~PGPDecoderContext_Impl (void);

	sal_Bool prepareDecode (void);
	sal_Bool decode (
		com::sun::star::uno::Sequence<sal_Int8> &rBuffer);

	void setRecipients (
		PGPKeySetRef   Recipients,
		const PGPKeyID KeyIDList[],
		PGPUInt32      KeyIDCount);
};

/*========================================================================
 *
 * PGPDecoder_Impl interface.
 *
 *======================================================================*/
class PGPDecoder_Impl : public XPGPDecoder, public PGPCodec_Impl
{
public:
	PGPDecoder_Impl (void);

	/** XInterface.
	 */
	virtual com::sun::star::uno::Any
	SAL_CALL queryInterface (
		const com::sun::star::uno::Type &rType)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL acquire (void)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL release (void)
		throw (com::sun::star::uno::RuntimeException);

	/** XPGPDecoder.
	 */
	virtual void SAL_CALL addDecoderListener (
		const com::sun::star::uno::Reference<XPGPDecoderListener> &rxListener)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL removeDecoderListener (
		const com::sun::star::uno::Reference<XPGPDecoderListener> &rxListener)
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL decryptAndVerify (
		const com::sun::star::uno::Reference<istream_type> &rxCipherText,
		const com::sun::star::uno::Reference<ostream_type> &rxPlainText)
		throw (com::sun::star::uno::RuntimeException);

protected:
	/** Destruction.
	 */
	virtual ~PGPDecoder_Impl (void);

private:
	/** Representation.
	 */
	PGPDecoderContext_Impl m_context;

	/** Operation.
	 */
	virtual sal_Bool codeData (
		com::sun::star::uno::Sequence<sal_Int8> &rBuffer);
};

/*========================================================================
 *
 * The End.
 *
 *======================================================================*/

} // pgp
} // star
} // sun
} // com

#endif /* _EXTENSIONS_PGP_PGPIMPL_HXX */

