/*************************************************************************
 *
 *  $RCSfile: pgpmain.hxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:49 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _EXTENSIONS_PGP_PGPMAIN_HXX
#define _EXTENSIONS_PGP_PGPMAIN_HXX "$Revision: 1.1.1.1 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_ANY_H_
#include <com/sun/star/uno/Any.h>
#endif
#ifndef _COM_SUN_STAR_UNO_REFERENCE_H_
#include <com/sun/star/uno/Reference.h>
#endif
#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif

#ifndef _COM_SUN_STAR_PGP_RECIPIENTSEVENT_HPP_
#include <com/sun/star/pgp/RecipientsEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_PGP_SIGNATUREEVENT_HPP_
#include <com/sun/star/pgp/SignatureEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_PGP_XPGPENCODER_HPP_
#include <com/sun/star/pgp/XPGPEncoder.hpp>
#endif
#ifndef _COM_SUN_STAR_PGP_XPGPDECODER_HPP_
#include <com/sun/star/pgp/XPGPDecoder.hpp>
#endif
#ifndef _COM_SUN_STAR_PGP_XPGPDECODERLISTENER_HPP_
#include <com/sun/star/pgp/XPGPDecoderListener.hpp>
#endif
#ifndef _COM_SUN_STAR_PGP_XPGPPREFERENCES_HPP_
#include <com/sun/star/pgp/XPGPPreferences.hpp>
#endif

#ifndef _CPPUHELPER_INTERFACECONTAINER_H_
#include <cppuhelper/interfacecontainer.h>
#endif
#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

/*========================================================================
 *
 * SimplePGPMailer definitions.
 *
 *======================================================================*/
#define PGPMAILER_SERVICE_NAME        "com.sun.star.pgp.SimplePGPMailer"
#define PGPMAILER_IMPLEMENTATION_NAME "com.sun.star.pgp.SimplePGPMailer.V10"

namespace com
{
namespace sun
{
namespace star
{
namespace pgp
{

typedef com::sun::star::io::XInputStream  istream_type;
typedef com::sun::star::io::XOutputStream ostream_type;

/*========================================================================
 *
 * SimplePGPMailerService interface.
 *
 *======================================================================*/
class SimplePGPMailerService :
	public cppu::OWeakObject,
	public com::sun::star::lang::XServiceInfo,
	public XPGPPreferences,
	public XPGPEncoder,
	public XPGPDecoder,
	public XPGPDecoderListener
{
public:
	SimplePGPMailerService (void);

	/** XInterface.
	 */
	virtual com::sun::star::uno::Any
	SAL_CALL queryInterface (
		const com::sun::star::uno::Type &rType)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL acquire (void)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL release (void)
		throw (com::sun::star::uno::RuntimeException);

	/** XServiceInfo.
	 */
	virtual rtl::OUString SAL_CALL getImplementationName (void)
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL supportsService (
		const rtl::OUString &rServiceName)
		throw (com::sun::star::uno::RuntimeException);

	virtual com::sun::star::uno::Sequence<rtl::OUString>
	SAL_CALL getSupportedServiceNames (void)
		throw (com::sun::star::uno::RuntimeException);

	/** XPGPPreferences.
	 */
	virtual sal_Bool SAL_CALL getEncryptToSelf (void)
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL getEncryptByDefault (void)
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL getSignByDefault (void)
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL getAutoDecrypt (void)
		throw (com::sun::star::uno::RuntimeException);

	/** XPGPEncoder.
	 */
	virtual sal_Bool SAL_CALL encryptAndSign (
		const com::sun::star::uno::Sequence<rtl::OUString> &rRecipients,
		const com::sun::star::uno::Reference<istream_type> &rxPlainText,
		const com::sun::star::uno::Reference<ostream_type> &rxCipherText)
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL encrypt (
		const com::sun::star::uno::Sequence<rtl::OUString> &rRecipients,
		const com::sun::star::uno::Reference<istream_type> &rxPlainText,
		const com::sun::star::uno::Reference<ostream_type> &rxCipherText)
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL sign (
		sal_Bool                                            bDataIsAscii,
		const com::sun::star::uno::Reference<istream_type> &rxPlainText,
		const com::sun::star::uno::Reference<ostream_type> &rxCipherText)
		throw (com::sun::star::uno::RuntimeException);

	/** XPGPDecoder.
	 */
	virtual void SAL_CALL addDecoderListener (
		const com::sun::star::uno::Reference<XPGPDecoderListener> &rxListener)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL removeDecoderListener (
		const com::sun::star::uno::Reference<XPGPDecoderListener> &rxListener)
		throw (com::sun::star::uno::RuntimeException);

	virtual sal_Bool SAL_CALL decryptAndVerify (
		const com::sun::star::uno::Reference<istream_type> &rxCipherText,
		const com::sun::star::uno::Reference<ostream_type> &rxPlainText)
		throw (com::sun::star::uno::RuntimeException);

	/** XPGPDecoderListener.
	 */
	virtual void SAL_CALL decrypted (const RecipientsEvent &rEvent)
		throw (com::sun::star::uno::RuntimeException);

	virtual void SAL_CALL verified  (const SignatureEvent  &rEvent)
		throw (com::sun::star::uno::RuntimeException);

	/** XEventListener.
	 */
	virtual void SAL_CALL disposing (
		const com::sun::star::lang::EventObject &rSource)
		throw (com::sun::star::uno::RuntimeException);

protected:
	/** Destruction.
	 */
	virtual ~SimplePGPMailerService (void);

private:
	/** Representation.
	 */
	osl::Mutex                      m_aMutex;
	cppu::OInterfaceContainerHelper m_aEncoderListener;
	cppu::OInterfaceContainerHelper m_aDecoderListener;

	/** Not implemented.
	 */
	SimplePGPMailerService (const SimplePGPMailerService&);
	SimplePGPMailerService& operator= (const SimplePGPMailerService&);
};

/*========================================================================
 *
 * The End.
 *
 *======================================================================*/

} // pgp
} // star
} // sun
} // com

#endif /* _EXTENSIONS_PGP_PGPMAIN_HXX */

