/*************************************************************************
 *
 *  $RCSfile: SignersPassPhraseDialog.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.star.pgp;
import java.util.*;
import java.awt.GridBagLayout;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.event.ItemListener;
import java.awt.event.ItemEvent;
import javax.swing.*;
import javax.swing.event.*;

import com.sun.star.pgp.IPGP;
import com.sun.star.pgp.UserInfo;


//==================================================================================================
public class SignersPassPhraseDialog extends JPanel
{
	private static final boolean DEBUG = false;
	
	//______________________________________________________________________________________________
	public UserInfo getSigner()
	{
		return (UserInfo)_signersBox.getSelectedItem();
	}
	//______________________________________________________________________________________________
	public String getPassPhrase()
	{
		return new String( _phraseField.getPassword() );
	}
	
	//----------------------------------------------------------------------------------------------
	public SignersPassPhraseDialog(ResourceBundle bundle, IPGP pgp )
	{
		super( new GridBagLayout() );
		
		Insets insets = new Insets( 2, 2, 2, 2 );

		// all possible Signers label
		// d4_label1:"Signer:"
		add( new JLabel( bundle.getString("d4_label1") ),
			 new JXGridBagConstraints( 0, 0, 2, 1, 1.0, 0.0,
									   GridBagConstraints.WEST, GridBagConstraints.NONE,
									   insets, 0, 0 ) );

		// all possible Signers box
		_signersBox = new JComboBox( pgp.getSignatureUserInfos() );
		_signersBox.setEditable( false );
		// d4_toolTip1: "Select signing user of your EMail"
		_signersBox.setToolTipText(bundle.getString( "d4_toolTip1") );
		_signersBox.setSelectedItem( pgp.getDefaultPrivateUserInfo() );
		
		add( _signersBox,
			 new JXGridBagConstraints( 0, 1, 2, 1, 1.0, 0.0,
									   GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL,
									   insets, 0, 0 ) );
		
		// Passphrase label d4_label2: "Enter Passphrase for your private key:"
		add( new JLabel(bundle.getString("d4_label2") ),
			 new JXGridBagConstraints( 0, 2, 2, 1, 1.0, 0.0,
									   GridBagConstraints.WEST, GridBagConstraints.NONE,
									   insets, 0, 0 ) );

		// Passphrase field
		_phraseField = new JPasswordField();
		// d4_toolTip2: "Enter Passphrase to use private key"
		_phraseField.setToolTipText( bundle.getString( "d4_toolTip2") );
		add( _phraseField,
			 new JXGridBagConstraints( 0, 3, 2, 1, 1.0, 0.0,
									   GridBagConstraints.WEST, GridBagConstraints.HORIZONTAL,
									   insets, 0, 0 ) );
	}
	
	//##############################################################################################

	private JComboBox							_signersBox = null;
	private JPasswordField						_phraseField;
	
	//==============================================================================================
	public static SignersPassPhraseDialog invoke(ResourceBundle bundle,  IPGP pgp )
	{
		SignersPassPhraseDialog dialog = new SignersPassPhraseDialog( bundle, pgp );

		
		//  int nRet = JOptionPane.showConfirmDialog( null, dialog,
//  												  "Enter Private Passphrase ["+pgp.toString()+"]",
//  												  JOptionPane.OK_CANCEL_OPTION,
//  												  JOptionPane.QUESTION_MESSAGE );
		
		//  return (nRet == JOptionPane.OK_OPTION) ? dialog : null;
		Object obj[]={ bundle.getString("g_ok"),bundle.getString("g_cancel")};

 		JOptionPane pane= new JOptionPane( dialog, JOptionPane.QUESTION_MESSAGE,
 									  JOptionPane.OK_CANCEL_OPTION, null,
	 								  obj, obj[0] );
		// d4_title1= "Enter Private Passphrase"
		JDialog dlg= pane.createDialog(null, bundle.getString("d4_title1"));
		dlg.show();

		if( obj[0].equals( pane.getValue()))
			return dialog;
		else
			return null;

	}
}
