/*************************************************************************
 *
 *  $RCSfile: SimplePGPMailerFactory.java,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
package com.sun.star.pgp;

import com.sun.star.uno.XInterface;
import com.sun.star.lang.XMultiServiceFactory;
import com.sun.star.lang.XServiceInfo;
import com.sun.star.lang.XSingleServiceFactory;
import com.sun.star.uno.Exception;

import com.sun.star.pgp.IPGP;


//==================================================================================================
public class SimplePGPMailerFactory implements
			 XServiceInfo
		   , XSingleServiceFactory
{
	private static final boolean DEBUG = false;

	static final String SERVICE_NAME			= "com.sun.star.pgp.SimplePGPMailer";
	static final String IMPLEMENTATION_NAME		= "com.sun.star.pgp.SimplePGPMailerImpl";
	
	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// XSingleServiceFactory
	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++

	//______________________________________________________________________________________________
    public Object createInstance()
        throws Exception
	{
		if (DEBUG)
			System.out.println( "### creating new SimplePGPMailer..." );
  		return new SimplePGPMailer( _xServiceFactory, _pgp );
	}


    public Object createInstanceWithArguments( Object[] aArguments )
		throws Exception, RuntimeException
	{
		return null; // not impl
	}

	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// XServiceInfo
	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	public String getImplementationName()
	{
		return IMPLEMENTATION_NAME;
	}

    public boolean supportsService( String ServiceName )
	{
		return ServiceName.equals( SERVICE_NAME );
	}

    public String[] getSupportedServiceNames()
	{
		return new String[] { SERVICE_NAME };
	}

	//----------------------------------------------------------------------------------------------
	SimplePGPMailerFactory( XMultiServiceFactory xSF, IPGP pgp )
	{
		_xServiceFactory= xSF;
		_pgp = pgp;
	}

// attributes --------------------------------------------------
	private XMultiServiceFactory _xServiceFactory= null;
	private IPGP				_pgp;
}
