/*************************************************************************
 *
 *  $RCSfile: pgpimpl.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _EXTENSIONS_PGP_PGPIMPL_CXX "$Revision: 1.1.1.1 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_MEMORY_H_
#include <rtl/memory.h>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX_
#include <com/sun/star/uno/Sequence.hxx>
#endif

#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif

#ifndef _COM_SUN_STAR_PGP_XPGPENCODER_HPP_
#include <com/sun/star/pgp/XPGPEncoder.hpp>
#endif
#ifndef _COM_SUN_STAR_PGP_XPGPDECODER_HPP_
#include <com/sun/star/pgp/XPGPDecoder.hpp>
#endif
#ifndef _COM_SUN_STAR_PGP_XPGPDECODERLISTENER_HPP_
#include <com/sun/star/pgp/XPGPDecoderListener.hpp>
#endif

#ifndef _EXTENSIONS_PGP_PGPIMPL_HXX
#include "pgpimpl.hxx"
#endif
#ifndef _EXTENSIONS_PGP_PGPUI_HXX
#include "pgpui.hxx"
#endif

#include <limits.h>

using namespace com::sun::star::io;
using namespace com::sun::star::pgp;
using namespace com::sun::star::uno;
using namespace rtl;

/*========================================================================
 *
 * PGPCodec_Impl implementation.
 *
 *======================================================================*/
/*
 * PGPCodec_Impl.
 */
PGPCodec_Impl::PGPCodec_Impl (void)
{
}

/*
 * ~PGPCodec_Impl.
 */
PGPCodec_Impl::~PGPCodec_Impl (void)
{
}

/*
 * queryInterface.
 */
Any SAL_CALL PGPCodec_Impl::queryInterface (
	const Type &rType) throw (RuntimeException)
{
	return OWeakObject::queryInterface (rType);
}

/*
 * acquire.
 */
void SAL_CALL PGPCodec_Impl::acquire (void) throw (RuntimeException)
{
	OWeakObject::acquire();
}

/*
 * release.
 */
void SAL_CALL PGPCodec_Impl::release (void) throw (RuntimeException)
{
	OWeakObject::release();
}

/*
 * transportData.
 */
sal_Bool PGPCodec_Impl::transportData (
	const Reference<XInputStream>  &rxInput,
	const Reference<XOutputStream> &rxOutput) throw (RuntimeException)
{
	sal_Bool result = sal_False;
	if (rxInput.is() && rxOutput.is())
	{
		// Transport: read, code, write.
		try
		{
			rxInput->readBytes (m_buffer, INT_MAX);
			rxInput->closeInput();

			if (m_buffer.getLength())
			{
				if (codeData (m_buffer))
				{
					rxOutput->writeBytes (m_buffer);
					result = sal_True;
				}
				m_buffer = Sequence<sal_Int8>();
			}
			rxOutput->closeOutput();
		}
		catch (IOException)
		{
			// Cleanup.
			rxInput->closeInput();
			rxOutput->closeOutput();
		}
	}
	return result;
}

/*
 * codeData.
 */
sal_Bool PGPCodec_Impl::codeData (Sequence<sal_Int8> &rBuffer)
{
	return sal_True;
}

/*========================================================================
 *
 * PGPEncoder_Impl implementation.
 *
 *======================================================================*/
/*
 * PGPEncoder_Impl.
 */
PGPEncoder_Impl::PGPEncoder_Impl (void)
	: PGPCodec_Impl()
{
}

/*
 * ~PGPEncoder_Impl.
 */
PGPEncoder_Impl::~PGPEncoder_Impl (void)
{
}

/*
 * queryInterface.
 */
Any SAL_CALL PGPEncoder_Impl::queryInterface (
	const Type &rType) throw (RuntimeException)
{
	Any result (cppu::queryInterface (
		rType,
		SAL_STATIC_CAST (XPGPEncoder*, this)));
	if (!result.hasValue())
		result = PGPCodec_Impl::queryInterface (rType);
	return (result);
}

/*
 * acquire.
 */
void SAL_CALL PGPEncoder_Impl::acquire (void) throw (RuntimeException)
{
	PGPCodec_Impl::acquire();
}

/*
 * release.
 */
void SAL_CALL PGPEncoder_Impl::release (void) throw (RuntimeException)
{
	PGPCodec_Impl::release();
}

/*
 * encryptAndSign.
 */
sal_Bool SAL_CALL PGPEncoder_Impl::encryptAndSign (
	const Sequence<OUString>       &rRecipients,
	const Reference<XInputStream>  &rxPlainText,
	const Reference<XOutputStream> &rxCipherText) throw (RuntimeException)
{
	if (!m_context.prepareEncrypt (rRecipients))
		return sal_False;
	if (!m_context.prepareSign (sal_False))
		return sal_False;
	if (!m_context.prepareOutput (sal_False))
		return sal_False;

	transportData (rxPlainText, rxCipherText);
	return sal_True;
}

/*
 * encrypt.
 */
sal_Bool SAL_CALL PGPEncoder_Impl::encrypt (
	const Sequence<OUString>       &rRecipients,
	const Reference<XInputStream>  &rxPlainText,
	const Reference<XOutputStream> &rxCipherText) throw (RuntimeException)
{
	if (!m_context.prepareEncrypt (rRecipients))
		return sal_False;
	if (!m_context.prepareOutput (sal_False))
		return sal_False;

	transportData (rxPlainText, rxCipherText);
	return sal_True;
}

/*
 * sign.
 */
sal_Bool SAL_CALL PGPEncoder_Impl::sign (
	sal_Bool                        bDataIsAscii,
	const Reference<XInputStream>  &rxPlainText,
	const Reference<XOutputStream> &rxCipherText) throw (RuntimeException)
{
	if (!m_context.prepareSign (bDataIsAscii))
		return sal_False;
	if (!m_context.prepareOutput (bDataIsAscii))
		return sal_False;

	transportData (rxPlainText, rxCipherText);
	return sal_True;
}

/*
 * codeData.
 */
sal_Bool PGPEncoder_Impl::codeData (Sequence<sal_Int8> &rBuffer)
{
	if (rBuffer.getLength())
		return m_context.encode (rBuffer);
	else
		return sal_False;
}

/*========================================================================
 *
 * PGPDecoder_Impl implementation.
 *
 *======================================================================*/
/*
 * PGPDecoder_Impl.
 */
PGPDecoder_Impl::PGPDecoder_Impl (void)
	: PGPCodec_Impl()
{
}

/*
 * ~PGPDecoder_Impl.
 */
PGPDecoder_Impl::~PGPDecoder_Impl (void)
{
}

/*
 * queryInterface.
 */
Any SAL_CALL PGPDecoder_Impl::queryInterface (
	const Type &rType) throw (RuntimeException)
{
	Any result (cppu::queryInterface (
		rType,
		SAL_STATIC_CAST (XPGPDecoder*, this)));
	if (!result.hasValue())
		result = PGPCodec_Impl::queryInterface (rType);
	return (result);
}

/*
 * acquire.
 */
void SAL_CALL PGPDecoder_Impl::acquire (void) throw (RuntimeException)
{
	PGPCodec_Impl::acquire();
}

/*
 * release.
 */
void SAL_CALL PGPDecoder_Impl::release (void) throw (RuntimeException)
{
	PGPCodec_Impl::release();
}

/*
 * addDecoderListener.
 */
void SAL_CALL PGPDecoder_Impl::addDecoderListener (
	const Reference<XPGPDecoderListener> &rxListener) throw (RuntimeException)
{
	m_context.m_listener = rxListener;
}

/*
 * removeDecoderListener.
 */
void SAL_CALL PGPDecoder_Impl::removeDecoderListener (
	const Reference<XPGPDecoderListener> &rxListener) throw (RuntimeException)
{
	if (m_context.m_listener == rxListener)
		m_context.m_listener = NULL;
}

/*
 * decryptAndVerify.
 */
sal_Bool SAL_CALL PGPDecoder_Impl::decryptAndVerify (
	const Reference<XInputStream>  &rxCipherText,
	const Reference<XOutputStream> &rxPlainText) throw (RuntimeException)
{
	if (!m_context.prepareDecode())
		return sal_False;

	transportData (rxCipherText, rxPlainText);
	return sal_True;
}

/*
 * codeData.
 */
sal_Bool PGPDecoder_Impl::codeData (Sequence<sal_Int8> &rBuffer)
{
	if (rBuffer.getLength())
		return m_context.decode (rBuffer);
	else
		return sal_False;
}

