/*************************************************************************
 *
 *  $RCSfile: pgpmain.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _EXTENSIONS_PGP_PGPMAIN_CXX "$Revision: 1.1.1.1 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif
#ifndef _OSL_MUTEX_HXX_
#include <osl/mutex.hxx>
#endif
#ifndef _RTL_USTRING_HXX_
#include <rtl/ustring.hxx>
#endif

#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif
#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICE_FACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSINGLESERVICE_FACTORY_HPP_
#include <com/sun/star/lang/XSingleServiceFactory.hpp>
#endif
#ifndef _COM_SUN_STAR_LANG_XSERVICEINFO_HPP_
#include <com/sun/star/lang/XServiceInfo.hpp>
#endif

#ifndef _COM_SUN_STAR_PGP_RECIPIENTSEVENT_HPP_
#include <com/sun/star/pgp/RecipientsEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_PGP_SIGNATUREEVENT_HPP_
#include <com/sun/star/pgp/SignatureEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_PGP_XPGPENCODER_HPP_
#include <com/sun/star/pgp/XPGPEncoder.hpp>
#endif
#ifndef _COM_SUN_STAR_PGP_XPGPDECODER_HPP_
#include <com/sun/star/pgp/XPGPDecoder.hpp>
#endif
#ifndef _COM_SUN_STAR_PGP_XPGPDECODERLISTENER_HPP_
#include <com/sun/star/pgp/XPGPDecoderListener.hpp>
#endif
#ifndef _COM_SUN_STAR_PGP_XPGPPREFERENCES_HPP_
#include <com/sun/star/pgp/XPGPPreferences.hpp>
#endif

#ifndef _COM_SUN_STAR_REGISTRY_XREGISTRYKEY_HPP_
#include <com/sun/star/registry/XRegistryKey.hpp>
#endif

#ifndef _CPPUHELPER_INTERFACECONTAINER_H_
#include <cppuhelper/interfacecontainer.h>
#endif
#ifndef _CPPUHELPER_FACTORY_HXX_
#include <cppuhelper/factory.hxx>
#endif
#ifndef _CPPUHELPER_WEAK_HXX_
#include <cppuhelper/weak.hxx>
#endif

#ifndef _EXTENSIONS_PGP_PGPMAIN_HXX
#include "pgpmain.hxx"
#endif
#ifndef _EXTENSIONS_PGP_PGPIMPL_HXX
#include "pgpimpl.hxx"
#endif
#ifndef _EXTENSIONS_PGP_PGPUI_HXX
#include "pgpui.hxx"
#endif

using namespace com::sun::star::io;
using namespace com::sun::star::lang;
using namespace com::sun::star::pgp;
using namespace com::sun::star::registry;
using namespace com::sun::star::uno;
using namespace cppu;
using namespace rtl;

/*========================================================================
 *
 * SimplePGPMailerService internals.
 *
 *======================================================================*/
#define S2U(p) rtl::OUString::createFromAscii((p))

/*
 * SimplePGPMailerService_getImplementationName.
 */
static OUString SAL_CALL SimplePGPMailerService_getImplementationName (void)
{
	return S2U (PGPMAILER_IMPLEMENTATION_NAME);
}

/*
 * SimplePGPMailerService_getSupportedServiceNames.
 */
static Sequence<OUString>
SAL_CALL SimplePGPMailerService_getSupportedServiceNames (void)
{
	OUString aName (S2U (PGPMAILER_SERVICE_NAME));
	Sequence<OUString> aSeq (&aName, 1);
	return aSeq;
}

/*
 * SimplePGPMailerService_createInstance.
 */
static Reference<XInterface>
SAL_CALL SimplePGPMailerService_createInstance (
	const Reference<XMultiServiceFactory> &rxManager)
{
	Reference<XInterface> xInst (
		SAL_STATIC_CAST (OWeakObject*, new SimplePGPMailerService()));
	return xInst;
}

/*
 * SimplePGPMailerService_createServiceFactory.
 */
static Reference<XSingleServiceFactory>
SAL_CALL SimplePGPMailerService_createServiceFactory (
	const Reference<XMultiServiceFactory> &rxManager)
{
	Reference<XSingleServiceFactory> xFactory (
		cppu::createSingleFactory (
			rxManager,
			SimplePGPMailerService_getImplementationName(),
			SimplePGPMailerService_createInstance,
			SimplePGPMailerService_getSupportedServiceNames()));
	return xFactory;
}

/*========================================================================
 *
 * SimplePGPMailerService implementation.
 *
 *======================================================================*/
/*
 * SimplePGPMailerService.
 */
SimplePGPMailerService::SimplePGPMailerService (void)
	: m_aEncoderListener (m_aMutex),
	  m_aDecoderListener (m_aMutex)
{
}

/*
 * ~SimplePGPMailerService.
 */
SimplePGPMailerService::~SimplePGPMailerService (void)
{
}

/*
 * XInterface: queryInterface.
 */
Any SAL_CALL SimplePGPMailerService::queryInterface (const Type &rType)
	throw (RuntimeException)
{
	Any result (cppu::queryInterface (
		rType,
		SAL_STATIC_CAST (XServiceInfo*, this),
		SAL_STATIC_CAST (XPGPPreferences*, this),
		SAL_STATIC_CAST (XPGPEncoder*, this),
		SAL_STATIC_CAST (XPGPDecoder*, this),
		SAL_STATIC_CAST (XPGPDecoderListener*, this)));
	if (!result.hasValue())
		result = OWeakObject::queryInterface (rType);
	return (result);
}

/*
 * XInterface: acquire.
 */
void SAL_CALL SimplePGPMailerService::acquire (void) throw (RuntimeException)
{
	OWeakObject::acquire();
}

/*
 * XInterface: release.
 */
void SAL_CALL SimplePGPMailerService::release (void) throw (RuntimeException)
{
	OWeakObject::release();
}

/*
 * XServiceInfo: getImplementationName.
 */
OUString SAL_CALL SimplePGPMailerService::getImplementationName (void)
	throw (RuntimeException)
{
	return SimplePGPMailerService_getImplementationName();
}

/*
 * XServiceInfo: supportsService.
 */
sal_Bool SAL_CALL SimplePGPMailerService::supportsService (
	const OUString &rServiceName) throw (RuntimeException)
{
	return (rServiceName.compareToAscii (PGPMAILER_SERVICE_NAME) == 0);
}

/*
 * XServiceInfo: getSupportedServiceNames.
 */
Sequence<OUString>
SAL_CALL SimplePGPMailerService::getSupportedServiceNames (void)
	throw (RuntimeException)
{
	return SimplePGPMailerService_getSupportedServiceNames();
}

/*
 * getEncryptToSelf.
 */
sal_Bool SAL_CALL SimplePGPMailerService::getEncryptToSelf (void)
	throw (RuntimeException)
{
	PGPUIPreferences_Impl aPrefs;
	PGPUIGetPreferences_Impl (aPrefs);
	return (aPrefs.m_bEncryptToSelf ? sal_True : sal_False);
}

/*
 * getEncryptByDefault.
 */
sal_Bool SAL_CALL SimplePGPMailerService::getEncryptByDefault (void)
	throw (RuntimeException)
{
	PGPUIPreferences_Impl aPrefs;
	PGPUIGetPreferences_Impl (aPrefs);
	return (aPrefs.m_bEncryptByDefault ? sal_True : sal_False);
}

/*
 * getSignByDefault.
 */
sal_Bool SAL_CALL SimplePGPMailerService::getSignByDefault (void)
	throw (RuntimeException)
{
	PGPUIPreferences_Impl aPrefs;
	PGPUIGetPreferences_Impl (aPrefs);
	return (aPrefs.m_bSignByDefault ? sal_True : sal_False);
}

/*
 * getAutoDecrypt.
 */
sal_Bool SAL_CALL SimplePGPMailerService::getAutoDecrypt (void)
	throw (RuntimeException)
{
	PGPUIPreferences_Impl aPrefs;
	PGPUIGetPreferences_Impl (aPrefs);
	return (aPrefs.m_bAutoDecrypt ? sal_True : sal_False);
}

/*
 * encryptAndSign.
 */
sal_Bool SAL_CALL SimplePGPMailerService::encryptAndSign (
	const Sequence<OUString>       &rRecipients,
	const Reference<XInputStream>  &rxPlainText,
	const Reference<XOutputStream> &rxCipherText)
	throw (RuntimeException)
{
	Reference<XPGPEncoder> xEncoder (new PGPEncoder_Impl);
	return xEncoder->encryptAndSign (rRecipients, rxPlainText, rxCipherText);
}

/*
 * encrypt.
 */
sal_Bool SAL_CALL SimplePGPMailerService::encrypt (
	const Sequence<OUString>       &rRecipients,
	const Reference<XInputStream>  &rxPlainText,
	const Reference<XOutputStream> &rxCipherText)
	throw (RuntimeException)
{
	Reference<XPGPEncoder> xEncoder (new PGPEncoder_Impl);
	return xEncoder->encrypt (rRecipients, rxPlainText, rxCipherText);
}

/*
 * sign.
 */
sal_Bool SAL_CALL SimplePGPMailerService::sign (
	sal_Bool                        bDataIsAscii,
	const Reference<XInputStream>  &rxPlainText,
	const Reference<XOutputStream> &rxCipherText)
	throw (RuntimeException)
{
	Reference<XPGPEncoder> xEncoder (new PGPEncoder_Impl);
	return xEncoder->sign (bDataIsAscii, rxPlainText, rxCipherText);
}

/*
 * XPGPDecoder::addDecoderListener.
 */
void SAL_CALL SimplePGPMailerService::addDecoderListener (
	const Reference<XPGPDecoderListener> &rxListener)
	throw (RuntimeException)
{
	m_aDecoderListener.addInterface (rxListener);
}

/*
 * XPGPDecoder::removeDecoderListener.
 */
void SAL_CALL SimplePGPMailerService::removeDecoderListener (
	const Reference<XPGPDecoderListener> &rxListener)
	throw (RuntimeException)
{
	m_aDecoderListener.removeInterface (rxListener);
}

/*
 * XPGPDecoder: decryptAndVerify.
 */
sal_Bool SAL_CALL SimplePGPMailerService::decryptAndVerify (
	const Reference<XInputStream>  &rxCipherText,
	const Reference<XOutputStream> &rxPlainText)
	throw (RuntimeException)
{
	Reference<XPGPDecoder> xDecoder (new PGPDecoder_Impl);
	xDecoder->addDecoderListener (this);

	return xDecoder->decryptAndVerify (rxCipherText, rxPlainText);
}

/*
 * XPGPDecoderListener: decrypted.
 */
void SAL_CALL SimplePGPMailerService::decrypted (
	const RecipientsEvent &rEvent) throw (RuntimeException)
{
	RecipientsEvent event (rEvent);
	event.Source = SAL_STATIC_CAST (OWeakObject*, this);

	OInterfaceIteratorHelper it (m_aDecoderListener);
	while (it.hasMoreElements())
	{
		XPGPDecoderListener *lstner =
			(XPGPDecoderListener*)(it.next());
		if (lstner)
			lstner->decrypted (event);
	}
}

/*
 * XPGPDecoderListener: verified.
 */
void SAL_CALL SimplePGPMailerService::verified (
	const SignatureEvent &rEvent) throw (RuntimeException)
{
	SignatureEvent event (rEvent);
	event.Source = SAL_STATIC_CAST (OWeakObject*, this);

	OInterfaceIteratorHelper it (m_aDecoderListener);
	while (it.hasMoreElements())
	{
		XPGPDecoderListener *lstner =
			(XPGPDecoderListener*)(it.next());
		if (lstner)
			lstner->verified (event);
	}
}

/*
 * XEventListener::disposing.
 */
void SAL_CALL SimplePGPMailerService::disposing (
	const EventObject &rSource) throw (RuntimeException)
{
}

/*========================================================================
 *
 * Component Loader.
 *
 *======================================================================*/

static sal_Bool writeInfo( void * pRegistryKey,
						   const OUString & rImplementationName,
   						   Sequence< OUString > const & rServiceNames )
{
	OUString aKeyName( OUString::createFromAscii( "/" ) );
	aKeyName += rImplementationName;
	aKeyName += OUString::createFromAscii( "/UNO/SERVICES" );

	Reference< XRegistryKey > xKey;
	try
	{
		xKey = static_cast< XRegistryKey * >(
									pRegistryKey )->createKey( aKeyName );
	}
	catch ( InvalidRegistryException const & )
	{
	}

	if ( !xKey.is() )
		return sal_False;

	sal_Bool bSuccess = sal_True;

	for ( sal_Int32 n = 0; n < rServiceNames.getLength(); ++n )
	{
		try
		{
			xKey->createKey( rServiceNames[ n ] );
		}
		catch ( InvalidRegistryException const & )
		{
			bSuccess = sal_False;
			break;
		}
	}
	return bSuccess;
}

//=========================================================================
extern "C" void SAL_CALL component_getImplementationEnvironment(
	const sal_Char ** ppEnvTypeName, uno_Environment ** ppEnv )
{
	*ppEnvTypeName = CPPU_CURRENT_LANGUAGE_BINDING_NAME;
}

//=========================================================================
extern "C" sal_Bool SAL_CALL component_writeInfo(
	void * pServiceManager, void * pRegistryKey )
{
	return pRegistryKey &&
		   writeInfo( pRegistryKey,
			   		  SimplePGPMailerService_getImplementationName(),
			   		  SimplePGPMailerService_getSupportedServiceNames() );
}

//=========================================================================
extern "C" void * SAL_CALL component_getFactory(
	const sal_Char * pImplName, void * pServiceManager, void * pRegistryKey )
{
	void * pRet = 0;

	Reference< XMultiServiceFactory > xSMgr(
			reinterpret_cast< XMultiServiceFactory * >( pServiceManager ) );
	Reference< XSingleServiceFactory > xFactory;

	if ( SimplePGPMailerService_getImplementationName().
			compareToAscii( pImplName ) == 0 )
		xFactory = SimplePGPMailerService_createServiceFactory( xSMgr );

	if ( xFactory.is() )
	{
		xFactory->acquire();
		pRet = xFactory.get();
	}

	return pRet;
}

