/*************************************************************************
 *
 *  $RCSfile: pgpsdk55.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#define _EXTENSIONS_PGP_PGPSDK_CXX "$Revision: 1.1.1.1 $"

#ifndef _SAL_TYPES_H_
#include <sal/types.h>
#endif

#ifndef _RTL_MEMORY_H_
#include <rtl/memory.h>
#endif
#ifndef _RTL_USTRING_HXX
#include <rtl/ustring.hxx>
#endif

#ifndef _COM_SUN_STAR_UNO_SEQUENCE_HXX
#include <com/sun/star/uno/Sequence.hxx>
#endif

#ifndef _COM_SUN_STAR_PGP_SIGNATUREEVENT_HPP_
#include <com/sun/star/pgp/SignatureEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_PGP_XPGPDECODERLISTENER_HPP_
#include <com/sun/star/pgp/XPGPDecoderListener.hpp>
#endif

#ifndef _EXTENSIONS_PGP_PGPIMPL_HXX
#include "pgpimpl.hxx"
#endif
#ifndef _EXTENSIONS_PGP_PGPUI_HXX
#include "pgpui.hxx"
#endif

#ifndef Included_pgpPubTypes_h
#include "pgpPubTypes.h"
#endif
#ifndef Included_pgpUtilities_h
#include "pgpUtilities.h"
#endif
#ifndef Included_pgpErrors_h
#include "pgpErrors.h"
#endif
#ifndef Included_pgpEncode_h
#include "pgpEncode.h"
#endif
#ifndef Included_pgpKeys_h
#include "pgpKeys.h"
#endif

using namespace com::sun::star::pgp;
using namespace com::sun::star::uno;
using namespace rtl;

#define S2U(s) OStringToOUString((s), RTL_TEXTENCODING_MS_1252)

/*========================================================================
 *
 * PGPEncoderContext_Impl implementation.
 *
 *======================================================================*/
/*
 * EncodeEventHandler_Impl.
 */
static PGPError PGPAPI EncodeEventHandler_Impl (
	PGPContextRef  context,
	PGPEvent      *event,
	PGPUserValue   userValue);

/*
 * PGPEncoderContext_Impl.
 */
PGPEncoderContext_Impl::PGPEncoderContext_Impl (void)
	: m_context (NULL),
	  m_keyring (NULL),
	  m_options (NULL)
{
	PGPError errcode = PGPsdkInit();
	if (IsntPGPError(errcode))
	{
		// context.
		errcode = PGPNewContext (kPGPsdkAPIVersion, &m_context);
		if (IsntPGPError(errcode))
		{
			// keyring.
			if (PGPOpenDefaultKeyRings (
				m_context, kPGPKeyRingOpenFlags_Mutable, &m_keyring))
			{
				PGPOpenDefaultKeyRings (m_context, 0, &m_keyring);
			}
		}
	}
}

/*
 * ~PGPEncoderContext_Impl.
 */
PGPEncoderContext_Impl::~PGPEncoderContext_Impl (void)
{
	if (m_options)
		PGPFreeOptionList (m_options);
	if (m_keyring)
		PGPFreeKeySet (m_keyring);
	if (m_context)
		PGPFreeContext (m_context);
	PGPsdkCleanup();
}

/*
 * prepareEncrypt.
 */
sal_Bool PGPEncoderContext_Impl::prepareEncrypt (
	const Sequence<OUString> &rRecipients)
{
	// Check context.
	PGPError errcode = kPGPError_BadParams;
	if (m_context && m_keyring)
	{
		// Obtain recipient keyset.
		PGPKeySetRef keyset = NULL;

		PGPUIGetRecipientKeySet_Impl (
			m_context, rRecipients, &m_keyring, &keyset);
		if (keyset)
		{
			// Check encoding options.
			if (!m_options)
				PGPNewOptionList (m_context, &m_options);

			// Setup encryption options.
			errcode = PGPAppendOptionList (
				m_context, m_options,
				PGPOEncryptToKeySet (
					m_context, keyset),
				PGPOLastOption (m_context));

			// Cleanup.
			PGPFreeKeySet (keyset);
		}
	}
	return IsntPGPError(errcode);
}

/*
 * prepareSign.
 */
sal_Bool PGPEncoderContext_Impl::prepareSign (sal_Bool bDataIsAscii)
{
	// Check context.
	PGPError errcode = kPGPError_BadParams;
	if (m_context && m_keyring)
	{
		// Obtain signing passphrase.
		PGPKeyRef  key = NULL;
		char      *passphrase = NULL;

		errcode = PGPUIGetSigningPhrase_Impl (
			m_context, m_keyring, &key, &passphrase);
		if (IsntPGPError(errcode))
		{
			// Check encoding options.
			if (!m_options)
				PGPNewOptionList (m_context, &m_options);

			// Setup signing options.
			errcode = PGPAppendOptionList (
				m_context, m_options,
				PGPOClearSign (
					m_context, bDataIsAscii),
				PGPOSignWithKey (
					m_context, key,
					PGPOPassphrase (m_context, passphrase),
					PGPOLastOption (m_context)),
				PGPOLastOption (m_context));
		}
		PGPUIFreePhrase_Impl (passphrase);
	}
	return IsntPGPError(errcode);
}

/*
 * prepareOutput.
 */
sal_Bool PGPEncoderContext_Impl::prepareOutput (sal_Bool bDataIsAscii)
{
	PGPError errcode = kPGPError_BadParams;
	if (m_context && m_options)
	{
		sal_Bool bDataIsBinary = (bDataIsAscii == sal_False);

		errcode = PGPAppendOptionList (
			m_context, m_options,
			PGPOArmorOutput (
				m_context, bDataIsBinary),
			PGPODataIsASCII (
				m_context, bDataIsAscii),
			PGPOLastOption (m_context));

		if (IsntPGPError(errcode) && bDataIsBinary)
		{
			errcode = PGPAppendOptionList (
				m_context, m_options,
				PGPOOutputLineEndType (
					m_context, kPGPLineEnd_CRLF),
				PGPOLastOption (m_context));
		}
	}
	return IsntPGPError(errcode);
}

/*
 * encode.
 */
sal_Bool PGPEncoderContext_Impl::encode (Sequence<sal_Int8> &rBuffer)
{
	PGPError errcode = kPGPError_BadParams;
	if (m_context && m_options)
	{
		void   *pOutData = NULL;
		PGPSize nOutSize = 0;

		errcode = PGPEncode (
			m_context, m_options,
			PGPOEventHandler (
				m_context, EncodeEventHandler_Impl, this),
			PGPOInputBuffer (
				m_context, rBuffer.getConstArray(), rBuffer.getLength()),
			PGPOAllocatedOutputBuffer (
				m_context, &pOutData, MAX_PGPSize, &nOutSize),
			PGPOLastOption (m_context));

		if (IsntPGPError(errcode))
		{
			rBuffer.realloc (nOutSize);
			rtl_copyMemory (rBuffer.getArray(), pOutData, nOutSize);
			PGPFreeData (pOutData);
		}
	}
	return IsntPGPError(errcode);
}

/*
 * EncodeEventHandler_Impl.
 */
static PGPError PGPAPI EncodeEventHandler_Impl (
	PGPContextRef  context,
	PGPEvent      *event,
	PGPUserValue   userValue)
{
	if (event)
	{
		if (event->type == kPGPEvent_WarningEvent)
		{
			PGPError warning    = event->data.warningData.warning;
			void*    warningArg = event->data.warningData.warningArg;

			if (warning == kPGPError_KeyInvalid)
			{
				PGPKeySetRef warnset = (PGPKeySetRef)warningArg;
			}
		}
	}
	return kPGPError_NoErr;
}

/*========================================================================
 *
 * PGPDecoderContext_Impl implementation.
 *
 *======================================================================*/
/*
 * DecodeEventHandler_Impl.
 */
static PGPError PGPAPI DecodeEventHandler_Impl (
	PGPContextRef  context,
	PGPEvent      *event,
	PGPUserValue   userValue);

/*
 * PGPDecoderContext_Impl.
 */
PGPDecoderContext_Impl::PGPDecoderContext_Impl (void)
	: m_listener   (NULL),
	  m_context    (NULL),
	  m_keyring    (NULL),
	  m_options    (NULL),
	  m_recipients (NULL),
	  m_keyidlist  (NULL),
	  m_keyidcount (0)
{
	PGPError errcode = PGPsdkInit();
	if (IsntPGPError(errcode))
	{
		// context.
		errcode = PGPNewContext (kPGPsdkAPIVersion, &m_context);
		if (IsntPGPError(errcode))
		{
			// keyring.
			PGPOpenDefaultKeyRings (m_context, 0, &m_keyring);
		}
	}
}

/*
 * ~PGPDecoderContext_Impl.
 */
PGPDecoderContext_Impl::~PGPDecoderContext_Impl (void)
{
	if (m_options)
		PGPFreeOptionList (m_options);
	if (m_recipients)
		PGPFreeKeySet (m_recipients);
	if (m_keyring)
		PGPFreeKeySet (m_keyring);
	if (m_context)
		PGPFreeContext (m_context);
	PGPsdkCleanup();
}

/*
 * prepareDecode.
 */
sal_Bool PGPDecoderContext_Impl::prepareDecode (void)
{
	// Check context.
	PGPError errcode = kPGPError_BadParams;
	if (m_context && m_keyring)
	{
		// Check decoding options.
		if (!m_options)
			PGPNewOptionList (m_context, &m_options);

		// Setup decryption options.
		errcode = PGPAppendOptionList (
			m_context, m_options,
			PGPOKeySetRef (
				m_context, m_keyring),
			PGPOPassThroughIfUnrecognized (
				m_context, sal_True),
			PGPOSendEventIfKeyFound (
				m_context, sal_True),
			PGPOLastOption (m_context));
	}
	return IsntPGPError(errcode);
}

/*
 * decode.
 */
sal_Bool PGPDecoderContext_Impl::decode (Sequence<sal_Int8> &rBuffer)
{
	PGPError errcode = kPGPError_BadParams;
	if (m_context && m_options)
	{
		void   *pOutData = NULL;
		PGPSize nOutSize = 0;

		errcode = PGPDecode (
			m_context, m_options,
			PGPOEventHandler (
				m_context, DecodeEventHandler_Impl, this),
			PGPOInputBuffer (
				m_context, rBuffer.getConstArray(), rBuffer.getLength()),
			PGPOAllocatedOutputBuffer (
				m_context, &pOutData, MAX_PGPSize, &nOutSize),
			PGPOLastOption (m_context));

		if (IsntPGPError(errcode))
		{
			rBuffer.realloc (nOutSize);
			rtl_copyMemory (rBuffer.getArray(), pOutData, nOutSize);
			PGPFreeData (pOutData);
		}
	}
	return IsntPGPError(errcode);
}

/*
 * setRecipients.
 */
void PGPDecoderContext_Impl::setRecipients (
	PGPKeySetRef   Recipients,
	const PGPKeyID KeyIDList[],
	PGPUInt32      KeyIDCount)
{
	if (m_recipients)
		PGPFreeKeySet (m_recipients);
	m_recipients = Recipients;
	if (m_recipients)
		PGPIncKeySetRefCount (m_recipients);

	m_keyidlist  = KeyIDList;
	m_keyidcount = KeyIDCount;
}

/*========================================================================
 *
 * DecodeEventHandler_Impl implementation.
 *
 *======================================================================*/
/*
 * DecodeEventHandler_Impl.
 */
static PGPError PGPAPI DecodeEventHandler_Impl (
	PGPContextRef  context,
	PGPEvent      *event,
	PGPUserValue   userValue)
{
	PGPDecoderContext_Impl *ctx = (PGPDecoderContext_Impl *)userValue;
	PGPError errcode = kPGPError_NoErr;
	if (event)
	{
		switch (event->type)
		{
			case kPGPEvent_AnalyzeEvent:
				switch (event->data.analyzeData.sectionType)
				{
					case kPGPAnalyze_Encrypted:
						// RecipientsEvent.
						break;

					case kPGPAnalyze_Signed:
						// SignatureEvent.
						break;

					case kPGPAnalyze_Key:
						// KeyFoundEvent.
						break;

					case kPGPAnalyze_Unknown:
						break;

					default:
						break;
				}
				break;

			case kPGPEvent_RecipientsEvent:
				if (context)
				{
					PGPUInt32 n = event->data.recipientsData.keyCount;
					if (n > 0)
					{
						ctx->setRecipients (
							event->data.recipientsData.recipientSet,
							event->data.recipientsData.keyIDArray,
							event->data.recipientsData.keyCount);
					}
				}
				break;

			case kPGPEvent_PassphraseEvent:
				if (context)
				{
					PGPKeySetRef  keyset = NULL;
					char         *passphrase = NULL;

					if (ctx->m_recipients)
						keyset = ctx->m_recipients;
					else
						keyset = event->data.passphraseData.keyset;

					errcode = PGPUIGetDecryptPhrase_Impl (
						context, ctx->m_keyring, keyset,
						ctx->m_keyidlist, ctx->m_keyidcount, &passphrase);
					if (IsntPGPError(errcode))
					{
						PGPAddJobOptions (
							event->job,
							PGPOPassphrase (context, passphrase),
							PGPOLastOption (context));

						PGPUIFreePhrase_Impl (passphrase);
					}
				}
				break;

			case kPGPEvent_SignatureEvent:
				if (context)
				{
					PGPBoolean checked  = event->data.signatureData.checked;
					PGPBoolean verified = event->data.signatureData.verified;
					PGPKeyRef  key      = event->data.signatureData.signingKey;

					if (ctx->m_listener.is())
					{
						SignatureEvent SigEvent;

						SigEvent.Checked  = checked;
						SigEvent.Verified = verified;

						if (key)
						{
							PGPSize length = 0;
							char    buffer[256] = "";

							PGPGetPrimaryUserIDNameBuffer (
								key, sizeof(buffer), buffer, &length);
							if (length > 0) length--;

							SigEvent.SignerUserID =
								S2U (OString (buffer, length));
						}
						ctx->m_listener->verified (SigEvent);
					}
				}
				break;

			case kPGPEvent_KeyFoundEvent:
				if (context)
				{
					PGPKeySetRef keyset = event->data.keyFoundData.keySet;
					PGPUInt32    n = 0;

					PGPCountKeys (keyset, &n);
					if (n > 0)
					{
#if 0  /* NYI */
						PGPUIQueryAddKeys_Impl (
							context, ctx->m_keyring, keyset);
#endif /* NYI */
					}
				}
				break;

			default:
				break;
		}
	}
	return errcode;
}

