/*************************************************************************
 *
 *  $RCSfile: pgpdll60.c,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:50 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#ifdef WIN32

#define WIN32_LEAN_AND_MEAN
#include <windows.h>

#ifndef Included_pgpErrors_h
#include "pgpErrors.h"
#endif

#ifndef Included_pgpUtilities_h
#include "pgpUtilities.h"
#endif

/*
 * PGPcl.h
 */
extern PGPError PGPAPI PGPclInitLibrary (PGPContextRef context);
extern PGPError PGPAPI PGPclCloseLibrary (void);

#define PGPCL_DECRYPTIONCACHE 0x0001
#define PGPCL_SIGNINGCACHE    0x0002

extern BOOL PGPAPI PGPclPurgeCachedPassphrase (DWORD dwFlags);

/*
 * PGPContext.
 */
static PGPContextRef g_context = NULL;

PGPContextRef PGPGetContext_Impl (void)
{
	return g_context;
}

/*
 * DllMain.
 */
__declspec(dllexport) BOOL WINAPI DllMain (
	HINSTANCE hInst, DWORD dwReason, LPVOID lpReserved)
{
	switch (dwReason)
	{
		case DLL_PROCESS_ATTACH:
			if (g_context == NULL)
			{
				PGPError errcode = PGPsdkInit();
				if (IsntPGPError(errcode))
				{
					errcode = PGPNewContext (kPGPsdkAPIVersion, &g_context);
					if (IsntPGPError(errcode))
					{
						// PGPInitPassphraseCaches().
						errcode = PGPclInitLibrary (g_context);
					}
				}
			}
			break;

		case DLL_PROCESS_DETACH:
			if (g_context)
			{
#if 1  /* OK */
				PGPclPurgeCachedPassphrase (
					PGPCL_DECRYPTIONCACHE | PGPCL_SIGNINGCACHE);
#endif /* OK */
#if 0  /* BUG */
				// BUG: endless wait in PGPClosePassphraseCaches().
				PGPclCloseLibrary();
#endif /* BUG */
				PGPFreeContext (g_context);
				g_context = NULL;

				PGPsdkCleanup();
			}
			break;

		default:
			break;
	}
	return TRUE;
}

/*========================================================================
 *
 * The End.
 *
 *======================================================================*/

#endif /* WIN32 */

