/*************************************************************************
 *
 *  $RCSfile: testvfs.cxx,v $
 *
 *  $Revision: 1.1.1.1 $
 *
 *  last change: $Author: hr $ $Date: 2000/09/18 16:16:53 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/
#include <vfscontent.hxx>
#include <vfshelper.hxx>
#include <vfscontentprovider.hxx>

#include <vcl/wrkwin.hxx>
#include <vcl/svapp.hxx>
#include <vcl/menu.hxx>
#include <vcl/button.hxx>
#include <vcl/dialog.hxx>
#include <vcl/msgbox.hxx>
#include <svtools/svmedit.hxx>
#include <svtools/svtreebx.hxx>
#include <tools/datetime.hxx>
#include <tools/intn.hxx>

#include <cppuhelper/servicefactory.hxx>

#ifndef _COM_SUN_STAR_UCB_OPENCOMMANDARGUMENT_HPP_
#include <com/sun/star/ucb/OpenCommandArgument.hpp>
#endif
#ifndef _COM_SUN_STAR_UCB_XPROPERTYTASKPROCESSER_HPP_
#include <com/sun/star/ucb/XPropertyTaskProcessor.hpp>
#endif
#ifndef _COM_SUN_STAR_HIERARCHY_XCONTENTHIERARCHY_HPP_
#include <com/sun/star/hierarchy/XContentHierarchy.hpp>
#endif

#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif

#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XINDEXACCESS_HPP_
#include <com/sun/star/container/XIndexAccess.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_XCONTENTCREATOR_HPP_
#include <com/sun/star/ucb/XContentCreator.hpp>
#endif

#include <tools/stream.hxx>

using namespace com::sun::star::io;
using namespace com::sun::star::container;
using namespace com::sun::star::hierarchy;


class UnoMemoryStream : public SvMemoryStream, 
						public XInputStream,
						public XOutputStream,
						public OWeakObject
{

public:
	UnoMemoryStream( ULONG nInitSize = 0x3FFF, ULONG nResize = 0x3FFFF );

	Any 				SAL_CALL queryInterface( const Type& type ) throw(RuntimeException);
	void 				SAL_CALL acquire() throw(RuntimeException) { OWeakObject::acquire(); }
	void 				SAL_CALL release() throw(RuntimeException) { OWeakObject::release(); }
	
    
	// XInputStream
    sal_Int32			SAL_CALL readBytes( Sequence< sal_Int8 >& aData, sal_Int32 nBytesToRead ) throw( NotConnectedException, BufferSizeExceededException, RuntimeException );
    sal_Int32			SAL_CALL readSomeBytes( Sequence< sal_Int8 >& aData, sal_Int32 nMaxBytesToRead ) throw( NotConnectedException, BufferSizeExceededException, RuntimeException);
    void				SAL_CALL skipBytes( sal_Int32 nBytesToSkip ) throw( NotConnectedException, BufferSizeExceededException, RuntimeException );
    sal_Int32			SAL_CALL available() throw( NotConnectedException, RuntimeException );
    void				SAL_CALL closeInput() throw ( NotConnectedException, RuntimeException );

	// XOutputStream
    void				SAL_CALL writeBytes( const Sequence< sal_Int8 >& aData ) throw( NotConnectedException, BufferSizeExceededException, RuntimeException );
    void				SAL_CALL flush() throw( NotConnectedException, BufferSizeExceededException, RuntimeException );
    void				SAL_CALL closeOutput() throw( NotConnectedException,  BufferSizeExceededException,  RuntimeException );


};

UnoMemoryStream::UnoMemoryStream( ULONG nInitSize, ULONG nResize )
	: SvMemoryStream( nInitSize, nResize )
{
}

sal_Int32 UnoMemoryStream::readBytes( Sequence< sal_Int8 >& aData, sal_Int32 nBytesToRead ) throw( NotConnectedException, BufferSizeExceededException, RuntimeException )
{
	INT32 nRead = available();
	if ( nRead > nBytesToRead )
		nRead = nBytesToRead;
	
	Read( aData.getArray(), nRead );
	
	return nRead;
}

sal_Int32 UnoMemoryStream::readSomeBytes( Sequence< sal_Int8 >& aData, sal_Int32 nMaxBytesToRead ) throw( NotConnectedException, BufferSizeExceededException, RuntimeException)
{
	return readSomeBytes( aData, nMaxBytesToRead );
}

void UnoMemoryStream::skipBytes( sal_Int32 nBytesToSkip ) throw( NotConnectedException, BufferSizeExceededException, RuntimeException )
{
	SeekRel( nBytesToSkip );
}

sal_Int32 UnoMemoryStream::available() throw( NotConnectedException, RuntimeException )
{
	ULONG nPos = Tell();
	ULONG nEnd = Seek( STREAM_SEEK_TO_END );
	Seek( nPos );
	return nEnd - nPos;
}

void UnoMemoryStream::closeInput() throw ( NotConnectedException, RuntimeException )
{
}


void UnoMemoryStream::writeBytes( const Sequence< sal_Int8 >& aData ) throw( NotConnectedException, BufferSizeExceededException, RuntimeException )
{
	Write( aData.getConstArray(), aData.getLength() );
}

void UnoMemoryStream::flush() throw( NotConnectedException, BufferSizeExceededException, RuntimeException )
{
	Flush();
}

void UnoMemoryStream::closeOutput() throw( NotConnectedException,  BufferSizeExceededException,  RuntimeException )
{
}


Any UnoMemoryStream::queryInterface( const Type &type ) throw( RuntimeException )
{
	Any	aRet = ::cppu::queryInterface( type,
										SAL_STATIC_CAST( XInputStream*, this ), SAL_STATIC_CAST( XOutputStream*, this )	);

	return (aRet.hasValue() ? aRet : OWeakObject::queryInterface( type ));
}

String ReadFileContent( Reference<XContent> xContent )
{
	Reference<XCommandTaskProcessor> xCTP = Reference<XCommandTaskProcessor>::query( xContent );
	Reference<XContentTaskEnvironment> xCTE;
	com::sun::star::ucb::Command aCmd;
	aCmd.Name = L"open";
	aCmd.Handle = -1;
	UnoMemoryStream* pStream = new UnoMemoryStream;
	Reference<XOutputStream> xOut = pStream;
	OpenCommandArgument aOpenArg;
	aOpenArg.Sink = xOut;
	aCmd.Argument <<= aOpenArg; 
	// !!!!!!!!!!!! Reference< XCommandTask > xCT = xCTP->createCommandTask( aCmd, xCTE );
	Reference< XCommandTask > xCT;
	xCT->execute();
	pStream->Seek( 0xFFFFFFFF );
	ULONG nSize = pStream->Tell();
	String aStr;
	char* pBuf= aStr.AllocBuffer( nSize );
	pStream->Seek( 0 );
	pStream->Read( pBuf, nSize );
	return aStr;
}

void WriteFileContent( Reference<XContent> xContent, const String& rText )
{
	UnoMemoryStream* pStream = new UnoMemoryStream;
	pStream->Write( rText.GetStr(), rText.Len() );
	pStream->Seek( 0 );

	Reference<XCommandTaskProcessor> xCTP = Reference<XCommandTaskProcessor>::query( xContent );
	Reference<XContentTaskEnvironment> xCTE;
	com::sun::star::ucb::Command aCmd;
	aCmd.Name = L"insert";
	aCmd.Handle = -1;
	Reference<XInputStream> xIn = pStream;
	aCmd.Argument <<= xIn; 
	// !!!!!!!!!!!! Reference< XCommandTask > xCT = xCTP->createCommandTask( aCmd, xCTE );
	// xCT->execute();
}



inline UNODateTime GetUNODateTime( const Date& rDate, const Time& rTime )
{
	UNODateTime aDateTime;

	aDateTime.HundredthSeconds = rTime.Get100Sec();
	aDateTime.Seconds = rTime.GetSec();
	aDateTime.Minutes = rTime.GetMin();
	aDateTime.Hours = rTime.GetHour();

	aDateTime.Day = rDate.GetDay();
	aDateTime.Month = rDate.GetMonth();
	aDateTime.Year = rDate.GetYear();

	return aDateTime;
}

inline Date GetDate( const UNODateTime& rDateTime )
{
	Date aDate;

	aDate.SetDay( rDateTime.Day );
	aDate.SetMonth(rDateTime.Month );
	aDate.SetYear(rDateTime.Year );

	return aDate;
}

inline Time GetTime( const UNODateTime& rDateTime )
{
	Time aTime;

	aTime.Set100Sec( rDateTime.HundredthSeconds );
	aTime.SetSec( rDateTime.Seconds );
	aTime.SetMin( rDateTime.Minutes );
	aTime.SetHour( rDateTime.Hours );

	return aTime;
}


#define ENCODINGHACK	RTL_TEXTENCODING_MS_1252

class MyApp : public Application
{
public:
	void		Main();
};

MyApp aMyApp;

#define MENU_FILEMENU		1
#define MENU_CREATEFILE		2
#define MENU_CREATEFOLDER	3
#define MENU_READFILE		4
#define MENU_WRITEFILE		5
#define MENU_DELETE			6
#define MENU_RENAME			7
#define MENU_HIERACHY		8

class EditBox : public ModalDialog
{
	Edit*			pEdit;
	OKButton		aOKButton;

public:
					EditBox( Window* pParent, BOOL bMultiLine );
					~EditBox();

	String			GetEditText() const { return pEdit->GetText(); }
	void			SetEditText( const String& rText ) { pEdit->SetText( rText ); }
};

EditBox::EditBox( Window* pParent, BOOL bMultiLine ) : ModalDialog( pParent, WB_CLOSEABLE ), aOKButton( this, WB_DEFBUTTON )
{
	pEdit = bMultiLine ? new MultiLineEdit( this, 0 ) : new Edit( this, 0 );
	if ( bMultiLine )
	{
		SetOutputSizePixel( Size( 300, 155 ) );
		pEdit->SetPosSizePixel( Point( 20, 20 ), Size( 260, 100 ) );
		aOKButton.SetPosSizePixel( Point( 125, 125 ), Size( 50, 20 ) );
	}
	else
	{
		SetOutputSizePixel( Size( 300, 75 ) );
		pEdit->SetPosSizePixel( Point( 20, 20 ), Size( 260, 20 ) );
		aOKButton.SetPosSizePixel( Point( 125, 45 ), Size( 50, 20 ) );
	}

	pEdit->Show();
	aOKButton.Show();
	pEdit->GrabFocus();
}

EditBox::~EditBox()
{
	delete pEdit;
}

class InfoWindow : public Window
{
private:
	International	aInternational;
	DateTime		aCreationDate;
	DateTime		aModifyDate;
	String			aTitle;
	BOOL			bArchive;
	BOOL			bHidden;
	BOOL			bReadOnly;

public:
				InfoWindow( Window* pParent );

	void		UpdateInfos( Reference<XContent> xContent );
	void		Paint( const Rectangle& rRect );

};

class ContentWindow : public Window
{
private:
	MultiLineEdit		aEdit;
	PushButton			aWriteButton;
	Reference<XContent>	xContent;

	DECL_LINK(	ModifyHdl, void* );

public:
				ContentWindow( Window* pParent );

	void		Resize();

	void		SetWriteHdl( Link& rLnk ) { aWriteButton.SetClickHdl( rLnk ); }
	String		GetEditText() const { return aEdit.GetText(); }

	void		SetContent( Reference<XContent> xContent );
};

ContentWindow::ContentWindow( Window* pParent ) : 
	Window( pParent, 0 ),
	aEdit( this, 0 ),
	aWriteButton( this, WB_DEFBUTTON|WB_NOPOINTERFOCUS )
{
	aWriteButton.SetText( "Write" );
	aWriteButton.Show();
	aEdit.SetControlBackground( Color( COL_LIGHTGRAY ) );
	aEdit.SetModifyHdl( LINK( this, ContentWindow, ModifyHdl ) );
	SetBackground( Color( COL_GRAY ) );
}

void ContentWindow::SetContent( Reference<XContent> xC )
{
	xContent = xC;

	if ( xC.is() && ( xC->getContentType() == L"File" ) )
	{
		String aContent = ReadFileContent( xC );
		aEdit.SetText( aContent );
		aEdit.SetControlBackground( Color( COL_LIGHTGRAY ) );
		aEdit.Show();
		aWriteButton.Show();
		aWriteButton.Disable();
	}
	else
	{
		aEdit.Hide();
		aWriteButton.Hide();
		aEdit.SetText( String() );
	}
}

IMPL_LINK( ContentWindow, ModifyHdl, void*, EMPTYARG )
{
	aWriteButton.Enable();
	aEdit.SetControlBackground( Color( COL_WHITE ) );
	return 0;
}


void ContentWindow::Resize()
{
	Size aSz = GetOutputSizePixel();
	Size aButtonSize( 50, 20 );
	long nExtra = 10;
	long nFrame = 3;
	aEdit.SetPosSizePixel( Point( nFrame, nFrame ), Size( aSz.Width() - nFrame*2, aSz.Height()-aButtonSize.Height()-nExtra*2 ) );
	aWriteButton.SetPosSizePixel( Point( 20, aSz.Height()-aButtonSize.Height()-nFrame ), aButtonSize);
}




InfoWindow::InfoWindow( Window* pParent ) : Window( pParent, 0 )
{
	aInternational = Application::GetAppInternational();
	SetBackground( Color( COL_LIGHTGRAY ) );
}

void InfoWindow::UpdateInfos( Reference<XContent> xContent )
{
	VFSContent* pC = (VFSContent*)(XContent*)xContent.get();

	aCreationDate.SetDate( GetDate( pC->GetExtendedAttributes().aDateCreated ).GetDate() );
	aCreationDate.SetTime( GetTime( pC->GetExtendedAttributes().aDateCreated ).GetTime() );

	aModifyDate.SetDate( GetDate( pC->GetExtendedAttributes().aDateModified ).GetDate() );
	aModifyDate.SetTime( GetTime( pC->GetExtendedAttributes().aDateModified ).GetTime() );

	aTitle = OUStringToOString( pC->GetExtendedAttributes().aTitle, RTL_TEXTENCODING_UTF8 ).getStr();

	bArchive = pC->aSimpleAttributes.bIsArchive;
	bReadOnly = pC->aSimpleAttributes.bIsReadOnly;
	bHidden = pC->aSimpleAttributes.bIsHidden;

	Invalidate();
}

void InfoWindow::Paint( const Rectangle& rRect )
{
	long nH = GetTextSize( "" ).Height();
	Point aPos( 5, 5 );
	String aTmp;

	aTmp = "Attribs: ";
	DrawText( aPos, aTmp );
	aPos.Y() += nH;
	aTmp = " R";
	aTmp += bReadOnly ? '+' : '-';
	aTmp += " A";
	aTmp += bArchive ? '+' : '-';
	aTmp += " H";
	aTmp += bHidden ? '+' : '-';
	DrawText( aPos, aTmp );
	aPos.Y() += 2*nH;

	aTmp = "Title: ";
	DrawText( aPos, aTmp );
	aPos.Y() += nH;
	aTmp = " ";
	aTmp += aTitle;
	DrawText( aPos, aTmp );
	aPos.Y() += 2*nH;

	aTmp = "Created: ";
	DrawText( aPos, aTmp );
	aPos.Y() += nH;
	aTmp = "  ";
	aTmp += aInternational.GetDate( aCreationDate );
	DrawText( aPos, aTmp );
	aPos.Y() += nH;
	aTmp = "  ";
	aTmp += aInternational.GetTime( aCreationDate );
	DrawText( aPos, aTmp );
	aPos.Y() += 2*nH;

	aTmp = "Modified: ";
	DrawText( aPos, aTmp );
	aPos.Y() += nH;
	aTmp = "  ";
	aTmp += aInternational.GetDate( aModifyDate );
	DrawText( aPos, aTmp );
	aPos.Y() += nH;
	aTmp = "  ";
	aTmp += aInternational.GetTime( aModifyDate );
	DrawText( aPos, aTmp );
	aPos.Y() += 2*nH;
}


class VFSTreeList : public SvTreeListBox
{
private:
	OUString								aVFSRoot;
	Reference< XContentProvider >			xCP;
	Reference<XContentIdentifierFactory>	xCIDF;
	Reference<XContentIdentifier>			xCID;


protected:
	virtual void			RequestingChilds( SvLBoxEntry* pParent );
	virtual void			ExpandedHdl();

//	virtual SvLBoxEntry* 	CloneEntry( SvLBoxEntry* pSource );
//	virtual long			ExpandingHdl();

public:
					VFSTreeList( Window* pParent );
					~VFSTreeList();

	void			Clear();
};

VFSTreeList::VFSTreeList( Window* pParent ) : SvTreeListBox( pParent, WB_HASLINES )
{
	SetSelectionMode( SINGLE_SELECTION );

	aVFSRoot = L"vfs://file:///f|/test.vfs?/";
	xCP = new VFSContentProvider;
	xCIDF = Reference<XContentIdentifierFactory>::query(xCP);
	xCID = xCIDF->createContentIdentifier( aVFSRoot );

	Reference< XContent > xC = xCP->queryContent( xCID );
	if ( xC.is() )
	{
		SvLBoxEntry* pEntry = InsertEntry( "<R O O T>", 0, TRUE, LIST_APPEND );
		pEntry->SetUserData( new Reference< XContent >(xC) );
	}

}

VFSTreeList::~VFSTreeList()
{
	Clear();
}

void VFSTreeList::Clear()
{
	SvLBoxEntry* pEntry = First();
	while ( pEntry )
	{
		delete (Reference< XContent >*)pEntry->GetUserData();
		pEntry = Next( pEntry );
	}
	SvTreeListBox::Clear();
}

void VFSTreeList::RequestingChilds( SvLBoxEntry* pEntry )
{
	Reference< XContent >* pContentRef = (Reference< XContent >*)pEntry->GetUserData();
	Reference<XIndexAccess> xIndexAccess = 	Reference<XIndexAccess>::query(*pContentRef);
	if ( xIndexAccess.is() )
	{
		sal_Int32 nEntries = xIndexAccess->getCount();
		for ( sal_Int32 n = 0; n < nEntries; n++ )
		{
			Any aAny = xIndexAccess->getByIndex( n );
			Reference<XContent> xC;
			aAny >>= xC;
			if ( xC.is() )
			{
				OUString aStr = xC->getIdentifier()->getContentIdentifier();
				String aTmpEntryStr = OUStringToOString( aStr, ENCODINGHACK ).getStr();
				USHORT nTokens = aTmpEntryStr.GetTokenCount( '/' );
				String aEntryStr = aTmpEntryStr.GetToken( nTokens-1, '/' );
				if ( !aEntryStr.Len() )
					aEntryStr = aTmpEntryStr.GetToken( nTokens-2, '/' );
				if ( xC->getContentType() == L"Folder" )
				{
					aEntryStr.Insert( "<", 0 );
					aEntryStr.Insert( ">", aEntryStr.Len() );
				}
				SvLBoxEntry* pE = InsertEntry( aEntryStr, pEntry, TRUE, LIST_APPEND );
				pE->SetUserData( new Reference<XContent>(xC) );
			}
		}
	}
}

void VFSTreeList::ExpandedHdl()
{
	SvLBoxEntry* pEntry = GetHdlEntry();
	DBG_ASSERT( pEntry, "Was wurde zugeklappt?" );
	// Die OnDemand erzeugten Childs loeschen,
	// SubChilds werden automatisch geloescht.
	if ( !IsExpanded( pEntry ) && pEntry->HasChildsOnDemand() )
	{
		SvLBoxEntry* pChild = FirstChild( pEntry );
		while ( pChild )
		{
			delete (Reference< XContent >*)pChild->GetUserData();
			pChild->SetUserData( NULL );
			GetModel()->Remove( pChild );	// Ruft auch den DTOR
			pChild = FirstChild( pEntry );
		}
	}
}


// -----------------------------------------------------------------------

class MyWin : public WorkWindow
{
private:
	VFSTreeList	aTreeList;
	InfoWindow	aInfoWindow;
	ContentWindow	aContentWindow;
	MenuBar		aMenuBar;
	PopupMenu	aFileMenu;

protected:
	DECL_LINK(	MenuSelect, Menu* );
	DECL_LINK(	TreeSelect, void* );
	DECL_LINK(	WriteHdl, void* );


public:
				MyWin( Window* pParent, WinBits nWinStyle );

//	void		MouseMove( const MouseEvent& rMEvt );
//	void		MouseButtonDown( const MouseEvent& rMEvt );
//	void		MouseButtonUp( const MouseEvent& rMEvt );
//	void		KeyInput( const KeyEvent& rKEvt );
//	void		KeyUp( const KeyEvent& rKEvt );
//	void		Paint( const Rectangle& rRect );
	void		Resize();
};

// -----------------------------------------------------------------------

void MyApp::Main()
{
	// 564???
//	Reference<XMultiServiceFactory> xMSF = cppu::getDefaultRegistryServiceFactory();

	MyWin aMainWin( NULL, WB_APP | WB_STDWORK );
	aMainWin.SetText( "Star-View - Workbench" );
	aMainWin.Show();

	Execute();

//	Reference<XComponent> xComp = Reference<XComponent>::query(xMSF);
//	xComp->dispose();
}

// -----------------------------------------------------------------------

MyWin::MyWin( Window* pParent, WinBits nWinStyle ) :
	WorkWindow( pParent, nWinStyle ), aTreeList( this ), aInfoWindow( this ), aContentWindow( this )
{
	aTreeList.Show();
	aTreeList.SetSelectHdl( LINK( this, MyWin, TreeSelect ) );
	aInfoWindow.Show();
	aContentWindow.SetWriteHdl( LINK( this, MyWin, WriteHdl ) );
	aContentWindow.Show();

	aMenuBar.InsertItem( MENU_FILEMENU, "~File" );
	aFileMenu.InsertItem( MENU_CREATEFILE, "Create File"  );
	aFileMenu.InsertItem( MENU_CREATEFOLDER, "Create Folder" );
	aFileMenu.InsertSeparator();
	aFileMenu.InsertItem( MENU_READFILE, "Read" );
	aFileMenu.InsertItem( MENU_WRITEFILE, "Write" );
	aFileMenu.InsertSeparator();
	aFileMenu.InsertItem( MENU_DELETE, "Delete" );
	aFileMenu.InsertSeparator();
	aFileMenu.InsertItem( MENU_RENAME, "Rename" );
	aFileMenu.InsertSeparator();
	aFileMenu.InsertItem( MENU_HIERACHY, "Hierachy..." );


	aMenuBar.SetPopupMenu( MENU_FILEMENU, &aFileMenu );
	aMenuBar.SetSelectHdl( LINK( this, MyWin, MenuSelect ) );

	Application::SetAppMenu( &aMenuBar );
}

IMPL_LINK( MyWin, WriteHdl, void*, EMPTYARG )
{
	SvLBoxEntry* pCurrent = aTreeList.GetCurEntry();
	Reference< XContent > xContent = *(Reference< XContent >*)pCurrent->GetUserData();
	WriteFileContent( xContent, aContentWindow.GetEditText() );
	return 0;
}

IMPL_LINK( MyWin, MenuSelect, Menu*, pMenu )
{
	SvLBoxEntry* pCurrent = aTreeList.GetCurEntry();
	Reference< XContent > xContent = *(Reference< XContent >*)pCurrent->GetUserData();
	switch( pMenu->GetCurItemId() )
	{
		case MENU_READFILE: 
		{
			String aFileContent = ReadFileContent( xContent );
			EditBox aBox( this, TRUE );
			aBox.SetEditText( aFileContent );
			aBox.Execute();
		}
		break;
		case MENU_WRITEFILE: 
		{
			EditBox aBox( this, TRUE );
			if( aBox.Execute() )
			{
				String aText = aBox.GetEditText();
				WriteFileContent( xContent, aText );
			}
		}
		break;
		case MENU_CREATEFILE:
		case MENU_CREATEFOLDER: 
		{
			Reference<XContentCreator> xContentCreator = Reference<XContentCreator>::query(xContent);
			if ( xContentCreator.is() )
			{
				EditBox aEditBox( this, FALSE );
				if ( aEditBox.Execute() )
				{
					ContentInfo aCI;
					aCI.Type = ( pMenu->GetCurItemId() == MENU_CREATEFOLDER ) ? L"Folder" : L"File";
					Reference<XContent> xC = xContentCreator->createNewContent ( aCI );
					if ( xC.is() )
					{
						Sequence< PropertyValue > aProps( 1 );
						aProps[0].Name = L"Title";
						aProps[0].Value <<= OStringToOUString( aEditBox.GetEditText().GetStr(), RTL_TEXTENCODING_UTF8 );
			
						Reference< XPropertyTaskProcessor >	xPTP = Reference< XPropertyTaskProcessor >::query(xC);
						Reference< XPropertyTask >	xPT = xPTP->createPropertyTask( PropertyTaskType_SET, aProps, NULL );
						xPT->execute();

						sal_Bool bDone = sal_False; // xContentCreator->insertContent( xC );

						DBG_ASSERT( bDone, "Content not inserted!" );
						if ( bDone )
						{
							String aEntryStr( aEditBox.GetEditText() );
							if ( xC->getContentType() == L"Folder" )
							{
								aEntryStr.Insert( "<", 0 );
								aEntryStr.Insert( ">", aEntryStr.Len() );
							}
							SvLBoxEntry* pEntry = aTreeList.InsertEntry( aEntryStr, pCurrent, TRUE, LIST_APPEND );
							pEntry->SetUserData( new Reference<XContent>(xC) );
							aTreeList.SetCurEntry( pCurrent );
							aTreeList.MakeVisible( pCurrent );
						}
					}
					else
					{
						InfoBox( this, "Content not created!" ).Execute();
					}
				}
			}
			else
			{
				InfoBox( this, "No ContentCreator!" ).Execute();
			}				

		}
		break;
		case MENU_DELETE:
		{
			Reference<XCommandTaskProcessor> xCTP = Reference<XCommandTaskProcessor>::query( xContent );
			Reference<XContentTaskEnvironment> xCTE;
			com::sun::star::ucb::Command aCmd;
			aCmd.Name = L"delete";
			aCmd.Handle = -1;
			// !!!!!!!!!!!! Reference< XCommandTask > xCT = xCTP->createCommandTask( aCmd, xCTE );
			// xCT->execute();

			delete (Reference< XContent >*)pCurrent->GetUserData();
			pCurrent->SetUserData( NULL );
			aTreeList.GetModel()->Remove( pCurrent );		
		}
		case MENU_RENAME:
		{
			EditBox aEditBox( this, FALSE );
			if ( aEditBox.Execute() )
			{
				Sequence< PropertyValue > aProps( 1 );
				aProps[0].Name = L"Title";
				aProps[0].Value <<= OStringToOUString( aEditBox.GetEditText().GetStr(), RTL_TEXTENCODING_UTF8 );
	
				Reference< XPropertyTaskProcessor >	xPTP = Reference< XPropertyTaskProcessor >::query(xContent);
				Reference< XPropertyTask >	xPT = xPTP->createPropertyTask( PropertyTaskType_SET, aProps, NULL );
				xPT->execute();
			}
		}
		case MENU_HIERACHY:
		{
			Reference< XContent > xRoot = *(Reference< XContent >*) aTreeList.GetEntry( 0 )->GetUserData();
			Reference< XContent > xCurrent = *(Reference< XContent >*) aTreeList.GetCurEntry()->GetUserData();
			Reference<XContentHierarchy> xContentHierarchy = Reference<XContentHierarchy>::query(xRoot);
			if ( xContentHierarchy.is() )
			{
				Sequence<Any> aIDs = xContentHierarchy->getHierarchyIdentifierFromContent( xCurrent );
				OString aResult( "Hierachy:\n========\n\n" );
				for ( USHORT n = aIDs.getLength(); n; )
				{
					OUString aID;
					aIDs[--n] >>= aID;
					aResult += OUStringToOString( aID, RTL_TEXTENCODING_UTF8 );
					aResult += OString( "\n" );
				}
				InfoBox( this, aResult ).Execute();

				Reference< XContent > xTest = xContentHierarchy->getContentFromHierarchyIdentifier(aIDs);
				if ( !xTest.is() )
					ErrorBox( this, WB_OK|WB_DEF_OK, "Content?!" ).Execute();

				sal_Bool bTest2 = xContentHierarchy->compareHierarchyIdentifiers( aIDs, aIDs );
				if ( !bTest2 )
					ErrorBox( this, WB_OK|WB_DEF_OK, "!??!??!?!??" ).Execute();


			}
		}
	}
	return 0;
}

IMPL_LINK( MyWin, TreeSelect, void*, pMenu )
{
	SvLBoxEntry* pCurrent = aTreeList.GetCurEntry();
	aInfoWindow.UpdateInfos( *(Reference< XContent >*)pCurrent->GetUserData() );
	aContentWindow.SetContent( *(Reference< XContent >*)pCurrent->GetUserData() );
	return 0;
}

void MyWin::Resize()
{
	Size aOutSz = GetOutputSizePixel();
	aInfoWindow.SetPosSizePixel( Point( 0, 0 ), Size( 100, aOutSz.Height()-100 ) );
	aTreeList.SetPosSizePixel( Point( 100, 0 ), Size( aOutSz.Width()-100, aOutSz.Height()-100 ) );
	aContentWindow.SetPosSizePixel( Point( 0, aOutSz.Height()-100 ), Size( aOutSz.Width(), 100 ) );

}
