#!/bin/sh
#*************************************************************************
#
#   $RCSfile: npsdkpatch.sh,v $
#
#   $Revision: 1.6 $
#
#   last change: $Author: pluby $ $Date: 2000/10/18 20:19:53 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc..
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

tarball="../download/mozilla-source-M16-stub.tar.gz"
unziptarball="../download/mozilla-source-M16-stub.tar"

if test -s "$tarball"; then
  if test "$OS" = "SOLARIS"; then
#Only SOLARIS
    _gnutar=`tar --version 2> /dev/null`
    gnutar=`echo $_gnutar | awk '/GNU/ { print "true" }'`
    if test "$gnutar" = "true"; then
       tar -T flist.cp -x -z -f $tarball
       chmod -R +w mozilla 
       tar -x -z -f npsdk.pat.tar.gz
    else
       gunzip -d $tarball
       tar xf $unziptarball -I flist.cp
       chmod -R +w mozilla
       gzip $unziptarball
       gunzip npsdk.pat.tar.gz
       tar xf npsdk.pat.tar
       gzip npsdk.pat.tar
    fi
  elif test "$OS" = "MACOSX"; then
#Only MACOSX 
    tar -x -z -f $tarball `cat flist.cp`
    tar -x -z -f npsdk.pat.tar.gz
  else
#LINUX and others
    tar -T flist.cp -x -z -f $tarball
    tar -x -z -f npsdk.pat.tar.gz
  fi

#
# convert the files into unix format
#

  for CPNAME in `cat flist.cp`
  do
     if test -s "$CPNAME"; then
      mv -f $CPNAME ./pat.tmp
      sed -e 's/
$//' ./pat.tmp > $CPNAME
      rm -f pat.tmp
     fi
  done

#
# move the files into the final place
#

  for FNAME in `cat flist.cp`
  do
    cp $FNAME rtufiles/
  done
  rm -rf mozilla

#
# apply the patches
#

  for PNAME in `cat flist.pat`
  do
    patch -i pat/$PNAME.pat rtufiles/$PNAME
  done

#
# copy the SD files into rtufiles directory
#

  for SDNAME in `cat flist.sd`
  do
    SDDIR=`dirname $SDNAME`
    if test ! -d "rtufiles/$SDDIR"; then
      mkdir -p rtufiles/$SDDIR
    fi
    cp sdfiles/$SDNAME rtufiles/$SDNAME
  done

  echo Patch done. > patchinf
  echo Patch done.
  rm -f patcherror
  rm -rf pat
else

#
# error message
#

  echo "Can't find the $tarball file. See patcherror file."
  echo "Source tarball is missing: $tarball " > patcherror
  echo "Copy it into <OPENOFFICE>/external/download directory. " >> patcherror
fi
