#!/bin/sh
#*************************************************************************
#
#   $RCSfile: odbcpatch.sh,v $
#
#   $Revision: 1.7 $
#
#   last change: $Author: armin $ $Date: 2001/02/06 14:26:14 $
#
#   The Contents of this file are made available subject to the terms of
#   either of the following licenses
#
#          - GNU Lesser General Public License Version 2.1
#          - Sun Industry Standards Source License Version 1.1
#
#   Sun Microsystems Inc., October, 2000
#
#   GNU Lesser General Public License Version 2.1
#   =============================================
#   Copyright 2000 by Sun Microsystems, Inc.
#   901 San Antonio Road, Palo Alto, CA 94303, USA
#
#   This library is free software; you can redistribute it and/or
#   modify it under the terms of the GNU Lesser General Public
#   License version 2.1, as published by the Free Software Foundation.
#
#   This library is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
#   Lesser General Public License for more details.
#
#   You should have received a copy of the GNU Lesser General Public
#   License along with this library; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston,
#   MA  02111-1307  USA
#
#
#   Sun Industry Standards Source License Version 1.1
#   =================================================
#   The contents of this file are subject to the Sun Industry Standards
#   Source License Version 1.1 (the "License"); You may not use this file
#   except in compliance with the License. You may obtain a copy of the
#   License at http://www.openoffice.org/license.html.
#
#   Software provided under this License is provided on an "AS IS" basis,
#   WITHOUT WARRUNTY OF ANY KIND, EITHER EXPRESS OR IMPLIED, INCLUDING,
#   WITHOUT LIMITATION, WARRUNTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
#   MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
#   See the License for the specific provisions governing your rights and
#   obligations concerning the Software.
#
#   The Initial Developer of the Original Code is: Sun Microsystems, Inc..
#
#   Copyright: 2000 by Sun Microsystems, Inc.
#
#   All Rights Reserved.
#
#   Contributor(s): _______________________________________
#
#
#
#*************************************************************************

tarball="../download/unixODBC-2.0.3-stub.tar.gz"
unziptarball="../download/unixODBC-2.0.3-stub.tar"

if test -s "$tarball"; then
  if test "$OS" = "SOLARIS"; then
#Only SOLARIS
    _gnutar=`tar --version 2> /dev/null`
    gnutar=`echo $_gnutar | awk '/GNU/ { print "true" }'`
    if test "$gnutar" = "true"; then
       tar -T flist.cp -x -z -f $tarball
       chmod -R +w unixODBC-2.0.3
       tar -x -z -f odbc.pat.tar.gz
    else
       gunzip -d $tarball
       tar xf $unziptarball -I flist.cp
       chmod -R +w unixODBC-2.0.3
       gzip unixODBC-2.0.3.tar
       gunzip odbc.pat.tar.gz
       tar xf odbc.pat.tar
       gzip odbc.pat.tar
    fi
  elif test "$OS" = "MACOSX"; then
#Only MACOSX 
    tar -x -z -f $tarball `cat flist.cp`
    tar -x -z -f odbc.pat.tar.gz
  else
#LINUX and others
    tar -T flist.cp -x -z -f $tarball
    tar -x -z -f odbc.pat.tar.gz
  fi

#
# copy and convert the files into unix format
#

  for CPNAME in `cat flist.cp`
  do
     cp $CPNAME rtufiles/
     if test -s "rtufiles/$CPNAME"; then
      mv -f rtufiles/$CPNAME rtufiles/conv.tmp
      sed -e 's/^M$//' rtufiles/conv.tmp > rtufiles/$CPNAME
      rm -f rtufiles/conv.tmp
     fi
  done
  rm -rf unixODBC-2.0.3

#
# apply the patches
#

  for PNAME in `cat flist.pat`
  do
	echo $PNAME
#      patch -i pat/$PNAME.pat rtufiles/$PNAME
  done

#
# insert our files into ready to use directory
#

  for SDNAME in `cat flist.sd`
  do
    SDDIR=`dirname $SDNAME`
    if test ! -d "rtufiles/$SDDIR"; then
      mkdir -p rtufiles/$SDDIR
    fi
    cp sdfiles/$SDNAME rtufiles/$SDNAME
  done

  echo Patch done. > patchinf
  echo Patch done.
  rm -f patcherror
  rm -rf pat

else
     echo "Can't find the $tarball file. See patcherror file."
     echo "Source tarball is missing: $tarball " >> patcherror
     echo "Copy it into $SRC_ROOT/external/download directory. " >> patcherror
fi

