/*************************************************************************
 *
 *  $RCSfile: Image.cxx,v $
 *
 *  $Revision: 1.10 $
 *
 *  last change: $Author: vg $ $Date: 2001/09/12 17:12:14 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#ifndef _FRM_IMAGE_HXX_
#include "Image.hxx"
#endif

#ifndef _COM_SUN_STAR_FORM_XSUBMIT_HPP_
#include <com/sun/star/form/XSubmit.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_SYSTEMPOINTER_HPP_
#include <com/sun/star/awt/SystemPointer.hpp>
#endif
#ifndef _COM_SUN_STAR_FORM_FORMCOMPONENTTYPE_HPP_
#include <com/sun/star/form/FormComponentType.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XDISPATCH_HPP_
#include <com/sun/star/frame/XDispatch.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XDISPATCHPROVIDER_HPP_
#include <com/sun/star/frame/XDispatchProvider.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_FRAMESEARCHFLAG_HPP_
#include <com/sun/star/frame/FrameSearchFlag.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XCONTROLLER_HPP_
#include <com/sun/star/frame/XController.hpp>
#endif
#ifndef _COM_SUN_STAR_FRAME_XFRAME_HPP_
#include <com/sun/star/frame/XFrame.hpp>
#endif
#ifndef _COM_SUN_STAR_UTIL_XURLTRANSFORMER_HPP_
#include <com/sun/star/util/XURLTransformer.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_ACTIONEVENT_HPP_
#include <com/sun/star/awt/ActionEvent.hpp>
#endif
#ifndef _COM_SUN_STAR_AWT_XACTIONLISTENER_HPP_
#include <com/sun/star/awt/XActionListener.hpp>
#endif

#ifndef _URLOBJ_HXX
#include <tools/urlobj.hxx>
#endif
#ifndef _TOOLS_DEBUG_HXX
#include <tools/debug.hxx>
#endif
#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif
#ifndef _SFXDOCFILE_HXX
#include <sfx2/docfile.hxx>
#endif
#ifndef _SFX_OBJSH_HXX //autogen
#include <sfx2/objsh.hxx>
#endif
#ifndef _VOS_MUTEX_HXX_
#include <vos/mutex.hxx>
#endif

#ifndef _USR_SMARTCONV_HXX_
#include "conversion.hxx"
#endif
#ifndef _FRM_SERVICES_HXX_
#include "services.hxx"
#endif
#ifndef _COMPHELPER_CONTAINER_HXX_
#include <comphelper/container.hxx>
#endif

#define LOCAL_URL_PREFIX	'#'

//.........................................................................
namespace frm
{
//.........................................................................

using namespace ::com::sun::star::uno;
using namespace ::com::sun::star::sdb;
using namespace ::com::sun::star::sdbc;
using namespace ::com::sun::star::sdbcx;
using namespace ::com::sun::star::beans;
using namespace ::com::sun::star::container;
using namespace ::com::sun::star::form;
using namespace ::com::sun::star::awt;
using namespace ::com::sun::star::io;
using namespace ::com::sun::star::lang;
using namespace ::com::sun::star::util;
using namespace ::com::sun::star::frame;


//==================================================================
// OImageControl
//==================================================================
//------------------------------------------------------------------------------
Sequence<Type> OImageControl::_getTypes()
{
    static Sequence<Type> aTypes;
    if (!aTypes.getLength())
        aTypes = concatSequences(OControl::_getTypes(), OImageControl_BASE::getTypes());
    return aTypes;
}

//------------------------------------------------------------------------------
OImageControl::OImageControl(const Reference<XMultiServiceFactory>& _rxFactory, const ::rtl::OUString& _aService)
                :OControl(_rxFactory, _aService)
                ,m_aApproveActionListeners(m_aMutex)
                ,m_aActionListeners(m_aMutex)
                ,m_pThread(NULL)
{
}

//------------------------------------------------------------------------------
OImageControl::~OImageControl()
{
    if (!OComponentHelper::rBHelper.bDisposed)
    {
        acquire();
        dispose();
    }
}

// UNO Anbindung
//------------------------------------------------------------------------------
Any SAL_CALL OImageControl::queryAggregation(const Type& _rType) throw (RuntimeException)
{
    Any aReturn = OControl::queryAggregation(_rType);
    if (!aReturn.hasValue())
        aReturn = OImageControl_BASE::queryInterface(_rType);
    return aReturn;
}

// XApproveActionBroadcaster
//------------------------------------------------------------------------------
void OImageControl::addApproveActionListener(
        const Reference<XApproveActionListener>& l) throw( RuntimeException )
{
    m_aApproveActionListeners.addInterface(l);
}

//------------------------------------------------------------------------------
void OImageControl::removeApproveActionListener(
        const Reference<XApproveActionListener>& l) throw( RuntimeException )
{
    m_aApproveActionListeners.removeInterface(l);
}

// OComponentHelper
//------------------------------------------------------------------------------
void OImageControl::disposing()
{
    EventObject aEvt(static_cast<XWeak*>(this));
    m_aApproveActionListeners.disposeAndClear(aEvt);
    m_aActionListeners.disposeAndClear(aEvt);

    {
        ::osl::MutexGuard aGuard( m_aMutex );
        if( m_pThread )
        {
            m_pThread->release();
            m_pThread = NULL;
        }
    }

    OControl::disposing();
}

//------------------------------------------------------------------------------
void OImageControl::propertyChange( const PropertyChangeEvent& rEvt )
    throw( RuntimeException )
{
    Reference<XWindowPeer>  xPeer(getPeer());
    if (!xPeer.is())
        return;

    // Wenn eine URL gesetzt worden ist, muss die Hand angezeigt werden
    if( ( rEvt.PropertyName == PROPERTY_TARGET_URL ) &&
        ( rEvt.NewValue.getValueType().getTypeClass() == ::com::sun::star::uno::TypeClass_STRING ) )
    {

        Reference<XPointer> xPoint(
            m_xServiceFactory->createInstance(SRV_AWT_POINTER), UNO_QUERY);
        if (xPoint.is())
            if (getString(rEvt.NewValue).getLength())
                xPoint->setType(SystemPointer::REFHAND);
            else
                xPoint->setType(SystemPointer::ARROW);

        xPeer->setPointer(xPoint);
    }
}

// XControl
//------------------------------------------------------------------------------
void SAL_CALL OImageControl::createPeer(const Reference<XToolkit>& _rxToolkit, const Reference<XWindowPeer>& Parent) throw( RuntimeException )
{
    OControl::createPeer(_rxToolkit, Parent);
    Reference<XWindowPeer>  xPeer = getPeer();

    // Pointer umsetzen
    if (!xPeer.is())
        return;

    Reference<XFastPropertySet>  xSet(getModel(), UNO_QUERY);
    if (xSet.is())
    {
        // ist eine TargetUrl gesetzt, wird die Refhand verwendet
        if (getString(xSet->getFastPropertyValue(PROPERTY_ID_TARGET_URL)).getLength())
        {
            Reference<XPointer> xPoint(
                m_xServiceFactory->createInstance(SRV_AWT_POINTER), UNO_QUERY);
            if (xPoint.is())
                xPoint->setType(SystemPointer::REFHAND);
            xPeer->setPointer(xPoint);
        }
    }

    // dem ImageProducer einen neuen Consumer bekannt geben
    Reference<XImageProducerSupplier>  xImgSrc(getModel(), UNO_QUERY);
    if (!xImgSrc.is())
        return;

    Reference<XImageProducer>  xImgProd = xImgSrc->getImageProducer();
    Reference<XImageConsumer>  xImgCons(xPeer, UNO_QUERY);

    xImgProd->addConsumer(xImgCons);
    xImgProd->startProduction();
}

//------------------------------------------------------------------------------
sal_Bool OImageControl::setModel(const Reference<XControlModel>& Model) throw ( ::com::sun::star::uno::RuntimeException)
{
    Reference<XPropertySet>  xSet(getModel(), UNO_QUERY);
    if (xSet.is())
        xSet->removePropertyChangeListener(PROPERTY_TARGET_URL, this);

    sal_Bool bRes = OControl::setModel(Model);
    if (bRes)
    {
        xSet = Reference<XPropertySet> (Model, UNO_QUERY);
        if (xSet.is())
            xSet->addPropertyChangeListener(PROPERTY_TARGET_URL, this);
    }
    return bRes;
}

//------------------------------------------------------------------------------
Reference< XModel >  OImageControl::getXModel(const InterfaceRef& xIface) const
{
    Reference< XModel >  xModel(xIface, UNO_QUERY);
    if (xModel.is())
        return xModel;
    else
    {
        Reference<XChild>  xChild(xIface, UNO_QUERY);
        if (xChild.is())
        {
            InterfaceRef  xParent = xChild->getParent();
            return getXModel(xParent);
        }
        else
            return NULL;
    }
}

//------------------------------------------------------------------------------
// Diese Methode wird auch aus einem Thread gerufen und muss deshalb
// thread-safe sein.
void OImageControl::actionPerformed_Impl(sal_Bool bNotifyListener, const MouseEvent& rEvt)
{
    if( bNotifyListener )
    {
        sal_Bool bCanceled = sal_False;
        ::cppu::OInterfaceIteratorHelper aIter(m_aApproveActionListeners);
        EventObject aEvt(static_cast<XWeak*>(this));
        while( !bCanceled && aIter.hasMoreElements() )
        {
            XInterface *pNext = aIter.next();
            // Jede approveAction-Methode muss thread-safe sein!!!
            if( !((XApproveActionListener*)pNext)->approveAction(aEvt) )
                bCanceled = sal_True;
        }

        if (bCanceled)
            return;
    }

    // Ob der Rest des Codes Thread-Safe ist weiss man nicht genau. Deshalb
    // wird das meiste bei gelocktem Solar-Mutex erledigen.
    Reference<XPropertySet>  xSet;
    InterfaceRef  xParent;
    FormButtonType eButtonType;
    {
        ::vos::OGuard aGuard( Application::GetSolarMutex() );

        // Parent holen
        Reference<XFormComponent>  xComp(getModel(), UNO_QUERY);
        if (!xComp.is())
            return;

        xParent = xComp->getParent();
        if (!xParent.is())
            return;

        // Welchen ButtonType haben wir?
        if (!query_interface((::com::sun::star::uno::Reference< ::com::sun::star::uno::XInterface >)xComp, xSet))
            return;
        eButtonType = *(FormButtonType*)xSet->getPropertyValue(PROPERTY_BUTTONTYPE).getValue();
    }

    switch (eButtonType)
    {
        case FormButtonType_RESET:
        {
            // reset-Methoden muessen thread-safe sein!
            Reference<XReset>  xReset(xParent, UNO_QUERY);
            if (!xReset.is())
                return;

            xReset->reset();
        }
        break;

        case FormButtonType_SUBMIT:
        {
            // submit-Methoden muessen thread-safe sein!
            Reference<XSubmit>  xSubmit(xParent, UNO_QUERY);
            if (!xSubmit.is())
                return;

            xSubmit->submit(this, rEvt);
        }
        break;

        case FormButtonType_URL:
        {
            ::vos::OGuard aGuard( Application::GetSolarMutex() );

            Reference< XModel >  xModel = getXModel(xParent);
            if (!xModel.is())
                return;

            ///////////////////////////////////////////////////////////////////////
            // Jetzt URL ausfuehren
            Reference< XController >  xController = xModel->getCurrentController();
            if (!xController.is())
                return;

            Reference< XFrame >  xFrame = xController->getFrame();
            if( !xFrame.is() )
                return;

            URL aURL;
            aURL.Complete =
                getString(xSet->getPropertyValue(PROPERTY_TARGET_URL));

			if (aURL.Complete.getLength() && (LOCAL_URL_PREFIX == aURL.Complete.getStr()[0]))
			{	// the URL contains a local URL only. Since the URLTransformer does not handle this case correctly
				// (it can't: it does not know the document URL), we have to take care for this ourself.
				// The real solution would be to not allow such relative URLs (there is a rule that at runtime, all
				// URLs have to be absolute), but for compatibility reasons this is no option.
				// The more as the user does not want to see a local URL as "file://<path>/<document>#mark" if it
				// could be "#mark" as well.
				// If we someday say that this hack (yes, it's kind of a hack) is not sustainable anymore, the complete
				// solutiuon would be:
				// * recognize URLs consisting of a mark only while _reading_ the document
				// * for this, allow the INetURLObject (which at the moment is invoked when reading URLs) to
				//   transform such mark-only URLs into correct absolute URLs
				// * at the UI, show only the mark
				// * !!!! recognize every SAVEAS on the document, so the absolute URL can be adjusted. This seems
				// rather impossible !!!
				// 89752 - 23.07.2001 - frank.schoenheit@sun.com
				aURL.Mark = aURL.Complete;
				aURL.Complete = xModel->getURL();
				aURL.Complete += aURL.Mark;
			}

            Reference<XURLTransformer>
                xTransformer(m_xServiceFactory->createInstance(
                    ::rtl::OUString::createFromAscii("com.sun.star.util.URLTransformer")), UNO_QUERY);

            if (xTransformer.is())
                xTransformer->parseSmart( aURL, ::rtl::OUString::createFromAscii(INET_FILE_SCHEME) );

            ::rtl::OUString aTargetFrame;
            xSet->getPropertyValue(PROPERTY_TARGET_FRAME) >>= aTargetFrame;

            Reference< XDispatch >  xDisp = Reference< XDispatchProvider > (xFrame,UNO_QUERY)->queryDispatch( aURL, aTargetFrame,
                    FrameSearchFlag::SELF | FrameSearchFlag::PARENT |
                    FrameSearchFlag::SIBLINGS | FrameSearchFlag::CREATE );

            Sequence<PropertyValue> aArgs(1);
            PropertyValue& rProp = aArgs.getArray()[0];
            rProp.Name = ::rtl::OUString::createFromAscii("Referer");
            rProp.Value <<= xModel->getURL();

            if (xDisp.is())
                xDisp->dispatch( aURL, aArgs );
        }   break;
        default:
        {
                // notify the action listeners for a push button
            ActionEvent aEvt(static_cast<XWeak*>(this), m_aActionCommand);
            NOTIFY_LISTENERS(m_aActionListeners, XActionListener, actionPerformed, aEvt);
        }
    }
}


//==================================================================
// OImageModel
//==================================================================
//------------------------------------------------------------------------------
Sequence<Type> OImageModel::_getTypes()
{
    static Sequence<Type> aTypes;
    if (!aTypes.getLength())
    {
        // my base class
        Sequence<Type> aBaseClassTypes = OControlModel::_getTypes();

        Sequence<Type> aOwnTypes(1);
        Type* pOwnTypes = aOwnTypes.getArray();
        pOwnTypes[0] = getCppuType((Reference<XImageProducerSupplier>*)NULL);

        aTypes = concatSequences(aBaseClassTypes, aOwnTypes);
    }
    return aTypes;
}

//------------------------------------------------------------------
OImageModel::OImageModel(
                    const Reference<XMultiServiceFactory>& _rxFactory,
                    const ::rtl::OUString& _rUnoControlModelTypeName,
                    const ::rtl::OUString& rDefault)
              :OControlModel(_rxFactory, _rUnoControlModelTypeName, rDefault)
              ,OPropertyChangeListener(m_aMutex)
              ,m_pProducer(new ImageProducer)
              ,m_pMedium(NULL)
              ,m_bDownloading(sal_False)
              ,m_bProdStarted(sal_False)
{
    increment(m_refCount);
    m_xProducer = m_pProducer;

    m_eButtonType = FormButtonType_PUSH;

    if (m_xAggregateSet.is())
    {
        OPropertyChangeMultiplexer* pMultiplexer = new OPropertyChangeMultiplexer(this, m_xAggregateSet);
        pMultiplexer->addProperty(PROPERTY_IMAGE_URL);
    }
    decrement(m_refCount);
}

//------------------------------------------------------------------------------
OImageModel::~OImageModel()
{
    if (!OComponentHelper::rBHelper.bDisposed)
    {
        acquire();
        dispose();
    }
    DBG_ASSERT(m_pMedium == NULL, "OImageModel::~OImageModel : leaving a memory leak ...");
        // spaetestens im dispose sollte das aufgeraeumt worden sein
}

// OComponentHelper
//------------------------------------------------------------------------------
void OImageModel::disposing()
{
    OControlModel::disposing();
    if (m_pMedium)
    {
        delete m_pMedium;
        m_pMedium = NULL;
    }

    m_xProducer = NULL;
}

//------------------------------------------------------------------------------
Any SAL_CALL OImageModel::queryAggregation(const Type& _rType) throw (RuntimeException)
{
    Any aReturn = OControlModel::queryAggregation(_rType);
    if (!aReturn.hasValue())
        aReturn = ::cppu::queryInterface(_rType
            ,static_cast<XImageProducerSupplier*>(this)
        );

    return aReturn;
}

//------------------------------------------------------------------------------
void OImageModel::getFastPropertyValue(Any& rValue, sal_Int32 nHandle) const
{
    switch (nHandle)
    {
        case PROPERTY_ID_BUTTONTYPE     : rValue <<= m_eButtonType; break;
        case PROPERTY_ID_TARGET_URL     : rValue <<= m_sTargetURL; break;
        case PROPERTY_ID_TARGET_FRAME   : rValue <<= m_sTargetFrame; break;
        default:
            OControlModel::getFastPropertyValue(rValue, nHandle);
    }
}

//------------------------------------------------------------------------------
void OImageModel::setFastPropertyValue_NoBroadcast(sal_Int32 nHandle, const Any& rValue) throw ( ::com::sun::star::uno::Exception)
{
    switch (nHandle)
    {
        case PROPERTY_ID_BUTTONTYPE :
            DBG_ASSERT(isA(rValue, static_cast<FormButtonType*>(NULL)), "OImageModel::setFastPropertyValue_NoBroadcast : invalid type !" );
            rValue >>= m_eButtonType;
            break;

        case PROPERTY_ID_TARGET_URL :
            DBG_ASSERT(rValue.getValueType().getTypeClass() == TypeClass_STRING, "OImageModel::setFastPropertyValue_NoBroadcast : invalid type !" );
            rValue >>= m_sTargetURL;
            break;

        case PROPERTY_ID_TARGET_FRAME :
            DBG_ASSERT(rValue.getValueType().getTypeClass() == TypeClass_STRING, "OImageModel::setFastPropertyValue_NoBroadcast : invalid type !" );
            rValue >>= m_sTargetFrame;
            break;

        default:
            OControlModel::setFastPropertyValue_NoBroadcast(nHandle, rValue);
    }
}

//------------------------------------------------------------------------------
sal_Bool OImageModel::convertFastPropertyValue(Any& rConvertedValue, Any& rOldValue, sal_Int32 nHandle, const Any& rValue)
                            throw( IllegalArgumentException )
{
    switch (nHandle)
    {
        case PROPERTY_ID_BUTTONTYPE :
        {
            if (!isA(rValue, static_cast<FormButtonType*>(NULL)))
            {
                throw IllegalArgumentException();
            }

            FormButtonType eVal;
            rValue >>= eVal;
            if (eVal != m_eButtonType)
            {
                rConvertedValue = rValue;
                rOldValue <<= m_eButtonType;
                return sal_True;
            }
            return sal_False;
        }
        break;

        case PROPERTY_ID_TARGET_URL :
            return tryPropertyValue(rConvertedValue, rOldValue, rValue, m_sTargetURL);

        case PROPERTY_ID_TARGET_FRAME :
            return tryPropertyValue(rConvertedValue, rOldValue, rValue, m_sTargetFrame);

        default:
            return OControlModel::convertFastPropertyValue(rConvertedValue, rOldValue, nHandle, rValue);
    }
}

//------------------------------------------------------------------------------
void OImageModel::StartProduction()
{
    ImageProducer *pImgProd = GetImageProducer();
    if (!m_pMedium)
    {
        // caution: the medium may be NULL if somebody gave us a invalid URL to work with
        // 11/24/2000 - 79667 - FS
        pImgProd->SetImage(String());
        m_bDownloading = sal_False;
        return;
    }

    if (m_pMedium->GetErrorCode()==0)
    {
        SvStream* pStream = m_pMedium->GetInStream();

        pImgProd->SetImage(*pStream);
        pImgProd->startProduction();
        m_bProdStarted = sal_True;
    }
    else
    {
        pImgProd->SetImage(String());
        delete m_pMedium;
        m_pMedium = 0;
        m_bDownloading = sal_False;
    }
}

//------------------------------------------------------------------------------
void OImageModel::SetURL( const ::rtl::OUString& rURL )
{
    if (m_pMedium || !rURL.getLength())
    {
        // Den Stream am Producer freigeben, bevor das Medium geloscht wird.
        GetImageProducer()->SetImage(String());
        delete m_pMedium;
        m_pMedium = NULL;
    }

    // the SfxMedium is not allowed to be created with an invalid URL, so we have to check this first
    // 23.01.2001 - 81927 - FS
    INetURLObject aUrl(rURL);
    if (INET_PROT_NOT_VALID == aUrl.GetProtocol())
        // we treat an invalid URL like we would treat no URL
        return;

    if (rURL.getLength())
    {
        if (m_pMedium)
            delete m_pMedium;

        m_pMedium = new SfxMedium(rURL, STREAM_STD_READ, sal_False);
        m_pMedium->SetTransferPriority(SFX_TFPRIO_VISIBLE_HIGHRES_GRAPHIC);
        m_pMedium->SetDataAvailableLink(
                STATIC_LINK(this, OImageModel, DataAvailableLink));

        // Das XModel suchen, um an die Object-Shell oder zumindest den
        // Referer zu gelangen.
        // Das Model findet man allerdings nur beim Laden von HTML-Dokumenten
        // und dann, wenn die URL in einem bereits geladenen Dokument
        // geaendert wird. Waehrend des Ladens kommt man nicht an das
        // Model ran.
        Reference< XModel >  xModel;
        InterfaceRef  xIfc( *this );
        while( !xModel.is() && xIfc.is() )
        {
            Reference<XChild>  xChild( xIfc, UNO_QUERY );
            xIfc = xChild->getParent();
            query_interface(xIfc, xModel);
        }

        // Die Object-Shell suchen, indem wir
        // ueber alle Object-Shells iterieren und deren XModel mit dem
        // eigenen vergleichen. Als Optimierung probieren wir aber erstmal
        // die aktuelle Object-Shell.
        // wir unser XModel mit dem aller Object
        SfxObjectShell *pObjSh = 0;

        if( xModel.is() )
        {
            SfxObjectShell *pTestObjSh = SfxObjectShell::Current();
            if( pTestObjSh )
            {
                Reference< XModel >  xTestModel = pTestObjSh->GetModel();
                if( xTestModel == xModel )
                    pObjSh = pTestObjSh;
            }
            if( !pObjSh )
            {
                SfxObjectShell *pTestObjSh = SfxObjectShell::GetFirst();
                while( !pObjSh && pTestObjSh )
                {
                    Reference< XModel > xTestModel = pTestObjSh->GetModel();
                    if( xTestModel == xModel )
                        pObjSh = pTestObjSh;
                    else
                        pTestObjSh = SfxObjectShell::GetNext( *pTestObjSh );
                }
            }
        }

#ifdef USE_REGISTER_TRANSFER
        if( pObjSh )
        {
            // Medium registrieren, damit abgebrochen werden kann
            pObjSh->RegisterTransfer( *m_pMedium );

            // Target-Frame uebertragen, damit auch javascript:-URLs
            // "geladen" werden koennen.
            const SfxMedium *pShMedium = pObjSh->GetMedium();
            if( pShMedium )
                m_pMedium->SetLoadTargetFrame(pShMedium->GetLoadTargetFrame());
        }
        else
        {
            // Keine Object-Shell, aber ein Medium? Dann uebernehmen wir
            // zumindest den Referer.
            if( xModel.is() )
            {
                ::rtl::OUString sReferer( xModel->getURL() );
                if( sReferer.getLength() )
                    m_pMedium->SetReferer( OUStringToString(sReferer, CHARSET_SYSTEM) );
            }

            // Keinen Eintrag im Roter Button Menu
            m_pMedium->SetDontCreateCancellable();
        }
#else
        if( pObjSh )
        {
            m_pMedium->SetUsesCache( !pObjSh->IsReloading() );

            // Target-Frame uebertragen, damit auch javascript:-URLs
            // "geladen" werden koennen.
            const SfxMedium *pShMedium = pObjSh->GetMedium();
            if( pShMedium )
                m_pMedium->SetLoadTargetFrame(pShMedium->GetLoadTargetFrame());
        }

        if( xModel.is() )
        {
            ::rtl::OUString sReferer( xModel->getURL() );
            if( sReferer.getLength() )
                m_pMedium->SetReferer( sReferer );
        }

        // Keinen Eintrag im Roter Button Menu
        m_pMedium->SetDontCreateCancellable();
#endif

        // Downloading-Flag auf sal_True setzen. Es werden dann auch
        // Data-Available-Links, wenn wir in den Pending-Staus gelangen.
        m_bDownloading = sal_True;
        m_bProdStarted = sal_False;

        // Download anstossen (Achtung: Kann auch synchron sein).
        m_pMedium->DownLoad(STATIC_LINK(this, OImageModel, DownloadDoneLink));
    }
    else
    {
        GetImageProducer()->startProduction();
    }
}

//------------------------------------------------------------------------------
void OImageModel::DataAvailable()
{
    if (!m_bProdStarted)
        StartProduction();

    GetImageProducer()->NewDataAvailable();
}

//------------------------------------------------------------------------------
void OImageModel::DownloadDone()
{
    DataAvailable();
    m_bDownloading = sal_False;
}

//------------------------------------------------------------------------------
IMPL_STATIC_LINK( OImageModel, DownloadDoneLink, void*, EMPTYARG )
{
    pThis->DownloadDone();
    return 0;
}

//------------------------------------------------------------------------------
IMPL_STATIC_LINK( OImageModel, DataAvailableLink, void*, EMPTYARG )
{
    pThis->DataAvailable();
    return 0;
}

//------------------------------------------------------------------------------
void OImageModel::_propertyChanged( const PropertyChangeEvent& rEvt )
    throw( RuntimeException )
{
    // Wenn eine URL gesetzt worden ist, muss die noch an den ImageProducer
    // weitergereicht werden.
    ::osl::MutexGuard aGuard(m_aMutex);
    SetURL( getString(rEvt.NewValue) );
}

//==================================================================
// OImageControlThread_Impl
//==================================================================
//------------------------------------------------------------------
EventObject* OImageControlThread_Impl::cloneEvent( const EventObject* _pEvt ) const
{
    return new EventObject( *_pEvt );
}

//------------------------------------------------------------------
void OImageControlThread_Impl::processEvent( ::cppu::OComponentHelper *pCompImpl,
                                               const EventObject* pEvt,
                                               const Reference<XControl>&,
                                               sal_Bool )
{
    ((OImageControl *)pCompImpl)->actionPerformed_Impl( sal_True, *(MouseEvent *)pEvt );
}

//.........................................................................
}   // namespace frm
//.........................................................................

