/*************************************************************************
 *
 *  $RCSfile: basedispatcher.cxx,v $
 *
 *  $Revision: 1.24.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/10/31 20:57:09 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include <tools/solar.h>

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_DISPATCH_BASEDISPATCHER_HXX_
#include <dispatch/basedispatcher.hxx>
#endif

#ifndef __FRAMEWORK_DISPATCH_INTERACTION_HXX_
#include <dispatch/interaction.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_ARGUMENTANALYZER_HXX_
#include <classes/argumentanalyzer.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_FILTERCACHE_HXX_
#include <classes/filtercache.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_TRANSACTIONGUARD_HXX_
#include <threadhelp/transactionguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_READGUARD_HXX_
#include <threadhelp/readguard.hxx>
#endif

#ifndef __FRAMEWORK_THREADHELP_WRITEGUARD_HXX_
#include <threadhelp/writeguard.hxx>
#endif

#ifndef __FRAMEWORK_SERVICES_H_
#include <services.h>
#endif

#ifndef __FRAMEWORK_GENERAL_H_
#include <general.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_TASK_XJOBEXECUTOR_HPP_
#include <com/sun/star/task/XJobExecutor.hpp>
#endif

#ifndef _COM_SUN_STAR_TASK_XSTATUSINDICATORFACTORY_HPP_
#include <com/sun/star/task/XStatusIndicatorFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_FRAMESEARCHFLAG_HPP_
#include <com/sun/star/frame/FrameSearchFlag.hpp>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_XTYPEDETECTION_HPP_
#include <com/sun/star/document/XTypeDetection.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XSYNCHRONOUSFRAMELOADER_HPP_
#include <com/sun/star/frame/XSynchronousFrameLoader.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XTASK_HPP_
#include <com/sun/star/frame/XTask.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_XTASKSSUPPLIER_HPP_
#include <com/sun/star/frame/XTasksSupplier.hpp>
#endif

#ifndef _COM_SUN_STAR_DOCUMENT_XACTIONLOCKABLE_HPP_
#include <com/sun/star/document/XActionLockable.hpp>
#endif

#ifndef _COM_SUN_STAR_MOZILLA_XPLUGININSTANCE_HPP_
#include <com/sun/star/mozilla/XPluginInstance.hpp>
#endif

#ifndef _COM_SUN_STAR_LANG_WRAPPEDTARGETRUNTIMEEXCEPTION_HPP_
#include <com/sun/star/lang/WrappedTargetRuntimeException.hpp>
#endif

#ifndef _COM_SUN_STAR_UCB_COMMANDABORTEDEXCEPTION_HPP_
#include <com/sun/star/ucb/CommandAbortedException.hpp>
#endif

#ifndef _COM_SUN_STAR_CONTAINER_XNAMEACCESS_HPP_
#include <com/sun/star/container/XNameAccess.hpp>
#endif

#ifndef _COM_SUN_STAR_FRAME_DISPATCHRESULTSTATE_HPP_
#include <com/sun/star/frame/DispatchResultState.hpp>
#endif

//_________________________________________________________________________________________________________________
//	includes of other projects
//_________________________________________________________________________________________________________________

#ifndef _SV_SVAPP_HXX
#include <vcl/svapp.hxx>
#endif

#ifndef _SV_WRKWIN_HXX
#include <vcl/wrkwin.hxx>
#endif

#ifndef INCLUDED_SVTOOLS_MODULEOPTIONS_HXX
#include <svtools/moduleoptions.hxx>
#endif

#ifndef _TOOLKIT_HELPER_VCLUNOHELPER_HXX_
#include <toolkit/unohlp.hxx>
#endif

#ifndef _CPPUHELPER_IMPLBASE1_HXX_
#include <cppuhelper/implbase1.hxx>
#endif

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

namespace framework{

class NotificationListener_Impl : public cppu::WeakImplHelper1< css::frame::XDispatchResultListener >
{
    BaseDispatcher*     pDispatcher;
    css::uno::WeakReference < css::frame::XNotifyingDispatch > xDispatcher;

public:
    NotificationListener_Impl( BaseDispatcher* pDisp )
        : pDispatcher( pDisp )
        , xDispatcher( pDisp )
    {
    }

    virtual void SAL_CALL dispatchFinished( const css::frame::DispatchResultEvent& aEvent ) throw( css::uno::RuntimeException );
    virtual void SAL_CALL disposing( const css::lang::EventObject& aEvent ) throw( css::uno::RuntimeException );
};

void SAL_CALL NotificationListener_Impl::dispatchFinished( const css::frame::DispatchResultEvent& aEvent ) throw( css::uno::RuntimeException )
{
    css::uno::Reference < css::uno::XInterface > xDispatch = xDispatcher.get();
    if ( xDispatch.is() )
        pDispatcher->dispatchFinished( aEvent, this );
}

void SAL_CALL NotificationListener_Impl::disposing( const css::lang::EventObject& aEvent ) throw( css::uno::RuntimeException )
{
}

//_________________________________________________________________________________________________________________
//	non exported const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	non exported definitions
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

//*****************************************************************************************************************
//	XInterface, XTypeProvider
//*****************************************************************************************************************
DEFINE_XINTERFACE_5     (   BaseDispatcher                                                              ,
                            OWeakObject                                                                  ,
                            DIRECT_INTERFACE ( css::lang::XTypeProvider                                 ),
                            DIRECT_INTERFACE ( css::frame::XNotifyingDispatch                           ),
                            DIRECT_INTERFACE ( css::frame::XDispatch                                    ),
                            DIRECT_INTERFACE ( css::frame::XLoadEventListener                           ),
                            DERIVED_INTERFACE( css::lang::XEventListener, css::frame::XLoadEventListener   )
						)

DEFINE_XTYPEPROVIDER_5  (   BaseDispatcher                                                              ,
                            css::lang::XTypeProvider                                                    ,
                            css::frame::XNotifyingDispatch                                              ,
                            css::frame::XDispatch                                                       ,
                            css::frame::XLoadEventListener                                              ,
                            css::lang::XEventListener
						)

/*-************************************************************************************************************//**
    @short      standard ctor
    @descr      These initialize a new instance of this class with needed informations for work.

    @attention  If you whish to work with your own reference - you must increase your own refcount!
                Otherwise realeasing of this reference will decrease to 0 at the end of this method ... and you will die during your own ctor!
                Use seperate scope to prevent your code against releasing of temp. references too!!!

    @seealso    using at owner

    @param      "xFactory", reference to servicemanager for creation of new services
    @param      "xOwner"  , reference to our owner, which use us as helper
    @return     -

    @onerror    -
*//*-*************************************************************************************************************/
BaseDispatcher::BaseDispatcher( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory    ,
                                const css::uno::Reference< css::frame::XFrame >&              xOwnerFrame )
		//	Init baseclasses first
        :   ThreadHelpBase          ( &Application::GetSolarMutex()  )
        ,   TransactionBase         (                                )
        ,   OWeakObject             (                                )
        // Init member
        ,   m_xFactory              ( xFactory                       )
        ,   m_xOwner                ( xOwnerFrame                    )
        ,   m_aLoaderThreads        (                                )
        ,   m_aListenerContainer    ( m_aLock.getShareableOslMutex() )
        ,   m_aResultListenerContainer    ( m_aLock.getShareableOslMutex() )
{
	// Safe impossible cases
    // We need valid informations about ouer owner for work.
    LOG_ASSERT2( implcp_ctor( xFactory, xOwnerFrame ), "BaseDispatcher::BaseDispatcher()", "Invalid parameter detected!" )

    ++m_refCount;
    {
        // Start listening for dispose/ing events on our owner frame!
        xOwnerFrame->addEventListener( css::uno::Reference< css::lang::XEventListener >( static_cast< ::cppu::OWeakObject* >(this), css::uno::UNO_QUERY ) );
    }
    --m_refCount;

    // Enable object for real working.
    m_aTransactionManager.setWorkingMode( E_WORK );
}

/*-************************************************************************************************************//**
    @short      standard destructor
    @descr      This method do nothing! Use disposing() instead of these one.
                This method is protected, because its not allowed to use an instance of this class as a member!
                You MUST use a pointer or reference.

    @seealso    method disposing()

    @param      -
    @return     -

    @onerror    -
*//*-*************************************************************************************************************/
BaseDispatcher::~BaseDispatcher()
{
	// Warn programmer if he forgot to dispose this instance.
	// We must release all our references ...
	// and a dtor isn't the best place to do that!
    LOG_ASSERT2( m_aTransactionManager.getWorkingMode()!=E_CLOSE, "BaseDispatcher::~BaseDispatcher()", "Your forgot to dispose this service helper ...!" )
}

/*-************************************************************************************************************//**
    @interface  XDispatch
    @short      add/remove listener for state events
    @descr      You can add a listener to get information about status of dispatch: OK or Failed.

    @attention  We don't need any mutex or lock here ... because our helper is threadsafe himself.
                He live if we live ... our transaction is registered ... disposing() wait for us.
                Normaly: no trouble should occure!

                But:
                Mostly deregistration of a listener is called during our own dispose method.
                So we should use E_SOFTEXCEPTIONS to enable working without any ALREADY-DISPOSED-EXCPETIONS!
                NOT RIGHT FOR ADD LISTENER!

    @seealso    method statusChanged()

    @param      "xListener", reference to a valid listener for state events.
    @param      "aURL"     , URL about listener will be informed, if something occured.
    @return     -

    @onerror    -
    @threadsafe yes
*//*-*************************************************************************************************************/
void SAL_CALL BaseDispatcher::addStatusListener( const css::uno::Reference< css::frame::XStatusListener >& xListener ,
                                                  const css::util::URL&                                     aURL      ) throw( css::uno::RuntimeException )
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	// Method not defined for all incoming parameter
    LOG_ASSERT2( implcp_addStatusListener( xListener, aURL ), "BaseDispatcher::addStatusListener()", "Invalid parameter detected." )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    m_aListenerContainer.addInterface( aURL.Complete, xListener );
}

//*****************************************************************************************************************
void SAL_CALL BaseDispatcher::removeStatusListener( const css::uno::Reference< css::frame::XStatusListener >& xListener ,
                                                     const css::util::URL&                                     aURL      ) throw( css::uno::RuntimeException )
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	// Method not defined for all incoming parameter
    LOG_ASSERT2( implcp_removeStatusListener( xListener, aURL ), "BaseDispatcher::removeStatusListener()", "Invalid parameter detected." )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_SOFTEXCEPTIONS );

    m_aListenerContainer.removeInterface( aURL.Complete, xListener );
}

/*-************************************************************************************************************//**
    @short      callback from our dispatch helper
    @descr      If we started loading document we are listener to get informations about state of this operation.
                We inform our listener about getted status from our handler AND call our super class to react for this event too!

    @param      "aEvent", source of event and state of load operation
    @return     -

    @onerror    -
    @threadsafe yes
*//*-*************************************************************************************************************/
void BaseDispatcher::dispatchFinished( const css::frame::DispatchResultEvent& aEvent, const css::uno::Reference < css::frame::XDispatchResultListener >& rListener )
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    LoadBinding aBinding;
    if( m_aLoaderThreads.searchAndForget( rListener, aBinding ) == sal_True )
    {
        if( aEvent.State == css::frame::DispatchResultState::SUCCESS )
        {
            implts_sendResultEvent( aBinding.xFrame, aBinding.aURL.Complete, sal_True );
            // call superclass ... DO IT WITH ANY LOCK!
            reactForHandlingState( aBinding.aURL, aBinding.lDescriptor, sal_True, aBinding.aAsyncInfo );
        }
        else
        {
            implts_sendResultEvent( aBinding.xFrame, aBinding.aURL.Complete, sal_False );
            // call superclass ... DO IT WITH ANY LOCK!
            reactForHandlingState( aBinding.aURL, aBinding.lDescriptor, sal_False, aBinding.aAsyncInfo );
        }
    }
}

/*-************************************************************************************************************//**
    @interface  XLoadEventListener
    @short      callback from our async frame loader
    @descr      If we started loading document we are listener to get informations about state of this operation.
                We inform our listener about getted status from our loader AND call our super class to react for this event too!

    @attention  We don't need any mutex or loack here - because our use member or implts-methods are threadsafe himself.

    @seealso    method dispatch()
    @seealso    method add/removeStatusListener()

    @param      "aEvent", source of event and state of load operation
    @return     -

    @onerror    -
    @threadsafe yes
*//*-*************************************************************************************************************/
void SAL_CALL BaseDispatcher::loadFinished( const css::uno::Reference< css::frame::XFrameLoader >& xLoader ) throw( css::uno::RuntimeException )
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	// Method not defined for all incoming parameter
    LOG_ASSERT2( implcp_loadFinished( xLoader ), "BaseDispatcher::loadFinished()", "Invalid parameter detected." )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    // Loading was successfuly.
    // Try to find corresponding callback info and show task window!
    LoadBinding aBinding;
    if( m_aLoaderThreads.searchAndForget( xLoader, aBinding ) == sal_True )
    {
        implts_sendResultEvent( aBinding.xFrame, aBinding.aURL.Complete, sal_True );
        // Don't forget to open target for "dieing"! These lock prevent us against closing of task during load proccess!
        css::uno::Reference< css::document::XActionLockable > xLock( aBinding.xFrame, css::uno::UNO_QUERY );
        if( xLock.is() == sal_True )
            xLock->resetActionLocks();
        // call superclass ... DO IT WITH ANY LOCK!
        reactForLoadingState( aBinding.aURL, aBinding.lDescriptor, aBinding.xFrame, sal_True, aBinding.aAsyncInfo );
    }
}

void SAL_CALL BaseDispatcher::dispatchWithNotification ( const css::util::URL& aURL,
        const css::uno::Sequence< css::beans::PropertyValue >& lArguments,
        const css::uno::Reference < css::frame::XDispatchResultListener >& xListener
         ) throw( css::uno::RuntimeException )
{
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );
    m_aResultListenerContainer.addInterface( aURL.Complete, xListener );
    dispatch( aURL, lArguments );
}

//*****************************************************************************************************************
void SAL_CALL BaseDispatcher::loadCancelled( const css::uno::Reference< css::frame::XFrameLoader >& xLoader ) throw( css::uno::RuntimeException )
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	// Method not defined for all incoming parameter
    LOG_ASSERT2( implcp_loadCancelled( xLoader ), "BaseDispatcher::loadCancelled()", "Invalid parameter detected." )
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    // Loading failed.
    // Try to find corresponding callback info and delete task!
    LoadBinding aBinding;
    if( m_aLoaderThreads.searchAndForget( xLoader, aBinding ) == sal_True )
    {
        implts_sendResultEvent( aBinding.xFrame, aBinding.aURL.Complete, sal_False );
        // Don't forget to open target for "dieing"! These lock prevent us against closing of task during load proccess!
        css::uno::Reference< css::document::XActionLockable > xLock( aBinding.xFrame, css::uno::UNO_QUERY );
        if( xLock.is() == sal_True )
            xLock->resetActionLocks();
        // call superclass ... DO IT WITH ANY LOCK!
        reactForLoadingState( aBinding.aURL, aBinding.lDescriptor, aBinding.xFrame, sal_False, aBinding.aAsyncInfo );
    }
}

/*-************************************************************************************************************//**
    @interface  XEventListener
    @short      release this object
    @descr      This implementation is used as a helper of ODispatchProvider.
                He could get a dispose() call from his owner.
                We should die at the same time - disposed by our owner!
                That's why we are a listener for disposing events ...

    @attention  We accept disposing events of our owner frame only!

    @seealso    method Desktop::dispose()

    @param      "aEvent", describe the source of this event and should be the owner of this object.
    @return     -

    @onerror    We do nothing.
    @threadsafe yes
*//*-*************************************************************************************************************/
void SAL_CALL BaseDispatcher::disposing( const css::lang::EventObject& aEvent ) throw( css::uno::RuntimeException )
{
    /* UNSAFE AREA --------------------------------------------------------------------------------------------- */
	// Safe impossible cases
	// This method is not defined for all incoming parameter.
    LOG_ASSERT2( implcp_disposing( aEvent ), "BaseDispatcher::disposing()", "Invalid parameter detected." )

    /* Disposing of a service is a special procedure.
       We have registered all interface operations as non breakable ones.
       So we must disable this object for working - further requests will be rejected then.
       After that we can release our internal structures ... and die :_(

       But there exist one exception from this rule.
       We should release our listener BEFORE we disable this instance for real working.
       Otherwhise they call us back ... or try to work with us ...
       and we will run into some trouble.
       So it's a better idea to do it in a normal manner ... and disable object after that!
     */

    /* SAFE AREA ----------------------------------------------------------------------------------------------- */
    // We must be alone, if we look for multiple calls of disposing()!
    WriteGuard aWriteLock( m_aLock );

    // Register operation as transaction and reject wrong calls!
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    // It's a good idea to hold us alive by ourself.
    // So we can't die if last listener release his reference to us.
    css::uno::Reference< css::uno::XInterface > xThis ( static_cast< ::cppu::OWeakObject* >(this), css::uno::UNO_QUERY );
    css::uno::Reference< css::frame::XFrame >   xOwner( m_xOwner.get()                           , css::uno::UNO_QUERY );

    // Check source of event. Ignore wrong calls!
    if( xOwner == aEvent.Source )
    {
        // It's neccessary to stop currently running transaction.. because
        // follow setWorkingMode() wait for all registered ones.
        // If you forget it - it will block for ever.
        aTransaction.stop();
        m_aTransactionManager.setWorkingMode( E_BEFORECLOSE );

        // You can disable this write lock ...
        // Nobody can call this disposing() twice. He will get a DisposedException!
        aWriteLock.unlock();

        // First we must deregister as event listener on our owner frame.
        xOwner->removeEventListener( css::uno::Reference< css::lang::XEventListener >( static_cast< ::cppu::OWeakObject* >(this), css::uno::UNO_QUERY ) );

        // Forget all listener.
        // (helper is threadsafe himself!)
        // But you must enable callback "removeListener()" by using of E_SOFTEXCETIONS!
        // see "removeStatusListener() for further informations.
        css::lang::EventObject aOwnEvent;
        aOwnEvent.Source = xThis;
        m_aListenerContainer.disposeAndClear( aOwnEvent );

        // Remove all other member and free used memory.
        m_aLoaderThreads.free();
        m_xFactory = css::uno::Reference< css::lang::XMultiServiceFactory >();
        m_xOwner   = css::uno::WeakReference< css::frame::XFrame >()         ;

        // Disable object for further working!
        m_aTransactionManager.setWorkingMode( E_CLOSE );
    }
}

/*-************************************************************************************************************//**
    @short      try to detect type of given URL
    @descr      If you must handle or load this URL, you must know his type.
                These method ask our TypeDetection service and return his decision.
                Sometimes it will change your given descriptor too!
                Use third parameter ("bDeep") to differ between deep and flat detection!!

    @seealso    -

    @param      "aURL"       , URL to detect
    @param      "lDescriptor", optional description of this URL
    @param      "bDeep"      , allow/deny deep detection of file
    @return     An internal type name if detection was successfully ... or an empty string if not.

    @onerror    We return an empty string.
    @threadsafe yes
*//*-*************************************************************************************************************/
::rtl::OUString BaseDispatcher::implts_detectType( const css::util::URL&                                  aURL        ,
                                                         css::uno::Sequence< css::beans::PropertyValue >& lDescriptor ,
                                                         sal_Bool                                         bDeep       )
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    /* SAFE AREA ----------------------------------------------------------------------------------------------- */
    // Make snapshot of neccessary member.
    ReadGuard aReadLock( m_aLock );
    css::uno::Reference< css::lang::XMultiServiceFactory > xFactory = m_xFactory;
    aReadLock.unlock();
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */

    ::rtl::OUString sTypeName;
    css::uno::Reference< css::document::XTypeDetection > xDetection( xFactory->createInstance( SERVICENAME_TYPEDETECTION ), css::uno::UNO_QUERY );
    if( xDetection.is() == sal_True )
    {
        // Attention: URL mustn't exist in given descriptor ... but type detection need it!
        // => Set it! Splitting into main URL and additional jumpmarks is done by ArgumentAnalyzer automaticly ...
        ArgumentAnalyzer aAnalyzer( lDescriptor );
        aAnalyzer.setArgument( E_URL, aURL );

        // If no interaction handler is set on descriptor - use the global UI interaction handler as fallback!
        css::uno::Reference< css::task::XInteractionHandler > xInteraction;
        if( aAnalyzer.getArgument( E_INTERACTIONHANDLER, xInteraction ) == sal_False )
        {
            xInteraction = css::uno::Reference< css::task::XInteractionHandler >( xFactory->createInstance( SERVICENAME_UIINTERACTIONHANDLER ), css::uno::UNO_QUERY );
            if( xInteraction.is() == sal_True )
            {
                aAnalyzer.setArgument( E_INTERACTIONHANDLER, xInteraction );
            }
        }

        // Try to detect right type for given informations.
        // Look for possible exceptions! They can break it and should be handled!
        try
        {
            sTypeName = xDetection->queryTypeByDescriptor( lDescriptor, bDeep );
            // If no exception occure - but we couldn't detect right type ...
            // we can try to get neccessary information by using interaction mechanism.
            // An interaction handler should exist everytime.
            // If user forgot to set anyone - we created our own one some lines before!
            if(
                ( sTypeName.getLength() <  1        )   &&
                ( xInteraction.is()     == sal_True )
              )
            {
                RequestFilterSelect*                                  pRequest = new RequestFilterSelect( aURL.Complete );
                css::uno::Reference< css::task::XInteractionRequest > xRequest ( pRequest );
                xInteraction->handle( xRequest );

                if( pRequest->isAbort() == sal_False )
                {
                    ::rtl::OUString sFilter   = pRequest->getFilter();
                    Filter          aFilter   = FilterCache().getFilter( sFilter );
                                    sTypeName = aFilter.sType;
                    aAnalyzer.setArgument( E_TYPENAME  , sTypeName );
                    aAnalyzer.setArgument( E_FILTERNAME, sFilter   );
                }
            }
        }
        catch( css::lang::WrappedTargetRuntimeException& exPacked )
        {
            // Handle occured exceptions during type detection.
            css::ucb::CommandAbortedException exAbort;
            if( exPacked.TargetException >>= exAbort )
            {
                sTypeName = ::rtl::OUString();
            }
            else
            {
                throw;
            }
        }

        // Actualize given media descriptor, if no type could be detected!
        if( sTypeName.getLength() < 1 )
        {
            aAnalyzer.deleteArgument( E_TYPENAME   );
            aAnalyzer.deleteArgument( E_FILTERNAME );
        }
    }

    return sTypeName;
}

/*-************************************************************************************************************//**
    @short      try to handle it without any task as target
    @descr      Some URL's doesn't need any target frame - they describe not visible content! (e.g. sounds)
                So we should "handle it". We search for any registered handler for given type name and try to create it.
                If creation was successfully - we start an asynchronous proccess.
                To know, which of this proccesses are call us back (we are listener on these handlers)
                we save some informations in an internal list.
                Last parameter "bState" indicates - handler could found and proccess was started - or not.
                If it is "true" - caller do not make any further things - dispatch was successfuly - rest runs automaticly.
                If it is "false" - caller should do something. Send status event "failed" to his listener - or
                try to load given URL. It could be a visible content!

    @attention  a) We don't make any type detection here. Given type name must be OK. Please use implts_detectType()
                   to get this value.
                b) We don't send any status event here. Caller of this method should do that by using "implts_sendResultEvent()" and "bState"!

    @seealso    method implts_detectType()
    @seealso    method implts_loadIt()
    @seealso    method implts_sendResultEvent()

    @param      "aURL"       ,  URL for "loading"
    @param      "lDescriptor",  optional description of URL
    @param      "sTypeName"  ,  internal type name, which specify URL
    @return     true , if handle proccess was started successfull
                false, otherwise

    @onerror    We return false for "bState".
    @threadsafe yes
*//*-*************************************************************************************************************/
sal_Bool BaseDispatcher::implts_handleIt( const css::util::URL&                                  aURL        ,
                                                css::uno::Sequence< css::beans::PropertyValue >& lDescriptor ,
                                          const ::rtl::OUString&                                 sTypeName   ,
                                          const css::uno::Any&                                   aAsyncInfo  )
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    /* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( m_aLock );
    css::uno::Reference< css::lang::XMultiServiceFactory > xHandlerFactory( m_xFactory->createInstance( SERVICENAME_CONTENTHANDLERFACTORY ), css::uno::UNO_QUERY );
    aReadLock.unlock();
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */

    sal_Bool bState = sal_False;
    if( xHandlerFactory.is() == sal_True )
    {
        css::uno::Reference< css::frame::XDispatch > xDispatch( xHandlerFactory->createInstance( sTypeName ), css::uno::UNO_QUERY );
        css::uno::Reference< css::frame::XNotifyingDispatch > xHandler( xDispatch, css::uno::UNO_QUERY );
        if( xHandler.is() == sal_True )
        {
            LoadBinding aBinding( aURL, lDescriptor, xDispatch, aAsyncInfo );
            aBinding.xListener = new NotificationListener_Impl( this );
            m_aLoaderThreads.append( aBinding ); // threadsafe himself!
            xHandler->dispatchWithNotification( aURL, lDescriptor, aBinding.xListener );
            bState = sal_True;
        }
        else if ( xDispatch.is() )
        {
            xDispatch->dispatch( aURL, lDescriptor );
            bState = sal_True;
        }
    }

    return bState;
}

/*-************************************************************************************************************//**
    @short      try to load given URL into a target frame
    @descr      We try to find any registered frame loader and create it. If it was successfully - we start loading of URL.
                It could be synchron or asynchron (depends from created loader service and his supported interfaces ...
                We prefer a synchronous loading!)
                To know, which of this proccesses are call us back (we are listener on these loaders)
                we save some informations in an internal list.

    @attention  1) We don't make any type detection here. Given type name must be OK. Please use implts_detectType() or
                   implts_askType() to get this value.
                2) To show user any information about current started loading process, we set a new created StatusIndicator
                   on given descriptor. These one is used to show status and progress informations.

    @seealso    method implts_detectType()
    @seealso    method implts_askType()

    @param      "aURL"       ,  URL for loading
    @param      "lDescriptor",  optional description of URL
    @param      "sTypeName"  ,  internal type name, which specify URL
    @param      "xTarget"    ,  target of load operation
    @return     true , if operation was successful (means successful started asynchronous operations too!)
                false, otherwhise

    @onerror    We return false.
    @threadsafe yes
*//*-*************************************************************************************************************/
sal_Bool BaseDispatcher::implts_loadIt( const css::util::URL&                                  aURL           ,
                                              css::uno::Sequence< css::beans::PropertyValue >& lDescriptor    ,
                                        const ::rtl::OUString&                                 sTypeName      ,
                                        const css::uno::Reference< css::frame::XFrame >&       xTarget        ,
                                        const css::uno::Any&                                   aAsyncInfo     )
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    /* SAFE AREA ----------------------------------------------------------------------------------------------- */
    ReadGuard aReadLock( m_aLock );
    css::uno::Reference< css::lang::XMultiServiceFactory > xLoaderFactory( m_xFactory->createInstance( SERVICENAME_FRAMELOADERFACTORY ), css::uno::UNO_QUERY );
    aReadLock.unlock();
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */

    sal_Bool bSuccessful = sal_False;

    if(
        ( xLoaderFactory.is() == sal_True ) &&
        ( xTarget.is()        == sal_True )
      )
    {
        css::uno::Reference< css::uno::XInterface >                 xLoader     ( xLoaderFactory->createInstance( sTypeName ), css::uno::UNO_QUERY );
        css::uno::Reference< css::frame::XFrameLoader >             xAsyncLoader( xLoader                                    , css::uno::UNO_QUERY );
        css::uno::Reference< css::frame::XSynchronousFrameLoader >  xSyncLoader ( xLoader                                    , css::uno::UNO_QUERY );

        if(
            ( xSyncLoader.is()  == sal_True )    ||
            ( xAsyncLoader.is() == sal_True )
          )
        {
            // Add status indicator to descriptor. Loader can show an progresses then.
            // But don't do it, if loading should be hidden or preview is used ...!
            // So we prevent our code against wrong using. Why?
            // It could be, that using of this progress could make trouble. e.g. He make window visible ...
            // but shouldn't do that. But if no indicator is available ... nobody has a chance to do that!
            ArgumentAnalyzer aAnalyzer( lDescriptor );
            sal_Bool         bHidden  = sal_False    ;
            sal_Bool         bPreview = sal_False    ;
            aAnalyzer.getArgument( E_HIDDEN , bHidden  );
            aAnalyzer.getArgument( E_PREVIEW, bPreview );

            if(
                ( bHidden  == sal_False )    &&
                ( bPreview == sal_False )    &&
                ( !aAnalyzer.existArgument(E_STATUSINDICATOR))
              )
            {
                css::uno::Reference< css::task::XStatusIndicatorFactory > xIndicatorFactory( xTarget, css::uno::UNO_QUERY );
                if( xIndicatorFactory.is() == sal_True )
                {
                    css::uno::Reference< css::task::XStatusIndicator > xIndicator = xIndicatorFactory->createStatusIndicator();
                    if( xIndicator.is() == sal_True )
                    {
                        aAnalyzer.setArgument( E_STATUSINDICATOR, xIndicator );
                    }
                }
            }

            // Don't forget to lock task for following load process. Otherwise they could die during this operation by
            // terminating office or closing of this task by using api.
            // If we set this lock "close()" will return false and closing will be broken.
            // Attention: Don't forget to reset this lock again after finishing operation. Otherwise task couldn't die!!!
            css::uno::Reference< css::document::XActionLockable > xLock( xTarget, css::uno::UNO_QUERY );
            if( xLock.is()==sal_True )
                xLock->addActionLock();

            css::uno::Reference < css::frame::XTask > xTask( xTarget, css::uno::UNO_QUERY );
            css::uno::Reference < css::mozilla::XPluginInstance > xPlug( xTask, css::uno::UNO_QUERY );
            if ( xTask.is() && !xPlug.is() && !xTask->getController().is() )
            {
                // get pos/size of task window from module options
                ::rtl::OUString aFilterName;

                // get filtername from load arguments
                aAnalyzer.getArgument( E_FILTERNAME , aFilterName  );
                if ( aFilterName.getLength() )
                {
                    // get the properties of the filter
                    css::uno::Sequence < css::beans::PropertyValue > aProps;
                    css::uno::Reference< css::container::XNameAccess > xFilterFactory( m_xFactory->createInstance( SERVICENAME_FILTERFACTORY ), css::uno::UNO_QUERY );
                    try
                    {
                        css::uno::Any aAny = xFilterFactory->getByName( aFilterName );
                        if ( aAny >>= aProps )
                        {
                            // use property "DocumentServiceName" to detect the factory
                            ::rtl::OUString aServiceName;
                            sal_Int32 nPropertyCount = aProps.getLength();
                            for( sal_Int32 nProperty=0; nProperty<nPropertyCount; ++nProperty )
                            {
                                if( aProps[nProperty].Name == ::rtl::OUString(RTL_CONSTASCII_USTRINGPARAM("DocumentService")) )
                                {
                                    aProps[nProperty].Value >>= aServiceName;
                                    SvtModuleOptions::EFactory eFactory;
                                    if ( SvtModuleOptions::ClassifyFactoryByName( aServiceName, eFactory ) )
                                    {
                                        // get window attributes for this factory
                                        ::rtl::OUString aAttrs = SvtModuleOptions().GetFactoryWindowAttributes( eFactory );
                                        if ( aAttrs.getLength() )
                                        {
                                            ::vos::OClearableGuard aSolarGuard( Application::GetSolarMutex() );
                                            Window* pWindow = VCLUnoHelper::GetWindow( xTarget->getContainerWindow() );
                                            if ( pWindow && pWindow->IsSystemWindow() )
                                            {
                                                ((SystemWindow*)pWindow)->SetWindowState( ByteString( String( aAttrs ), RTL_TEXTENCODING_UTF8 ) );
                                            }
                                            aSolarGuard.clear();
                                        }
                                    }

                                    break;
                                }
                            }
                        }
                    }
                    catch ( css::uno::Exception& )
                    {
                    }
                }
            }

            // ... prefer synchron loading!
            if( xSyncLoader.is() == sal_True )
            {
                bSuccessful = sal_True;
                sal_Bool bState = xSyncLoader->load( lDescriptor, xTarget );
                implts_sendResultEvent( xTarget, aURL.Complete, bState );
                if( xLock.is() == sal_True )
                    xLock->resetActionLocks();
                // call super class ... DON'T DO IT WITH ANY LOCK!
                reactForLoadingState( aURL, lDescriptor, xTarget, bState, aAsyncInfo );
            }
            else
            // ... or use old asynchron mechanism :-(
            if( xAsyncLoader.is() == sal_True )
            {
                bSuccessful = sal_True;

                LoadBinding aBinding( aURL, lDescriptor, xTarget, xAsyncLoader, aAsyncInfo );
                m_aLoaderThreads.append( aBinding ); // threadsafe himself

                css::uno::Reference< css::frame::XLoadEventListener > xThis( static_cast< ::cppu::OWeakObject* >(this), css::uno::UNO_QUERY );
                xAsyncLoader->load( xTarget, aURL.Complete, lDescriptor, xThis );
                // Don't release lock of target here. Do it in callback functions - loadFinished()/loadCancelled()!
            }
        }
    }

    return bSuccessful;
}

/*-************************************************************************************************************//**
    @short          enable/disable a target frame
    @descr          As a reaction for finished loading operations we must change state of our target frame.
                    If it failed - we must e.g. dispose it or if it was successfully - we must e.g. show his window.

    @attention      Normaly we doesn't need any mutex or lock here - we work on given variables only - not on internal member.
                    But if you change it - you should thing about it!

    @seealso        method reactForLoadingState()

    @param          "xFrame"     , reference to target frame, which state should be changed
    @param          "lDescriptor", optional arguments of dispatch (contains some neccessary state variables which should be set on target!)
    @return         -

    @onerror        -
    @threadsafe     yes
*//*-*************************************************************************************************************/
void BaseDispatcher::implts_enableFrame( const css::uno::Reference< css::frame::XFrame >&        xFrame      ,
                                         const css::uno::Sequence< css::beans::PropertyValue >&  lDescriptor )
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    static bFirstVisibleTaskDetected = sal_False;

    if( xFrame.is() == sal_True )
    {
        // Analyze optional arguments and try to find frame name and visible state.
        // Try to set this information on given frame!
        ArgumentAnalyzer aAnalyzer( lDescriptor );

        css::uno::Reference< css::awt::XWindow > xFrameWindow = xFrame->getContainerWindow();
        if( xFrameWindow.is() == sal_True )
        {
            sal_Bool bHidden = sal_False;
            aAnalyzer.getArgument( E_HIDDEN, bHidden );
            xFrameWindow->setVisible( !bHidden );

            if(
                ( bHidden                   == sal_False )  &&
                ( bFirstVisibleTaskDetected == sal_False )
              )
            {
                ReadGuard aReadLock( m_aLock );
                css::uno::Reference< css::task::XJobExecutor > xExecutor( m_xFactory->createInstance( SERVICENAME_JOBEXECUTOR ), css::uno::UNO_QUERY );
                aReadLock.unlock();
                if( xExecutor.is() == sal_True )
                {
                    xExecutor->trigger( DECLARE_ASCII("onFirstVisibleTask") );
                    ReadGuard aGlobalLock( LockHelper::getGlobalLock() );
                    bFirstVisibleTaskDetected = sal_True;
                    aGlobalLock.unlock();
                }
            }
        }

        // Attention: Two cases could occure.
        //  1) argument "FrameName" isn't available ...
        //  2) argument is an empty string(!?)
        // Both cases should be ignored! We must set valid names only.
        // Of course ... release of frame name during dispatch isn't possible then!
        // But dispatching should initialize a frame not deinitialize it.
        // If somewhere whish to reset this frame name to "" ... he should call "setName() directly.
        ::rtl::OUString sFrameName;
        aAnalyzer.getArgument( E_FRAMENAME, sFrameName );
        if( sFrameName.getLength() > 0 )
        {
            xFrame->setName( sFrameName );
        }
    }
}

//*****************************************************************************************************************
void BaseDispatcher::implts_disableFrame( const css::uno::Reference< css::frame::XFrame >& xFrame )
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    if( xFrame.is() == sal_True )
    {
        // Attention: If given target is a tsak - we should "close()" it!
        // They will dispose herself then.
        // A normal frame shouzld be disposed directly.
        // Reference is released at the end of method automaticly!
        // But caller of this method should do that too ...
        css::uno::Reference< css::frame::XTask > xTask( xFrame, css::uno::UNO_QUERY );
        if( xTask.is() == sal_True )
        {
            xTask->close();
        }
        else
        {
            xFrame->dispose();
        }
    }
}

/*-************************************************************************************************************//**
    @short          deactivate/reactivate currently set controller of our owner frame
    @descr          If we start a new dispatch we should deactivate an currently set controller of our targte frame.
                    Otherwise we must reactivate it, if dispatch failed!
                    These little helper methods do that for use.

    @seealso        method readForLoadingState()
    @seealso        method XFrame::getController()
    @seealso        interface XController

    @param          "xController", currently set controller of our owner frame (could be NULL!)
    @return         true , if de-/reactivation was successfully OR no controller exist
                    false, otherwise

    @onerror        ... it depends from error type!
    @threadsafe     yes
*//*-*************************************************************************************************************/
sal_Bool BaseDispatcher::implts_deactivateController( const css::uno::Reference< css::frame::XController >& xController )
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    // We don't need any lock here ... we don't work on internal member here!
    // But if YOU change it ... you should think about it again ...

	// Set default result to "OK" ...
	// If no current controller exist - deactivation will be successfull everytime (!)
	// Otherwise we must suspend it   - and the state of that operation will be the result of this method.

	sal_Bool bState = sal_True;
	if( xController.is() == sal_True )
	{
		bState = xController->suspend( sal_True );
	}
	return bState;
}

//*****************************************************************************************************************
sal_Bool BaseDispatcher::implts_reactivateController( const css::uno::Reference< css::frame::XController >& xController )
{
	/* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register transaction and reject wrong calls.
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

    // We don't need any lock here ... we don't work on internal member here!
    // But if YOU change it ... you should think about it again ...

	// Set default result to "OK" ...
	// If no current controller exist - reactivation will be successfull everytime (!)
	// Otherwise we must do it - and the state of that operation will be the result of this method.

	sal_Bool bState = sal_True;
	if( xController.is() == sal_True )
	{
		bState = xController->suspend( sal_False );
	}
	return bState;
}

/*-************************************************************************************************************//**
    @short      send status event to our listener, which registered for given URL
    @descr      We search on our internal listener container for registered listener for given URL
                and send a status event by using given load state.

    @attention  These method is threadsafe without any lock. Because our helper are threadsafe himself.
                And they live if we live. To register a transaction should be enough.
                So we wait for it at our own disposing() call!

    @seealso    method add/removeStatusListener()
    @seealso    method impl_dispatchSystemTask()
    @seealso    method impl_dispatchBrowserTask()

    @param      "xEventSource", target of dispatch (can be null if dispatch failed!)
    @param      "sURL"        , URL of document, which listener are registered for
    @param      "bLoadState"  , state of load operation
    @return     -

    @onerror    We do nothing.
    @threadsafe yes
*//*-*************************************************************************************************************/
void BaseDispatcher::implts_sendResultEvent( const css::uno::Reference< css::frame::XFrame >& xEventSource ,
                                             const ::rtl::OUString&                           sURL         ,
                                                   sal_Bool                                   bLoadState   )
{
    /* UNSAFE AREA --------------------------------------------------------------------------------------------- */
    // Register operation as transaction and reject wrong calls!
    TransactionGuard aTransaction( m_aTransactionManager, E_HARDEXCEPTIONS );

	// Get listener for given URL!
    ::cppu::OInterfaceContainerHelper* pListenerForURL = m_aResultListenerContainer.getContainer( sURL );
	// Send messages to all listener.
	// Do nothing, if there no listener or "getContainer()" works not correct!
	if( pListenerForURL != NULL )
	{
		// Build event for send to listener.
        css::frame::DispatchResultEvent aEvent;
        aEvent.State = bLoadState ? css::frame::DispatchResultState::SUCCESS : css::frame::DispatchResultState::FAILURE;
        aEvent.Result <<= xEventSource;
        aEvent.Source = (css::frame::XDispatch*) this;

		// Send message to all listener on this URL.
        ::cppu::OInterfaceIteratorHelper aIterator(*pListenerForURL);
        while( aIterator.hasMoreElements() == sal_True )
		{
            css::uno::Reference< css::frame::XDispatchResultListener > xListener( ((css::frame::XDispatchResultListener*)aIterator.next()), css::uno::UNO_QUERY );
            xListener->dispatchFinished( aEvent );
            m_aResultListenerContainer.removeInterface( sURL, xListener );
		}
	}
}

/*-************************************************************************************************************//**
    @short      append item on history
    @descr      If superclass has get his "reactForLoadingState()" ... he should append currently loaded
                document in history. These method search for existing entries or append new ones.
                User can decide that by using "bChange".

                e.g. BlankDispatcher should use "bChange=false" ... dispatched URLs are new documents always!
                     SelfDispatcher  should use "bChange=true"  ... dispatched URLs could be the same like currently loaded document

    @attention  These method is threadsafe without any lock. We don't use any member here.
                To register a transaction should be enough.
                So we wait for it at our own disposing() call!

    @seealso    method add/removeStatusListener()
    @seealso    method impl_dispatchSystemTask()
    @seealso    method impl_dispatchBrowserTask()

    @param      "xEventSource", target of dispatch (can be null if dispatch failed!)
    @param      "sURL"        , URL of document, which listener are registered for
    @param      "bLoadState"  , state of load operation
    @return     -

    @onerror    We do nothing.
    @threadsafe yes
*//*-*************************************************************************************************************/
/*DRAFT
void BaseDispatcher::implts_updateHistory( const SvtHistoryItem& rItem   ,
                                                 sal_Bool        bChange )
{
    SvtHistoryOptions aHistory;

    if( bChange == sal_True )
    {
        SvtHistoryItem aSearchItem;
        aSearchItem.sURL == rItem.sURL;
        aHistory.AppendOrChangeItem( eHISTORY, aSearchItem, sal_False, rItem ); // false => search similar!
    }
    else
        aHistory.AppendItem( eHISTORY, rItem );
}
*/
/*-************************************************************************************************************//**
    @short      debug-method to check incoming parameter of some other mehods of this class
    @descr      The following methods are used to check parameters for other methods
                of this class. The return value is used directly for an ASSERT(...).

    @seealso    ASSERTs in implementation!

    @param      references to checking variables
    @return     sal_True  on invalid parameter<BR>
                sal_False otherway

    @onerror    -
    @threadsafe yes / They don't work on members - they are static!
*//*-*************************************************************************************************************/
#ifdef ENABLE_ASSERTIONS

//*****************************************************************************************************************
sal_Bool BaseDispatcher::implcp_ctor( const css::uno::Reference< css::lang::XMultiServiceFactory >& xFactory    ,
                                      const css::uno::Reference< css::frame::XFrame >&              xOwnerFrame )
{
    return(
            ( &xFactory        ==  NULL      ) ||
            ( &xOwnerFrame     ==  NULL      ) ||
            ( xFactory.is()    ==  sal_False ) ||
            ( xOwnerFrame.is() ==  sal_False )
          );
}

//*****************************************************************************************************************
// We don't know anything about right values of aURL and seqArguments!
// Check valid references only.
sal_Bool BaseDispatcher::implcp_dispatch( const css::util::URL&                                  aURL       ,
                                          const css::uno::Sequence< css::beans::PropertyValue >& lArguments )
{
    return(
            ( &aURL                     == NULL ) ||
            ( &lArguments               == NULL ) ||
            ( aURL.Complete.getLength() <  1    )
          );
}

//*****************************************************************************************************************
// We need a valid URL. What is meaning with "register for nothing"?!
// xListener must be a valid reference too - nobody can advised otherwise!
sal_Bool BaseDispatcher::implcp_addStatusListener( const css::uno::Reference< css::frame::XStatusListener >& xListener ,
                                                   const css::util::URL&                                     aURL      )
{
    return(
            ( &xListener                == NULL      )  ||
            ( xListener.is()            == sal_False )  ||
            ( &aURL                     == NULL      )  ||
            ( aURL.Complete.getLength() <  1         )
          );
}

//*****************************************************************************************************************
// The same goes for these case! We have added valid listener for correct URL only.
// We can't remove invalid listener for nothing!
sal_Bool BaseDispatcher::implcp_removeStatusListener( const css::uno::Reference< css::frame::XStatusListener >& xListener ,
                                                      const css::util::URL&                                     aURL      )
{
    return(
            ( &xListener                == NULL      )  ||
            ( xListener.is()            == sal_False )  ||
            ( &aURL                     == NULL      )  ||
            ( aURL.Complete.getLength() <  1         )
          );
}

//*****************************************************************************************************************
sal_Bool BaseDispatcher::implcp_statusChanged( const css::frame::FeatureStateEvent& aEvent )
{
    return( &aEvent == NULL );
}

//*****************************************************************************************************************
sal_Bool BaseDispatcher::implcp_loadFinished( const css::uno::Reference< css::frame::XFrameLoader >& xLoader )
{
    return(
            ( &xLoader     == NULL      )    ||
            ( xLoader.is() == sal_False )
          );
}

//*****************************************************************************************************************
sal_Bool BaseDispatcher::implcp_loadCancelled( const css::uno::Reference< css::frame::XFrameLoader >& xLoader )
{
    return(
            ( &xLoader     == NULL      )    ||
            ( xLoader.is() == sal_False )
          );
}

//*****************************************************************************************************************
sal_Bool BaseDispatcher::implcp_disposing( const css::lang::EventObject& aEvent )
{
    return(
            ( &aEvent            == NULL      ) ||
            ( aEvent.Source.is() == sal_False )
          );
}

#endif	//	#ifdef ENABLE_ASSERTIONS

}		//	namespace framework
