/*************************************************************************
 *
 *  $RCSfile: test_argumentanalyzer.cxx,v $
 *
 *  $Revision: 1.1.2.1 $
 *
 *  last change: $Author: mh $ $Date: 2002/06/01 05:31:57 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

//_________________________________________________________________________________________________________________
//	my own includes
//_________________________________________________________________________________________________________________

#ifndef __FRAMEWORK_CLASSES_ARGUMENTANALYZER_HXX_
#include <classes/argumentanalyzer.hxx>
#endif

#ifndef __FRAMEWORK_CLASSES_SERVICEMANAGER_HXX_
#include <classes/servicemanager.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_GENERIC_HXX_
#include <macros/generic.hxx>
#endif

#ifndef __FRAMEWORK_MACROS_DEBUG_HXX_
#include <macros/debug.hxx>
#endif

#ifndef __FRAMEWORK_GENERAL_H_
#include <general.h>
#endif

#ifndef __FRAMEWORK_SERVICES_H_
#include <services.h>
#endif

#ifndef __FRAMEWORK_ARGUMENTS_H_
#include <arguments.h>
#endif

//_________________________________________________________________________________________________________________
//	interface includes
//_________________________________________________________________________________________________________________

#ifndef _COM_SUN_STAR_LANG_XMULTISERVICEFACTORY_HPP_
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#endif

#ifndef _COM_SUN_STAR_BEANS_PROPERTYVALUE_HPP_
#include <com/sun/star/beans/PropertyValue.hpp>
#endif

#ifndef _COM_SUN_STAR_AWT_RECTANGLE_HPP_
#include <com/sun/star/awt/Rectangle.hpp>
#endif

#ifndef _COM_SUN_STAR_IO_XINPUTSTREAM_HPP_
#include <com/sun/star/io/XInputStream.hpp>
#endif

#ifndef _COM_SUN_STAR_IO_XOUTPUTSTREAM_HPP_
#include <com/sun/star/io/XOutputStream.hpp>
#endif

#ifndef _COM_SUN_STAR_TASK_XSTATUSINDICATOR_HPP_
#include <com/sun/star/task/XStatusIndicator.hpp>
#endif

#ifndef _COM_SUN_STAR_TASK_XINTERACTIONHANDLER_HPP_
#include <com/sun/star/task/XInteractionHandler.hpp>
#endif

//_________________________________________________________________________________________________________________
//	other includes
//_________________________________________________________________________________________________________________

#ifndef _COMPHELPER_PROCESSFACTORY_HXX_
#include <comphelper/processfactory.hxx>
#endif

#ifndef _RTL_USTRING_
#include <rtl/ustring.hxx>
#endif

#ifndef _RTL_USTRBUF_HXX_
#include <rtl/ustrbuf.hxx>
#endif

#ifndef _SAL_MAIN_H_
#include <sal/main.h>
#endif

//_________________________________________________________________________________________________________________
//	const
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	namespace
//_________________________________________________________________________________________________________________

using namespace ::framework;

//_________________________________________________________________________________________________________________
//	defines
//_________________________________________________________________________________________________________________

#define LOGFILE     "test_argumentanalyzer.log"

//_________________________________________________________________________________________________________________
//	declarations
//_________________________________________________________________________________________________________________

//_________________________________________________________________________________________________________________
//	global variables
//_________________________________________________________________________________________________________________

/*-****************************************************************************************************************
    initialize given list with standard values
****************************************************************************************************************-*/
void initArgumentList( css::uno::Sequence< css::beans::PropertyValue >& lList )
{
    lList.realloc( 31 );

    lList[ 0].Name  = ARGUMENTNAME_CHARACTERSET        ;
    lList[ 1].Name  = ARGUMENTNAME_MEDIATYPE           ;
    lList[ 2].Name  = ARGUMENTNAME_DETECTSERVICE       ;
    lList[ 3].Name  = ARGUMENTNAME_EXTENSION           ;
    lList[ 4].Name  = ARGUMENTNAME_URL                 ;
    lList[ 5].Name  = ARGUMENTNAME_FILTERNAME          ;
    lList[ 6].Name  = ARGUMENTNAME_FORMAT              ;
    lList[ 7].Name  = ARGUMENTNAME_FRAMENAME           ;
    lList[ 8].Name  = ARGUMENTNAME_PATTERN             ;
    lList[ 9].Name  = ARGUMENTNAME_POSTDATA            ;
    lList[10].Name  = ARGUMENTNAME_POSTSTRING          ;
    lList[11].Name  = ARGUMENTNAME_REFERRER            ;
    lList[12].Name  = ARGUMENTNAME_TEMPLATENAME        ;
    lList[13].Name  = ARGUMENTNAME_TEMPLATEREGIONNAME  ;
    lList[14].Name  = ARGUMENTNAME_JUMPMARK            ;
    lList[15].Name  = ARGUMENTNAME_TYPENAME            ;
    lList[16].Name  = ARGUMENTNAME_VERSION             ;
    lList[17].Name  = ARGUMENTNAME_VIEWID              ;
    lList[18].Name  = ARGUMENTNAME_FLAGS               ;
    lList[19].Name  = ARGUMENTNAME_ASTEMPLATE          ;
    lList[20].Name  = ARGUMENTNAME_HIDDEN              ;
    lList[21].Name  = ARGUMENTNAME_OPENNEWVIEW         ;
    lList[22].Name  = ARGUMENTNAME_READONLY            ;
    lList[23].Name  = ARGUMENTNAME_PREVIEW             ;
    lList[24].Name  = ARGUMENTNAME_SILENT              ;
    lList[25].Name  = ARGUMENTNAME_DEEPDETECTION       ;
    lList[26].Name  = ARGUMENTNAME_POSSIZE             ;
    lList[27].Name  = ARGUMENTNAME_INPUTSTREAM         ;
    lList[28].Name  = ARGUMENTNAME_OUTPUTSTREAM        ;
    lList[29].Name  = ARGUMENTNAME_STATUSINDICATOR     ;
    lList[30].Name  = ARGUMENTNAME_INTERACTIONHANDLER  ;

    lList[ 0].Value <<= ::rtl::OUString();
    lList[ 1].Value <<= ::rtl::OUString();
    lList[ 2].Value <<= ::rtl::OUString();
    lList[ 3].Value <<= ::rtl::OUString();
    lList[ 4].Value <<= ::rtl::OUString();
    lList[ 5].Value <<= ::rtl::OUString();
    lList[ 6].Value <<= ::rtl::OUString();
    lList[ 7].Value <<= ::rtl::OUString();
    lList[ 8].Value <<= ::rtl::OUString();
    lList[ 9].Value <<= ::rtl::OUString();
    lList[10].Value <<= ::rtl::OUString();
    lList[11].Value <<= ::rtl::OUString();
    lList[12].Value <<= ::rtl::OUString();
    lList[13].Value <<= ::rtl::OUString();
    lList[14].Value <<= ::rtl::OUString();
    lList[15].Value <<= ::rtl::OUString();
    lList[16].Value <<= (sal_Int16)0;
    lList[17].Value <<= (sal_Int16)0;
    lList[18].Value <<= (sal_Int32)0;
    lList[19].Value <<= sal_False;
    lList[20].Value <<= sal_False;
    lList[21].Value <<= sal_False;
    lList[22].Value <<= sal_False;
    lList[23].Value <<= sal_False;
    lList[24].Value <<= sal_False;
    lList[25].Value <<= sal_False;
    lList[26].Value <<= css::awt::Rectangle();
    lList[27].Value <<= css::uno::Reference< css::io::XInputStream >();
    lList[28].Value <<= css::uno::Reference< css::io::XOutputStream >();
    lList[29].Value <<= css::uno::Reference< css::task::XStatusIndicator >();
    lList[30].Value <<= css::uno::Reference< css::task::XInteractionHandler >();
}

/*-****************************************************************************************************************
    write names of list items and an additional comment to log file
****************************************************************************************************************-*/
void logArgumentList( const css::uno::Sequence< css::beans::PropertyValue >& lList    ,
                      const sal_Char*                                        pComment )
{
    ::rtl::OUStringBuffer sBuffer( 512 );

    sBuffer.appendAscii( pComment );
    sBuffer.appendAscii( ":\n"    );

    sal_Int32 nCount = lList.getLength();
    for( sal_Int32 nStep=0; nStep<nCount; ++nStep )
    {
        if( nStep<10 )
            sBuffer.appendAscii( "\t[ ");
        else
            sBuffer.appendAscii( "\t[" );
        sBuffer.append     ( (sal_Int32)nStep  );
        sBuffer.appendAscii( "]\t"             );
        sBuffer.append     ( lList[nStep].Name );
        sBuffer.appendAscii( "\t=\t"           );
        if(
            ( lList[nStep].Name == ARGUMENTNAME_CHARACTERSET       )    ||
            ( lList[nStep].Name == ARGUMENTNAME_MEDIATYPE          )    ||
            ( lList[nStep].Name == ARGUMENTNAME_DETECTSERVICE      )    ||
            ( lList[nStep].Name == ARGUMENTNAME_EXTENSION          )    ||
            ( lList[nStep].Name == ARGUMENTNAME_URL                )    ||
            ( lList[nStep].Name == ARGUMENTNAME_FILTERNAME         )    ||
            ( lList[nStep].Name == ARGUMENTNAME_FORMAT             )    ||
            ( lList[nStep].Name == ARGUMENTNAME_FRAMENAME          )    ||
            ( lList[nStep].Name == ARGUMENTNAME_PATTERN            )    ||
            ( lList[nStep].Name == ARGUMENTNAME_POSTDATA           )    ||
            ( lList[nStep].Name == ARGUMENTNAME_POSTSTRING         )    ||
            ( lList[nStep].Name == ARGUMENTNAME_REFERRER           )    ||
            ( lList[nStep].Name == ARGUMENTNAME_TEMPLATENAME       )    ||
            ( lList[nStep].Name == ARGUMENTNAME_TEMPLATEREGIONNAME )    ||
            ( lList[nStep].Name == ARGUMENTNAME_JUMPMARK           )    ||
            ( lList[nStep].Name == ARGUMENTNAME_TYPENAME           )
          )
        {
            ::rtl::OUString sValue;
            lList[nStep].Value >>= sValue;
            sBuffer.appendAscii( "\""   );
            sBuffer.append     ( sValue );
            sBuffer.appendAscii( "\""   );
        }
        else
        if(
            ( lList[nStep].Name == ARGUMENTNAME_VERSION )    ||
            ( lList[nStep].Name == ARGUMENTNAME_VIEWID  )
          )
        {
            sal_Int16 nValue;
            lList[nStep].Value >>= nValue;
            sBuffer.append( (sal_Int32)nValue );
        }
        else
        if( lList[nStep].Name == ARGUMENTNAME_FLAGS )
        {
            sal_Int32 nValue;
            lList[nStep].Value >>= nValue;
            sBuffer.append( (sal_Int32)nValue );
        }
        else
        if(
            ( lList[nStep].Name == ARGUMENTNAME_ASTEMPLATE     ) ||
            ( lList[nStep].Name == ARGUMENTNAME_HIDDEN         ) ||
            ( lList[nStep].Name == ARGUMENTNAME_OPENNEWVIEW    ) ||
            ( lList[nStep].Name == ARGUMENTNAME_READONLY       ) ||
            ( lList[nStep].Name == ARGUMENTNAME_PREVIEW        ) ||
            ( lList[nStep].Name == ARGUMENTNAME_SILENT         ) ||
            ( lList[nStep].Name == ARGUMENTNAME_DEEPDETECTION  )
          )
        {
            sal_Bool bValue;
            lList[nStep].Value >>= bValue;
            sBuffer.append( (sal_Bool)bValue );
        }
        else
        if( lList[nStep].Name == ARGUMENTNAME_POSSIZE )
        {
            css::awt::Rectangle aValue;
            lList[nStep].Value >>= aValue;
            sBuffer.appendAscii( "["            );
            sBuffer.append     ( aValue.X       );
            sBuffer.appendAscii( ","            );
            sBuffer.append     ( aValue.Y       );
            sBuffer.appendAscii( ","            );
            sBuffer.append     ( aValue.Width   );
            sBuffer.appendAscii( ","            );
            sBuffer.append     ( aValue.Height  );
            sBuffer.appendAscii( "]"            );
        }
        else
        if( lList[nStep].Name == ARGUMENTNAME_INPUTSTREAM )
        {
            css::uno::Reference< css::io::XInputStream > xValue;
            lList[nStep].Value >>= xValue;
            if( xValue.is() == sal_True )
                sBuffer.appendAscii( "SET"  );
            else
                sBuffer.appendAscii( "NULL" );
        }
        else
        if( lList[nStep].Name == ARGUMENTNAME_OUTPUTSTREAM )
        {
            css::uno::Reference< css::io::XOutputStream > xValue;
            lList[nStep].Value >>= xValue;
            if( xValue.is() == sal_True )
                sBuffer.appendAscii( "SET"  );
            else
                sBuffer.appendAscii( "NULL" );
        }
        else
        if( lList[nStep].Name == ARGUMENTNAME_STATUSINDICATOR )
        {
            css::uno::Reference< css::task::XStatusIndicator > xValue;
            lList[nStep].Value >>= xValue;
            if( xValue.is() == sal_True )
                sBuffer.appendAscii( "SET"  );
            else
                sBuffer.appendAscii( "NULL" );
        }
        else
        if( lList[nStep].Name == ARGUMENTNAME_INTERACTIONHANDLER )
        {
            css::uno::Reference< css::task::XInteractionHandler > xValue;
            lList[nStep].Value >>= xValue;
            if( xValue.is() == sal_True )
                sBuffer.appendAscii( "SET"  );
            else
                sBuffer.appendAscii( "NULL" );
        }
        sBuffer.appendAscii( "\n" );
    }

    sBuffer.appendAscii( "\n" );
    WRITE_LOGFILE( LOGFILE, U2B(sBuffer.makeStringAndClear()).getStr() )
}

//*****************************************************************************************************************
SAL_IMPLEMENT_MAIN()
{
    // Init global servicemanager and set it.
    // It's neccessary for other services ... e.g. configuration.
    ServiceManager aManager;
    ::comphelper::setProcessServiceFactory( aManager.getGlobalUNOServiceManager() );

    // Start test of ArgumentAnalyzer
    // 1) create list of example arguments
    css::uno::Sequence< css::beans::PropertyValue > lArgs;
    initArgumentList( lArgs );
    logArgumentList ( lArgs, "full initialized example list" );

    // 2) set list on analyzer
    ArgumentAnalyzer aAnalyzer( lArgs );

    // 3) check "existArgument()"
    //    We work on full initialized list. All items must exist!
    if( aAnalyzer.existArgument( E_CHARACTERSET        ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss CHARACTERSET ...\n" );
    if( aAnalyzer.existArgument( E_MEDIATYPE           ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss MEDIATYPE ...\n" );
    if( aAnalyzer.existArgument( E_DETECTSERVICE       ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss DETECTSERVICE ...\n" );
    if( aAnalyzer.existArgument( E_EXTENSION           ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss EXTENSION ...\n" );
    if( aAnalyzer.existArgument( E_URL                 ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss URL ...\n" );
    if( aAnalyzer.existArgument( E_FILTERNAME          ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss FILTERNAME ...\n" );
    if( aAnalyzer.existArgument( E_FORMAT              ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss FORMAT ...\n" );
    if( aAnalyzer.existArgument( E_FRAMENAME           ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss FRAMENAME ...\n" );
    if( aAnalyzer.existArgument( E_PATTERN             ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss PATTERN ...\n" );
    if( aAnalyzer.existArgument( E_POSTDATA            ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss POSTDATA ...\n" );
    if( aAnalyzer.existArgument( E_POSTSTRING          ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss POSTSTRING ...\n" );
    if( aAnalyzer.existArgument( E_REFERRER            ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss REFERRER ...\n" );
    if( aAnalyzer.existArgument( E_TEMPLATENAME        ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss TEMPLATENAME ...\n" );
    if( aAnalyzer.existArgument( E_TEMPLATEREGIONNAME  ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss TEMPLATEREGIONNAME ...\n" );
    if( aAnalyzer.existArgument( E_JUMPMARK            ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss JUMPMARK ...\n" );
    if( aAnalyzer.existArgument( E_TYPENAME            ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss TYPENAME ...\n" );
    if( aAnalyzer.existArgument( E_VERSION             ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss VERSION ...\n" );
    if( aAnalyzer.existArgument( E_VIEWID              ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss VIEWID ...\n" );
    if( aAnalyzer.existArgument( E_FLAGS               ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss FLAGS ...\n" );
    if( aAnalyzer.existArgument( E_ASTEMPLATE          ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss ASTEMPLATE ...\n" );
    if( aAnalyzer.existArgument( E_HIDDEN              ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss HIDDEN ...\n" );
    if( aAnalyzer.existArgument( E_OPENNEWVIEW         ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss OPENNEWVIEW ...\n" );
    if( aAnalyzer.existArgument( E_READONLY            ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss READONLY ...\n" );
    if( aAnalyzer.existArgument( E_PREVIEW             ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss PREVIEW ...\n" );
    if( aAnalyzer.existArgument( E_SILENT              ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss SILENT ...\n" );
    if( aAnalyzer.existArgument( E_DEEPDETECTION       ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss DEEPDETECTION ...\n" );
    if( aAnalyzer.existArgument( E_POSSIZE             ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss POSSIZE ...\n" );
    if( aAnalyzer.existArgument( E_INPUTSTREAM         ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss INPUTSTREAM ...\n" );
    if( aAnalyzer.existArgument( E_OUTPUTSTREAM        ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss OUTPUTSTREAM ...\n" );
    if( aAnalyzer.existArgument( E_STATUSINDICATOR     ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss STATUSINDICATOR ...\n" );
    if( aAnalyzer.existArgument( E_INTERACTIONHANDLER  ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Miss INTERACTIONHANDLER ...\n" );

    // 4) try to delete some items
    aAnalyzer.deleteArgument( E_CHARACTERSET );
    if( aAnalyzer.existArgument( E_CHARACTERSET ) == sal_True ) WRITE_LOGFILE( LOGFILE, "Couldn't delete CHARACTERSET ...\n" );
    logArgumentList( lArgs, "CHARACTERSET shouldnt exist ..." );

    aAnalyzer.deleteArgument( E_OPENNEWVIEW );
    if( aAnalyzer.existArgument( E_OPENNEWVIEW ) == sal_True ) WRITE_LOGFILE( LOGFILE, "Couldn't delete OPENNEWVIEW ...\n" );
    logArgumentList( lArgs, "OPENNEWVIEW shouldnt exist ..." );

    aAnalyzer.deleteArgument( E_FILTERNAME );
    if( aAnalyzer.existArgument( E_FILTERNAME ) == sal_True ) WRITE_LOGFILE( LOGFILE, "Couldn't delete FILTERNAME ...\n" );
    logArgumentList( lArgs, "FILTERNAME shouldnt exist ..." );

    // 5) We have deleted some items on top of list ... check items at the end for valid values and indices!
    if( aAnalyzer.existArgument( E_INTERACTIONHANDLER ) == sal_False ) WRITE_LOGFILE( LOGFILE, "Lost INTERACTIONHANDLER ...\n" );

    // 6) try to set/get some values from list items
    //    Attention: Use different values for different items or test every element in list seperatly.
    //    We must prevent use against overwriting of wrong ones by using damaged indices!
    ::rtl::OUString sSetValue;
    ::rtl::OUString sGetValue;

    sSetValue = DECLARE_ASCII("test value for MEDIATYPE" );
    aAnalyzer.setArgument( E_MEDIATYPE, sSetValue );
    if(
        ( aAnalyzer.getArgument( E_MEDIATYPE, sGetValue ) == sal_False )    ||
        ( sGetValue                                       != sSetValue )
      )
    {
        WRITE_LOGFILE( LOGFILE, "Couldn't set/get value for MEDIATYPE ..." );
    }

    sSetValue = DECLARE_ASCII("test value for TEMPLATENAME" );
    aAnalyzer.setArgument( E_TEMPLATENAME, sSetValue );
    if(
        ( aAnalyzer.getArgument( E_TEMPLATENAME, sGetValue ) == sal_False )    ||
        ( sGetValue                                          != sSetValue )
      )
    {
        WRITE_LOGFILE( LOGFILE, "Couldn't set/get value for TEMPLATENAME ..." );
    }

    sSetValue = DECLARE_ASCII("test value for JUMPMARK" );
    aAnalyzer.setArgument( E_JUMPMARK, sSetValue );
    if(
        ( aAnalyzer.getArgument( E_JUMPMARK, sGetValue ) == sal_False )    ||
        ( sGetValue                                      != sSetValue )
      )
    {
        WRITE_LOGFILE( LOGFILE, "Couldn't set/get value for JUMPMARK ..." );
    }

    logArgumentList( lArgs, "After set/get test ..." );

    // 7) test deletion of ALL items!
    aAnalyzer.deleteArgument( E_DETECTSERVICE       );  logArgumentList( lArgs, "After delete DETECTSERVICE ..." );
    aAnalyzer.deleteArgument( E_EXTENSION           );  logArgumentList( lArgs, "After delete EXTENSION ..." );
    aAnalyzer.deleteArgument( E_URL                 );  logArgumentList( lArgs, "After delete URL ..." );
    aAnalyzer.deleteArgument( E_FORMAT              );  logArgumentList( lArgs, "After delete FORMAT ..." );
    aAnalyzer.deleteArgument( E_FRAMENAME           );  logArgumentList( lArgs, "After delete FRAMENAME ..." );
    aAnalyzer.deleteArgument( E_PATTERN             );  logArgumentList( lArgs, "After delete PATTERN ..." );
    aAnalyzer.deleteArgument( E_POSTDATA            );  logArgumentList( lArgs, "After delete POSTDATA ..." );
    aAnalyzer.deleteArgument( E_POSTSTRING          );  logArgumentList( lArgs, "After delete POSTSTRING ..." );
    aAnalyzer.deleteArgument( E_REFERRER            );  logArgumentList( lArgs, "After delete REFERRER ..." );
    aAnalyzer.deleteArgument( E_TEMPLATEREGIONNAME  );  logArgumentList( lArgs, "After delete TEMPLATEREGIONNAME ..." );
    aAnalyzer.deleteArgument( E_TYPENAME            );  logArgumentList( lArgs, "After delete TYPENAME ..." );
    aAnalyzer.deleteArgument( E_VERSION             );  logArgumentList( lArgs, "After delete VERSION ..." );
    aAnalyzer.deleteArgument( E_VIEWID              );  logArgumentList( lArgs, "After delete VIEWID ..." );
    aAnalyzer.deleteArgument( E_FLAGS               );  logArgumentList( lArgs, "After delete FLAGS ..." );
    aAnalyzer.deleteArgument( E_ASTEMPLATE          );  logArgumentList( lArgs, "After delete ASTEMPLATE ..." );
    aAnalyzer.deleteArgument( E_HIDDEN              );  logArgumentList( lArgs, "After delete HIDDEN ..." );
    aAnalyzer.deleteArgument( E_OPENNEWVIEW         );  logArgumentList( lArgs, "After delete OPENNEWVIEW ..." );
    aAnalyzer.deleteArgument( E_READONLY            );  logArgumentList( lArgs, "After delete READONLY ..." );
    aAnalyzer.deleteArgument( E_PREVIEW             );  logArgumentList( lArgs, "After delete PREVIEW ..." );
    aAnalyzer.deleteArgument( E_SILENT              );  logArgumentList( lArgs, "After delete SILENT ..." );
    aAnalyzer.deleteArgument( E_DEEPDETECTION       );  logArgumentList( lArgs, "After delete DEEPDETECTION ..." );
    aAnalyzer.deleteArgument( E_POSSIZE             );  logArgumentList( lArgs, "After delete POSSIZE ..." );
    aAnalyzer.deleteArgument( E_INPUTSTREAM         );  logArgumentList( lArgs, "After delete INPUTSTREAM ..." );
    aAnalyzer.deleteArgument( E_OUTPUTSTREAM        );  logArgumentList( lArgs, "After delete OUTPUTSTREAM ..." );
    aAnalyzer.deleteArgument( E_STATUSINDICATOR     );  logArgumentList( lArgs, "After delete STATUSINDICATOR ..." );
    aAnalyzer.deleteArgument( E_INTERACTIONHANDLER  );  logArgumentList( lArgs, "After delete INTERACTIONHANDLER ..." );
    aAnalyzer.deleteArgument( E_TEMPLATENAME        );  logArgumentList( lArgs, "After delete TEMPLATENAME ..." );
    aAnalyzer.deleteArgument( E_MEDIATYPE           );  logArgumentList( lArgs, "After delete MEDIATYPE ..." );
    aAnalyzer.deleteArgument( E_JUMPMARK            );  logArgumentList( lArgs, "After delete JUMPMARK ..." );

    return 0;
}
