/*************************************************************************
 *
 *  $RCSfile: calendarImpl.cxx,v $
 *
 *  $Revision: 1.9 $
 *
 *  last change: $Author: bustamam $ $Date: 2001/12/14 23:19:30 $
 *
 *  The Contents of this file are made available subject to the terms of
 *  either of the following licenses
 *
 *         - GNU Lesser General Public License Version 2.1
 *         - Sun Industry Standards Source License Version 1.1
 *
 *  Sun Microsystems Inc., October, 2000
 *
 *  GNU Lesser General Public License Version 2.1
 *  =============================================
 *  Copyright 2000 by Sun Microsystems, Inc.
 *  901 San Antonio Road, Palo Alto, CA 94303, USA
 *
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License version 2.1, as published by the Free Software Foundation.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 *  MA  02111-1307  USA
 *
 *
 *  Sun Industry Standards Source License Version 1.1
 *  =================================================
 *  The contents of this file are subject to the Sun Industry Standards
 *  Source License Version 1.1 (the "License"); You may not use this file
 *  except in compliance with the License. You may obtain a copy of the
 *  License at http://www.openoffice.org/license.html.
 *
 *  Software provided under this License is provided on an "AS IS" basis,
 *  WITHOUT WARRANTY OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING,
 *  WITHOUT LIMITATION, WARRANTIES THAT THE SOFTWARE IS FREE OF DEFECTS,
 *  MERCHANTABLE, FIT FOR A PARTICULAR PURPOSE, OR NON-INFRINGING.
 *  See the License for the specific provisions governing your rights and
 *  obligations concerning the Software.
 *
 *  The Initial Developer of the Original Code is: Sun Microsystems, Inc.
 *
 *  Copyright: 2000 by Sun Microsystems, Inc.
 *
 *  All Rights Reserved.
 *
 *  Contributor(s): _______________________________________
 *
 *
 ************************************************************************/

#include "calendarImpl.hxx"
#include <com/sun/star/i18n/XCalendar.hpp>
#include <com/sun/star/i18n/AmPmValue.hpp>
#include <com/sun/star/i18n/CalendarDisplayIndex.hpp>
#include <com/sun/star/i18n/CalendarFieldIndex.hpp>
#include <com/sun/star/i18n/Months.hpp>
#include <com/sun/star/i18n/Weekdays.hpp>
#include <com/sun/star/i18n/XLocaleData.hpp>
#include <com/sun/star/lang/XMultiServiceFactory.hpp>
#include <comphelper/processfactory.hxx>

#ifndef _TOOLS_SOLMATH_HXX
#include <tools/solmath.hxx>
#endif

typedef struct _Era_array {
	sal_Char*	eraID;
	sal_Int32	startYear;
	sal_Int32	startMonth;
	sal_Int32	startDay;
} Era_array;

#define gengou_len 5
Era_array gengou[] =
{
    {"Dummy",	0,	0,	0},
    {"Meiji",	1868,	1,	1},
    {"Taisho",	1912,	7,	30},
    {"Showa",	1926,	12,	5},
    {"Heisei",	1989,	1,	8}
};

#define ROC_len 2
Era_array ROC[] =
{
    {"Dummy",	0,	0,	0},
    {"MINGUO",	1912,	1,	1}
};

#define ERROR ::com::sun::star::uno::RuntimeException()

static const sal_Int16 nFirstDayOfWeekInvalid = 0x7fff;
static const sal_Int16 nMinimumNumberOfDaysForFirstWeekInvalid = 0x7fff;

using namespace ::com::sun::star;
using namespace ::com::sun::star::i18n;
using namespace ::com::sun::star::uno;


CalendarImpl::CalendarImpl()
		:
		aEpoch( Date( 1, 1, 1970 ) ),
		nDstOffset( 0 )
{
	invalidateData();
	Reference< lang::XMultiServiceFactory > xMSF
		= ::comphelper::getProcessServiceFactory();
	Reference < XInterface > xI( xMSF->createInstance(
		::rtl::OUString(
		RTL_CONSTASCII_USTRINGPARAM( "com.sun.star.i18n.LocaleData" ) ) ),
		UNO_QUERY );
	if ( xI.is() ) {
		Any x = xI->queryInterface(
			::getCppuType( (const uno::Reference< XLocaleData >*)0) );
		x >>= xLocaleData;
	}
}


CalendarImpl::~CalendarImpl()
{
}


void CalendarImpl::invalidateData()
{
	nFirstDayOfWeek = nFirstDayOfWeekInvalid;
	nMinimumNumberOfDaysForFirstWeek = nMinimumNumberOfDaysForFirstWeekInvalid;
}


void SAL_CALL
CalendarImpl::loadDefaultCalendar( const ::com::sun::star::lang::Locale& rLocale )
throw(::com::sun::star::uno::RuntimeException)
{
	Sequence< Calendar > xC = xLocaleData->getAllCalendars(rLocale);
	for (sal_Int32 i = 0; i < xC.getLength(); i++)
	{
		if ( xC[i].Default )
		{
			aCalendar = xC[i];
			aLocale = rLocale;
			invalidateData();
			return;
		}
	}
}


void SAL_CALL
CalendarImpl::loadCalendar( const ::rtl::OUString& uniqueID,
					const ::com::sun::star::lang::Locale& rLocale )
						throw(::com::sun::star::uno::RuntimeException)
{
	Sequence< Calendar > xC = xLocaleData->getAllCalendars(rLocale);
	for (sal_Int32 i = 0; i < xC.getLength(); i++)
	{
		if ( uniqueID == xC[i].Name )
		{
			aCalendar = xC[i];
			aLocale = rLocale;
			invalidateData();
			return;
		}
	}
	throw ERROR;
}


::com::sun::star::i18n::Calendar SAL_CALL
CalendarImpl::getLoadedCalendar() throw(::com::sun::star::uno::RuntimeException)
{
	return aCalendar;
}


::com::sun::star::uno::Sequence< ::rtl::OUString > SAL_CALL
CalendarImpl::getAllCalendars( const ::com::sun::star::lang::Locale& rLocale )
throw(::com::sun::star::uno::RuntimeException)
{
	Sequence< Calendar > xC = xLocaleData->getAllCalendars(rLocale);
	sal_Int32 nLen = xC.getLength();
	Sequence< ::rtl::OUString > xSeq( nLen );
	for (sal_Int32 i = 0; i < nLen; i++)
	{
		xSeq[i] = xC[i].Name;
	}
	return xSeq;
}

void SAL_CALL
CalendarImpl::setDateTime( double fTimeInDays )
throw(::com::sun::star::uno::RuntimeException)
{
	aDateTime = aEpoch;
	aDateTime += fTimeInDays;
}

double SAL_CALL
CalendarImpl::getDateTime() throw(::com::sun::star::uno::RuntimeException)
{
	return aDateTime - aEpoch;
}

::rtl::OUString SAL_CALL
CalendarImpl::getUniqueID() throw(::com::sun::star::uno::RuntimeException)
{
	return aCalendar.Name;
}

void SAL_CALL
CalendarImpl::setValue( sal_Int16 nFieldIndex, sal_Int16 nValue )
throw(::com::sun::star::uno::RuntimeException)
{
	using namespace ::com::sun::star::i18n::CalendarFieldIndex;
	switch ( nFieldIndex )
	{
		case AM_PM:			goto err; // f = ::Calendar::AM_PM; break;
		case DAY_OF_MONTH:	aDateTime.SetDay( nValue ); break;
		case DAY_OF_WEEK:	goto err; // f = ::Calendar::DAY_OF_WEEK; break;
		case DAY_OF_YEAR:	goto err; // f = ::Calendar::DAY_OF_YEAR; break;
		case DST_OFFSET:	nDstOffset = nValue; break;
		case HOUR:			aDateTime.SetHour( nValue ); break;
		case MINUTE:		aDateTime.SetMin( nValue ); break;
		case SECOND:		aDateTime.SetSec( nValue ); break;
		case MILLISECOND:	aDateTime.Set100Sec( nValue / 10 ); break;
		case WEEK_OF_MONTH:	goto err; // f = ::Calendar::WEEK_OF_MONTH; break;
		case WEEK_OF_YEAR:	goto err; // f = ::Calendar::WEEK_OF_YEAR; break;
		case YEAR:			aDateTime.SetYear( nValue ); break;
		// month 0- to 1-based
		case MONTH:			aDateTime.SetMonth( nValue + 1 ); break;
		case ERA:			break; // f = ::Calendar::ERA; break;
		default:			throw ERROR;
	}
	return;

 err:
	throw ERROR;
}

static sal_Int16 SAL_CALL
getEraSeq(DateTime& aDateTime, Era_array array[], sal_Int16 array_len)
{
	for (sal_Int16 i = array_len - 1; i > 0; i--) {
	    if (aDateTime.GetYear() >= array[i].startYear && 
		    aDateTime.GetMonth() >= array[i].startMonth &&
		    aDateTime.GetDay() >=  gengou[i].startDay)
		return i;
	}
	return 0;
}

static sal_Int16 SAL_CALL
getEraYear(DateTime& aDateTime, Era_array array[], sal_Int16 array_len)
{
	sal_Int16 year = aDateTime.GetYear();
	for (sal_Int16 i = array_len - 1; i > 0; i--) {
	    if (year >= array[i].startYear && 
		    aDateTime.GetMonth() >= array[i].startMonth &&
		    aDateTime.GetDay() >=  gengou[i].startDay)
		return year - array[i].startYear + 1;
	}
	return array[1].startYear - year;
}

sal_Int16 SAL_CALL
CalendarImpl::getValue( sal_Int16 nFieldIndex )
throw(::com::sun::star::uno::RuntimeException)
{
	using namespace ::com::sun::star::i18n::CalendarFieldIndex;
	switch ( nFieldIndex )
	{
		case AM_PM:
		{
			USHORT nH = aDateTime.GetHour();
			if ( 0 <= nH && nH < 12 )
				return AmPmValue::AM;
			else
				return AmPmValue::PM;
		}
		break;
		case DAY_OF_MONTH:	return aDateTime.GetDay(); break;
		// dayofweek map Monday(0) to Sunday(0)
		case DAY_OF_WEEK:	return (aDateTime.GetDayOfWeek() + 1) % 7; break;
		case DAY_OF_YEAR:	return aDateTime.GetDayOfYear(); break;
		case DST_OFFSET:	return nDstOffset; break;
		case HOUR:			return aDateTime.GetHour(); break;
		case MINUTE:		return aDateTime.GetMin(); break;
		case SECOND:		return aDateTime.GetSec(); break;
		case MILLISECOND:	return aDateTime.Get100Sec() * 10; break;
		case WEEK_OF_MONTH:	goto err; break;
		case WEEK_OF_YEAR:	return aDateTime.GetWeekOfYear(); break;
		case YEAR:		
					if (aCalendar.Name.compareToAscii("gengou") == 0) {
					    return getEraYear(aDateTime, gengou, gengou_len);
					} else if (aCalendar.Name.compareToAscii("ROC") == 0) {
					    return getEraYear(aDateTime, ROC, ROC_len);
					} else {
					    return aDateTime.GetYear();
					}
					break;
		// month 1- to 0-based
		case MONTH:			return aDateTime.GetMonth() - 1; break;
		case ERA:
					if (aCalendar.Name.compareToAscii("gengou") == 0) {
					    return getEraSeq(aDateTime, gengou, gengou_len);
					} else if (aCalendar.Name.compareToAscii("ROC") == 0) {
					    return getEraSeq(aDateTime, ROC, ROC_len);
					} else {
					    return aDateTime.GetYear() < 0 ? 0 : 1;
					}
					break;
		default:			throw ERROR;
	}
	return 0;

 err:
	throw ERROR;
}

void SAL_CALL
CalendarImpl::addValue( sal_Int16 nFieldIndex, sal_Int32 nAmount )
throw(::com::sun::star::uno::RuntimeException)
{
	using namespace ::com::sun::star::i18n::CalendarFieldIndex;
	switch ( nFieldIndex )
	{
		case AM_PM:			goto err; break;
		case DAY_OF_MONTH:
		case DAY_OF_WEEK:
		case DAY_OF_YEAR:
			// add days
			setDateTime( getDateTime() + nAmount );
		break;
		case DST_OFFSET:	nDstOffset += sal_Int16(nAmount); break;
		case HOUR:			setDateTime( getDateTime() + double(nAmount) / 24 ); break;
		case MINUTE:		setDateTime( getDateTime() + double(nAmount) / (24*60) ); break;
		case SECOND:		setDateTime( getDateTime() + double(nAmount) / (24UL*60*60) ); break;
		case MILLISECOND:	setDateTime( getDateTime() + double(nAmount) / (24UL*60*60*1000) ); break;
		case WEEK_OF_MONTH:
		case WEEK_OF_YEAR:
			// add weeks
			setDateTime( getDateTime() + nAmount * getNumberOfDaysInWeek() );
		break;
		case YEAR:			aDateTime.SetYear( aDateTime.GetYear() + USHORT(nAmount) ); break;
		case MONTH:
		{
			sal_Int16 nMIY = getNumberOfMonthsInYear();
			sal_Int32 nMonth = nAmount + aDateTime.GetMonth();
			sal_Int32 nY, nM;
			if ( nMonth > 0 )
			{
				nY = aDateTime.GetYear() + (nMonth-1) / nMIY;
				nM = ((nMonth-1) % nMIY) + 1;
			}
			else
			{
				nY = aDateTime.GetYear() + (nMonth-nMIY) / nMIY;
				nM = nMIY - (-nMonth) % nMIY;
			}
			// create a valid date
			Date aDate( 1, USHORT(nM), USHORT(nY) );
			// and add days of month, so 31Jan + 1 month may become 3Mar
			aDate += aDateTime.GetDay() - 1;
			aDateTime.SetDate( aDate.GetDate() );
		}
		break;
		case ERA:			goto err; break;
		default:			throw ERROR;
	}
	return;

 err:
	throw ERROR;
}

sal_Int16 SAL_CALL
CalendarImpl::getFirstDayOfWeek() throw(::com::sun::star::uno::RuntimeException)
{
	if ( nFirstDayOfWeek == nFirstDayOfWeekInvalid )
	{
		const ::rtl::OUString& rDayName = aCalendar.StartOfWeek;
		sal_Int32 nLen = aCalendar.Days.getLength();
		for ( sal_Int32 j=0; j<nLen; j++ )
		{
			if ( rDayName == aCalendar.Days[j].ID )
				return nFirstDayOfWeek = sal_Int16(j);
		}
		nFirstDayOfWeek = 0;
	}
	return nFirstDayOfWeek;
}

void SAL_CALL
CalendarImpl::setFirstDayOfWeek( sal_Int16 nDay ) throw(::com::sun::star::uno::RuntimeException)
{
	nFirstDayOfWeek = nDay;
}

void SAL_CALL
CalendarImpl::setMinimumNumberOfDaysForFirstWeek( sal_Int16 nDays ) throw(::com::sun::star::uno::RuntimeException)
{
	nMinimumNumberOfDaysForFirstWeek = nDays;
}

sal_Int16 SAL_CALL
CalendarImpl::getMinimumNumberOfDaysForFirstWeek() throw(::com::sun::star::uno::RuntimeException)
{
	if ( nMinimumNumberOfDaysForFirstWeek == nMinimumNumberOfDaysForFirstWeekInvalid )
		nMinimumNumberOfDaysForFirstWeek = aCalendar.MinimumNumberOfDaysForFirstWeek;
	return nMinimumNumberOfDaysForFirstWeek;
}


::rtl::OUString SAL_CALL
CalendarImpl::getDisplayName( sal_Int16 displayIndex, sal_Int16 idx, sal_Int16 nameType )
throw(::com::sun::star::uno::RuntimeException)
{
	using namespace ::com::sun::star::i18n::CalendarDisplayIndex;
	using namespace ::com::sun::star::i18n;

	::rtl::OUString aStr;

	switch( displayIndex )
	{
		case AM_PM:/* ==0 */
		{
			LocaleDataItem i = xLocaleData->getLocaleItem(aLocale); // use keeping Locale
			if (idx == 0) aStr = i.timeAM;
			else if (idx == 1) aStr = i.timePM;
			else throw ERROR;
		}
		break;
		case DAY:
		{
			if( idx >= aCalendar.Days.getLength() ) throw ERROR;
			if (nameType == 0) aStr = aCalendar.Days[idx].AbbrevName;
			else if (nameType == 1) aStr = aCalendar.Days[idx].FullName;
		}
		break;
		case MONTH:
		{

			if( idx >= aCalendar.Months.getLength() ) throw ERROR;
			if (nameType == 0) aStr = aCalendar.Months[idx].AbbrevName;
			else if (nameType == 1) aStr = aCalendar.Months[idx].FullName;
		}
		break;
		case ERA:
		{
			if( idx >= aCalendar.Eras.getLength() ) throw ERROR;
			if (nameType == 0) aStr = aCalendar.Eras[idx].AbbrevName;
			else if (nameType == 1) aStr = aCalendar.Eras[idx].FullName;
		}
		break;
		case YEAR:
		{
			;
		}
		break;
		default:
			throw ERROR;
	}
	return aStr;
}


sal_Int16 SAL_CALL
CalendarImpl::getNumberOfMonthsInYear() throw(::com::sun::star::uno::RuntimeException)
{
	return sal_Int16(aCalendar.Months.getLength());
}


sal_Int16 SAL_CALL
CalendarImpl::getNumberOfDaysInWeek() throw(::com::sun::star::uno::RuntimeException)
{
	return sal_Int16(aCalendar.Days.getLength());
}


::com::sun::star::uno::Sequence< ::com::sun::star::i18n::CalendarItem > SAL_CALL
CalendarImpl::getMonths() throw(::com::sun::star::uno::RuntimeException)
{
	return aCalendar.Months;
}


::com::sun::star::uno::Sequence< ::com::sun::star::i18n::CalendarItem > SAL_CALL
CalendarImpl::getDays() throw(::com::sun::star::uno::RuntimeException)
{
	return aCalendar.Days;
}

sal_Bool SAL_CALL
CalendarImpl::isValid() throw(::com::sun::star::uno::RuntimeException)
{
    return aDateTime.IsValid();
}
